# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################

## The classes for parsing rss/atom feeds

import urllib2

try:
    from clive.feedparser import feedparser as fparser
    from clive.newt import snack as newt
except ImportError, err:
    raise SystemExit('error: %s' % err)

from clive.unicode import tostr

__all__ = ['FeedParser']

## The feed parsing class
class FeedParser:

    ## Constructor
    def __init__(self, opts, say, proxy):
        self._opts = opts
        self._say = say
        self._proxy = proxy

    ## Reap feeds and display selection lists
    def parse(self, raw_urls):
        fparser.USER_AGENT = self._opts.http_agent
        h = urllib2.ProxyHandler(self._proxy)
        # Reap URLs
        feeds = []
        for url in raw_urls:
            self._say('feed: %s' % url)
            d = fparser.parse(url, handlers=[h])
            if not hasattr(d.feed, 'title'):
                self._say('error: invalid rss/atom feed')
            elif not hasattr(d, 'entries'):
                self._say('error: no rss/atom feed entries found')
            else:
                feeds.append(d)
        # Display feeds and return user selection (video URLs)
        if len(feeds) == 0:
            raise SystemExit('error: no data: check feed url(s)')
        u = DisplayFeeds(feeds, self._opts)
        return u.get_selection()


## The class that displays the feeds with found video URLs
class DisplayFeeds:

    ## Constructor
    def __init__(self, feeds, opts):
        self._last = None # Selection before hitting "Resize"
        self._feeds = feeds
        self._opts = opts
        while 1:
            self._selection = self._main()
            if self._selection: break

    ## Returns the user selection of videos to be extracted
    def get_selection(self):
        return self._selection

    def _main(self):
        sel = []
        try:
            scr = newt.SnackScreen()
            sel = self._show_feeds(scr)
        finally:
            scr.finish()
        return sel

    def _ok(self):
        return self._ct.getSelection()

    def _cancel(self):
        raise SystemExit('Cancelled.')

    def _resize(self):
        self._last = self._ct.getSelection()
        return None

    def _show_feeds(self, scr):
        w = scr.width - (scr.width/6)
        ww = w-12
        ct = newt.CheckboxTree(scr.height/2, scroll=1)
        for (i,d) in enumerate(self._feeds):
            t = d.feed.title[:w]
            t += (' (%d)' % len(d.entries))
            try:
                t = tostr(t, self._opts)
            except UnicodeDecodeError, err:
                continue # Skip item if decoding fails for some reason
            ct.append(t)
            for e in d.entries:
                """
                date = e.date_parsed
                t = ('%02d-%02d-%02d: %s' % \
                    (date[0],date[1],date[2],e.title))[:ww]
                """
                try:
                    t = tostr(e.title[:ww], self._opts)
                except UnicodeDecodeError, err:
                    continue # Skip item if decoding fails for some reason
                sel = False
                if self._last and e.link in self._last:
                    sel = True
                ct.addItem(t, (i, newt.snackArgs['append']),
                    e.link, selected=sel)
        g = newt.GridForm(scr, 'RSS/Atom Feeds: Videos found', 1,2)
        g.add(ct, col=0, row=0, padding=(0,0,0,1))
        b = newt.ButtonBar(scr,
            [('Resize',2),('Cancel',0), ('Extract',1)], compact=0)
        g.add(b, col=0, row=1, padding=(0,0,0,0))
        self._ct = ct
        d = {0:self._cancel, 1:self._ok, 2:self._resize, None:self._ok}
        return d.get(b.buttonPressed(g.runOnce()))()
