# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################

## The classes that wrap various host log in functionalities

import gzip

try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

from clive.error import CliveError
try:
    from clive.urlgrabber.grabber import URLGrabber, URLGrabError
except ImportError, err:
    raise SystemExit('error: %s' % err)

__all__ = ['Login']

## The log in class
class Login:

    ## Constructor
    def __init__(self, opts, opener, proxy, say):
        self._opts = opts
        self._opener = opener
        self._proxy = proxy
        self._say = say

    ## Youtube: log-in and confirm age
    def youtube(self):
        if not self._opts.youtube_username or \
            not self._opts.youtube_password: return
        self._say('youtube: attempt to login...')
        url = 'http://youtube.com/login?'
        url += ('current_form=loginform&username=%s&' \
            'password=%s&action_login=log+in' % (self._opts.youtube_username,
            self._opts.youtube_password))
        data = self._urlopen(url)
        if 'login was incorrect' in data.lower():
            self._say('youtube: incorrect login')
            raise SystemExit
        url = 'http://youtube.com/verify_age?action_confirm=Confirm'
        self._urlopen(url)
        self._say('youtube: login ok')

    ## Metacafe: disable family filter
    def metacafe(self):
        url = 'http://metacafe.com/family_filter?filters=0'
        self._urlopen(url, read=0)

    ## Dailymotion: log-in
    def dmotion(self):
        if not self._opts.dmotion_username or \
            not self._opts.dmotion_password: return
        self._say('dmotion: attempt to login...')
        url='http://dailymotion.com/login?username=%s&password=%s' % (
            self._opts.dmotion_username, self._opts.dmotion_password)
        data = self._urlopen(url)
        if 'wrong login data' in data.lower():
            self._say('dmotion: incorrect login')
            raise SystemExit
        self._say('dmotion: probably ok, try again if extraction fails')

    def _urlopen(self, url, read=1):
        data = ''
        try:
            g = URLGrabber(
                http_headers = (('accept-encoding', 'gzip'),),
                user_agent = self._opts.http_agent,
                proxies = self._proxy,
                opener = self._opener)
            o = g.urlopen(url)
            if read:
                data = o.read()
                if o.hdr.get('content-encoding') == 'gzip':
                    data = gzip.GzipFile(fileobj=StringIO(data)).read()
            return data
        except URLGrabError, err:
            self._say('%s [%s]' % (err.strerror,url), is_error=1)
            raise SystemExit
