# AM_PY_HEADERS([PATH-TO-PYTHON], [PYTHON-VERSION])
# --------------------------------------------------------------------------
# Checks if python header files can be found. Exports PYTHON_INCLUDES.
# Calls AM_PYTHON_PATH. Exports PYTHON_INCLUDES and the AM_PYTHON_PATH.
# exports. Based on: http://source.macgimp.org/ AM_PY_HEADERS which is GPL
# and is attributed to James Henstridge.
AC_DEFUN([AM_PY_HEADERS],
    [AC_MSG_CHECKING([for python header files])
py_prefix=`$1 -c "import sys; print sys.prefix"`
py_exec_prefix=`$1 -c "import sys; print sys.exec_prefix"`
py_incl_dir="${py_prefix}/include/python$2"
if test "$py_prefix" != "$py_exec_prefix"; then
    py_incl_dir="$py_incl_dir -I${py_exec_prefix}/include/python$2"
fi
PYTHON_INCLUDES="-I$py_incl_dir"
AC_SUBST(PYTHON_INCLUDES)
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
AC_PREPROC_IFELSE([AC_LANG_SOURCE([[#include <Python.h>]])],
    [AC_MSG_RESULT([$py_incl_dir])], [AC_MSG_FAILURE([not found])])
CPPFLAGS="$save_CPPFLAGS"
])

# AM_PY_URLGRABBER([PATH-TO-PYTHON], [MIN-VERSION], [FOUND], [NOT-FOUND])
# --------------------------------------------------------------------------
# Checks if python urlgrabber module is installed.
AC_DEFUN([AM_PY_URLGRABBER],
  [ AC_MSG_CHECKING([whether urlgrabber >= $2])
prog="import sys
minver = '$2'.replace('.','')
r = 1 # error/no
try:
	import urlgrabber as _u
	if _u.__version__.replace('.','') >= minver:
		r = 0
except ImportError:
	pass
sys.exit(r)"
  AS_IF([AM_RUN_LOG([$1 -c "$prog"])], [$3], [$4])])

# AM_PY_FEEDPARSER([PATH-TO-PYTHON], [MIN-VERSION], [FOUND], [NOT-FOUND])
# --------------------------------------------------------------------------
# Checks if python feedparser module is installed.
AC_DEFUN([AM_PY_FEEDPARSER],
  [ AC_MSG_CHECKING([whether feedparser >= $2])
prog="import sys
minver = '$2'.replace('.','')
r = 1 # error/no
try:
	import feedparser as _f
	if _f.__version__.replace('.','') >= minver:
		r = 0
except ImportError:
	pass
sys.exit(r)"
  AS_IF([AM_RUN_LOG([$1 -c "$prog"])], [$3], [$4])])

# AM_PY_NEWT([PATH-TO-PYTHON], [FOUND], [NOT-FOUND])
# --------------------------------------------------------------------------
# Checks if newt python module (snack) is installed.
AC_DEFUN([AM_PY_NEWT],
    [ AC_MSG_CHECKING([whether newt (snack) module is installed])
prog="import sys
try:
    import snack
    r = 0
except ImportError:
    r = 1
sys.exit(r)"
  AS_IF([AM_RUN_LOG([$1 -c "$prog"])], [$2], [$3])])


