namespace Clinica {

    public interface MedicineSearchEngine : UserInterfaceActivatable {
    
        /**
         * @brief Return the name of the search engine.
         */
        public abstract string get_name ();
    
        /**
         * @brief This method should be implemented by the MedicalSearchEngine
         * and should lookup for medicines matching the given key and
         * call push_result for each one.
         */ 
        public abstract void search_medicine (string key, MedicineTreeView treeview);
        
        /**
         * @brief Abort any search that the search engine is currently doing.
         */
        public abstract void abort_search ();
    }
}
