use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@K@L`@{
@@@@@@@@@@K@@K@L`@{
@@@@@@@@@{@@M]@@@|
@@@@@@@@@K@@@{
@@@@@@@@K@L`@{
@@@@@@@@K@@{@@@@K
@@@@@@@@@@K@@K@@{
@@@@@@@@@
M]@@[|@L`@{
@@@@@@@@[|@L`@{
@@@@@@@@[|@L`@{
@@@@@@@@[|@L`@{
@@@@@@@@@
';

print "1..60\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 8 ? "" : "not ", "ok 2\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 8\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 9\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 10\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 11\n";
print @foo == 8 ? "" : "not ", "ok 12\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 14\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 16\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 18\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 19\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 20\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 21\n";
print @foo == 8 ? "" : "not ", "ok 22\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 25\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 26\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 28\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 29\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 30\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 31\n";
print @foo == 8 ? "" : "not ", "ok 32\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 35\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 36\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 37\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 38\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 39\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 40\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 41\n";
print @foo == 8 ? "" : "not ", "ok 42\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 43\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 44\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 45\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 46\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 47\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 48\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 49\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 50\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 51\n";
print @foo == 8 ? "" : "not ", "ok 52\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 53\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 54\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 55\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 56\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 57\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 58\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 59\n";
print "VI\n" eq (shift @foo) ? "" : "not ", "ok 60\n";

sub foo {
    push @foo, join('', @_);
}

