use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@z@L`@{{
@z@L`@{{
@z@L`@{{
@@@z
@@@z
@@@z
@z@L`@{{
@@@z
@z@L`@z@@z
@@@z
@z@L`@z@@z
@@@z
@@
';

print "1..48\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 6 ? "" : "not ", "ok 2\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 8\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 9\n";
print @foo == 6 ? "" : "not ", "ok 10\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 14\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 16\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 17\n";
print @foo == 6 ? "" : "not ", "ok 18\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 19\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 20\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 24\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 25\n";
print @foo == 6 ? "" : "not ", "ok 26\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 28\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 29\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 30\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 32\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 33\n";
print @foo == 6 ? "" : "not ", "ok 34\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 35\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 36\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 37\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 38\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 39\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 40\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 41\n";
print @foo == 6 ? "" : "not ", "ok 42\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 43\n";
print "XXXI\n" eq (shift @foo) ? "" : "not ", "ok 44\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 45\n";
print "lxvDXXXV\n" eq (shift @foo) ? "" : "not ", "ok 46\n";
print "XVII\n" eq (shift @foo) ? "" : "not ", "ok 47\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 48\n";

sub foo {
    push @foo, join('', @_);
}

