package Language::INTERCAL::Opcodes;

# Definition of compiler's internal opcodes for CLC-INTERCAL

# This file is part of CLC-INTERCAL.

# Copyright (C) 1999 Claudio Calvelli <lunatic@assurdo.com>, all rights reserved

# WARNING - do not operate heavy machinery while using CLC-INTERCAL

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

use vars qw($VERSION @EXPORT @EXPORT_OK @ISA @BC_NAMES %EXPORT_TAGS);
$VERSION = '0.05';

require Exporter;

@ISA = qw(Exporter);
@EXPORT = ();
@EXPORT_OK = qw(@BC_NAMES);

my @bc_s = qw(
    NOP BUG UBUG ILLEGAL

    ABSTAIN ASSIGN COME GABSTAIN GREINSTATE IGNORE READ
    REINSTATE REMEMBER RETRIEVE STASH STOP WRITE

    FORGET NEXT RESUME

    CFORK CREATE CRFORK CONVERT ENROL ENSLAVE FINISH FORK
    FREE GFORK GRADUATES LEARN SFORK STUDY SWAP VFORK
    WHILE_CB WHILE_BC WHILE_E
);

my @bc_e = qw(
    AND CONSTANT INTERLEAVE OR REGISTER SELECT SUBSCRIPT XOR

    INDIRECT NUMBER OVERLOAD_RANGE OVERLOAD_REGISTER OWNER SPLAT

    BAND BOR BXOR
);

my @bc_t = qw(
    CONSTANT EXPRESSION GERUND GERUND_LIST LABEL
    REGISTER STATEMENT STATEMENT_LIST
);

@BC_NAMES = ();

my $i = 0;
my $b;

for $b (@bc_s) {
    eval "sub S_$b () { $i }";
    push @EXPORT, "S_$b";
    push @BC_NAMES, "S_$b";
    $i++
}

for $b (@bc_e) {
    eval "sub E_$b () { $i }";
    push @EXPORT, "E_$b";
    push @BC_NAMES, "E_$b";
    $i++
}

for $b (@bc_t) {
    eval "sub T_$b () { $i }";
    push @EXPORT, "T_$b";
    push @BC_NAMES, "T_$b";
    $i++
}

push @EXPORT_OK, @EXPORT;
%EXPORT_TAGS = ('BC_IDS' => \@EXPORT);

1;
