#!/usr/bin/env python


########################################################################
#     Chris's Lame File Browser 4 (This is the properties widget)
#     Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
 #   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##################################################################


import os, os.path, stat, string, sys
import fileinfo, mimetype
import gtk, gobject, pango


class set:
	def __init__(self, image_path, names):
	
		names.pop()
	
		# Create the main window for the app
		self.mainWindow = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.mainWindow.show()
		self.mainWindow.set_size_request(420, 360)
		self.mainWindow.connect("destroy", self.quit)
		self.mainWindow.set_title("Properties")
		
		# Create a table to hold all the stuff in the widget
		self.mainTable = gtk.Table()
		self.mainTable.show()
		self.mainWindow.add(self.mainTable)
		
		# Create a box to hold the title
		self.titleBox = gtk.HBox(gtk.FALSE)
		self.titleBox.show()
		self.mainTable.attach(self.titleBox, 0,1, 0,1, gtk.FILL, gtk.FILL, 2, 2)

		# Create a label (i.e. the title)
		self.title = gtk.Label()
		self.title.set_use_markup(gtk.TRUE)
		self.title.set_markup('<span size="12000"> Rename the files in the entry boxes </span>' 
					 	    	'\n<span size="12000"> Remember The Extentions!</span>' + 
					    	 	'\n<span size="12000"> Press SAVE when done or CANCEL to quit.</span>' + 
				             	'\n<span size="12000"> Use Reset to Get the Original File Name Back.</span>')
		self.title.show()
		self.titleBox.pack_start(self.title, gtk.FALSE, 5)
		
		# Create the logo
		self.logo = gtk.Image()
		logoPixbuf = gtk.gdk.pixbuf_new_from_file(image_path + "/Toolbar/new.png")
		self.logoPixbuf = logoPixbuf.scale_simple(48, 48, gtk.gdk.INTERP_BILINEAR)
		self.logo.set_from_pixbuf(self.logoPixbuf)
		self.logo.show()
		self.titleBox.pack_start(self.logo, gtk.FALSE, 10)
		
		# Create a scrollBox for the rename entries
		self.mainScroll = gtk.ScrolledWindow()
		self.mainScroll.show()
		self.mainTable.attach(self.mainScroll, 0,1, 1,2, gtk.EXPAND|gtk.FILL, gtk.EXPAND|gtk.FILL, 2, 2)	
                
		# Create a box for all the entries within the scrolled window
		self.mainBox = gtk.VBox()
		self.mainBox.show()
		self.mainScroll.add_with_viewport(self.mainBox)	     
                
		# Create the entry boxes with the names in them
		self.createEntries(names)
		
		# Create a button box for the buttons at the bottom
		self.buttonBox = gtk.HButtonBox()
		self.buttonBox.show()
		self.mainTable.attach(self.buttonBox, 0, 1, 2, 3, gtk.FILL, gtk.FILL, 5, 5)
		
		# Create the save button
		self.saveButton = gtk.Button("Save")
		self.saveButton.show()
		self.saveButton.get_child().modify_font(pango.FontDescription("sans bold 12"))
		self.saveButton.connect("clicked", self.saved, names)
		self.buttonBox.pack_start(self.saveButton)
		
		# Create the cancel button
		self.cancelButton = gtk.Button("Cancel")
		self.cancelButton.show()
		self.cancelButton.get_child().modify_font(pango.FontDescription("sans bold 12"))
		self.cancelButton.connect("clicked", self.quit)
		self.buttonBox.pack_start(self.cancelButton)
		
	
	###########################################################################
	# Create Entries
	###########################################################################
	def createEntries(self, names):
	
		# Create a list object to hold the entry boxes
		self.entries = []

		# Create the entry boxes and the reset buttons based on the names passed to the widget
		for name in names:                        
                        
                        # Create a box to put the button, entry and permissions in
                        box = gtk.VBox(gtk.FALSE)
                        box.show()
                        self.mainBox.pack_start(box)                   
			                        
			# Create an entry box and add it to the table with the file name	
			entryBox = gtk.Entry()
			entryBox.show()
			entryBox.modify_font(pango.FontDescription("sans bold 12"))
			entryBox.set_text(os.path.basename(name))
			box.pack_start(entryBox)
	
			# Create a reset button
			resetButton = gtk.Button("Reset")
			resetButton.show()
			resetButton.get_child().modify_font(pango.FontDescription("sans bold 12"))
			resetButton.connect("clicked", self.resetName, entryBox, os.path.basename(name))
			box.pack_start(resetButton)
			
			infoFrame = gtk.Frame("Information")
			infoBox = gtk.HBox()
			infoBox.set_border_width(5)
			infoFrame.add(infoBox)

			filesize = fileinfo.getStats(name)[0]
			sizeLabel = gtk.Label("Size: " + filesize)
			infoBox.pack_start(sizeLabel, False, True, padding=5)
			
			mime = mimetype.getTypes(None, name)
			mime_type = mime[name]
			mimeLabel = gtk.Label("Mimetype: "+ mime_type[0] + "/" + mime_type[1])
			infoBox.pack_start(mimeLabel, False, True, padding=5)			
			
			infoFrame.show_all()
			box.pack_start(infoFrame)
			
			# Add the entry to a list for later use
			self.entries.append(entryBox)
                        
                        # Create a frame for the button box
                        nameFrame = gtk.Frame('Permissions')
                        nameFrame.show()
                        nameFrame.set_label_align(0.5, 0.0)
                        box.pack_start(nameFrame)                        
                            
                        # Create a button box for the buttons
                        buttonBox = gtk.HBox(gtk.FALSE)
                        buttonBox.show()
                        nameFrame.add(buttonBox)
                            
                        # Add the permission buttons to the box
                        permissionButtons = []
                        self.permissionButtons = []

                        # Get the permissions in octal form (UNIX numeric [777,755,530] form)
                        fileInfo = os.stat(name)
                        mode = oct(fileInfo[stat.ST_MODE])
                        
                        # Determine the permissions and add them to the buttons
                        y=0
                        for group in ['owner','group','others']:
                            
                            # Make a box for the frame
                            frameBox = gtk.VBox(gtk.FALSE)
                            frameBox.show()
                            buttonBox.pack_start(frameBox)
                                           
                            # Add the frame to the frameBox
                            buttonFrame = gtk.Frame(group)
                            buttonFrame.show()
                            frameBox.pack_start(buttonFrame)
                                            
                            # Put a box in the frame for the buttons
                            groupingBox = gtk.VBox(gtk.FALSE)
                            groupingBox.show()
                            buttonFrame.add(groupingBox)                            
                            
                            for permissions in ['read','write','execute']:
                                            
                                # Add the buttons to the box
                                permissionButton = gtk.CheckButton(permissions)
                                permissionButton.show()
                                permissionButton.get_child().modify_fg(gtk.STATE_ACTIVE, gtk.gdk.Color(0,40000,0,10))
                                permissionButton.get_child().modify_fg(gtk.STATE_NORMAL, gtk.gdk.Color(40000,0,0,10))
                                permissionButton.get_child().modify_font(pango.FontDescription("sans bold 12"))			
                                
                                place = -3 + y
                                number = int(mode[place])
                                    
                                if permissions == 'read' and number in [7,6,5,4]:
                                    permissionButton.set_active(gtk.TRUE)
                                    
                                elif permissions == 'write' and number in [7,6,3,2]:
                                    permissionButton.set_active(gtk.TRUE)

                                elif permissions == 'execute' and number in [7,5,3,1]:                                        
                                    permissionButton.set_active(gtk.TRUE)
                                
                                else:
                                    permissionButton.set_active(gtk.FALSE)
                                    
                                groupingBox.pack_start(permissionButton)
                                self.permissionButtons.append(permissionButton)
                                
                            y=y+1

	###########################################################################
	# Reset Name
	###########################################################################
	def resetName(self, button, entry, name):
		
		# Reset the file name in the entry box
		entry.set_text(name)


	###########################################################################
	# This function changes the filename and the permissions
	###########################################################################
	def saved(self, button, names):
	
		# Lets get the base path
		path = []
		for name in names:
			path.append(os.path.dirname(name))
		
		# Let's try to change permissions and rename the files
		for x in range(len(self.entries)):
			
                        # Create some variables necessary for changing from gtk.TRUE/FALSE to os.chmod octals
                        permissionOctals = [4,2,1]
                        octalPermission = ""
                    
                        # Run through the 3 sets of 3 (rwx) at positions 0, 3 and 6
                        for y in [0,3,6]:
                            permissions = 0
                        
                            #Get the individual on/off settings for each set
                            for z in range(3):
                                answer = self.permissionButtons[(y+z)].get_active()
                            
                                # If the box is checked, change the appropriate permission using the option
                                if answer == gtk.TRUE:
                                    permissions = permissions + permissionOctals[z]
                            
                            # Add the number to the list as a string (so we concatenate and not add)
                            octalPermission += str(permissions)
                        
                        # Change the octive to a decimal
                        octals = [64,8,1]
                        number = 0
                        for n in range(len(octalPermission)):
                            number += int(octalPermission[n])*octals[n]

                        # Use the decimal to change the permissions
                        os.chmod(names[x] , number)
                    
                        
			# If a name was left blank, then use the old name (why not?)
			if self.entries[x].get_text() == "":
				self.entries[x].set_text(os.path.basename(names[x]))

			# Give the locations useful names
			oldName = names[x]
			if path[x] != "":
				newName = path[x] + "/" + self.entries[x].get_text()
			else:
				newName = self.entries[x].get_text()
	
			try:
				# Try to rename the file
				os.rename(oldName, newName)
			except:
				# Print an error if something goes wrong
				print "Bummer, won't rename"
                                
		# We're done		
		self.quit()     


	###########################################################################
	# This function quits the program
	#########################################################################
	def quit(self, button=None, event=None):        
               
		# Quit, now that we're done
		self.mainWindow.destroy()
		
