package ClamTk::Update;

use strict;
use LWP::UserAgent;
$|++;

use encoding 'utf8';

use ClamTk::GUI;

use Locale::gettext;
use POSIX qw/locale_h/;
textdomain("clamtk");
setlocale( LC_MESSAGES, "" );
bind_textdomain_codeset( "clamtk", "UTF-8" );

use Gtk2;
use Glib qw/TRUE FALSE/;

my ( $win, $update_list );

sub updater {
    $win = Gtk2::Dialog->new();
    $win->signal_connect( destroy => sub { $win->destroy; } );
    $win->set_title( gettext('Updates') );
    $win->set_default_size( 625, 130 );

    if ( -e "/usr/share/pixmaps/clamtk.png" ) {
        $win->set_default_icon_from_file("/usr/share/pixmaps/clamtk.png");
    } elsif ( -e "/usr/share/pixmaps/clam.xpm" ) {
        $win->set_default_icon_from_file("/usr/share/pixmaps/clam.xpm");
    }

    my $tt = Gtk2::Tooltips->new();

    my $update_win = Gtk2::ScrolledWindow->new();
    $win->vbox->pack_start( $update_win, TRUE, TRUE, 0 );
    $update_win->set_policy( 'never', 'never' );
    $update_win->set_shadow_type('etched-out');

    $update_list = Gtk2::SimpleList->new(
        gettext('Updates')     => 'text',
        gettext('Description') => 'text',
        gettext('Select')      => 'bool',
        gettext('Status')      => 'text',
    );
    $update_win->add($update_list);

    my $sig_box = Gtk2::CheckButton->new();
    $sig_box->set_active(FALSE);
    if ( $> != 0 ) {
        $sig_box->set_sensitive(FALSE);
        $tt->set_tip( $sig_box, gettext('You must be root to enable this.') );
    }

    my $gui_box = Gtk2::CheckButton->new();

    my $user_can = 0;
    if ( ClamTk::Prefs->get_property( $main::scanner, "Update" ) eq 'single' )
    {
        $user_can = 1;
    }

    if ( $> == 0 || $user_can ) {
        push @{ $update_list->{data} },
            [
            gettext("Signature updates"),
            gettext("Check for antivirus signature updates"),
            $sig_box, gettext("N/A"),
            ];
    }
    push @{ $update_list->{data} },
        [
        gettext("GUI updates"),
        gettext("Check for updates to the graphical interface"),
        $gui_box, gettext("N/A"),
        ];

    my $hbox = Gtk2::HButtonBox->new();
    $win->vbox->pack_start( $hbox, FALSE, FALSE, 0 );
    $hbox->set_layout_default('spread');

    my $go = Gtk2::Button->new( gettext('Check for updates') );
    $hbox->add($go);
    $go->signal_connect( clicked => \&decision );

    my $close = Gtk2::Button->new( gettext('Close this window') );
    $hbox->add($close);
    $close->signal_connect(
        clicked => sub {
            $update_win->destroy;
            $win->destroy;
        }
    );

    $win->show_all();
    $win->run;
    $win->destroy;
}

sub decision {
    my ( $rowref, $scalar );
    $scalar = scalar( @{ $update_list->{data} } );
    return unless ($scalar);
    my $value = 0;

    for ( 0 .. $scalar ) {
        Gtk2->main_iteration while Gtk2->events_pending;
        $rowref = $update_list->{data}[$_];
        if ( $rowref->[2] == 1 ) {    # is it enabled?
            if ( $rowref->[0] eq gettext('Signature updates') ) {
                $update_list->{data}[$_][3] = gettext("Checking...");
                $value = update_signatures();
                $update_list->{data}[$_][3] =
                      $value == 0 ? gettext("Update failed")
                    : $value == 1 ? gettext("Signatures are current")
                    : $value == 2 ? gettext("Updated")
                    :               "";
                ClamTk::GUI->set_sig_status();
            } elsif ( $rowref->[0] eq gettext('GUI updates') ) {
                $update_list->{data}[$_][3] = gettext("Checking...");
                $value = update_gui();
                $update_list->{data}[$_][3] =
                      $value == 0 ? gettext("Check failed")
                    : $value == 1 ? gettext("GUI is current")
                    : $value == 2 ? gettext("A newer version is available")
                    : $value == 3 ? gettext("GUI is current")
                    :               "";
                ClamTk::GUI->set_tk_status( $main::scanner, $value );
            } else {
                warn "ref = ", $rowref->[0], "\n";
            }
        }
    }
}

sub update_signatures {
    Gtk2->main_iteration while Gtk2->events_pending;
    $win->queue_draw;

    # return code:
    # 0 = failed, 1 = current, 2 = has been updated

    my @result;
    my $command = $main::scanner->{freshclam};
    if ( ClamTk::Prefs->get_property( $main::scanner, "Update" ) eq 'single' )
    {
        $command
            .= " --datadir=$main::scanner->{db} --log=$main::scanner->{db}/freshclam.log";
    }

    eval {
        local $SIG{ALRM} = sub { die "failed\n" };
        alarm 60;

        @result = `$command --stdout`;
        alarm 0;
    };
    if ( $@ && $@ eq "failed\n" ) {
        return 0;
    }
    if ( !@result ) {
        return 0;
    } else {
        foreach my $line (@result) {
            if ( $line =~ /Database updated .(\d+) signatures/ ) {
                return 2;
            }

            #elsif ( $line =~ /WARNING: Incremental update failed/ ) {
            #    return 0;
            #}
            elsif ( $line =~ /up to date/ ) {
                return 1;
            }
        }
        return 0;
    }
    $win->queue_draw;
}

sub update_gui {
    my ($version) = $main::scanner->{VERSION};

    # return code:
    # 0 = failed, 1 = current, 2 = not current, 3 = too updated
    $version =~ s/[^0-9]//g;

    my $ua = LWP::UserAgent->new;
    $ua->timeout(10);
    $ua->env_proxy;

    my $response = $ua->get('http://clamtk.sourceforge.net/latest');

    if ( $response->is_success ) {
        my $content = $response->content;
        chomp($content);
        $version =~ s/[^0-9]//g;
        $content =~ s/[^0-9]//g;
        return 1 if ( $version == $content );
        return 2 if ( $content > $version );
        return 3 if ( $version > $content );
        return 0;
    } else {
        return 0;
    }
}

sub db_select {
    my $choice = Gtk2::Dialog->new();
    $choice->signal_connect( destroy => sub { $choice->destroy; } );
    $choice->set_title( gettext('Antivirus Signatures') );
    $choice->set_default_size( 325, 230 );

    if ( -e "/usr/share/pixmaps/clamtk.png" ) {
        $choice->set_default_icon_from_file("/usr/share/pixmaps/clamtk.png");
    } elsif ( -e "/usr/share/pixmaps/clam.xpm" ) {
        $choice->set_default_icon_from_file("/usr/share/pixmaps/clam.xpm");
    }

    my $view = Gtk2::TextView->new;
    $view->set_wrap_mode('word');
    $view->set_editable(FALSE);
    $view->set_cursor_visible(FALSE);
    $view->set_indent(5);

    my $sw = Gtk2::ScrolledWindow->new;
    $sw->set_shadow_type('etched-in');
    $sw->set_policy( 'automatic', 'automatic' );
    $sw->set_border_width(5);

    my $dialog =
        gettext( "\nPlease choose how you will update your antivirus "
            . "signatures.\n\nIf this is a multi-user system or you have an "
            . "administrator, you should probably choose 'System Wide'.\n\n"
            . "If you need to be able to update the signatures yourself, "
            . "you should probably choose 'Single User'.\n" );

    my $buffer = $view->get_buffer;
    $buffer->create_tag( 'mono', family => 'Monospace' );
    $buffer->insert_with_tags_by_name( $buffer->get_start_iter, $dialog,
        'mono' );

    $sw->add($view);
    $choice->vbox->pack_start( $sw, TRUE, TRUE, 0 );

    my $selection = '';

    my $c_box = Gtk2::HButtonBox->new();
    $choice->vbox->pack_start( $c_box, FALSE, FALSE, 0 );

    my ( $single_btn, $sys_btn, $save_btn, $quit_btn, $label );

    $single_btn = Gtk2::Button->new( gettext('Single User') );
    $c_box->add($single_btn);
    $single_btn->signal_connect(
        clicked => sub {
            $single_btn->set_relief('none');
            $sys_btn->set_relief('normal');
            $selection = 'single';
            $save_btn->set_sensitive(TRUE);
        }
    );

    $sys_btn = Gtk2::Button->new( gettext('System Wide') );
    $c_box->add($sys_btn);
    $sys_btn->signal_connect(
        clicked => sub {
            $sys_btn->set_relief('none');
            $single_btn->set_relief('normal');
            $selection = 'shared';
            $save_btn->set_sensitive(TRUE);
        }
    );

    $save_btn = Gtk2::Button->new('Save');
    $c_box->add($save_btn);
    $save_btn->signal_connect(
        clicked => sub {
            save($selection);
            $label->set_text( gettext("Your preferences were saved.") );
            $save_btn->set_sensitive(FALSE);
            $single_btn->set_sensitive(FALSE);
            $sys_btn->set_sensitive(FALSE);
            $quit_btn->set_sensitive(TRUE);
        }
    );
    $save_btn->set_sensitive(FALSE);

    $quit_btn = Gtk2::Button->new('Quit');
    $c_box->add($quit_btn);
    $quit_btn->signal_connect( clicked => sub { $choice->destroy } );
    $quit_btn->set_sensitive(FALSE);

    $label = Gtk2::Label->new();
    $choice->vbox->pack_start( $label, FALSE, FALSE, 0 );

    $view->show();
    $choice->show_all();
    $choice->run;
    $choice->destroy;

}

sub save {
    my $update = shift;
    my $Config = ClamTk::Prefs->get_all_prefs($main::scanner);

    my ($ret) = ClamTk::Prefs->set_all(
        $main::scanner,                $Config->{_}->{SaveToLog},
        $Config->{_}->{ScanHidden},    $Config->{_}->{SizeLimit},
        $Config->{_}->{Thorough},      $Config->{_}->{LastScan},
        $Config->{_}->{LastInfection}, $update
    );

    if ( $ret == 1 ) {

        # if it worked, see if there are system signatures around
        # we can copy to save bandwidth and time
        if ( $update eq 'single' ) {
            my ( $d, $m ) = (0) x 2;
            Gtk2->main_iteration while ( Gtk2->events_pending );
            for my $dir_list (
                '/var/lib/clamav',         '/var/clamav',
                '/opt/local/share/clamav', '/usr/share/clamav',
                '/usr/local/share/clamav'
                )
            {
                if ( -e "$dir_list/daily.cld" ) {
                    system(
                        "cp",
                        "$dir_list/daily.cld",
                        "$main::scanner->{db}/daily.cld"
                    );
                    $d = 1;
                } elsif ( -e "$dir_list/daily.cvd" ) {
                    system(
                        "cp",
                        "$dir_list/daily.cvd",
                        "$main::scanner->{db}/daily.cvd"
                    );
                    $d = 1;
                }
                if ( -e "$dir_list/main.cld" ) {
                    system(
                        "cp",
                        "$dir_list/main.cld",
                        "$main::scanner->{db}/main.cld"
                    );
                    $m = 1;
                } elsif ( -e "$dir_list/main.cvd" ) {
                    system(
                        "cp",
                        "$dir_list/main.cvd",
                        "$main::scanner->{db}/main.cvd"
                    );
                    $m = 1;
                }
                last if ( $d && $m );
            }
        }
    }
}

1;
