;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: CL-USER; -*-
;;;
;;; Filename:    packages.lisp
;;; Author:      Jochen Schmidt <jsc@dataheaven.de>
;;; Description: package definitions
;;;

(defpackage #:ssl
  (:use #:common-lisp)
  (:export
   
   #:initialize-ssl-library
   #:shutdown-ssl-library
   
   ;; ACL SSL API
   #:make-ssl-client-stream
   #:make-ssl-server-stream
   
   ;; SSL error conditions
   #:ssl-error
   #:ssl-error-none
   #:ssl-error-zero-return
   #:ssl-error-want-something
   #:ssl-error-want-read
   #:ssl-error-want-write
   #:ssl-error-want-connect
   #:ssl-error-want-x509-lookup
   #:ssl-error-syscall
   #:ssl-error-ssl
   
   ;; Stream classes
   #:binary-ssl-stream
   #:character-ssl-stream))


(defpackage #:ssl-internal
  (:use :common-lisp :ssl
	#+ssl-use-uffi :uffi #+cmu :alien #+cmu :c-call
	#+cormanlisp :win32 #+cormanlisp :c-types)
  (:export
   
   ;; Simple buffering protocol
   #:simple-buffering-mixin
   #:make-byte-vector
   #:free-byte-vector
   #:bvref
   #:ssl-socket-read-byte
   #:ssl-socket-read-char
   #:ssl-socket-write-byte
   #:ssl-socket-write-char
   #:fill-input-buffer
   #:flush-output-buffer
   #:ssl-socket-internal-close
   
   ;; SSL connection protocol 
   #:ssl-socket         ; Class
   #:ssl-client-socket  ; Class
   #:ssl-server-socket  ; Class
   #:ssl-socket-handle
   #:ssl-socket-ctx
   #:close-ssl-socket
   
   ;; Direct OpenSSL interface
   #:ssl-load-error-strings
   #:ssl-library-init
   #:ssl-v23-method
   #:ssl-set-connect-state
   #:ssl-set-accept-state
   #:ssl-ctx-new
   #:ssl-new
   #:ssl-set-fd
   #:ssl-get-error
   #:err-get-error
   #:ssl-connect
   #:ssl-accept
   #:ssl-write
   #:ssl-read
   #:ssl-pending
   #:ssl-shutdown
   #:ssl-free
   #:ssl-ctx-free
   
   #:+ssl-filetype-pem+
   #:+ssl-filetype-asn1+
   #:+ssl-filetype-default+
   
   #:ssl-set-cipher-list
   #:ssl-ctx-use-rsa-privatekey-file
   #:ssl-use-rsa-privatekey-file
   #:ssl-use-certificate-file
   #:ssl-ctx-load-verify-locations
   #:ssl-ctx-set-client-ca-list
   #:ssl-set-client-ca-list
   #:ssl-load-client-ca-file))

#+cormanlisp
(require 'gray-streams)

#-cormanlisp
(defpackage :gray-stream
	(:import-from #+lispworks :stream #+cmu :lisp #+allegro :excl
		      #+:sbcl :sb-gray
                  "FUNDAMENTAL-BINARY-INPUT-STREAM"
                  "FUNDAMENTAL-BINARY-OUTPUT-STREAM"
                  "FUNDAMENTAL-CHARACTER-INPUT-STREAM"
                  "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM"
                  "STREAM-ELEMENT-TYPE"
                  "STREAM-LISTEN"
                  "STREAM-READ-BYTE"
                  "STREAM-READ-CHAR"
                  "STREAM-WRITE-BYTE"
                  "STREAM-WRITE-CHAR"
                  "STREAM-READ-CHAR-NO-HANG"
                  "STREAM-FORCE-OUTPUT"
                  "STREAM-FINISH-OUTPUT"
                  "STREAM-CLEAR-INPUT"
                  "STREAM-CLEAR-OUTPUT"
                  "STREAM-LINE-COLUMN"
		  "STREAM-READ-SEQUENCE")
	(:export "FUNDAMENTAL-BINARY-INPUT-STREAM"
             "FUNDAMENTAL-BINARY-OUTPUT-STREAM"
             "FUNDAMENTAL-CHARACTER-INPUT-STREAM"
             "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM"
             "STREAM-ELEMENT-TYPE"
             "STREAM-LISTEN"
             "STREAM-READ-BYTE"
             "STREAM-READ-CHAR"
             "STREAM-WRITE-BYTE"
             "STREAM-WRITE-CHAR"
             "STREAM-READ-CHAR-NO-HANG"
             "STREAM-FORCE-OUTPUT"
             "STREAM-FINISH-OUTPUT"
             "STREAM-CLEAR-INPUT"
             "STREAM-CLEAR-OUTPUT"
             "STREAM-LINE-COLUMN"
	     "STREAM-READ-SEQUENCE"))

#+cormanlisp
(defpackage :gray-stream
  (:use #:common-lisp :gray-streams)
  (:export 
   #:fundamental-binary-input-stream
   #:fundamental-binary-output-stream
   #:fundamental-character-input-stream
   #:fundamental-character-output-stream
   #:stream-element-type
   #:stream-listen
   #:stream-read-byte
   #:stream-read-char
   #:stream-write-byte
   #:stream-write-char
   #:stream-read-char-no-hang
   #:stream-force-output
   #:stream-finish-output
   #:stream-clear-input
   #:stream-clear-output
   #:stream-line-column
   #:stream-read-sequence
   #:stream-unread-char
   #:stream-read-line
   #:stream-write-sequence
   #:stream-write-string
   #:stream-write-buffer
   #:stream-read-buffer
   #:stream-fill-buffer
   #:stream-flush-buffer
   #:with-stream-input-buffer
   #:with-stream-output-buffer))
