(in-package :ssl-internal)


;; (alien:load-foreign "/lib/libc.so"
;;    :libraries '("-L" "/opt/OpenSSL/lib" "-lssl" "-lcrypto"))

;; (alien:load-foreign "/opt/OpenSSL/lib/libssl.a"
;;    :libraries '("-u" "SSL_new" "-L" "/opt/OpenSSL/lib" "-lcrypto"))

(eval-when (:compile-toplevel :load-toplevel :execute)
(alien:load-foreign "/tmp/ssl.so")
)

(def-alien-type ssl-method (* integer))
(def-alien-type ssl-ctx (* integer))
(def-alien-type ssl-ptr (* integer))
(def-alien-type x509-stack (* integer))

(def-alien-routine ("SSL_load_error_strings" ssl-load-error-strings) void)
(def-alien-routine ("SSL_library_init" ssl-library-init) int)
(def-alien-routine ("SSLv23_method" ssl-v23-method) ssl-method)
(def-alien-routine ("SSL_set_connect_state" ssl-set-connect-state) void (ssl ssl-ptr))
(def-alien-routine ("SSL_set_accept_state" ssl-set-accept-state) void (ssl ssl-ptr))
(def-alien-routine ("SSL_CTX_new" ssl-ctx-new) ssl-ctx (method ssl-method))
(def-alien-routine ("SSL_new" ssl-new) ssl-ptr (ctx ssl-ctx))
(def-alien-routine ("SSL_set_fd" ssl-set-fd) int
  (ssl ssl-ptr)
  (fd int))
(def-alien-routine ("SSL_get_error" ssl-get-error) int
  (ssl ssl-ptr)
  (ret int))

(def-alien-routine ("SSL_connect" ssl-connect) int (ssl ssl-ptr))
(def-alien-routine ("SSL_accept" ssl-accept) int (ssl ssl-ptr))
(def-alien-routine ("SSL_write" ssl-write) int
  (ssl ssl-ptr)
  (buf (* (unsigned 8))) ;(array (unsigned 8)))
  (num int))
(def-alien-routine ("SSL_read" ssl-read) int
  (ssl ssl-ptr)
  (buf (* (unsigned 8))) ;(array (unsigned 8)))
  (num int))
(def-alien-routine ("SSL_pending" ssl-pending) int (ssl ssl-ptr))
(def-alien-routine ("SSL_shutdown" ssl-shutdown) void (ssl ssl-ptr))
(def-alien-routine ("SSL_free" ssl-free) void (ssl ssl-ptr))
(def-alien-routine ("SSL_CTX_free" ssl-ctx-free) void (ctx ssl-ctx))
(def-alien-routine ("RAND_seed" rand-seed) void
  (buf (* (UNSIGNED 8))) ;(array (unsigned 8)))
  (num integer))

(def-alien-routine ("ERR_get_error" err-get-error) unsigned-long)
(def-alien-routine ("ERR_error_string" err-error-string) c-string
  (e unsigned-long)
  (buf c-string))

;;;-----------------------------------
;; Certificate and Privatekey handling
;;;-----------------------------------

(defconstant +ssl-filetype-pem+ 1)
(defconstant +ssl-filetype-asn1+ 2)
(defconstant +ssl-filetype-default+ 3)

(def-alien-routine ("SSL_set_cipher_list" ssl-set-cipher-list) int
  (ssl ssl-ptr)
  (str c-string))

(def-alien-routine ("SSL_use_RSAPrivateKey_file" ssl-use-rsa-privatekey-file) int
  (ssl ssl-ptr)
  (str c-string)
  (type int))

(def-alien-routine ("SSL_CTX_use_RSAPrivateKey_file" ssl-ctx-use-rsa-privatekey-file) int
  (ctx ssl-ctx)
  (str c-string)
  (type int))

(def-alien-routine ("SSL_use_certificate_file" ssl-use-certificate-file) int
  (ssl ssl-ptr)
  (str c-string)
  (type int))

(def-alien-routine ("SSL_CTX_load_verify_locations" ssl-ctx-load-verify-locations) int
  (ctx ssl-ctx)
  (CAfile c-string)
  (CApath c-string))

(def-alien-routine ("SSL_CTX_set_client_CA_list" ssl-ctx-set-client-ca-list) void
  (ctx ssl-ctx)
  (list x509-stack))

(def-alien-routine ("SSL_set_client_CA_list" ssl-set-client-ca-list) void
  (ssl ssl-ptr)
  (list x509-stack))

(def-alien-routine ("SSL_load_client_CA_file" ssl-load-client-ca-file) x509-stack
  (file c-string))

(defun make-byte-vector (size)
  (make-alien (unsigned 8) size))

(defun free-byte-vector (vector)
  (free-alien vector))

(defmacro bvref (buffer i)
  `(deref ,buffer ,i))