;;;
;;; FFI to access for GL, GLU, GLX, and GLUT from Allegro Common Lisp
;;;
;;; Richard Mann
;;; 31 October 1996
;;; 18 May 1998
;;;
;;; Copyright 1996 and 1997 University of Toronto. All rights reserved.
;;; Copyright 1998 NEC Research Institute, Inc. All rights reserved.

(in-package :gl)

;;;
;;; GL
;;;

(foreign-define GL_FALSE 0)
(foreign-define GL_TRUE 1)
(foreign-define GL_BYTE 5120)
(foreign-define GL_UNSIGNED_BYTE 5121)
(foreign-define GL_SHORT 5122)
(foreign-define GL_UNSIGNED_SHORT 5123)
(foreign-define GL_INT 5124)
(foreign-define GL_UNSIGNED_INT 5125)
(foreign-define GL_FLOAT 5126)
(foreign-define GL_2_BYTES 5127)
(foreign-define GL_3_BYTES 5128)
(foreign-define GL_4_BYTES 5129)
(foreign-define GL_LINES 1)
(foreign-define GL_POINTS 0)
(foreign-define GL_LINE_STRIP 3)
(foreign-define GL_LINE_LOOP 2)
(foreign-define GL_TRIANGLES 4)
(foreign-define GL_TRIANGLE_STRIP 5)
(foreign-define GL_TRIANGLE_FAN 6)
(foreign-define GL_QUADS 7)
(foreign-define GL_QUAD_STRIP 8)
(foreign-define GL_POLYGON 9)
(foreign-define GL_EDGE_FLAG 2883)
(foreign-define GL_MATRIX_MODE 2976)
(foreign-define GL_MODELVIEW 5888)
(foreign-define GL_PROJECTION 5889)
(foreign-define GL_TEXTURE 5890)
(foreign-define GL_POINT_SMOOTH 2832)
(foreign-define GL_POINT_SIZE 2833)
(foreign-define GL_POINT_SIZE_GRANULARITY 2835)
(foreign-define GL_POINT_SIZE_RANGE 2834)
(foreign-define GL_LINE_SMOOTH 2848)
(foreign-define GL_LINE_STIPPLE 2852)
(foreign-define GL_LINE_STIPPLE_PATTERN 2853)
(foreign-define GL_LINE_STIPPLE_REPEAT 2854)
(foreign-define GL_LINE_WIDTH 2849)
(foreign-define GL_LINE_WIDTH_GRANULARITY 2851)
(foreign-define GL_LINE_WIDTH_RANGE 2850)
(foreign-define GL_POINT 6912)
(foreign-define GL_LINE 6913)
(foreign-define GL_FILL 6914)
(foreign-define GL_CCW 2305)
(foreign-define GL_CW 2304)
(foreign-define GL_FRONT 1028)
(foreign-define GL_BACK 1029)
(foreign-define GL_CULL_FACE 2884)
(foreign-define GL_CULL_FACE_MODE 2885)
(foreign-define GL_POLYGON_SMOOTH 2881)
(foreign-define GL_POLYGON_STIPPLE 2882)
(foreign-define GL_FRONT_FACE 2886)
(foreign-define GL_POLYGON_MODE 2880)
(foreign-define GL_COMPILE 4864)
(foreign-define GL_COMPILE_AND_EXECUTE 4865)
(foreign-define GL_LIST_BASE 2866)
(foreign-define GL_LIST_INDEX 2867)
(foreign-define GL_LIST_MODE 2864)
(foreign-define GL_NEVER 512)
(foreign-define GL_LESS 513)
(foreign-define GL_GEQUAL 518)
(foreign-define GL_LEQUAL 515)
(foreign-define GL_GREATER 516)
(foreign-define GL_NOTEQUAL 517)
(foreign-define GL_EQUAL 514)
(foreign-define GL_ALWAYS 519)
(foreign-define GL_DEPTH_TEST 2929)
(foreign-define GL_DEPTH_BITS 3414)
(foreign-define GL_DEPTH_CLEAR_VALUE 2931)
(foreign-define GL_DEPTH_FUNC 2932)
(foreign-define GL_DEPTH_RANGE 2928)
(foreign-define GL_DEPTH_WRITEMASK 2930)
(foreign-define GL_DEPTH_COMPONENT 6402)
(foreign-define GL_LIGHTING 2896)
(foreign-define GL_LIGHT0 16384)
(foreign-define GL_LIGHT1 16385)
(foreign-define GL_LIGHT2 16386)
(foreign-define GL_LIGHT3 16387)
(foreign-define GL_LIGHT4 16388)
(foreign-define GL_LIGHT5 16389)
(foreign-define GL_LIGHT6 16390)
(foreign-define GL_LIGHT7 16391)
(foreign-define GL_SPOT_EXPONENT 4613)
(foreign-define GL_SPOT_CUTOFF 4614)
(foreign-define GL_CONSTANT_ATTENUATION 4615)
(foreign-define GL_LINEAR_ATTENUATION 4616)
(foreign-define GL_QUADRATIC_ATTENUATION 4617)
(foreign-define GL_AMBIENT 4608)
(foreign-define GL_DIFFUSE 4609)
(foreign-define GL_SPECULAR 4610)
(foreign-define GL_SHININESS 5633)
(foreign-define GL_EMISSION 5632)
(foreign-define GL_POSITION 4611)
(foreign-define GL_SPOT_DIRECTION 4612)
(foreign-define GL_AMBIENT_AND_DIFFUSE 5634)
(foreign-define GL_COLOR_INDEXES 5635)
(foreign-define GL_LIGHT_MODEL_TWO_SIDE 2898)
(foreign-define GL_LIGHT_MODEL_LOCAL_VIEWER 2897)
(foreign-define GL_LIGHT_MODEL_AMBIENT 2899)
(foreign-define GL_FRONT_AND_BACK 1032)
(foreign-define GL_SHADE_MODEL 2900)
(foreign-define GL_FLAT 7424)
(foreign-define GL_SMOOTH 7425)
(foreign-define GL_COLOR_MATERIAL 2903)
(foreign-define GL_COLOR_MATERIAL_FACE 2901)
(foreign-define GL_COLOR_MATERIAL_PARAMETER 2902)
(foreign-define GL_NORMALIZE 2977)
(foreign-define GL_CLIP_PLANE0 12288)
(foreign-define GL_CLIP_PLANE1 12289)
(foreign-define GL_CLIP_PLANE2 12290)
(foreign-define GL_CLIP_PLANE3 12291)
(foreign-define GL_CLIP_PLANE4 12292)
(foreign-define GL_CLIP_PLANE5 12293)
(foreign-define GL_ACCUM_RED_BITS 3416)
(foreign-define GL_ACCUM_GREEN_BITS 3417)
(foreign-define GL_ACCUM_BLUE_BITS 3418)
(foreign-define GL_ACCUM_ALPHA_BITS 3419)
(foreign-define GL_ACCUM_CLEAR_VALUE 2944)
(foreign-define GL_ACCUM 256)
(foreign-define GL_ADD 260)
(foreign-define GL_LOAD 257)
(foreign-define GL_MULT 259)
(foreign-define GL_RETURN 258)
(foreign-define GL_ALPHA_TEST 3008)
(foreign-define GL_ALPHA_TEST_REF 3010)
(foreign-define GL_ALPHA_TEST_FUNC 3009)
(foreign-define GL_BLEND 3042)
(foreign-define GL_BLEND_SRC 3041)
(foreign-define GL_BLEND_DST 3040)
(foreign-define GL_ZERO 0)
(foreign-define GL_ONE 1)
(foreign-define GL_SRC_COLOR 768)
(foreign-define GL_ONE_MINUS_SRC_COLOR 769)
(foreign-define GL_DST_COLOR 774)
(foreign-define GL_ONE_MINUS_DST_COLOR 775)
(foreign-define GL_SRC_ALPHA 770)
(foreign-define GL_ONE_MINUS_SRC_ALPHA 771)
(foreign-define GL_DST_ALPHA 772)
(foreign-define GL_ONE_MINUS_DST_ALPHA 773)
(foreign-define GL_SRC_ALPHA_SATURATE 776)
(foreign-define GL_FEEDBACK 7169)
(foreign-define GL_RENDER 7168)
(foreign-define GL_SELECT 7170)
(foreign-define GL_2D 1536)
(foreign-define GL_3D 1537)
(foreign-define GL_3D_COLOR 1538)
(foreign-define GL_3D_COLOR_TEXTURE 1539)
(foreign-define GL_4D_COLOR_TEXTURE 1540)
(foreign-define GL_POINT_TOKEN 1793)
(foreign-define GL_LINE_TOKEN 1794)
(foreign-define GL_LINE_RESET_TOKEN 1799)
(foreign-define GL_POLYGON_TOKEN 1795)
(foreign-define GL_BITMAP_TOKEN 1796)
(foreign-define GL_DRAW_PIXEL_TOKEN 1797)
(foreign-define GL_COPY_PIXEL_TOKEN 1798)
(foreign-define GL_PASS_THROUGH_TOKEN 1792)
(foreign-define GL_FOG 2912)
(foreign-define GL_FOG_MODE 2917)
(foreign-define GL_FOG_DENSITY 2914)
(foreign-define GL_FOG_COLOR 2918)
(foreign-define GL_FOG_INDEX 2913)
(foreign-define GL_FOG_START 2915)
(foreign-define GL_FOG_END 2916)
(foreign-define GL_LINEAR 9729)
(foreign-define GL_EXP 2048)
(foreign-define GL_EXP2 2049)
(foreign-define GL_LOGIC_OP 3057)
(foreign-define GL_LOGIC_OP_MODE 3056)
(foreign-define GL_CLEAR 5376)
(foreign-define GL_SET 5391)
(foreign-define GL_COPY 5379)
(foreign-define GL_COPY_INVERTED 5388)
(foreign-define GL_NOOP 5381)
(foreign-define GL_INVERT 5386)
(foreign-define GL_AND 5377)
(foreign-define GL_NAND 5390)
(foreign-define GL_OR 5383)
(foreign-define GL_NOR 5384)
(foreign-define GL_XOR 5382)
(foreign-define GL_EQUIV 5385)
(foreign-define GL_AND_REVERSE 5378)
(foreign-define GL_AND_INVERTED 5380)
(foreign-define GL_OR_REVERSE 5387)
(foreign-define GL_OR_INVERTED 5389)
(foreign-define GL_STENCIL_TEST 2960)
(foreign-define GL_STENCIL_WRITEMASK 2968)
(foreign-define GL_STENCIL_BITS 3415)
(foreign-define GL_STENCIL_FUNC 2962)
(foreign-define GL_STENCIL_VALUE_MASK 2963)
(foreign-define GL_STENCIL_REF 2967)
(foreign-define GL_STENCIL_FAIL 2964)
(foreign-define GL_STENCIL_PASS_DEPTH_PASS 2966)
(foreign-define GL_STENCIL_PASS_DEPTH_FAIL 2965)
(foreign-define GL_STENCIL_CLEAR_VALUE 2961)
(foreign-define GL_STENCIL_INDEX 6401)
(foreign-define GL_KEEP 7680)
(foreign-define GL_REPLACE 7681)
(foreign-define GL_INCR 7682)
(foreign-define GL_DECR 7683)
(foreign-define GL_NONE 0)
(foreign-define GL_LEFT 1030)
(foreign-define GL_RIGHT 1031)
(foreign-define GL_FRONT_LEFT 1024)
(foreign-define GL_FRONT_RIGHT 1025)
(foreign-define GL_BACK_LEFT 1026)
(foreign-define GL_BACK_RIGHT 1027)
(foreign-define GL_AUX0 1033)
(foreign-define GL_AUX1 1034)
(foreign-define GL_AUX2 1035)
(foreign-define GL_AUX3 1036)
(foreign-define GL_COLOR_INDEX 6400)
(foreign-define GL_RED 6403)
(foreign-define GL_GREEN 6404)
(foreign-define GL_BLUE 6405)
(foreign-define GL_ALPHA 6406)
(foreign-define GL_LUMINANCE 6409)
(foreign-define GL_LUMINANCE_ALPHA 6410)
(foreign-define GL_ALPHA_BITS 3413)
(foreign-define GL_RED_BITS 3410)
(foreign-define GL_GREEN_BITS 3411)
(foreign-define GL_BLUE_BITS 3412)
(foreign-define GL_INDEX_BITS 3409)
(foreign-define GL_SUBPIXEL_BITS 3408)
(foreign-define GL_AUX_BUFFERS 3072)
(foreign-define GL_READ_BUFFER 3074)
(foreign-define GL_DRAW_BUFFER 3073)
(foreign-define GL_DOUBLEBUFFER 3122)
(foreign-define GL_STEREO 3123)
(foreign-define GL_BITMAP 6656)
(foreign-define GL_COLOR 6144)
(foreign-define GL_DEPTH 6145)
(foreign-define GL_STENCIL 6146)
(foreign-define GL_DITHER 3024)
(foreign-define GL_RGB 6407)
(foreign-define GL_RGBA 6408)
(foreign-define GL_MAX_MODELVIEW_STACK_DEPTH 3382)
(foreign-define GL_MAX_PROJECTION_STACK_DEPTH 3384)
(foreign-define GL_MAX_TEXTURE_STACK_DEPTH 3385)
(foreign-define GL_MAX_ATTRIB_STACK_DEPTH 3381)
(foreign-define GL_MAX_NAME_STACK_DEPTH 3383)
(foreign-define GL_MAX_LIST_NESTING 2865)
(foreign-define GL_MAX_LIGHTS 3377)
(foreign-define GL_MAX_CLIP_PLANES 3378)
(foreign-define GL_MAX_VIEWPORT_DIMS 3386)
(foreign-define GL_MAX_PIXEL_MAP_TABLE 3380)
(foreign-define GL_MAX_EVAL_ORDER 3376)
(foreign-define GL_MAX_TEXTURE_SIZE 3379)
(foreign-define GL_ATTRIB_STACK_DEPTH 2992)
(foreign-define GL_COLOR_CLEAR_VALUE 3106)
(foreign-define GL_COLOR_WRITEMASK 3107)
(foreign-define GL_CURRENT_INDEX 2817)
(foreign-define GL_CURRENT_COLOR 2816)
(foreign-define GL_CURRENT_NORMAL 2818)
(foreign-define GL_CURRENT_RASTER_COLOR 2820)
(foreign-define GL_CURRENT_RASTER_DISTANCE 2825)
(foreign-define GL_CURRENT_RASTER_INDEX 2821)
(foreign-define GL_CURRENT_RASTER_POSITION 2823)
(foreign-define GL_CURRENT_RASTER_TEXTURE_COORDS 2822)
(foreign-define GL_CURRENT_RASTER_POSITION_VALID 2824)
(foreign-define GL_CURRENT_TEXTURE_COORDS 2819)
(foreign-define GL_INDEX_CLEAR_VALUE 3104)
(foreign-define GL_INDEX_MODE 3120)
(foreign-define GL_INDEX_WRITEMASK 3105)
(foreign-define GL_MODELVIEW_MATRIX 2982)
(foreign-define GL_MODELVIEW_STACK_DEPTH 2979)
(foreign-define GL_NAME_STACK_DEPTH 3440)
(foreign-define GL_PROJECTION_MATRIX 2983)
(foreign-define GL_PROJECTION_STACK_DEPTH 2980)
(foreign-define GL_RENDER_MODE 3136)
(foreign-define GL_RGBA_MODE 3121)
(foreign-define GL_TEXTURE_MATRIX 2984)
(foreign-define GL_TEXTURE_STACK_DEPTH 2981)
(foreign-define GL_VIEWPORT 2978)
(foreign-define GL_AUTO_NORMAL 3456)
(foreign-define GL_MAP1_COLOR_4 3472)
(foreign-define GL_MAP1_GRID_DOMAIN 3536)
(foreign-define GL_MAP1_GRID_SEGMENTS 3537)
(foreign-define GL_MAP1_INDEX 3473)
(foreign-define GL_MAP1_NORMAL 3474)
(foreign-define GL_MAP1_TEXTURE_COORD_1 3475)
(foreign-define GL_MAP1_TEXTURE_COORD_2 3476)
(foreign-define GL_MAP1_TEXTURE_COORD_3 3477)
(foreign-define GL_MAP1_TEXTURE_COORD_4 3478)
(foreign-define GL_MAP1_VERTEX_3 3479)
(foreign-define GL_MAP1_VERTEX_4 3480)
(foreign-define GL_MAP2_COLOR_4 3504)
(foreign-define GL_MAP2_GRID_DOMAIN 3538)
(foreign-define GL_MAP2_GRID_SEGMENTS 3539)
(foreign-define GL_MAP2_INDEX 3505)
(foreign-define GL_MAP2_NORMAL 3506)
(foreign-define GL_MAP2_TEXTURE_COORD_1 3507)
(foreign-define GL_MAP2_TEXTURE_COORD_2 3508)
(foreign-define GL_MAP2_TEXTURE_COORD_3 3509)
(foreign-define GL_MAP2_TEXTURE_COORD_4 3510)
(foreign-define GL_MAP2_VERTEX_3 3511)
(foreign-define GL_MAP2_VERTEX_4 3512)
(foreign-define GL_COEFF 2560)
(foreign-define GL_DOMAIN 2562)
(foreign-define GL_ORDER 2561)
(foreign-define GL_FOG_HINT 3156)
(foreign-define GL_LINE_SMOOTH_HINT 3154)
(foreign-define GL_PERSPECTIVE_CORRECTION_HINT 3152)
(foreign-define GL_POINT_SMOOTH_HINT 3153)
(foreign-define GL_POLYGON_SMOOTH_HINT 3155)
(foreign-define GL_DONT_CARE 4352)
(foreign-define GL_FASTEST 4353)
(foreign-define GL_NICEST 4354)
(foreign-define GL_SCISSOR_TEST 3089)
(foreign-define GL_SCISSOR_BOX 3088)
(foreign-define GL_MAP_COLOR 3344)
(foreign-define GL_MAP_STENCIL 3345)
(foreign-define GL_INDEX_SHIFT 3346)
(foreign-define GL_INDEX_OFFSET 3347)
(foreign-define GL_RED_SCALE 3348)
(foreign-define GL_RED_BIAS 3349)
(foreign-define GL_GREEN_SCALE 3352)
(foreign-define GL_GREEN_BIAS 3353)
(foreign-define GL_BLUE_SCALE 3354)
(foreign-define GL_BLUE_BIAS 3355)
(foreign-define GL_ALPHA_SCALE 3356)
(foreign-define GL_ALPHA_BIAS 3357)
(foreign-define GL_DEPTH_SCALE 3358)
(foreign-define GL_DEPTH_BIAS 3359)
(foreign-define GL_PIXEL_MAP_S_TO_S_SIZE 3249)
(foreign-define GL_PIXEL_MAP_I_TO_I_SIZE 3248)
(foreign-define GL_PIXEL_MAP_I_TO_R_SIZE 3250)
(foreign-define GL_PIXEL_MAP_I_TO_G_SIZE 3251)
(foreign-define GL_PIXEL_MAP_I_TO_B_SIZE 3252)
(foreign-define GL_PIXEL_MAP_I_TO_A_SIZE 3253)
(foreign-define GL_PIXEL_MAP_R_TO_R_SIZE 3254)
(foreign-define GL_PIXEL_MAP_G_TO_G_SIZE 3255)
(foreign-define GL_PIXEL_MAP_B_TO_B_SIZE 3256)
(foreign-define GL_PIXEL_MAP_A_TO_A_SIZE 3257)
(foreign-define GL_PIXEL_MAP_S_TO_S 3185)
(foreign-define GL_PIXEL_MAP_I_TO_I 3184)
(foreign-define GL_PIXEL_MAP_I_TO_R 3186)
(foreign-define GL_PIXEL_MAP_I_TO_G 3187)
(foreign-define GL_PIXEL_MAP_I_TO_B 3188)
(foreign-define GL_PIXEL_MAP_I_TO_A 3189)
(foreign-define GL_PIXEL_MAP_R_TO_R 3190)
(foreign-define GL_PIXEL_MAP_G_TO_G 3191)
(foreign-define GL_PIXEL_MAP_B_TO_B 3192)
(foreign-define GL_PIXEL_MAP_A_TO_A 3193)
(foreign-define GL_PACK_ALIGNMENT 3333)
(foreign-define GL_PACK_LSB_FIRST 3329)
(foreign-define GL_PACK_ROW_LENGTH 3330)
(foreign-define GL_PACK_SKIP_PIXELS 3332)
(foreign-define GL_PACK_SKIP_ROWS 3331)
(foreign-define GL_PACK_SWAP_BYTES 3328)
(foreign-define GL_UNPACK_ALIGNMENT 3317)
(foreign-define GL_UNPACK_LSB_FIRST 3313)
(foreign-define GL_UNPACK_ROW_LENGTH 3314)
(foreign-define GL_UNPACK_SKIP_PIXELS 3316)
(foreign-define GL_UNPACK_SKIP_ROWS 3315)
(foreign-define GL_UNPACK_SWAP_BYTES 3312)
(foreign-define GL_ZOOM_X 3350)
(foreign-define GL_ZOOM_Y 3351)
(foreign-define GL_TEXTURE_ENV 8960)
(foreign-define GL_TEXTURE_ENV_MODE 8704)
(foreign-define GL_TEXTURE_1D 3552)
(foreign-define GL_TEXTURE_2D 3553)
(foreign-define GL_TEXTURE_WRAP_S 10242)
(foreign-define GL_TEXTURE_WRAP_T 10243)
(foreign-define GL_TEXTURE_MAG_FILTER 10240)
(foreign-define GL_TEXTURE_MIN_FILTER 10241)
(foreign-define GL_TEXTURE_ENV_COLOR 8705)
(foreign-define GL_TEXTURE_GEN_S 3168)
(foreign-define GL_TEXTURE_GEN_T 3169)
(foreign-define GL_TEXTURE_GEN_MODE 9472)
(foreign-define GL_TEXTURE_BORDER_COLOR 4100)
(foreign-define GL_TEXTURE_WIDTH 4096)
(foreign-define GL_TEXTURE_HEIGHT 4097)
(foreign-define GL_TEXTURE_BORDER 4101)
(foreign-define GL_TEXTURE_COMPONENTS 4099)
(foreign-define GL_NEAREST_MIPMAP_NEAREST 9984)
(foreign-define GL_NEAREST_MIPMAP_LINEAR 9986)
(foreign-define GL_LINEAR_MIPMAP_NEAREST 9985)
(foreign-define GL_LINEAR_MIPMAP_LINEAR 9987)
(foreign-define GL_OBJECT_LINEAR 9217)
(foreign-define GL_OBJECT_PLANE 9473)
(foreign-define GL_EYE_LINEAR 9216)
(foreign-define GL_EYE_PLANE 9474)
(foreign-define GL_SPHERE_MAP 9218)
(foreign-define GL_DECAL 8449)
(foreign-define GL_MODULATE 8448)
(foreign-define GL_NEAREST 9728)
(foreign-define GL_REPEAT 10497)
(foreign-define GL_CLAMP 10496)
(foreign-define GL_S 8192)
(foreign-define GL_T 8193)
(foreign-define GL_R 8194)
(foreign-define GL_Q 8195)
(foreign-define GL_TEXTURE_GEN_R 3170)
(foreign-define GL_TEXTURE_GEN_Q 3171)
(foreign-define GL_VENDOR 7936)
(foreign-define GL_RENDERER 7937)
(foreign-define GL_VERSION 7938)
(foreign-define GL_EXTENSIONS 7939)
(foreign-define GL_INVALID_VALUE 1281)
(foreign-define GL_INVALID_ENUM 1280)
(foreign-define GL_INVALID_OPERATION 1282)
(foreign-define GL_STACK_OVERFLOW 1283)
(foreign-define GL_STACK_UNDERFLOW 1284)
(foreign-define GL_OUT_OF_MEMORY 1285)
(foreign-define GL_CONSTANT_COLOR_EXT 32769)
(foreign-define GL_ONE_MINUS_CONSTANT_COLOR_EXT 32770)
(foreign-define GL_CONSTANT_ALPHA_EXT 32771)
(foreign-define GL_ONE_MINUS_CONSTANT_ALPHA_EXT 32772)
(foreign-define GL_BLEND_EQUATION_EXT 32777)
(foreign-define GL_MIN_EXT 32775)
(foreign-define GL_MAX_EXT 32776)
(foreign-define GL_FUNC_ADD_EXT 32774)
(foreign-define GL_FUNC_SUBTRACT_EXT 32778)
(foreign-define GL_FUNC_REVERSE_SUBTRACT_EXT 32779)
(foreign-define GL_BLEND_COLOR_EXT 32773)
(foreign-define GL_REPLACE_EXT 32866)
(foreign-define GL_POLYGON_OFFSET_EXT 32823)
(foreign-define GL_POLYGON_OFFSET_FACTOR_EXT 32824)
(foreign-define GL_POLYGON_OFFSET_BIAS_EXT 32825)
(foreign-define GL_CURRENT_BIT 1)
(foreign-define GL_POINT_BIT 2)
(foreign-define GL_LINE_BIT 4)
(foreign-define GL_POLYGON_BIT 8)
(foreign-define GL_POLYGON_STIPPLE_BIT 16)
(foreign-define GL_PIXEL_MODE_BIT 32)
(foreign-define GL_LIGHTING_BIT 64)
(foreign-define GL_FOG_BIT 128)
(foreign-define GL_DEPTH_BUFFER_BIT 256)
(foreign-define GL_ACCUM_BUFFER_BIT 512)
(foreign-define GL_STENCIL_BUFFER_BIT 1024)
(foreign-define GL_VIEWPORT_BIT 2048)
(foreign-define GL_TRANSFORM_BIT 4096)
(foreign-define GL_ENABLE_BIT 8192)
(foreign-define GL_COLOR_BUFFER_BIT 16384)
(foreign-define GL_HINT_BIT 32768)
(foreign-define GL_EVAL_BIT 65536)
(foreign-define GL_LIST_BIT 131072)
(foreign-define GL_TEXTURE_BIT 262144)
(foreign-define GL_SCISSOR_BIT 524288)
(foreign-define GL_ALL_ATTRIB_BITS 1048575)

(foreign-function glclearindex (FLOAT) VOID "glClearIndex")
(foreign-function glclearcolor (FLOAT FLOAT FLOAT FLOAT) VOID "glClearColor")
(foreign-function glclear (INT) VOID "glClear")
(foreign-function glindexmask (UNSIGNED-INT) VOID "glIndexMask")
(foreign-function glcolormask (UNSIGNED-CHAR UNSIGNED-CHAR UNSIGNED-CHAR UNSIGNED-CHAR) VOID "glColorMask")
(foreign-function glalphafunc (INT FLOAT) VOID "glAlphaFunc")
(foreign-function glblendfunc (INT INT) VOID "glBlendFunc")
(foreign-function gllogicop (INT) VOID "glLogicOp")
(foreign-function glcullface (INT) VOID "glCullFace")
(foreign-function glfrontface (INT) VOID "glFrontFace")
(foreign-function glpointsize (FLOAT) VOID "glPointSize")
(foreign-function gllinewidth (FLOAT) VOID "glLineWidth")
(foreign-function gllinestipple (INT UNSIGNED-SHORT) VOID "glLineStipple")
(foreign-function glpolygonmode (INT INT) VOID "glPolygonMode")
(foreign-function glpolygonstipple ((POINTER UNSIGNED-CHAR)) VOID "glPolygonStipple")
(foreign-function glgetpolygonstipple ((POINTER UNSIGNED-CHAR)) VOID "glGetPolygonStipple")
(foreign-function gledgeflag (UNSIGNED-CHAR) VOID "glEdgeFlag")
(foreign-function gledgeflagv ((POINTER UNSIGNED-CHAR)) VOID "glEdgeFlagv")
(foreign-function glscissor (INT INT INT INT) VOID "glScissor")
(foreign-function glclipplane (INT (POINTER DOUBLE)) VOID "glClipPlane")
(foreign-function glgetclipplane (INT (POINTER DOUBLE)) VOID "glGetClipPlane")
(foreign-function gldrawbuffer (INT) VOID "glDrawBuffer")
(foreign-function glreadbuffer (INT) VOID "glReadBuffer")
(foreign-function glenable (INT) VOID "glEnable")
(foreign-function gldisable (INT) VOID "glDisable")
(foreign-function glisenabled (INT) UNSIGNED-CHAR "glIsEnabled")
(foreign-function glgetbooleanv (INT (POINTER UNSIGNED-CHAR)) VOID "glGetBooleanv")
(foreign-function glgetdoublev (INT (POINTER DOUBLE)) VOID "glGetDoublev")
(foreign-function glgetfloatv (INT (POINTER FLOAT)) VOID "glGetFloatv")
(foreign-function glgetintegerv (INT (POINTER INT)) VOID "glGetIntegerv")
(foreign-function glpushattrib (INT) VOID "glPushAttrib")
(foreign-function glpopattrib () VOID "glPopAttrib")
(foreign-function glrendermode (INT) INT "glRenderMode")
(foreign-function glgeterror () INT "glGetError")
(foreign-function glgetstring (INT) (POINTER UNSIGNED-CHAR) "glGetString")
(foreign-function glfinish () VOID "glFinish")
(foreign-function glflush () VOID "glFlush")
(foreign-function glhint (INT INT) VOID "glHint")
(foreign-function glcleardepth (DOUBLE) VOID "glClearDepth")
(foreign-function gldepthfunc (INT) VOID "glDepthFunc")
(foreign-function gldepthmask (UNSIGNED-CHAR) VOID "glDepthMask")
(foreign-function gldepthrange (DOUBLE DOUBLE) VOID "glDepthRange")
(foreign-function glclearaccum (FLOAT FLOAT FLOAT FLOAT) VOID "glClearAccum")
(foreign-function glaccum (INT FLOAT) VOID "glAccum")
(foreign-function glmatrixmode (INT) VOID "glMatrixMode")
(foreign-function glortho (DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glOrtho")
(foreign-function glfrustum (DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glFrustum")
(foreign-function glviewport (INT INT INT INT) VOID "glViewport")
(foreign-function glpushmatrix () VOID "glPushMatrix")
(foreign-function glpopmatrix () VOID "glPopMatrix")
(foreign-function glloadidentity () VOID "glLoadIdentity")
(foreign-function glloadmatrixd ((POINTER DOUBLE)) VOID "glLoadMatrixd")
(foreign-function glloadmatrixf ((POINTER FLOAT)) VOID "glLoadMatrixf")
(foreign-function glmultmatrixd ((POINTER DOUBLE)) VOID "glMultMatrixd")
(foreign-function glmultmatrixf ((POINTER FLOAT)) VOID "glMultMatrixf")
(foreign-function glrotated (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glRotated")
(foreign-function glrotatef (FLOAT FLOAT FLOAT FLOAT) VOID "glRotatef")
(foreign-function glscaled (DOUBLE DOUBLE DOUBLE) VOID "glScaled")
(foreign-function glscalef (FLOAT FLOAT FLOAT) VOID "glScalef")
(foreign-function gltranslated (DOUBLE DOUBLE DOUBLE) VOID "glTranslated")
(foreign-function gltranslatef (FLOAT FLOAT FLOAT) VOID "glTranslatef")
(foreign-function glislist (UNSIGNED-INT) UNSIGNED-CHAR "glIsList")
(foreign-function gldeletelists (UNSIGNED-INT INT) VOID "glDeleteLists")
(foreign-function glgenlists (INT) UNSIGNED-INT "glGenLists")
(foreign-function glnewlist (UNSIGNED-INT INT) VOID "glNewList")
(foreign-function glendlist () VOID "glEndList")
(foreign-function glcalllist (UNSIGNED-INT) VOID "glCallList")
(foreign-function glcalllists (INT INT (POINTER VOID)) VOID "glCallLists")
(foreign-function gllistbase (UNSIGNED-INT) VOID "glListBase")
(foreign-function glbegin (INT) VOID "glBegin")
(foreign-function glend () VOID "glEnd")
(foreign-function glvertex2d (DOUBLE DOUBLE) VOID "glVertex2d")
(foreign-function glvertex2f (FLOAT FLOAT) VOID "glVertex2f")
(foreign-function glvertex2i (INT INT) VOID "glVertex2i")
(foreign-function glvertex2s (SHORT SHORT) VOID "glVertex2s")
(foreign-function glvertex3d (DOUBLE DOUBLE DOUBLE) VOID "glVertex3d")
(foreign-function glvertex3f (FLOAT FLOAT FLOAT) VOID "glVertex3f")
(foreign-function glvertex3i (INT INT INT) VOID "glVertex3i")
(foreign-function glvertex3s (SHORT SHORT SHORT) VOID "glVertex3s")
(foreign-function glvertex4d (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glVertex4d")
(foreign-function glvertex4f (FLOAT FLOAT FLOAT FLOAT) VOID "glVertex4f")
(foreign-function glvertex4i (INT INT INT INT) VOID "glVertex4i")
(foreign-function glvertex4s (SHORT SHORT SHORT SHORT) VOID "glVertex4s")
(foreign-function glvertex2dv ((POINTER DOUBLE)) VOID "glVertex2dv")
(foreign-function glvertex2fv ((POINTER FLOAT)) VOID "glVertex2fv")
(foreign-function glvertex2iv ((POINTER INT)) VOID "glVertex2iv")
(foreign-function glvertex2sv ((POINTER SHORT)) VOID "glVertex2sv")
(foreign-function glvertex3dv ((POINTER DOUBLE)) VOID "glVertex3dv")
(foreign-function glvertex3fv ((POINTER FLOAT)) VOID "glVertex3fv")
(foreign-function glvertex3iv ((POINTER INT)) VOID "glVertex3iv")
(foreign-function glvertex3sv ((POINTER SHORT)) VOID "glVertex3sv")
(foreign-function glvertex4dv ((POINTER DOUBLE)) VOID "glVertex4dv")
(foreign-function glvertex4fv ((POINTER FLOAT)) VOID "glVertex4fv")
(foreign-function glvertex4iv ((POINTER INT)) VOID "glVertex4iv")
(foreign-function glvertex4sv ((POINTER SHORT)) VOID "glVertex4sv")
(foreign-function glnormal3b (SIGNED-CHAR SIGNED-CHAR SIGNED-CHAR) VOID "glNormal3b")
(foreign-function glnormal3d (DOUBLE DOUBLE DOUBLE) VOID "glNormal3d")
(foreign-function glnormal3f (FLOAT FLOAT FLOAT) VOID "glNormal3f")
(foreign-function glnormal3i (INT INT INT) VOID "glNormal3i")
(foreign-function glnormal3s (SHORT SHORT SHORT) VOID "glNormal3s")
(foreign-function glnormal3bv ((POINTER SIGNED-CHAR)) VOID "glNormal3bv")
(foreign-function glnormal3dv ((POINTER DOUBLE)) VOID "glNormal3dv")
(foreign-function glnormal3fv ((POINTER FLOAT)) VOID "glNormal3fv")
(foreign-function glnormal3iv ((POINTER INT)) VOID "glNormal3iv")
(foreign-function glnormal3sv ((POINTER SHORT)) VOID "glNormal3sv")
(foreign-function glindexd (DOUBLE) VOID "glIndexd")
(foreign-function glindexf (FLOAT) VOID "glIndexf")
(foreign-function glindexi (INT) VOID "glIndexi")
(foreign-function glindexs (SHORT) VOID "glIndexs")
(foreign-function glindexdv ((POINTER DOUBLE)) VOID "glIndexdv")
(foreign-function glindexfv ((POINTER FLOAT)) VOID "glIndexfv")
(foreign-function glindexiv ((POINTER INT)) VOID "glIndexiv")
(foreign-function glindexsv ((POINTER SHORT)) VOID "glIndexsv")
(foreign-function glcolor3b (SIGNED-CHAR SIGNED-CHAR SIGNED-CHAR) VOID "glColor3b")
(foreign-function glcolor3d (DOUBLE DOUBLE DOUBLE) VOID "glColor3d")
(foreign-function glcolor3f (FLOAT FLOAT FLOAT) VOID "glColor3f")
(foreign-function glcolor3i (INT INT INT) VOID "glColor3i")
(foreign-function glcolor3s (SHORT SHORT SHORT) VOID "glColor3s")
(foreign-function glcolor3ub (UNSIGNED-CHAR UNSIGNED-CHAR UNSIGNED-CHAR) VOID "glColor3ub")
(foreign-function glcolor3ui (UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT) VOID "glColor3ui")
(foreign-function glcolor3us (UNSIGNED-SHORT UNSIGNED-SHORT UNSIGNED-SHORT) VOID "glColor3us")
(foreign-function glcolor4b (SIGNED-CHAR SIGNED-CHAR SIGNED-CHAR SIGNED-CHAR) VOID "glColor4b")
(foreign-function glcolor4d (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glColor4d")
(foreign-function glcolor4f (FLOAT FLOAT FLOAT FLOAT) VOID "glColor4f")
(foreign-function glcolor4i (INT INT INT INT) VOID "glColor4i")
(foreign-function glcolor4s (SHORT SHORT SHORT SHORT) VOID "glColor4s")
(foreign-function glcolor4ub (UNSIGNED-CHAR UNSIGNED-CHAR UNSIGNED-CHAR UNSIGNED-CHAR) VOID "glColor4ub")
(foreign-function glcolor4ui (UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT) VOID "glColor4ui")
(foreign-function glcolor4us (UNSIGNED-SHORT UNSIGNED-SHORT UNSIGNED-SHORT UNSIGNED-SHORT) VOID "glColor4us")
(foreign-function glcolor3bv ((POINTER SIGNED-CHAR)) VOID "glColor3bv")
(foreign-function glcolor3dv ((POINTER DOUBLE)) VOID "glColor3dv")
(foreign-function glcolor3fv ((POINTER FLOAT)) VOID "glColor3fv")
(foreign-function glcolor3iv ((POINTER INT)) VOID "glColor3iv")
(foreign-function glcolor3sv ((POINTER SHORT)) VOID "glColor3sv")
(foreign-function glcolor3ubv ((POINTER UNSIGNED-CHAR)) VOID "glColor3ubv")
(foreign-function glcolor3uiv ((POINTER UNSIGNED-INT)) VOID "glColor3uiv")
(foreign-function glcolor3usv ((POINTER UNSIGNED-SHORT)) VOID "glColor3usv")
(foreign-function glcolor4bv ((POINTER SIGNED-CHAR)) VOID "glColor4bv")
(foreign-function glcolor4dv ((POINTER DOUBLE)) VOID "glColor4dv")
(foreign-function glcolor4fv ((POINTER FLOAT)) VOID "glColor4fv")
(foreign-function glcolor4iv ((POINTER INT)) VOID "glColor4iv")
(foreign-function glcolor4sv ((POINTER SHORT)) VOID "glColor4sv")
(foreign-function glcolor4ubv ((POINTER UNSIGNED-CHAR)) VOID "glColor4ubv")
(foreign-function glcolor4uiv ((POINTER UNSIGNED-INT)) VOID "glColor4uiv")
(foreign-function glcolor4usv ((POINTER UNSIGNED-SHORT)) VOID "glColor4usv")
(foreign-function gltexcoord1d (DOUBLE) VOID "glTexCoord1d")
(foreign-function gltexcoord1f (FLOAT) VOID "glTexCoord1f")
(foreign-function gltexcoord1i (INT) VOID "glTexCoord1i")
(foreign-function gltexcoord1s (SHORT) VOID "glTexCoord1s")
(foreign-function gltexcoord2d (DOUBLE DOUBLE) VOID "glTexCoord2d")
(foreign-function gltexcoord2f (FLOAT FLOAT) VOID "glTexCoord2f")
(foreign-function gltexcoord2i (INT INT) VOID "glTexCoord2i")
(foreign-function gltexcoord2s (SHORT SHORT) VOID "glTexCoord2s")
(foreign-function gltexcoord3d (DOUBLE DOUBLE DOUBLE) VOID "glTexCoord3d")
(foreign-function gltexcoord3f (FLOAT FLOAT FLOAT) VOID "glTexCoord3f")
(foreign-function gltexcoord3i (INT INT INT) VOID "glTexCoord3i")
(foreign-function gltexcoord3s (SHORT SHORT SHORT) VOID "glTexCoord3s")
(foreign-function gltexcoord4d (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glTexCoord4d")
(foreign-function gltexcoord4f (FLOAT FLOAT FLOAT FLOAT) VOID "glTexCoord4f")
(foreign-function gltexcoord4i (INT INT INT INT) VOID "glTexCoord4i")
(foreign-function gltexcoord4s (SHORT SHORT SHORT SHORT) VOID "glTexCoord4s")
(foreign-function gltexcoord1dv ((POINTER DOUBLE)) VOID "glTexCoord1dv")
(foreign-function gltexcoord1fv ((POINTER FLOAT)) VOID "glTexCoord1fv")
(foreign-function gltexcoord1iv ((POINTER INT)) VOID "glTexCoord1iv")
(foreign-function gltexcoord1sv ((POINTER SHORT)) VOID "glTexCoord1sv")
(foreign-function gltexcoord2dv ((POINTER DOUBLE)) VOID "glTexCoord2dv")
(foreign-function gltexcoord2fv ((POINTER FLOAT)) VOID "glTexCoord2fv")
(foreign-function gltexcoord2iv ((POINTER INT)) VOID "glTexCoord2iv")
(foreign-function gltexcoord2sv ((POINTER SHORT)) VOID "glTexCoord2sv")
(foreign-function gltexcoord3dv ((POINTER DOUBLE)) VOID "glTexCoord3dv")
(foreign-function gltexcoord3fv ((POINTER FLOAT)) VOID "glTexCoord3fv")
(foreign-function gltexcoord3iv ((POINTER INT)) VOID "glTexCoord3iv")
(foreign-function gltexcoord3sv ((POINTER SHORT)) VOID "glTexCoord3sv")
(foreign-function gltexcoord4dv ((POINTER DOUBLE)) VOID "glTexCoord4dv")
(foreign-function gltexcoord4fv ((POINTER FLOAT)) VOID "glTexCoord4fv")
(foreign-function gltexcoord4iv ((POINTER INT)) VOID "glTexCoord4iv")
(foreign-function gltexcoord4sv ((POINTER SHORT)) VOID "glTexCoord4sv")
(foreign-function glrasterpos2d (DOUBLE DOUBLE) VOID "glRasterPos2d")
(foreign-function glrasterpos2f (FLOAT FLOAT) VOID "glRasterPos2f")
(foreign-function glrasterpos2i (INT INT) VOID "glRasterPos2i")
(foreign-function glrasterpos2s (SHORT SHORT) VOID "glRasterPos2s")
(foreign-function glrasterpos3d (DOUBLE DOUBLE DOUBLE) VOID "glRasterPos3d")
(foreign-function glrasterpos3f (FLOAT FLOAT FLOAT) VOID "glRasterPos3f")
(foreign-function glrasterpos3i (INT INT INT) VOID "glRasterPos3i")
(foreign-function glrasterpos3s (SHORT SHORT SHORT) VOID "glRasterPos3s")
(foreign-function glrasterpos4d (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glRasterPos4d")
(foreign-function glrasterpos4f (FLOAT FLOAT FLOAT FLOAT) VOID "glRasterPos4f")
(foreign-function glrasterpos4i (INT INT INT INT) VOID "glRasterPos4i")
(foreign-function glrasterpos4s (SHORT SHORT SHORT SHORT) VOID "glRasterPos4s")
(foreign-function glrasterpos2dv ((POINTER DOUBLE)) VOID "glRasterPos2dv")
(foreign-function glrasterpos2fv ((POINTER FLOAT)) VOID "glRasterPos2fv")
(foreign-function glrasterpos2iv ((POINTER INT)) VOID "glRasterPos2iv")
(foreign-function glrasterpos2sv ((POINTER SHORT)) VOID "glRasterPos2sv")
(foreign-function glrasterpos3dv ((POINTER DOUBLE)) VOID "glRasterPos3dv")
(foreign-function glrasterpos3fv ((POINTER FLOAT)) VOID "glRasterPos3fv")
(foreign-function glrasterpos3iv ((POINTER INT)) VOID "glRasterPos3iv")
(foreign-function glrasterpos3sv ((POINTER SHORT)) VOID "glRasterPos3sv")
(foreign-function glrasterpos4dv ((POINTER DOUBLE)) VOID "glRasterPos4dv")
(foreign-function glrasterpos4fv ((POINTER FLOAT)) VOID "glRasterPos4fv")
(foreign-function glrasterpos4iv ((POINTER INT)) VOID "glRasterPos4iv")
(foreign-function glrasterpos4sv ((POINTER SHORT)) VOID "glRasterPos4sv")
(foreign-function glrectd (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "glRectd")
(foreign-function glrectf (FLOAT FLOAT FLOAT FLOAT) VOID "glRectf")
(foreign-function glrecti (INT INT INT INT) VOID "glRecti")
(foreign-function glrects (SHORT SHORT SHORT SHORT) VOID "glRects")
(foreign-function glrectdv ((POINTER DOUBLE) (POINTER DOUBLE)) VOID "glRectdv")
(foreign-function glrectfv ((POINTER FLOAT) (POINTER FLOAT)) VOID "glRectfv")
(foreign-function glrectiv ((POINTER INT) (POINTER INT)) VOID "glRectiv")
(foreign-function glrectsv ((POINTER SHORT) (POINTER SHORT)) VOID "glRectsv")
(foreign-function glshademodel (INT) VOID "glShadeModel")
(foreign-function gllightf (INT INT FLOAT) VOID "glLightf")
(foreign-function gllighti (INT INT INT) VOID "glLighti")
(foreign-function gllightfv (INT INT (POINTER FLOAT)) VOID "glLightfv")
(foreign-function gllightiv (INT INT (POINTER INT)) VOID "glLightiv")
(foreign-function glgetlightfv (INT INT (POINTER FLOAT)) VOID "glGetLightfv")
(foreign-function glgetlightiv (INT INT (POINTER INT)) VOID "glGetLightiv")
(foreign-function gllightmodelf (INT FLOAT) VOID "glLightModelf")
(foreign-function gllightmodeli (INT INT) VOID "glLightModeli")
(foreign-function gllightmodelfv (INT (POINTER FLOAT)) VOID "glLightModelfv")
(foreign-function gllightmodeliv (INT (POINTER INT)) VOID "glLightModeliv")
(foreign-function glmaterialf (INT INT FLOAT) VOID "glMaterialf")
(foreign-function glmateriali (INT INT INT) VOID "glMateriali")
(foreign-function glmaterialfv (INT INT (POINTER FLOAT)) VOID "glMaterialfv")
(foreign-function glmaterialiv (INT INT (POINTER INT)) VOID "glMaterialiv")
(foreign-function glgetmaterialfv (INT INT (POINTER FLOAT)) VOID "glGetMaterialfv")
(foreign-function glgetmaterialiv (INT INT (POINTER INT)) VOID "glGetMaterialiv")
(foreign-function glcolormaterial (INT INT) VOID "glColorMaterial")
(foreign-function glpixelzoom (FLOAT FLOAT) VOID "glPixelZoom")
(foreign-function glpixelstoref (INT FLOAT) VOID "glPixelStoref")
(foreign-function glpixelstorei (INT INT) VOID "glPixelStorei")
(foreign-function glpixeltransferf (INT FLOAT) VOID "glPixelTransferf")
(foreign-function glpixeltransferi (INT INT) VOID "glPixelTransferi")
(foreign-function glpixelmapfv (INT INT (POINTER FLOAT)) VOID "glPixelMapfv")
(foreign-function glpixelmapuiv (INT INT (POINTER UNSIGNED-INT)) VOID "glPixelMapuiv")
(foreign-function glpixelmapusv (INT INT (POINTER UNSIGNED-SHORT)) VOID "glPixelMapusv")
(foreign-function glgetpixelmapfv (INT (POINTER FLOAT)) VOID "glGetPixelMapfv")
(foreign-function glgetpixelmapuiv (INT (POINTER UNSIGNED-INT)) VOID "glGetPixelMapuiv")
(foreign-function glgetpixelmapusv (INT (POINTER UNSIGNED-SHORT)) VOID "glGetPixelMapusv")
(foreign-function glbitmap (INT INT FLOAT FLOAT FLOAT FLOAT (POINTER UNSIGNED-CHAR)) VOID "glBitmap")
(foreign-function glreadpixels (INT INT INT INT INT INT (POINTER VOID)) VOID "glReadPixels")
(foreign-function gldrawpixels (INT INT INT INT (POINTER VOID)) VOID "glDrawPixels")
(foreign-function glcopypixels (INT INT INT INT INT) VOID "glCopyPixels")
(foreign-function glstencilfunc (INT INT UNSIGNED-INT) VOID "glStencilFunc")
(foreign-function glstencilmask (UNSIGNED-INT) VOID "glStencilMask")
(foreign-function glstencilop (INT INT INT) VOID "glStencilOp")
(foreign-function glclearstencil (INT) VOID "glClearStencil")
(foreign-function gltexgend (INT INT DOUBLE) VOID "glTexGend")
(foreign-function gltexgenf (INT INT FLOAT) VOID "glTexGenf")
(foreign-function gltexgeni (INT INT INT) VOID "glTexGeni")
(foreign-function gltexgendv (INT INT (POINTER DOUBLE)) VOID "glTexGendv")
(foreign-function gltexgenfv (INT INT (POINTER FLOAT)) VOID "glTexGenfv")
(foreign-function gltexgeniv (INT INT (POINTER INT)) VOID "glTexGeniv")
(foreign-function glgettexgendv (INT INT (POINTER DOUBLE)) VOID "glGetTexGendv")
(foreign-function glgettexgenfv (INT INT (POINTER FLOAT)) VOID "glGetTexGenfv")
(foreign-function glgettexgeniv (INT INT (POINTER INT)) VOID "glGetTexGeniv")
(foreign-function gltexenvf (INT INT FLOAT) VOID "glTexEnvf")
(foreign-function gltexenvi (INT INT INT) VOID "glTexEnvi")
(foreign-function gltexenvfv (INT INT (POINTER FLOAT)) VOID "glTexEnvfv")
(foreign-function gltexenviv (INT INT (POINTER INT)) VOID "glTexEnviv")
(foreign-function glgettexenvfv (INT INT (POINTER FLOAT)) VOID "glGetTexEnvfv")
(foreign-function glgettexenviv (INT INT (POINTER INT)) VOID "glGetTexEnviv")
(foreign-function gltexparameterf (INT INT FLOAT) VOID "glTexParameterf")
(foreign-function gltexparameteri (INT INT INT) VOID "glTexParameteri")
(foreign-function gltexparameterfv (INT INT (POINTER FLOAT)) VOID "glTexParameterfv")
(foreign-function gltexparameteriv (INT INT (POINTER INT)) VOID "glTexParameteriv")
(foreign-function glgettexparameterfv (INT INT (POINTER FLOAT)) VOID "glGetTexParameterfv")
(foreign-function glgettexparameteriv (INT INT (POINTER INT)) VOID "glGetTexParameteriv")
(foreign-function glgettexlevelparameterfv (INT INT INT (POINTER FLOAT)) VOID "glGetTexLevelParameterfv")
(foreign-function glgettexlevelparameteriv (INT INT INT (POINTER INT)) VOID "glGetTexLevelParameteriv")
(foreign-function glteximage1d (INT INT INT INT INT INT INT (POINTER VOID)) VOID "glTexImage1D")
(foreign-function glteximage2d (INT INT INT INT INT INT INT INT (POINTER VOID)) VOID "glTexImage2D")
(foreign-function glgetteximage (INT INT INT INT (POINTER VOID)) VOID "glGetTexImage")
(foreign-function glmap1d (INT DOUBLE DOUBLE INT INT (POINTER DOUBLE)) VOID "glMap1d")
(foreign-function glmap1f (INT FLOAT FLOAT INT INT (POINTER FLOAT)) VOID "glMap1f")
(foreign-function glmap2d (INT DOUBLE DOUBLE INT INT DOUBLE DOUBLE INT INT (POINTER DOUBLE)) VOID "glMap2d")
(foreign-function glmap2f (INT FLOAT FLOAT INT INT FLOAT FLOAT INT INT (POINTER FLOAT)) VOID "glMap2f")
(foreign-function glgetmapdv (INT INT (POINTER DOUBLE)) VOID "glGetMapdv")
(foreign-function glgetmapfv (INT INT (POINTER FLOAT)) VOID "glGetMapfv")
(foreign-function glgetmapiv (INT INT (POINTER INT)) VOID "glGetMapiv")
(foreign-function glevalcoord1d (DOUBLE) VOID "glEvalCoord1d")
(foreign-function glevalcoord1f (FLOAT) VOID "glEvalCoord1f")
(foreign-function glevalcoord1dv ((POINTER DOUBLE)) VOID "glEvalCoord1dv")
(foreign-function glevalcoord1fv ((POINTER FLOAT)) VOID "glEvalCoord1fv")
(foreign-function glevalcoord2d (DOUBLE DOUBLE) VOID "glEvalCoord2d")
(foreign-function glevalcoord2f (FLOAT FLOAT) VOID "glEvalCoord2f")
(foreign-function glevalcoord2dv ((POINTER DOUBLE)) VOID "glEvalCoord2dv")
(foreign-function glevalcoord2fv ((POINTER FLOAT)) VOID "glEvalCoord2fv")
(foreign-function glmapgrid1d (INT DOUBLE DOUBLE) VOID "glMapGrid1d")
(foreign-function glmapgrid1f (INT FLOAT FLOAT) VOID "glMapGrid1f")
(foreign-function glmapgrid2d (INT DOUBLE DOUBLE INT DOUBLE DOUBLE) VOID "glMapGrid2d")
(foreign-function glmapgrid2f (INT FLOAT FLOAT INT FLOAT FLOAT) VOID "glMapGrid2f")
(foreign-function glevalpoint1 (INT) VOID "glEvalPoint1")
(foreign-function glevalpoint2 (INT INT) VOID "glEvalPoint2")
(foreign-function glevalmesh1 (INT INT INT) VOID "glEvalMesh1")
(foreign-function glevalmesh2 (INT INT INT INT INT) VOID "glEvalMesh2")
(foreign-function glfogf (INT FLOAT) VOID "glFogf")
(foreign-function glfogi (INT INT) VOID "glFogi")
(foreign-function glfogfv (INT (POINTER FLOAT)) VOID "glFogfv")
(foreign-function glfogiv (INT (POINTER INT)) VOID "glFogiv")
(foreign-function glfeedbackbuffer (INT INT (POINTER FLOAT)) VOID "glFeedbackBuffer")
(foreign-function glpassthrough (FLOAT) VOID "glPassThrough")
(foreign-function glselectbuffer (INT (POINTER UNSIGNED-INT)) VOID "glSelectBuffer")
(foreign-function glinitnames () VOID "glInitNames")
(foreign-function glloadname (UNSIGNED-INT) VOID "glLoadName")
(foreign-function glpushname (UNSIGNED-INT) VOID "glPushName")
(foreign-function glpopname () VOID "glPopName")
(foreign-function glblendequationext (INT) VOID "glBlendEquationEXT")
(foreign-function glblendcolorext (FLOAT FLOAT FLOAT FLOAT) VOID "glBlendColorEXT")
;;(foreign-function glpolygonoffsetext (FLOAT FLOAT) VOID "glPolygonOffsetEXT")

;;;
;;; GLU
;;;

(foreign-define GLU_SMOOTH 100000)
(foreign-define GLU_FLAT 100001)
(foreign-define GLU_NONE 100002)
(foreign-define GLU_POINT 100010)
(foreign-define GLU_LINE 100011)
(foreign-define GLU_FILL 100012)
(foreign-define GLU_SILHOUETTE 100013)
(foreign-define GLU_OUTSIDE 100020)
(foreign-define GLU_INSIDE 100021)
(foreign-define GLU_BEGIN 100100)
(foreign-define GLU_VERTEX 100101)
(foreign-define GLU_END 100102)
(foreign-define GLU_ERROR 100103)
(foreign-define GLU_EDGE_FLAG 100104)
(foreign-define GLU_CW 100120)
(foreign-define GLU_CCW 100121)
(foreign-define GLU_INTERIOR 100122)
(foreign-define GLU_EXTERIOR 100123)
(foreign-define GLU_UNKNOWN 100124)
(foreign-define GLU_TESS_ERROR1 100151)
(foreign-define GLU_TESS_ERROR2 100152)
(foreign-define GLU_TESS_ERROR3 100153)
(foreign-define GLU_TESS_ERROR4 100154)
(foreign-define GLU_TESS_ERROR5 100155)
(foreign-define GLU_TESS_ERROR6 100156)
(foreign-define GLU_TESS_ERROR7 100157)
(foreign-define GLU_TESS_ERROR8 100158)
(foreign-define GLU_TESS_ERROR9 100159)
(foreign-define GLU_AUTO_LOAD_MATRIX 100200)
(foreign-define GLU_CULLING 100201)
(foreign-define GLU_PARAMETRIC_TOLERANCE 100202)
(foreign-define GLU_SAMPLING_TOLERANCE 100203)
(foreign-define GLU_DISPLAY_MODE 100204)
(foreign-define GLU_SAMPLING_METHOD 100205)
(foreign-define GLU_U_STEP 100206)
(foreign-define GLU_V_STEP 100207)
(foreign-define GLU_PATH_LENGTH 100215)
(foreign-define GLU_PARAMETRIC_ERROR 100216)
(foreign-define GLU_DOMAIN_DISTANCE 100217)
(foreign-define GLU_MAP1_TRIM_2 100210)
(foreign-define GLU_MAP1_TRIM_3 100211)
(foreign-define GLU_OUTLINE_POLYGON 100240)
(foreign-define GLU_OUTLINE_PATCH 100241)
(foreign-define GLU_NURBS_ERROR1 100251)
(foreign-define GLU_NURBS_ERROR2 100252)
(foreign-define GLU_NURBS_ERROR3 100253)
(foreign-define GLU_NURBS_ERROR4 100254)
(foreign-define GLU_NURBS_ERROR5 100255)
(foreign-define GLU_NURBS_ERROR6 100256)
(foreign-define GLU_NURBS_ERROR7 100257)
(foreign-define GLU_NURBS_ERROR8 100258)
(foreign-define GLU_NURBS_ERROR9 100259)
(foreign-define GLU_NURBS_ERROR10 100260)
(foreign-define GLU_NURBS_ERROR11 100261)
(foreign-define GLU_NURBS_ERROR12 100262)
(foreign-define GLU_NURBS_ERROR13 100263)
(foreign-define GLU_NURBS_ERROR14 100264)
(foreign-define GLU_NURBS_ERROR15 100265)
(foreign-define GLU_NURBS_ERROR16 100266)
(foreign-define GLU_NURBS_ERROR17 100267)
(foreign-define GLU_NURBS_ERROR18 100268)
(foreign-define GLU_NURBS_ERROR19 100269)
(foreign-define GLU_NURBS_ERROR20 100270)
(foreign-define GLU_NURBS_ERROR21 100271)
(foreign-define GLU_NURBS_ERROR22 100272)
(foreign-define GLU_NURBS_ERROR23 100273)
(foreign-define GLU_NURBS_ERROR24 100274)
(foreign-define GLU_NURBS_ERROR25 100275)
(foreign-define GLU_NURBS_ERROR26 100276)
(foreign-define GLU_NURBS_ERROR27 100277)
(foreign-define GLU_NURBS_ERROR28 100278)
(foreign-define GLU_NURBS_ERROR29 100279)
(foreign-define GLU_NURBS_ERROR30 100280)
(foreign-define GLU_NURBS_ERROR31 100281)
(foreign-define GLU_NURBS_ERROR32 100282)
(foreign-define GLU_NURBS_ERROR33 100283)
(foreign-define GLU_NURBS_ERROR34 100284)
(foreign-define GLU_NURBS_ERROR35 100285)
(foreign-define GLU_NURBS_ERROR36 100286)
(foreign-define GLU_NURBS_ERROR37 100287)
(foreign-define GLU_INVALID_ENUM 100900)
(foreign-define GLU_INVALID_VALUE 100901)
(foreign-define GLU_OUT_OF_MEMORY 100902)
(foreign-define GLU_INCOMPATIBLE_GL_VERSION 100903)
(foreign-define GLU_VERSION 100800)
(foreign-define GLU_EXTENSIONS 100801)

(foreign-function glulookat (DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE) VOID "gluLookAt")
(foreign-function gluortho2d (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "gluOrtho2D")
(foreign-function gluperspective (DOUBLE DOUBLE DOUBLE DOUBLE) VOID "gluPerspective")
(foreign-function glupickmatrix (DOUBLE DOUBLE DOUBLE DOUBLE (POINTER INT)) VOID "gluPickMatrix")
(foreign-function gluproject (DOUBLE DOUBLE DOUBLE (POINTER DOUBLE) (POINTER DOUBLE) (POINTER INT) (POINTER DOUBLE) (POINTER DOUBLE) (POINTER DOUBLE)) INT "gluProject")
(foreign-function gluunproject (DOUBLE DOUBLE DOUBLE (POINTER DOUBLE) (POINTER DOUBLE) (POINTER INT) (POINTER DOUBLE) (POINTER DOUBLE) (POINTER DOUBLE)) INT "gluUnProject")
(foreign-function gluerrorstring (INT) (POINTER UNSIGNED-CHAR) "gluErrorString")
(foreign-function gluscaleimage (INT INT INT INT (POINTER VOID) INT INT INT (POINTER VOID)) INT "gluScaleImage")
(foreign-function glubuild1dmipmaps (INT INT INT INT INT (POINTER VOID)) INT "gluBuild1DMipmaps")
(foreign-function glubuild2dmipmaps (INT INT INT INT INT INT (POINTER VOID)) INT "gluBuild2DMipmaps")
(foreign-function glunewquadric () (POINTER (STRUCT "GLUquadricObj")) "gluNewQuadric")
(foreign-function gludeletequadric ((POINTER (STRUCT "GLUquadricObj"))) VOID "gluDeleteQuadric")
(foreign-function gluquadricdrawstyle ((POINTER (STRUCT "GLUquadricObj")) INT) VOID "gluQuadricDrawStyle")
(foreign-function gluquadricorientation ((POINTER (STRUCT "GLUquadricObj")) INT) VOID "gluQuadricOrientation")
(foreign-function gluquadricnormals ((POINTER (STRUCT "GLUquadricObj")) INT) VOID "gluQuadricNormals")
(foreign-function gluquadrictexture ((POINTER (STRUCT "GLUquadricObj")) UNSIGNED-CHAR) VOID "gluQuadricTexture")
(foreign-function gluquadriccallback ((POINTER (STRUCT "GLUquadricObj")) INT (POINTER FUNCTION)) VOID "gluQuadricCallback")
(foreign-function glucylinder ((POINTER (STRUCT "GLUquadricObj")) DOUBLE DOUBLE DOUBLE INT INT) VOID "gluCylinder")
(foreign-function glusphere ((POINTER (STRUCT "GLUquadricObj")) DOUBLE INT INT) VOID "gluSphere")
(foreign-function gludisk ((POINTER (STRUCT "GLUquadricObj")) DOUBLE DOUBLE INT INT) VOID "gluDisk")
(foreign-function glupartialdisk ((POINTER (STRUCT "GLUquadricObj")) DOUBLE DOUBLE INT INT DOUBLE DOUBLE) VOID "gluPartialDisk")
(foreign-function glunewnurbsrenderer () (POINTER (STRUCT "GLUnurbsObj")) "gluNewNurbsRenderer")
(foreign-function gludeletenurbsrenderer ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluDeleteNurbsRenderer")
(foreign-function gluloadsamplingmatrices ((POINTER (STRUCT "GLUnurbsObj")) (POINTER FLOAT) (POINTER FLOAT) (POINTER INT)) VOID "gluLoadSamplingMatrices")
(foreign-function glunurbsproperty ((POINTER (STRUCT "GLUnurbsObj")) INT FLOAT) VOID "gluNurbsProperty")
(foreign-function glugetnurbsproperty ((POINTER (STRUCT "GLUnurbsObj")) INT (POINTER FLOAT)) VOID "gluGetNurbsProperty")
(foreign-function glubegincurve ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluBeginCurve")
(foreign-function gluendcurve ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluEndCurve")
(foreign-function glunurbscurve ((POINTER (STRUCT "GLUnurbsObj")) INT (POINTER FLOAT) INT (POINTER FLOAT) INT INT) VOID "gluNurbsCurve")
(foreign-function glubeginsurface ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluBeginSurface")
(foreign-function gluendsurface ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluEndSurface")
(foreign-function glunurbssurface ((POINTER (STRUCT "GLUnurbsObj")) INT (POINTER FLOAT) INT (POINTER FLOAT) INT INT (POINTER FLOAT) INT INT INT) VOID "gluNurbsSurface")
(foreign-function glubegintrim ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluBeginTrim")
(foreign-function gluendtrim ((POINTER (STRUCT "GLUnurbsObj"))) VOID "gluEndTrim")
(foreign-function glupwlcurve ((POINTER (STRUCT "GLUnurbsObj")) INT (POINTER FLOAT) INT INT) VOID "gluPwlCurve")
(foreign-function glunurbscallback ((POINTER (STRUCT "GLUnurbsObj")) INT (POINTER FUNCTION)) VOID "gluNurbsCallback")
(foreign-function glunewtess () (POINTER (STRUCT "GLUtriangulatorObj")) "gluNewTess")
(foreign-function glutesscallback ((POINTER (STRUCT "GLUtriangulatorObj")) INT (POINTER FUNCTION)) VOID "gluTessCallback")
(foreign-function gludeletetess ((POINTER (STRUCT "GLUtriangulatorObj"))) VOID "gluDeleteTess")
(foreign-function glubeginpolygon ((POINTER (STRUCT "GLUtriangulatorObj"))) VOID "gluBeginPolygon")
(foreign-function gluendpolygon ((POINTER (STRUCT "GLUtriangulatorObj"))) VOID "gluEndPolygon")
(foreign-function glunextcontour ((POINTER (STRUCT "GLUtriangulatorObj")) INT) VOID "gluNextContour")
(foreign-function glutessvertex ((POINTER (STRUCT "GLUtriangulatorObj")) (POINTER DOUBLE) (POINTER VOID)) VOID "gluTessVertex")
(foreign-function glugetstring (INT) (POINTER UNSIGNED-CHAR) "gluGetString")

;;;
;;; GLX
;;;

(foreign-define GLX_VERSION 2)
(foreign-define GLX_BAD_VALUE 6)
(foreign-define GLX_EXTENSIONS 3)
(foreign-define GLX_BAD_VISUAL 4)
(foreign-define GLX_BAD_SCREEN 1)
(foreign-define GLX_BAD_ENUM 7)
(foreign-define GLX_BAD_ATTRIBUTE 2)
(foreign-define GLX_VENDOR 1)
(foreign-define GLX_BAD_CONTEXT 5)
(foreign-define GLX_H "")
(foreign-define GLX_VERSION_1_1 1)
(foreign-define GLX_NO_EXTENSION 3)
(foreign-define GLX_USE_GL 1)
(foreign-define GLX_BUFFER_SIZE 2)
(foreign-define GLX_LEVEL 3)
(foreign-define GLX_RGBA 4)
(foreign-define GLX_DOUBLEBUFFER 5)
(foreign-define GLX_STEREO 6)
(foreign-define GLX_AUX_BUFFERS 7)
(foreign-define GLX_RED_SIZE 8)
(foreign-define GLX_GREEN_SIZE 9)
(foreign-define GLX_BLUE_SIZE 10)
(foreign-define GLX_ALPHA_SIZE 11)
(foreign-define GLX_DEPTH_SIZE 12)
(foreign-define GLX_STENCIL_SIZE 13)
(foreign-define GLX_ACCUM_RED_SIZE 14)
(foreign-define GLX_ACCUM_GREEN_SIZE 15)
(foreign-define GLX_ACCUM_BLUE_SIZE 16)
(foreign-define GLX_ACCUM_ALPHA_SIZE 17)
(foreign-define GLX_SAMPLES_SGIS 100000)
(foreign-define GLX_SAMPLE_BUFFER_SGIS 100001)

(foreign-function glxchoosevisual ((POINTER STRUCT) INT (POINTER INT)) (POINTER STRUCT) "glXChooseVisual")
(foreign-function glxcreatecontext ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT) INT) (POINTER STRUCT) "glXCreateContext")
(foreign-function glxdestroycontext ((POINTER STRUCT) (POINTER STRUCT)) VOID "glXDestroyContext")
(foreign-function glxmakecurrent ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "glXMakeCurrent")
(foreign-function glxcopycontext ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT) UNSIGNED-INT) VOID "glXCopyContext")
(foreign-function glxswapbuffers ((POINTER STRUCT) UNSIGNED-LONG) VOID "glXSwapBuffers")
(foreign-function glxcreateglxpixmap ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) UNSIGNED-LONG "glXCreateGLXPixmap")
(foreign-function glxdestroyglxpixmap ((POINTER STRUCT) UNSIGNED-LONG) VOID "glXDestroyGLXPixmap")
(foreign-function glxqueryextension ((POINTER STRUCT) (POINTER INT) (POINTER INT)) INT "glXQueryExtension")
(foreign-function glxqueryversion ((POINTER STRUCT) (POINTER INT) (POINTER INT)) INT "glXQueryVersion")
(foreign-function glxisdirect ((POINTER STRUCT) (POINTER STRUCT)) INT "glXIsDirect")
(foreign-function glxgetconfig ((POINTER STRUCT) (POINTER STRUCT) INT (POINTER INT)) INT "glXGetConfig")
(foreign-function glxgetcurrentcontext () (POINTER STRUCT) "glXGetCurrentContext")
(foreign-function glxgetcurrentdrawable () UNSIGNED-LONG "glXGetCurrentDrawable")
(foreign-function glxwaitgl () VOID "glXWaitGL")
(foreign-function glxwaitx () VOID "glXWaitX")
(foreign-function glxusexfont (UNSIGNED-LONG INT INT INT) VOID "glXUseXFont")
(foreign-function glxqueryextensionsstring ((POINTER STRUCT) INT) STRING "glXQueryExtensionsString")
(foreign-function glxqueryserverstring ((POINTER STRUCT) INT INT) STRING "glXQueryServerString")
(foreign-function glxgetclientstring ((POINTER STRUCT) INT) STRING "glXGetClientString")

;;;
;;; GLUT
;;;

(foreign-define GLUT_NUM_SPACEBALL_BUTTONS 606)
(foreign-define GLUT_OVERLAY_DAMAGED 805)
(foreign-define GLUT_WINDOW_STENCIL_SIZE 105)
(foreign-define GLUT_OVERLAY_POSSIBLE 800)
(foreign-define GLUT_CURSOR_TOP_LEFT_CORNER 16)
(foreign-define GLUT_VIDEO_RESIZE_Y 907)
(foreign-define GLUT_API_VERSION 3)
(foreign-define GLUT_VIDEO_RESIZE_X 906)
(foreign-define GLUT_NOT_VISIBLE 0)
(foreign-define GL_NO_ERROR GL_FALSE)
(foreign-define GLUT_PARTIALLY_RETAINED 2)
(foreign-define GLUT_HAS_OVERLAY 802)
(foreign-define GLUT_RGB 0)
(foreign-define GLUT_RED 0)
(foreign-define GLUT_DISPLAY_MODE_POSSIBLE 400)
(foreign-define GLUT_SCREEN_HEIGHT 201)
(foreign-define GL_EXT_blend_logic_op 1)
(foreign-define GLUT_WINDOW_RGBA 116)
(foreign-define GLUT_STEREO 256)
(foreign-define GLUT_CURSOR_LEFT_ARROW 1)
;(foreign-define APIENTRY "")
(foreign-define GLUT_SCREEN_HEIGHT_MM 203)
(foreign-define GLUT_VIDEO_RESIZE_WIDTH_DELTA 904)
(foreign-define GLUT_ACTIVE_CTRL 2)
(foreign-define GLUT_CURSOR_INHERIT 100)
(foreign-define GLUT_WINDOW_NUM_CHILDREN 118)
(foreign-define GLUT_MULTISAMPLE 128)
; GLUT_STROKE_MONO_ROMAN (&glutStrokeMonoRoman)
(foreign-define GLUT_CURSOR_SPRAY 6)
(foreign-define GLUT_INIT_WINDOW_WIDTH 502)
(foreign-define GLUT_NORMAL 0)
(foreign-define GLUT_KEY_F9 9)
(foreign-define GLUT_MENU_NOT_IN_USE 0)
(foreign-define GLUT_KEY_F8 8)
(foreign-define GLUT_KEY_RIGHT 102)
(foreign-define GLUT_WINDOW_DEPTH_SIZE 106)
(foreign-define GLUT_KEY_F7 7)
(foreign-define GLUT_CURSOR_LEFT_RIGHT 11)
(foreign-define GLUT_KEY_F6 6)
(foreign-define GLUT_HAS_MOUSE 601)
(foreign-define GLUT_CURSOR_BOTTOM_LEFT_CORNER 19)
(foreign-define GLUT_KEY_F5 5)
(foreign-define GLUT_SINGLE 0)
(foreign-define GLUT_KEY_F4 4)
(foreign-define GLUT_WINDOW_GREEN_SIZE 108)
(foreign-define GLUT_HAS_SPACEBALL 602)
(foreign-define GLUT_KEY_F3 3)
(foreign-define GLUT_WINDOW_ACCUM_BLUE_SIZE 113)
(foreign-define GLUT_KEY_F2 2)
(foreign-define GLUT_VIDEO_RESIZE_HEIGHT 909)
(foreign-define GLUT_KEY_F1 1)
; GLUT_BITMAP_TIMES_ROMAN_24 (&glutBitmapTimesRoman24)
(foreign-define GLUT_LAYER_IN_USE 801)
(foreign-define GLUT_CURSOR_RIGHT_SIDE 15)
(foreign-define GLUT_NUM_DIALS 608)
(foreign-define GLUT_DOUBLE 2)
; GLUT_BITMAP_TIMES_ROMAN_10 (&glutBitmapTimesRoman10)
(foreign-define GLUT_RIGHT_BUTTON 2)
(foreign-define GLUT_DOWN 0)
(foreign-define GLUT_FULLY_RETAINED 1)
(foreign-define GLUT_WINDOW_WIDTH 102)
(foreign-define GLUT_WINDOW_ALPHA_SIZE 110)
(foreign-define GLUT_CURSOR_TOP_RIGHT_CORNER 17)
(foreign-define GLUT_XLIB_IMPLEMENTATION 9)
; GLUT_STROKE_ROMAN (&glutStrokeRoman)
(foreign-define GLUT_CURSOR_TOP_SIDE 12)
(foreign-define GLUT_WINDOW_COLORMAP_SIZE 119)
(foreign-define GLUT_INIT_DISPLAY_MODE 504)
(foreign-define GLUT_CURSOR_CYCLE 5)
(foreign-define GLUT_HIDDEN 0)
(foreign-define GLUT_WINDOW_RED_SIZE 107)
(foreign-define GLUT_WINDOW_DOUBLEBUFFER 115)
(foreign-define GLUT_LEFT 0)
(foreign-define GL_EXT_blend_color 1)
(foreign-define GLUT_TRANSPARENT_INDEX 803)
(foreign-define GLUT_VIDEO_RESIZE_Y_DELTA 903)
(foreign-define GLUT_BLUE 2)
(foreign-define GLUT_VIDEO_RESIZE_X_DELTA 902)
(foreign-define GLUT_UP 1)
(foreign-define GLUT_CURSOR_RIGHT_ARROW 0)
(foreign-define GLUT_INIT_WINDOW_Y 501)
(foreign-define GLUT_OVERLAY 1)
(foreign-define GLUT_INIT_WINDOW_X 500)
;(foreign-define _NO_LONGLONG 1) ; already defined in Xlib
;(foreign-define GL_H "")
(foreign-define GLUT_KEY_END 107)
(foreign-define GLUT_SCREEN_WIDTH 200)
(foreign-define GLUT_KEY_INSERT 108)
(foreign-define GLUT_RGBA GLUT_RGB)
(foreign-define GLUT_LUMINANCE 512)
(foreign-define GLUT_WINDOW_NUM_SAMPLES 120)
(foreign-define GLUT_NUM_TABLET_BUTTONS 609)
(foreign-define GLUT_ACTIVE_SHIFT 1)
(foreign-define GLUT_SCREEN_WIDTH_MM 202)
(foreign-define GLU_FALSE GL_FALSE)
(foreign-define GLUT_CURSOR_BOTTOM_RIGHT_CORNER 18)
(foreign-define GLUT_CURSOR_BOTTOM_SIDE 13)
(foreign-define GL_EXT_blend_minmax 1)
(foreign-define GL_EXT_polygon_offset 1)
(foreign-define GLUT_WINDOW_CURSOR 122)
; GLUT_BITMAP_9_BY_15 (&glutBitmap9By15)
(foreign-define CALLBACK "")
(foreign-define GLUT_STENCIL 32)
; GLUT_BITMAP_8_BY_13 (&glutBitmap8By13)
(foreign-define GLUT_WINDOW_Y 101)
(foreign-define GLUT_WINDOW_X 100)
(foreign-define GLUT_VISIBLE 1)
(foreign-define GLUT_ELAPSED_TIME 700)
(foreign-define GLUT_HAS_KEYBOARD 600)
;(foreign-define MESA "")
(foreign-define GLUT_WINDOW_BUFFER_SIZE 104)
(foreign-define GLUT_NORMAL_DAMAGED 804)
(foreign-define GLUT_WINDOW_ACCUM_GREEN_SIZE 112)
(foreign-define GLUT_HAS_DIAL_AND_BUTTON_BOX 603)
(foreign-define GLUT_WINDOW_STEREO 121)
(foreign-define GLUT_VIDEO_RESIZE_HEIGHT_DELTA 905)
(foreign-define GLUT_ENTERED 1)
(foreign-define GLUT_VIDEO_RESIZE_WIDTH 908)
(foreign-define GLUT_INIT_WINDOW_HEIGHT 503)
(foreign-define GLUT_CURSOR_TEXT 8)
(foreign-define GLUT_WINDOW_PARENT 117)
(foreign-define GLUT_NUM_BUTTON_BOX_BUTTONS 607)
(foreign-define GLUT_KEY_DOWN 103)
(foreign-define GLUT_WINDOW_ACCUM_ALPHA_SIZE 114)
(foreign-define GLUT_CURSOR_FULL_CROSSHAIR 102)
(foreign-define GLUT_KEY_PAGE_DOWN 105)
(foreign-define GLUT_ACTIVE_ALT 4)
; GLUT_BITMAP_HELVETICA_18 (&glutBitmapHelvetica18)
(foreign-define GLUT_WINDOW_BLUE_SIZE 109)
(foreign-define GLUT_CURSOR_UP_DOWN 10)
(foreign-define GLUT_INDEX 1)
(foreign-define GLUT_MENU_IN_USE 1)
(foreign-define GLUT_HAS_TABLET 604)
(foreign-define GLUT_DEPTH 16)
;(foreign-define GLU_H "")
(foreign-define GLUT_WINDOW_ACCUM_RED_SIZE 111)
(foreign-define GL_EXT_blend_subtract 1)
(foreign-define GLUT_KEY_LEFT 100)
(foreign-define GLUT_FULLY_COVERED 3)
; GLUT_BITMAP_HELVETICA_12 (&glutBitmapHelvetica12)
(foreign-define GLU_VERSION_1_1 1)
(foreign-define GLUT_CURSOR_WAIT 7)
(foreign-define GLUT_KEY_F12 12)
(foreign-define GLUT_KEY_HOME 106)
(foreign-define GLUT_GREEN 1)
; GLUT_BITMAP_HELVETICA_10 (&glutBitmapHelvetica10)
(foreign-define GLUT_KEY_F11 11)
(foreign-define GLUT_WINDOW_HEIGHT 103)
(foreign-define GLUT_KEY_F10 10)
(foreign-define GLUT_KEY_UP 101)
(foreign-define GLUT_CURSOR_NONE 101)
; GLU_TRUE GL_TRUE
(foreign-define GLUT_CURSOR_LEFT_SIDE 14)
(foreign-define GLUT_CURSOR_CROSSHAIR 9)
(foreign-define GLUT_MIDDLE_BUTTON 1)
(foreign-define GLUT_VIDEO_RESIZE_IN_USE 901)
(foreign-define GLUT_ACCUM 4)
(foreign-define GLUT_KEY_PAGE_UP 104)
(foreign-define GLUT_CURSOR_INFO 2)
(foreign-define GLUT_VIDEO_RESIZE_POSSIBLE 900)
(foreign-define GLUT_CURSOR_DESTROY 3)
(foreign-define GLUT_ALPHA 8)
(foreign-define GLUT_LEFT_BUTTON 0)
(foreign-define GLUT_NUM_MOUSE_BUTTONS 605)
(foreign-define GLUT_CURSOR_HELP 4)
(foreign-define GLUT_MENU_NUM_ITEMS 300)

;(foreign-function glutinit ((POINTER INT) (POINTER (POINTER CHAR))) VOID "glutInit")
(foreign-function glutinitdisplaymode (UNSIGNED-INT) VOID "glutInitDisplayMode")
(foreign-function glutinitdisplaystring ((POINTER CHAR)) VOID "glutInitDisplayString")
(foreign-function glutinitwindowposition (INT INT) VOID "glutInitWindowPosition")
(foreign-function glutinitwindowsize (INT INT) VOID "glutInitWindowSize")
(foreign-function glutmainloop () VOID "glutMainLoop")
(foreign-function glutcreatewindow ((POINTER CHAR)) INT "glutCreateWindow")
(foreign-function glutcreatesubwindow (INT INT INT INT INT) INT "glutCreateSubWindow")
(foreign-function glutdestroywindow (INT) VOID "glutDestroyWindow")
(foreign-function glutpostredisplay () VOID "glutPostRedisplay")
(foreign-function glutswapbuffers () VOID "glutSwapBuffers")
(foreign-function glutgetwindow () INT "glutGetWindow")
(foreign-function glutsetwindow (INT) VOID "glutSetWindow")
(foreign-function glutsetwindowtitle ((POINTER CHAR)) VOID "glutSetWindowTitle")
(foreign-function glutseticontitle ((POINTER CHAR)) VOID "glutSetIconTitle")
(foreign-function glutpositionwindow (INT INT) VOID "glutPositionWindow")
(foreign-function glutreshapewindow (INT INT) VOID "glutReshapeWindow")
(foreign-function glutpopwindow () VOID "glutPopWindow")
(foreign-function glutpushwindow () VOID "glutPushWindow")
(foreign-function gluticonifywindow () VOID "glutIconifyWindow")
(foreign-function glutshowwindow () VOID "glutShowWindow")
(foreign-function gluthidewindow () VOID "glutHideWindow")
(foreign-function glutfullscreen () VOID "glutFullScreen")
(foreign-function glutsetcursor (INT) VOID "glutSetCursor")
(foreign-function glutwarppointer (INT INT) VOID "glutWarpPointer")
(foreign-function glutestablishoverlay () VOID "glutEstablishOverlay")
(foreign-function glutremoveoverlay () VOID "glutRemoveOverlay")
(foreign-function glutuselayer (INT) VOID "glutUseLayer")
(foreign-function glutpostoverlayredisplay () VOID "glutPostOverlayRedisplay")
(foreign-function glutshowoverlay () VOID "glutShowOverlay")
(foreign-function gluthideoverlay () VOID "glutHideOverlay")
(foreign-function glutcreatemenu ((POINTER FUNCTION)) INT "glutCreateMenu")
(foreign-function glutdestroymenu (INT) VOID "glutDestroyMenu")
(foreign-function glutgetmenu () INT "glutGetMenu")
(foreign-function glutsetmenu (INT) VOID "glutSetMenu")
(foreign-function glutaddmenuentry ((POINTER CHAR) INT) VOID "glutAddMenuEntry")
(foreign-function glutaddsubmenu ((POINTER CHAR) INT) VOID "glutAddSubMenu")
(foreign-function glutchangetomenuentry (INT (POINTER CHAR) INT) VOID "glutChangeToMenuEntry")
(foreign-function glutchangetosubmenu (INT (POINTER CHAR) INT) VOID "glutChangeToSubMenu")
(foreign-function glutremovemenuitem (INT) VOID "glutRemoveMenuItem")
(foreign-function glutattachmenu (INT) VOID "glutAttachMenu")
(foreign-function glutdetachmenu (INT) VOID "glutDetachMenu")
(foreign-function glutdisplayfunc ((POINTER FUNCTION)) VOID "glutDisplayFunc")
(foreign-function glutreshapefunc ((POINTER FUNCTION)) VOID "glutReshapeFunc")
(foreign-function glutkeyboardfunc ((POINTER FUNCTION)) VOID "glutKeyboardFunc")
(foreign-function glutmousefunc ((POINTER FUNCTION)) VOID "glutMouseFunc")
(foreign-function glutmotionfunc ((POINTER FUNCTION)) VOID "glutMotionFunc")
(foreign-function glutpassivemotionfunc ((POINTER FUNCTION)) VOID "glutPassiveMotionFunc")
(foreign-function glutentryfunc ((POINTER FUNCTION)) VOID "glutEntryFunc")
(foreign-function glutvisibilityfunc ((POINTER FUNCTION)) VOID "glutVisibilityFunc")
(foreign-function glutidlefunc ((POINTER FUNCTION)) VOID "glutIdleFunc")
(foreign-function gluttimerfunc (UNSIGNED-INT (POINTER FUNCTION) INT) VOID "glutTimerFunc")
(foreign-function glutmenustatefunc ((POINTER FUNCTION)) VOID "glutMenuStateFunc")
(foreign-function glutspecialfunc ((POINTER FUNCTION)) VOID "glutSpecialFunc")
(foreign-function glutspaceballmotionfunc ((POINTER FUNCTION)) VOID "glutSpaceballMotionFunc")
(foreign-function glutspaceballrotatefunc ((POINTER FUNCTION)) VOID "glutSpaceballRotateFunc")
(foreign-function glutspaceballbuttonfunc ((POINTER FUNCTION)) VOID "glutSpaceballButtonFunc")
(foreign-function glutbuttonboxfunc ((POINTER FUNCTION)) VOID "glutButtonBoxFunc")
(foreign-function glutdialsfunc ((POINTER FUNCTION)) VOID "glutDialsFunc")
(foreign-function gluttabletmotionfunc ((POINTER FUNCTION)) VOID "glutTabletMotionFunc")
(foreign-function gluttabletbuttonfunc ((POINTER FUNCTION)) VOID "glutTabletButtonFunc")
(foreign-function glutmenustatusfunc ((POINTER FUNCTION)) VOID "glutMenuStatusFunc")
(foreign-function glutoverlaydisplayfunc ((POINTER FUNCTION)) VOID "glutOverlayDisplayFunc")
(foreign-function glutwindowstatusfunc ((POINTER FUNCTION)) VOID "glutWindowStatusFunc")
(foreign-function glutsetcolor (INT FLOAT FLOAT FLOAT) VOID "glutSetColor")
(foreign-function glutgetcolor (INT INT) FLOAT "glutGetColor")
(foreign-function glutcopycolormap (INT) VOID "glutCopyColormap")
(foreign-function glutget (INT) INT "glutGet")
(foreign-function glutdeviceget (INT) INT "glutDeviceGet")
(foreign-function glutextensionsupported ((POINTER CHAR)) INT "glutExtensionSupported")
(foreign-function glutgetmodifiers () INT "glutGetModifiers")
(foreign-function glutlayerget (INT) INT "glutLayerGet")
(foreign-function glutbitmapcharacter ((POINTER VOID) INT) VOID "glutBitmapCharacter")
(foreign-function glutbitmapwidth ((POINTER VOID) INT) INT "glutBitmapWidth")
(foreign-function glutstrokecharacter ((POINTER VOID) INT) VOID "glutStrokeCharacter")
(foreign-function glutstrokewidth ((POINTER VOID) INT) INT "glutStrokeWidth")
(foreign-function glutbitmaplength ((POINTER VOID) (POINTER UNSIGNED-CHAR)) INT "glutBitmapLength")
(foreign-function glutstrokelength ((POINTER VOID) (POINTER UNSIGNED-CHAR)) INT "glutStrokeLength")
(foreign-function glutwiresphere (DOUBLE INT INT) VOID "glutWireSphere")
(foreign-function glutsolidsphere (DOUBLE INT INT) VOID "glutSolidSphere")
(foreign-function glutwirecone (DOUBLE DOUBLE INT INT) VOID "glutWireCone")
(foreign-function glutsolidcone (DOUBLE DOUBLE INT INT) VOID "glutSolidCone")
(foreign-function glutwirecube (DOUBLE) VOID "glutWireCube")
(foreign-function glutsolidcube (DOUBLE) VOID "glutSolidCube")
(foreign-function glutwiretorus (DOUBLE DOUBLE INT INT) VOID "glutWireTorus")
(foreign-function glutsolidtorus (DOUBLE DOUBLE INT INT) VOID "glutSolidTorus")
(foreign-function glutwiredodecahedron () VOID "glutWireDodecahedron")
(foreign-function glutsoliddodecahedron () VOID "glutSolidDodecahedron")
(foreign-function glutwireteapot (DOUBLE) VOID "glutWireTeapot")
(foreign-function glutsolidteapot (DOUBLE) VOID "glutSolidTeapot")
(foreign-function glutwireoctahedron () VOID "glutWireOctahedron")
(foreign-function glutsolidoctahedron () VOID "glutSolidOctahedron")
(foreign-function glutwiretetrahedron () VOID "glutWireTetrahedron")
(foreign-function glutsolidtetrahedron () VOID "glutSolidTetrahedron")
(foreign-function glutwireicosahedron () VOID "glutWireIcosahedron")
(foreign-function glutsolidicosahedron () VOID "glutSolidIcosahedron")
(foreign-function glutvideoresizeget (INT) INT "glutVideoResizeGet")
(foreign-function glutsetupvideoresizing () VOID "glutSetupVideoResizing")
(foreign-function glutstopvideoresizing () VOID "glutStopVideoResizing")
(foreign-function glutvideoresize (INT INT INT INT) VOID "glutVideoResize")
(foreign-function glutvideopan (INT INT INT INT) VOID "glutVideoPan")
(foreign-function glutreporterrors () VOID "glutReportErrors")


;;; *** STRUCTS ***
;;; STRUCT:GLUquadricObj
;;; STRUCT:GLUtriangulatorObj
;;; STRUCT:GLUnurbsObj

;;; *** VARIABLES ***
;;; VARIABLE: glutStrokeRoman
(foreign-function glutstrokeroman () (POINTER (POINTER VOID)) "glob_glutStrokeRoman")
;;; VARIABLE: glutStrokeMonoRoman
(foreign-function glutstrokemonoroman () (POINTER (POINTER VOID)) "glob_glutStrokeMonoRoman")
;;; VARIABLE: glutBitmap9By15
(foreign-function glutbitmap9by15 () (POINTER (POINTER VOID)) "glob_glutBitmap9By15")
;;; VARIABLE: glutBitmap8By13
(foreign-function glutbitmap8by13 () (POINTER (POINTER VOID)) "glob_glutBitmap8By13")
;;; VARIABLE: glutBitmapTimesRoman10
(foreign-function glutbitmaptimesroman10 () (POINTER (POINTER VOID)) "glob_glutBitmapTimesRoman10")
;;; VARIABLE: glutBitmapTimesRoman24
(foreign-function glutbitmaptimesroman24 () (POINTER (POINTER VOID)) "glob_glutBitmapTimesRoman24")
;;; VARIABLE: glutBitmapHelvetica10
(foreign-function glutbitmaphelvetica10 () (POINTER (POINTER VOID)) "glob_glutBitmapHelvetica10")
;;; VARIABLE: glutBitmapHelvetica12
(foreign-function glutbitmaphelvetica12 () (POINTER (POINTER VOID)) "glob_glutBitmapHelvetica12")
;;; VARIABLE: glutBitmapHelvetica18
(foreign-function glutbitmaphelvetica18 () (POINTER (POINTER VOID)) "glob_glutBitmapHelvetica18")
