
(use-package :gl)

(defvar Xrot nil)
(defvar Xstep nil)
(defvar Yrot nil)
(defvar Ystep nil)
(defvar Zrot nil)
(defvar Zstep nil)
(defvar Step 5.0)
(defvar Scale 1.0)
(defvar Object nil)
(defvar animate? nil)
(defvar idle-callback)
(defvar draw-callback)
(defvar key-callback)
(defvar visible-callback)
(defvar reshape-callback)

(defun make-object ()
 (let ((list (glgenlists 1)))
  (glnewlist list GL_COMPILE)
  ;;
  (glBegin GL_LINE_LOOP)
  (glVertex3f 1.0 0.5 -0.4)
  (glVertex3f 1.0 -0.5 -0.4)
  (glVertex3f -1.0 -0.5 -0.4)
  (glVertex3f -1.0 0.5 -0.4)
  (glEnd)
  ;;
  (glBegin GL_LINE_LOOP)
  (glVertex3f 1.0 0.5 0.4)
  (glVertex3f 1.0 -0.5 0.4)
  (glVertex3f -1.0 -0.5 0.4)
  (glVertex3f -1.0 0.5 0.4)
  (glEnd)
  ;;
  (glBegin GL_LINES)
  (glVertex3f 1.0 0.5 -0.4)   (glVertex3f 1.0 0.5 0.4)
  (glVertex3f 1.0 -0.5 -0.4)  (glVertex3f 1.0 -0.5 0.4)
  (glVertex3f -1.0 -0.5 -0.4) (glVertex3f -1.0 -0.5 0.4)
  (glVertex3f -1.0 0.5 -0.4)  (glVertex3f -1.0 0.5 0.4)
  (glEnd)
  ;;
  (glEndList)
  ;;
  list))

(ff:defun-c-callable reshape-callback ((width :fixnum) (height :fixnum))
 (format t "RESHAPE. width:~a, height:~a~%" width height)
 (glViewport 0 0 width height)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 (glFrustum -1d0 1d0 -1d0 1d0 5d0 15d0)
 (glMatrixMode GL_MODELVIEW)
 (glLoadIdentity))

(ff:defun-c-callable draw-callback ()
 (format t "DRAW.~%")
 (glClear GL_COLOR_BUFFER_BIT)
 (glPushMatrix)
 (glTranslatef 0.0 0.0 -10.0)
 (glScalef Scale Scale Scale)
 (cond
   ((> xstep 0)
    (glrotatef (coerce xrot 'single-float) 1.0 0.0 0.0))
   ((> ystep 0)
    (glrotatef (coerce yrot 'single-float) 0.0 1.0 0.0))
   ((> zstep 0)
    (glrotatef (coerce zrot 'single-float) 0.0 0.0 1.0)))
 ;;
 (glcalllist object)
 ;;
 (glpopmatrix)
 ;;
 (glutSwapBuffers))

(ff:defun-c-callable idle-callback ()
 ;;
 (format t "IDLE.~%")
 (setf xrot (+ xrot xstep))
 (setf yrot (+ yrot ystep))
 (setf zrot (+ zrot zstep))
 ;;
 (cond
   ((>= xrot 360.0)
    (setf xrot 0)
    (setf xstep 0)
    (setf ystep step))
   ((>= yrot 360.0)
    (setf yrot 0)
    (setf ystep 0)
    (setf zstep step))
   ((>= zrot 360.0)
    (setf zrot 0)
    (setf zstep 0)
    (setf xstep step)))
 (glutPostRedisplay))

(ff:defun-c-callable visible-callback ((vis :fixnum))
 (format t "VISIBLE. vis:~a~%" vis)
 (cond ((= vis GLUT_VISIBLE)
        (glutIdleFunc idle-callback))
       (t
        (glutIdleFunc 0))))

(ff:defun-c-callable key-callback ((k :fixnum) (x :fixnum) (y :fixnum))
 (format t "KEY. k:~s, x:~s, y:~s~%" k x y)
 (case (character k)
   (#\Return
    (setf animate? (not animate?))
    (if animate?
	(glutIdleFunc idle-callback)
	(glutIdleFunc 0)))
   (#\Escape
    (glutDestroyWindow window)
    (break))))

(setq draw-callback (ff:register-function 'draw-callback))
(setq idle-callback (ff:register-function 'idle-callback))
(setq key-callback (ff:register-function 'key-callback))
(setq visible-callback (ff:register-function 'visible-callback))
(setq reshape-callback (ff:register-function 'reshape-callback))


(defun main ()
 (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize 300 300)
 (setq window (glutCreateWindow "spin"))
 
 ;; used by draw routine.
 (setf object (make-object))
 ;;
 (glcullface GL_BACK)
 (glenable GL_CULL_FACE)
 (gldisable GL_DITHER)
 (glshademodel GL_FLAT)
 (glcolor3f 1.0 1.0 1.0)
 ;;
 ;; Initial state of animation.
 (setf xrot 0)  (setf yrot 0)  (setf zrot 0)
 (setf xstep step)  (setf ystep 0)  (setf zstep 0)
 (setf animate? t)
 ;;
 (glutDisplayFunc draw-callback)
 (glutReshapeFunc reshape-callback)
 (glutIdleFunc idle-callback)
 (glutKeyboardFunc key-callback)
 (glutVisibilityFunc visible-callback)

 (glutMainLoop))
