(in-package :allegro-interface)

;;;
;;; FFI to access for GL, GLU, GLX, and GLUT from Allegro Common Lisp
;;;
;;; Richard Mann
;;; 31 October 1996
;;; 18 May 1998
;;;
;;; Copyright 1996 and 1997 University of Toronto. All rights reserved.
;;; Copyright 1998 NEC Research Institute, Inc. All rights reserved.

;;;
;;; Update of (foreign-function) to work with Windows DLL.
;;; 
;;; Mark Owen Riedl
;;; 02 May 2001
;;;

(defmacro foreign-define (name value)
 `(eval-when (compile eval load)
   (defconstant ,name ,value)
   (export ',name)))

(defmacro foreign-function (name arguments rettype string)
   `(eval-when (compile eval load)
      (ff:defforeign
       ',name
       :entry-point (string-downcase ,string)          ; Added (string-downcase) - MOR
       :arguments
       ',(mapcar
          #'(lambda (x)
              (cond ((listp x)
                     (cond ((listp (cadr x))
                            (and (eq (car x) 'pointer) 
                                 (or (eq (caddr x) 'union)
                                     (eq (caddr x) 'struct)))
                            'integer)
                           (t (cond ((and (eq (car x) 'pointer)
                                          (or (eq (cadr x) 'function)
                                              ;;(eq (cadr x) 'void)
                                              (eq (cadr x) 'struct)
                                              (eq (cadr x) 'union)))
                                     'integer)
                                  (t 'array)))))
                    (t (case x
                         (string 'string)
                         ((char signed-char) 'character)
                         (float 'single-float)
                         (double 'double-float)
                         ((unsigned-char
                           short unsigned-short
                           int unsigned-int
                           long unsigned-long)
                          'fixnum)
                         (otherwise 'integer)))))
          arguments)
       :prototype t
       :return-type
       ,(case rettype
          (void :void)
          (string :integer)
          ((unsigned-char
            short unsigned-short
            int unsigned-int
            long unsigned-long) :fixnum)
          (float :single-float)
          (double :double-float)
          (char :character)
          (pointer :integer)
          (otherwise :integer)))
      (export ',name)))
