
;;;
;;; FFI to access Misc C utilities from GCL (Gnu Common Lisp)
;;;
;;; For now, this file contains bindings for low-level array access.
;;; These are not needed now, but I may want them later on.
;;;
;;; Note: I tried to pass pointers as (POINTER VOID) = "void*", but
;;; this did not work.  Now I just use INT for all pointers.
;;;
;;; Richard Mann
;;; 31 October 1996
;;;

(eval-when (compile)
 (load "foreign.lsp"))

;;; Free memory
(foreign-function free (INT) VOID "free")
(foreign-function calloc (INT INT) INT "calloc")

;;; Microsecond delay
(foreign-function usleep (INT) INT "usleep")

;;;
;;; Types: CHAR, UNSIGNEDCHAR, SHORTINT, UNSIGNEDSHORTINT, INT, UNSIGNEDINT, 
;;; LONGINT, UNSIGNEDLONGINT, FLOAT, DOUBLE.
;;;
;;; Just do INT and CHAR for now.
;;;

(foreign-function make-chara (INT) INT "make_chara")
(foreign-function chara-ref (INT INT) CHAR "chara_ref")
(foreign-function chara-set! (INT INT CHAR) CHAR "chara_set")
(foreign-function make-char () INT "make_char")
(foreign-function char-ref (INT) CHAR "char_ref")
(foreign-function char-set! (INT CHAR) CHAR "char_set")

(foreign-function make-inta (INT) INT "make_inta")
(foreign-function inta-ref (INT INT) INT "inta_ref")
(foreign-function inta-set! (INT INT INT) INT "inta_set")
(foreign-function make-int () INT "make_int")
(foreign-function int-ref (INT) INT "int_ref")
(foreign-function int-set! (INT INT) INT "int_set")
