C********************************************************************
C     DETERMINATION OF STEPSIZE BY AN ARMIJO-LIKE TEST FOR
C     DESCENT
C********************************************************************
      SUBROUTINE O8UNIM(SIG1TH)
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8CONS.INC'
      DOUBLE PRECISION SIG1TH
C**** SIG1TH THE FIRST PROPOSED STEPSIZE FOR SEARCHING ON THE ARC
C**** IF SIG=ONE DID'NT WORK
C
C   N = NUMBER OF VARIABLES
C   X = CURRENT POINT
C   D = DIRECTION OF DESCENT. DD = SECOND ORDER CORRECTION
C   X,D = INPUT
C   X0,D0 ETC. INFORMATION FROM PREVIOUS STEP
C
C   XNORM,DNORM = EUCLIDEAN LENGTH OF X AND D
C   STPTRM = 1 ON SUCCESS , =-1 OR =-2 OTHERWISE
C   SIG = COMPUTED STEPSIZE
C   IT IS ASSUMED THAT ONE IS ASYMPTOTICALLY OPTIMAL
C   SIGSM = SMALLEST ACCEPTABLE STEPSIZE
C   SIGLA = LARGEST ACCEPTABLE STEPSIZE
C   ALPHA = SMALLEST FEASIBLE REDUCTION FACTOR FOR STEPSIZE
C   DELTA = MULTIPLIER FOR DERIVATIVE SHOULD BE SMALLER THAN .25
C   BETA = MAXIMUM FEASIBLE INCREASE OF X-NORM FOR SIG=1
C   THETA = BOUND FOR COS(ANGLE(CURRENT DIRECTION, PREVIOUS DIRECTION))
C           IF OVERRIDDEN, STEPSIZE LARGER THAN ONE IS TRIED
C
C*********************************************************************
C*** LOCAL
      INTEGER I,L,J
      DOUBLE PRECISION TERM,MAXPHI
      DOUBLE PRECISION SIGRES ,DIFF
      DOUBLE PRECISION STEP(NSTEP)
      LOGICAL DESC,DESCRE,SMINFE,LAINFE,REJECT,ERROR
      SAVE
      DATA STEP/P5,TWOM2,38*TM1/
C*** PROJECTION OF D, RESCALING AND COMPUTING DIRDER HAS BEEN DONE
C*** ALREADY
      L=0
      ERROR=.FALSE.
      PHI=SCF*FX+PSI
      SIG=SIG1TH
      VIOLIS(0)=0
      IF ( .NOT. SILENT ) CALL O8INFO(8)
100   CONTINUE
      L=L+1
      IF ( L .GT. NSTEP ) THEN
        IF ( ERROR .AND. .NOT. SILENT ) CALL O8MSG(24)
        STPTRM=-ONE
        SIG=ZERO
        RETURN
      ENDIF
C*****  COMPUTE A NEW X AND TEST FOR DESCENT
      CALL O8EVAL(SIG,SIGRES,REJECT,ERROR)
      IF ( ERROR ) THEN
        IF ( SIG .GT. ONE ) THEN
          CALL O8REST
          GOTO 200
        ELSE
          IF ( .NOT. SILENT ) CALL O8MSG(25)
          SIG=STEP(L)*SIG
          GOTO 100
        ENDIF
      ENDIF
      IF ( REJECT ) THEN
        IF ( SIG .GT. ONE ) THEN
          CALL O8REST
          GOTO 200
        ELSE
          SIG=STEP(L)*SIG
          GOTO 100
        ENDIF
      ENDIF
C
C
      IF ( .NOT. SILENT ) CALL O8INFO(9)
C*****  NEW FUNCTION VALUE
      IF ( SIG .GT. ONE ) THEN
        IF ( PHI1 .GE. PHIMIN ) THEN
C*****      PHI DOES'NT DECREASE FURTHER
          CALL O8REST
          GOTO 200
        ELSE
          IF ( SIG .LT. STMAXL ) THEN
            CALL O8SAVE
            SIG=MIN(STMAXL,SIG+SIG)
            GOTO 100
          ELSE
            GOTO 200
          ENDIF
        ENDIF
      ENDIF
      IF ( LASTCH .GE. ITSTEP-3 .OR. PHASE .NE. 2
     F      .OR. SINGUL ) THEN
C***** REQUIRE MONOTONIC BEHAVIOUR
        DIFF=PHI-PHI1
      ELSE
        MAXPHI=PHI
        DO J=1,3
          MAXPHI=
     +    MAX(SCF*ACCINF(ITSTEP-J,2)+ACCINF(ITSTEP-J,4),MAXPHI)
        ENDDO
        DIFF=MAXPHI-PHI1
      ENDIF
      DESC = DIFF .GE. MIN(-SIG*DELTA*DIRDER,LEVEL)
      DESCRE = UPSI - UPSI1 .GE. SIG*DELTA**2*UPSI/TAUQP
      SMINFE = UPSI .LE. TAU0*P5 .AND. UPSI1 .LE. TAU0
      LAINFE = UPSI .GT. TAU0*P5
      IF ( DESC .AND. ( SMINFE .OR. ( LAINFE .AND. DESCRE ) ) ) THEN
C*****  GOLDSTEIN-ARMIJO DESCENT TEST SATISFIED
        IF ( SIG .EQ. ONE .AND. ( (COSPHI .GE. THETA .AND. SIG0
     F        .GE. ONE .AND. (PHASE+1)*(PHASE-2) .NE. 0
     F         .AND. .NOT. SINGUL) .OR.
     F         DIFF .GE. -SIG*DELTA1*DIRDER )
C*****   1>=DELTA1  >> DELTA > 0
     F         .AND. STMAXL .GT. ONE .AND. UPSI .LT. TAU0*P5 )  THEN
C*****    TRY STEPSIZE LARGER THAN ONE
C*****    SAVE THE CURRENT POINT AS THE BEST ONE
          CALL O8SAVE
          SIG=MIN(STMAXL,SIG+SIG)
          GOTO 100
        ENDIF
        IF ( SIG .LE. ONE .AND. UPSI .GT. TAU0*P5 .AND.
     F         UPSI1 .GT. UPSI ) GOTO 300
        GOTO 200
      ELSE
        GOTO 300
      ENDIF
200   CONTINUE
C******   ACCEPT NEW X, SAVE OLD VALUES
      FX0 = FX
      FX = FX1
      UPSI0=UPSI
      UPSI=UPSI1
      PSI0=PSI
      PSI=PSI1
      STPTRM = ONE
      SIG0 = SIG
      DO I = 1,N
        X0(I)=X(I)
        D0(I)=D(I)
        X(I)=X1(I)
        DIFX(I)=X(I)-X0(I)
      ENDDO
      D0NORM=DNORM
      X0NORM=XNORM
      DO I=1,NRES
        RES(I)=RES1(I)
      ENDDO
      RETURN
C****** CONTINUE REDUCING SIG
300   CONTINUE
      IF ( SIGRES .LT. SIG ) THEN
        SIG=MIN(P5*SIG,MAX(STEP(L)*SIG,SIGRES))
      ELSE
        TERM=(DIFF-DIRDER*SIG)*TWO
        IF ( TERM .GT. EPSMAC*(SCF*ABS(FX)+PSI) ) THEN
          SIG=MIN(P5*SIG,MAX(STEP(L)*SIG,-DIRDER*SIG**2/TERM))
        ELSE
          SIG=STEP(L)*SIG
        ENDIF
      ENDIF
CTEST      DO I=1,N
CTEST        IF ( ABS(X1(I)-X(I)) .GE. SIGSM*(ABS(X(I))+TM2)) THEN
CTEST          GOTO 100
CTEST        ENDIF
CTEST      ENDDO
      IF ( SIG*MAX(ONE,DNORM) .GE. SIGSM  ) GOTO 100
      STPTRM = -ONE
      SIG=ZERO
      RETURN
      END
