<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 * $Id$
 *
 */
/*
 * Settings metadata file
 */

return [
  'customTranslateFunction' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'customTranslateFunction',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '30',
      'maxlength' => '100',
    ],
    'default' => NULL,
    'title' => ts('Custom Translate Function'),
  ],
  'monetaryThousandSeparator' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'monetaryThousandSeparator',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 2,
    ],
    'default' => ',',
    'add' => '4.3',
    'title' => ts('Thousands Separator'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'monetaryDecimalPoint' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'monetaryDecimalPoint',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 2,
    ],
    'default' => '.',
    'add' => '4.3',
    'title' => ts('Decimal Delimiter'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'moneyformat' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'moneyformat',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '%c %a',
    'add' => '4.3',
    'title' => ts('Monetary Amount Display'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'moneyvalueformat' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'moneyvalueformat',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '%!i',
    'add' => '4.3',
    'title' => ts('Monetary Value Display'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'defaultCurrency' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'defaultCurrency',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'default' => 'USD',
    'add' => '4.3',
    'title' => ts('Default Currency'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Default currency assigned to contributions and other monetary transactions.'),
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getCurrencySymbols',
    ],
    'on_change' => [
      'CRM_Admin_Form_Setting_Localization::onChangeDefaultCurrency',
    ],
  ],
  'defaultContactCountry' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'defaultContactCountry',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      //'class' => 'crm-select2',
    ],
    'add' => '4.4',
    'title' => ts('Default Country'),
    'is_domain' => 1,
    'is_contact' => 0,
    'is_required' => FALSE,
    'description' => ts('This value is selected by default when adding a new contact address.'),
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
    ],
  ],
  'defaultContactStateProvince' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'defaultContactStateProvince',
    'type' => 'Integer',
    'quick_form_type' => 'ChainSelect',
    'html_type' => 'ChainSelect',
    //'pseudoconstant' => array(
    //  'callback' => 'CRM_Core_PseudoConstant::stateProvince',
    //),
    //'html_attributes',
    'default' => NULL,
    'title' => ts('Default State/Province'),
    'description' => ts('This value is selected by default when adding a new contact address.'),
  ],
  'countryLimit' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'countryLimit',
    'type' => 'Array',
    'quick_form_type' => 'Element',
    'html_type' => 'advmultiselect',
    'html_attributes' => [
      'size' => 5,
      'style' => 'width:150px',
      'class' => 'advmultiselect',
    ],
    'default' => [],
    'add' => '4.3',
    'title' => ts('Available Countries'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
    ],
  ],
  'provinceLimit' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'provinceLimit',
    'type' => 'Array',
    'quick_form_type' => 'Element',
    'html_type' => 'advmultiselect',
    'html_attributes' => [
      'size' => 5,
      'style' => 'width:150px',
      'class' => 'advmultiselect',
    ],
    'default' => [],
    'add' => '4.3',
    'title' => ts('Available States and Provinces (by Country)'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
    ],
  ],
  'inheritLocale' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'inheritLocale',
    'type' => 'Boolean',
    'quick_form_type' => 'YesNo',
    'default' => '0',
    'add' => '4.3',
    'title' => ts('Inherit CMS Language'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'dateformatDatetime' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatDatetime',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '%B %E%f, %Y %l:%M %P',
    'add' => '4.3',
    'title' => ts('Date Format: Complete Date and Time'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'dateformatFull' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatFull',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '%B %E%f, %Y',
    'add' => '4.3',
    'title' => ts('Date Format: Complete Date'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'dateformatPartial' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatPartial',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '%B %Y',
    'add' => '4.3',
    'title' => ts('Date Format: Month and Year'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'dateformatTime' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatTime',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '12',
      'maxlength' => '60',
    ],
    'default' => '%l:%M %P',
    'title' => ts('Date Format: Time Only'),
  ],
  'dateformatYear' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatYear',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '12',
      'maxlength' => '60',
    ],
    'default' => '%Y',
    'title' => ts('Date Format: Year Only'),
  ],
  'dateformatFinancialBatch' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatFinancialBatch',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '12',
      'maxlength' => '60',
    ],
    'default' => '%m/%d/%Y',
    'title' => ts('Date Format: Financial Batch'),
  ],
  'dateformatshortdate' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateformatshortdate',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '12',
      'maxlength' => '60',
    ],
    'default' => '%m/%d/%Y',
    'title' => ts('Date Format: Short date Month Day Year'),
  ],
  'dateInputFormat' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'dateInputFormat',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'pseudoconstant' => [
      'callback' => 'CRM_Core_SelectValues::getDatePluginInputFormats',
    ],
    'default' => 'mm/dd/yy',
    'title' => ts('Date Input Format'),
  ],
  'fieldSeparator' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'fieldSeparator',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '2',
      'maxlength' => '8',
    ],
    'default' => ',',
    'title' => ts('Import / Export Field Separator'),
    'description' => ts('Global CSV separator character. Modify this setting to enable import and export of different kinds of CSV files (for example: \',\' \';\' \':\' \'|\' ).'),
  ],
  'fiscalYearStart' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'fiscalYearStart',
    'type' => 'Array',
    'quick_form_type' => 'MonthDay',
    'html_type' => 'MonthDay',
    'default' => ['M' => 1, 'd' => 1],
    'title' => ts('Fiscal Year Start'),
  ],
  'languageLimit' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'languageLimit',
    'type' => 'Array',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'multiple' => 1,
      'class' => 'crm-select2',
    ],
    'default' => NULL,
    'add' => '4.3',
    'title' => ts('Available Languages (Multi-lingual)'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Core_I18n::languages',
    ],
  ],
  'uiLanguages' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'uiLanguages',
    'type' => 'Array',
    'quick_form_type' => 'Select',
    'html_type' => 'select',
    'html_attributes' => [
      'multiple' => 1,
      'class' => 'crm-select2',
    ],
    'default' => NULL,
    'add' => '5.9',
    'title' => ts('Available Languages'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('User Interface languages available to users'),
    'pseudoconstant' => [
      'callback' => 'CRM_Core_I18n::languages',
    ],
  ],
  'lcMessages' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'lcMessages',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'default' => 'en_US',
    'add' => '4.3',
    'title' => ts('Default Language'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getDefaultLocaleOptions',
    ],
    'on_change' => [
      'CRM_Admin_Form_Setting_Localization::onChangeLcMessages',
    ],
  ],
  'legacyEncoding' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'legacyEncoding',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '12',
      'maxlength' => '30',
    ],
    'default' => 'Windows-1252',
    'title' => ts('Legacy Encoding'),
    'description' => ts('If import files are NOT encoded as UTF-8, specify an alternate character encoding for these files. The default of Windows-1252 will work for Excel-created .CSV files on many computers.'),
  ],
  'timeInputFormat' => [
    'add' => '4.7',
    'help_text' => NULL,
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'timeInputFormat',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'pseudoconstant' => [
      'callback' => 'CRM_Core_SelectValues::getTimeFormats',
    ],
    'default' => '1',
    'title' => ts('Time Input Format'),
    'on_change' => [
      'CRM_Core_BAO_PreferencesDate::onChangeSetting',
    ],
  ],
  'weekBegins' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'weekBegins',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'pseudoconstant' => [
      'callback' => 'CRM_Utils_Date::getFullWeekdayNames',
    ],
    'default' => '0',
    'add' => '4.7',
    'title' => ts('Week begins on'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'contact_default_language' => [
    'group_name' => 'Localization Preferences',
    'group' => 'localization',
    'name' => 'contact_default_language',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Localization::getDefaultLanguageOptions',
    ],
    'default' => '*default*',
    'add' => '4.7',
    'title' => ts('Default Language for contacts'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Default language (if any) for contact records'),
    'help_text' => 'If a contact is created with no language this setting will determine the language data (if any) to save.'
    . 'You may or may not wish to make an assumption here about whether it matches the site language',
  ],
];
