<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Price/LineItem.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Price_DAO_LineItem extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_line_item';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Line Item
   *
   * @var int unsigned
   */
  public $id;
  /**
   * table which has the transaction
   *
   * @var string
   */
  public $entity_table;
  /**
   * entry in table
   *
   * @var int unsigned
   */
  public $entity_id;
  /**
   * FK to civicrm_contribution
   *
   * @var int unsigned
   */
  public $contribution_id;
  /**
   * FK to civicrm_price_field
   *
   * @var int unsigned
   */
  public $price_field_id;
  /**
   * descriptive label for item - from price_field_value.label
   *
   * @var string
   */
  public $label;
  /**
   * How many items ordered
   *
   * @var float
   */
  public $qty;
  /**
   * price of each item
   *
   * @var float
   */
  public $unit_price;
  /**
   * qty * unit_price
   *
   * @var float
   */
  public $line_total;
  /**
   * Participant count for field
   *
   * @var int unsigned
   */
  public $participant_count;
  /**
   * FK to civicrm_price_field_value
   *
   * @var int unsigned
   */
  public $price_field_value_id;
  /**
   * FK to Financial Type.
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * Tax-deductible portion of the amount
   *
   * @var float
   */
  public $deductible_amount;
  /**
   * tax of each item
   *
   * @var float
   */
  public $tax_amount;
  /**
   * class constructor
   *
   * @return civicrm_line_item
   */
  function __construct()
  {
    $this->__table = 'civicrm_line_item';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_id', 'civicrm_contribution', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'price_field_id', 'civicrm_price_field', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'price_field_value_id', 'civicrm_price_field_value', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
      self::$_links[] = new CRM_Core_Reference_Dynamic(self::getTableName() , 'entity_id', NULL, 'id', 'entity_table');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item ID') ,
          'description' => 'Line Item',
          'required' => true,
        ) ,
        'entity_table' => array(
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Entity Type') ,
          'description' => 'table which has the transaction',
          'required' => true,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'entity_id' => array(
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Entity') ,
          'description' => 'entry in table',
          'required' => true,
        ) ,
        'contribution_id' => array(
          'name' => 'contribution_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Contribution') ,
          'description' => 'FK to civicrm_contribution',
          'FKClassName' => 'CRM_Contribute_DAO_Contribution',
        ) ,
        'price_field_id' => array(
          'name' => 'price_field_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Price Field') ,
          'description' => 'FK to civicrm_price_field',
          'FKClassName' => 'CRM_Price_DAO_PriceField',
        ) ,
        'label' => array(
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Label') ,
          'description' => 'descriptive label for item - from price_field_value.label',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'qty' => array(
          'name' => 'qty',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Line Item Quantity') ,
          'description' => 'How many items ordered',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'unit_price' => array(
          'name' => 'unit_price',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Unit Price') ,
          'description' => 'price of each item',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'line_total' => array(
          'name' => 'line_total',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Line Item Total') ,
          'description' => 'qty * unit_price',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'participant_count' => array(
          'name' => 'participant_count',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Participant Count') ,
          'description' => 'Participant count for field',
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'price_field_value_id' => array(
          'name' => 'price_field_value_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Option') ,
          'description' => 'FK to civicrm_price_field_value',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Price_DAO_PriceFieldValue',
        ) ,
        'financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type') ,
          'description' => 'FK to Financial Type.',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'deductible_amount' => array(
          'name' => 'deductible_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Deductible Amount') ,
          'description' => 'Tax-deductible portion of the amount',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'default' => '0.0',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'tax_amount' => array(
          'name' => 'tax_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Tax Amount') ,
          'description' => 'tax of each item',
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_line_item.tax_amount',
          'headerPattern' => '/tax(.?am(ou)?nt)?/i',
          'dataPattern' => '/^\d+(\.\d{2})?$/',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'entity_table' => 'entity_table',
        'entity_id' => 'entity_id',
        'contribution_id' => 'contribution_id',
        'price_field_id' => 'price_field_id',
        'label' => 'label',
        'qty' => 'qty',
        'unit_price' => 'unit_price',
        'line_total' => 'line_total',
        'participant_count' => 'participant_count',
        'price_field_value_id' => 'price_field_value_id',
        'financial_type_id' => 'financial_type_id',
        'deductible_amount' => 'deductible_amount',
        'tax_amount' => 'tax_amount',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['line_item'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['line_item'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
