<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Pledge/Pledge.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Pledge_DAO_Pledge extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_pledge';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Pledge ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Foreign key to civicrm_contact.id .
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * FK to Financial Type
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * The Contribution Page which triggered this contribution
   *
   * @var int unsigned
   */
  public $contribution_page_id;
  /**
   * Total pledged amount.
   *
   * @var float
   */
  public $amount;
  /**
   * Original amount for each of the installments.
   *
   * @var float
   */
  public $original_installment_amount;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * Time units for recurrence of pledge payments.
   *
   * @var string
   */
  public $frequency_unit;
  /**
   * Number of time units for recurrence of pledge payments.
   *
   * @var int unsigned
   */
  public $frequency_interval;
  /**
   * Day in the period when the pledge payment is due e.g. 1st of month, 15th etc. Use this to set the scheduled dates for pledge payments.
   *
   * @var int unsigned
   */
  public $frequency_day;
  /**
   * Total number of payments to be made.
   *
   * @var int unsigned
   */
  public $installments;
  /**
   * The date the first scheduled pledge occurs.
   *
   * @var datetime
   */
  public $start_date;
  /**
   * When this pledge record was created.
   *
   * @var datetime
   */
  public $create_date;
  /**
   * When a pledge acknowledgement message was sent to the contributor.
   *
   * @var datetime
   */
  public $acknowledge_date;
  /**
   * Last updated date for this pledge record.
   *
   * @var datetime
   */
  public $modified_date;
  /**
   * Date this pledge was cancelled by contributor.
   *
   * @var datetime
   */
  public $cancel_date;
  /**
   * Date this pledge finished successfully (total pledge payments equal to or greater than pledged amount).
   *
   * @var datetime
   */
  public $end_date;
  /**
   * The maximum number of payment reminders to send for any given payment.
   *
   * @var int unsigned
   */
  public $max_reminders;
  /**
   * Send initial reminder this many days prior to the payment due date.
   *
   * @var int unsigned
   */
  public $initial_reminder_day;
  /**
   * Send additional reminder this many days after last one sent, up to maximum number of reminders.
   *
   * @var int unsigned
   */
  public $additional_reminder_day;
  /**
   * Implicit foreign key to civicrm_option_values in the contribution_status option group.
   *
   * @var int unsigned
   */
  public $status_id;
  /**
   *
   * @var boolean
   */
  public $is_test;
  /**
   * The campaign for which this pledge has been initiated.
   *
   * @var int unsigned
   */
  public $campaign_id;
  /**
   * class constructor
   *
   * @return civicrm_pledge
   */
  function __construct()
  {
    $this->__table = 'civicrm_pledge';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_page_id', 'civicrm_contribution_page', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'campaign_id', 'civicrm_campaign', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'pledge_id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge ID') ,
          'description' => 'Pledge ID',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
        ) ,
        'pledge_contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID') ,
          'description' => 'Foreign key to civicrm_contact.id .',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.contact_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
        ) ,
        'pledge_financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Type') ,
          'description' => 'FK to Financial Type',
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'pledge_contribution_page_id' => array(
          'name' => 'contribution_page_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Contribution Page') ,
          'description' => 'The Contribution Page which triggered this contribution',
          'FKClassName' => 'CRM_Contribute_DAO_ContributionPage',
        ) ,
        'pledge_amount' => array(
          'name' => 'amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Total Pledged') ,
          'description' => 'Total pledged amount.',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_pledge.amount',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'pledge_original_installment_amount' => array(
          'name' => 'original_installment_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Original Installment Amount') ,
          'description' => 'Original amount for each of the installments.',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Pledge Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'name',
          )
        ) ,
        'pledge_frequency_unit' => array(
          'name' => 'frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Pledge Frequency Unit') ,
          'description' => 'Time units for recurrence of pledge payments.',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'month',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'recur_frequency_units',
            'keyColumn' => 'name',
            'optionEditPath' => 'civicrm/admin/options/recur_frequency_units',
          )
        ) ,
        'pledge_frequency_interval' => array(
          'name' => 'frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Frequency Interval') ,
          'description' => 'Number of time units for recurrence of pledge payments.',
          'required' => true,
          'default' => '1',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'frequency_day' => array(
          'name' => 'frequency_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge day') ,
          'description' => 'Day in the period when the pledge payment is due e.g. 1st of month, 15th etc. Use this to set the scheduled dates for pledge payments.',
          'required' => true,
          'default' => '3',
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'installments' => array(
          'name' => 'installments',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Number of Installments') ,
          'description' => 'Total number of payments to be made.',
          'default' => '1',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'start_date' => array(
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Start Date') ,
          'description' => 'The date the first scheduled pledge occurs.',
          'required' => true,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'pledge_create_date' => array(
          'name' => 'create_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Made') ,
          'description' => 'When this pledge record was created.',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.create_date',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'acknowledge_date' => array(
          'name' => 'acknowledge_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Acknowledged') ,
          'description' => 'When a pledge acknowledgement message was sent to the contributor.',
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'modified_date' => array(
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Modified Date') ,
          'description' => 'Last updated date for this pledge record.',
        ) ,
        'cancel_date' => array(
          'name' => 'cancel_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Cancelled Date') ,
          'description' => 'Date this pledge was cancelled by contributor.',
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'end_date' => array(
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge End Date') ,
          'description' => 'Date this pledge finished successfully (total pledge payments equal to or greater than pledged amount).',
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'max_reminders' => array(
          'name' => 'max_reminders',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum Number of Reminders') ,
          'description' => 'The maximum number of payment reminders to send for any given payment.',
          'default' => '1',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'initial_reminder_day' => array(
          'name' => 'initial_reminder_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Initial Reminder Day') ,
          'description' => 'Send initial reminder this many days prior to the payment due date.',
          'default' => '5',
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'additional_reminder_day' => array(
          'name' => 'additional_reminder_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Additional Reminder Days') ,
          'description' => 'Send additional reminder this many days after last one sent, up to maximum number of reminders.',
          'default' => '5',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'pledge_status_id' => array(
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Status Id') ,
          'description' => 'Implicit foreign key to civicrm_option_values in the contribution_status option group.',
          'import' => true,
          'where' => 'civicrm_pledge.status_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => false,
          'pseudoconstant' => array(
            'optionGroupName' => 'contribution_status',
            'optionEditPath' => 'civicrm/admin/options/contribution_status',
          )
        ) ,
        'pledge_is_test' => array(
          'name' => 'is_test',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Test') ,
          'import' => true,
          'where' => 'civicrm_pledge.is_test',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'pledge_campaign_id' => array(
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign') ,
          'description' => 'The campaign for which this pledge has been initiated.',
          'import' => true,
          'where' => 'civicrm_pledge.campaign_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_campaign',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          )
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'pledge_id',
        'contact_id' => 'pledge_contact_id',
        'financial_type_id' => 'pledge_financial_type_id',
        'contribution_page_id' => 'pledge_contribution_page_id',
        'amount' => 'pledge_amount',
        'original_installment_amount' => 'pledge_original_installment_amount',
        'currency' => 'currency',
        'frequency_unit' => 'pledge_frequency_unit',
        'frequency_interval' => 'pledge_frequency_interval',
        'frequency_day' => 'frequency_day',
        'installments' => 'installments',
        'start_date' => 'start_date',
        'create_date' => 'pledge_create_date',
        'acknowledge_date' => 'acknowledge_date',
        'modified_date' => 'modified_date',
        'cancel_date' => 'cancel_date',
        'end_date' => 'end_date',
        'max_reminders' => 'max_reminders',
        'initial_reminder_day' => 'initial_reminder_day',
        'additional_reminder_day' => 'additional_reminder_day',
        'status_id' => 'pledge_status_id',
        'is_test' => 'pledge_is_test',
        'campaign_id' => 'pledge_campaign_id',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['pledge'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['pledge'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
