#include "cp_types.h"
#include "cp_proto.h"

/* Experimental routines to pack with inversive distances. Idea:
 Status messages: # incompat faces, incompat total, angle err total,
   # incompat verts, # verts subject to inc/dec,
 elementary binary search 
 report on short test_cycle
 cmd controls what's tried. */

int test_riffle(struct p_data *p,int passes,int test_cycles,
		int cmd,double tol)
{
  int pass_count=0,stop_flag=0,tc,chgflag,i,chg_count=0,k;

  while (!stop_flag && pass_count<passes)
    {
      tc=0;
      if ((k=ck_pack_status(p,tol))) 
	{
	  if (k==0)
	    {
	      sprintf(msgbuf,"Test packing within tolerance %f at count %d.",
		      tol,pass_count);
	      msg();
	      return 1;
	    }
	  if (k==1)
	    {
	      sprintf(msgbuf,"Test packing: "
		      "inconsitency at count %d.",pass_count);
	      msg();
	    }
	}
      while (!stop_flag && tc<test_cycles)
        {
	  for (i=1;i<=p->nodecount;i++)
	    {
	      if (p->packR_ptr[i].aim>=0)
		{
		  tc++;
		  if (p->hes<0)
		    p->packR_ptr[i].rad = 
		      h_radcalc_binary(p,i,p->packR_ptr[i].rad,
		        p->packR_ptr[i].aim,&chgflag,cmd);
		  else if (p->hes==0)
		    p->packR_ptr[i].rad = 
		      e_radcalc_binary(p,i,p->packR_ptr[i].rad,
			p->packR_ptr[i].aim,&chgflag,cmd);
		  else return 1; /* spherical not yet ready */
		  chg_count += chgflag;
		}
	    }
	}
      pass_count += tc;
      if (!chg_count) stop_flag=1;
    }
  if (stop_flag)
    {
      sprintf(msgbuf,"Test riffle stopped; no changes.");
      msg();
    }
  else
    {
      sprintf(msgbuf,"Test riffle reached pass limit %d.",passes);
      msg();
    }
  return 1;
} /* test_riffle */
