#include "cp_types.h"
#include "cp_proto.h"

/* calling routine must set std_real_box */

extern Box std_real_box;

int reset_screen_box(struct s_data *q,int width,int height)
     /* resets screen boxes for screen, use default height. */
{
  double halfwidth;

  q->cflag_opt=1; /* default: open circles */
  q->fflag_opt=0;
  q->unitcircle=0;
  q->coord_flag=0;
  q->pix_box.rx=width;
  q->pix_box.ry=height;
  q->box=std_real_box;
  halfwidth=(q->box.ry-q->box.ly)*width/height/2.0;
  q->box.lx=(-1)*halfwidth;
  q->box.rx=halfwidth;
  q->factor=1.0;		
  return 1;
} /* reset_screen_box */
