use Test::More tests => 4;
use Test::LeakTrace;

#diag('test CipUX::RPC');
leaks_cmp_ok {
    use CipUX::RPC;
    my $rpc = CipUX::RPC->new( { cache_dir => 'blib/cache' } );
}
'<', 52;

#diag('test CipUX::RPC::Server');
leaks_cmp_ok {
    use CipUX::RPC::Server;
    my $rpc = CipUX::RPC::Server->new( { cache_dir => 'blib/cache' } );
}
'<', 3;

#'memory leaks CipUX::RPC::Server';

#diag('test CipUX::RPC::Server::Daemon');
leaks_cmp_ok {
    use CipUX::RPC::Server::Daemon;
    my $rpc = CipUX::RPC::Server::Daemon->new(
        { name => 'cipux_rpcd', cache_dir => 'blib/cache' } );
}
'<', 3;

#'memory leaks CipUX::RPC::Server::Daemon';

#diag('test CipUX::RPC::Test::Client');
no_leaks_ok {
    use CipUX::RPC::Test::Client;
    my $rpc = CipUX::RPC::Test::Client->new(
        { name => 'cipux_rpc_test_client', cache_dir => 'blib/cache' } );
}
'no memory leaks CipUX::RPC::Test::Client';

