/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: setsig.c,v 1.3 2000/11/30 22:12:41 olaf Exp $ */

#include "cipelib.h"

#ifndef NULL
#define NULL 0
#endif

void setsig(int sig, void (*fun)(int))
{
  struct sigaction sa;
  sa.sa_handler = fun;
  sa.sa_flags = 0;
  sigemptyset(&sa.sa_mask);
  sigaddset(&sa.sa_mask, SIGHUP);
  sigaddset(&sa.sa_mask, SIGINT);
  sigaddset(&sa.sa_mask, SIGTERM);
  sigaddset(&sa.sa_mask, SIGCHLD);
  sigaddset(&sa.sa_mask, SIGALRM);
  sigaction(sig, &sa, NULL);
  sigemptyset(&sa.sa_mask);
  sigaddset(&sa.sa_mask, sig);
  sigprocmask(SIG_UNBLOCK, &sa.sa_mask, NULL);
}
