/*
 * PrimeWindow.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  PrimeWindow.hpp  --  header of the primary window class
*/
#ifndef PrimeWindow_hpp
#define PrimeWindow_hpp

#include <FL/Fl_Window.H>
#include <FL/Fl_Menu.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Progress.H>

#include "ImagePanel.hpp"
#include "ShiftPanel.hpp"
#include "FollowCurveWindow.hpp"
#include "StatusLine.hpp"
#include "ProgressInfo.hpp"
#include "BrGUI.hpp"            // global `BrGUI' (later local!)

#if 0
// Versuch zu einer von Fl_Window abstammender Help-Klasse (wohingegen
// Fl_Help_Dialog keine solche und nur deren explizit durchgereichten 
// Methoden verfuegbar)...

class Br_Help_Dialog : public Fl_Window {
  Fl_Help_View view_;
public:
  Br_Help_Dialog() 
    : Fl_Window (530, 385, "Br_Help_Dialog"),
      view_ (10,10, 510, 350)
  { view_.end();
    end();
  }
  int load (const char* f)   { return view_.load(f); }
  void value (const char* v) { view_.value(v); }
  const char* value () const { return view_.value(); }
  // etc...
};
#endif

/**=========================================================
 *
 * Progress  -  class
 *
 * Die GUI-konkretisierte Progress-Klasse: erbt von ProgressInfo unten-
 *   stehende abstrakte Funktionen und von Fl_Progress den Rest.
 *
 *=========================================================*/
class Progress : public ProgressInfo, public Fl_Progress
{
public:
  Progress (int X, int Y, int W, int H, const char* la=0)
    : Fl_Progress(X,Y,W,H,la)
    { 
      Fl_Progress::minimum(0.0);    // accordingly to the ProgressInfo
      Fl_Progress::maximum(1.0);    //   convention "v \in [0,1]"
    }
  
  void value (float v) { Fl_Progress::value(v); Fl::flush(); }
  void show ()         { Fl_Progress::show(); Fl::flush(); }
  void hide ()         { Fl_Progress::hide(); Fl_Progress::value(0.0); }
  void text (const char* s) { Fl_Progress::label(s); Fl::flush(); }
};


/**==============================================================
 *
 * PrimeWindow  -  class
 *
 * Namenskonvention: Zeiger auf Fltk-Klassen enden auf "_" (Bsp.
 *   "input_refpic_", Zeiger auf meine eigenen beginnen mit 'p' und
 *   enden ohne Unterstrich ("pCCDCurvePlot"). Aehm, solche gibt's
 *   hier nicht, sondern in BrGUI.cpp.
 *
 *===============================================================*/
class PrimeWindow : public Fl_Window
{   
  //class Tabulat : public Fl_Tabs {// vielleicht... };

  Fl_Menu_Bar*      menubar_;
  Fl_Tabs*          tabs_; 
  ImagePanel*       imgPanel_;       
  ShiftPanel*       shiftPanel_;
  FollowCurveTabPanel* followPanel_; 
  Fl_Group*         followPanelFrame_; // wrapper for `followPanel_'
  Fl_File_Chooser*  file_chooser_;   
  StatusLine*       statusline_;
  Progress*         progress_;
  
  static Fl_Menu_Item  menu_menubar_[];  // all instances have the same
                                         // (inclusive static callbacks!)   
  double val_stops_;            // stops value
  int    shift_nx, shift_ny;    // later rather in `Br' or `Camera'
  int    shift_mx, shift_my;
  int    shift_xc, shift_yc;
  
public:
  PrimeWindow();  
  ~PrimeWindow(); 
  
private:
  int  do_file_chooser (const char *value, const char* pattern, int type, const char* title); 
  bool load_file (const char* fname);
  
  // Fl_Callbacks...
  void        cb_window (Fl_Widget*);
  static void cb_window_(Fl_Widget* w, PrimeWindow* I) 
    { I -> cb_window (w); }
  
  static void cb_quit_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_window((Fl_Widget*)o->user_data()); }  
  
  void        cb_open_file (Fl_Menu_*);
  static void cb_open_file_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_open_file(o); }  
    
  void        cb_clear (Fl_Menu_*);
  static void cb_clear_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_clear(o); }  
  
  void        cb_init_camera (Fl_Menu_*)    { BrGUI.init_camera(); }
  static void cb_init_camera_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_init_camera(o); }  
  
  void        cb_compute_CCD (Fl_Menu_*)    { BrGUI.make_CCD_curve(); }
  static void cb_compute_CCD_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_compute_CCD(o); }  
  
  void        cb_compute_HDR (Fl_Menu_*)    { BrGUI.complete_HDR(); }
  static void cb_compute_HDR_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_compute_HDR(o); }  
  
  void        cb_make_HDR (Fl_Menu_*)       { BrGUI.make_HDR(); }
  static void cb_make_HDR_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_make_HDR(o); }  
  
  void        cb_stops_menubar (Fl_Menu_*, void*);
  static void cb_stops_menubar_(Fl_Menu_* o, void* v) 
    { ((PrimeWindow*)o->user_data()) -> cb_stops_menubar(o,v); }
  
  void        cb_ShiftMenu (Fl_Menu_*);
  static void cb_ShiftMenu_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_ShiftMenu(o); }  
  
  void        cb_CCDCurveWindow (Fl_Menu_*);
  static void cb_CCDCurveWindow_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_CCDCurveWindow(o); }  

  void        cb_FollowCurveWindow ();
  static void cb_FollowCurveWindow_(Fl_Menu_* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_FollowCurveWindow(); }  
  
  void        cb_tabs (Fl_Tabs*);
  static void cb_tabs_(Fl_Tabs* w, PrimeWindow* I) 
    { I -> cb_tabs(w); }
    
  void        cb_help_about ();  
  static void cb_help_about_(Fl_Menu* o, void*)
    { ((PrimeWindow*)o->user_data()) -> cb_help_about(); }
    
  void        cb_help_tutorial ();
  static void cb_help_tutorial_(Fl_Menu* o, void*)  
    { ((PrimeWindow*)o->user_data()) -> cb_help_tutorial(); }  

  // Distributor callback(s)...
  void        event_msg (BracketingCore::Event);
  static void event_msg_(BracketingCore::Event* e, PrimeWindow* I)
    { I -> event_msg (*e); } 

  // other...      
  void do_FollowPanel();      
};

#endif  // dialog_hpp

// END OF FILE
