/*
 * BrGUI.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  BrGUI.hpp
*/
#ifndef BrGUI_hpp
#define BrGUI_hpp

#include "br_types_plot.hpp"      // type CurvePlotClass
#include "FollowCurveWindow.hpp"  // FollowCurveWindow
#include "CCDCurveMenu.hpp"       // CCDCurveWindow     
#include "ShiftMenu.hpp"          // ShifMenu
#include "help.hpp"               // HelpAbout, HelpTutorial

/**=================================================================
 *
 * BracketingGUI  --  class 
 *
 * Collects the pointers of all secondary top windows which `PrimeWindow' (or 
 *   its children) can create.
 * Contains further some common used "check-with-message" functions. Currently
 *   used only by `PrimeWindow' and its children, but not clear, whether this
 *   remains. Should the secondary windows want to use it too, they had to
 *   outhouse.
 * Name "BracketingGUI" meanwhile a bit curios.
 *
 * The hierarchy plan:
 *   1. layer:  imgVec, camera
 *   2. layer:  class BracketingCore ("Br"): "camera + distrib-messages"
                  connects `imgVec' and `camera'; helds numerical
 *                parameters for calling of camera functions; wraps all 
 *                relevant camera calls in the way "camera + message"
 *                (distrib_messages for the GUI layer)
 *   3. layer:  class BracketingGUI ("BrGUI"):  "Br + GUI"
 *
 * Open: Inheritance relation between BracketingCore and BracketingGUI.
 *   1) BracketingGUI derived from BracketingCore?
 *   2) BracketingGUI initialized with a `BracketingCore' reference?
 *   3) Global `Br' instance used in BracketingGUI (current state, bad).
 *
 *==================================================================*/
class BracketingGUI
{
public:
    // pointer of (possible) secondary top windows...
    FollowCurveWindow* pFollowCurveWindow;
    CCDCurveWindow*    pCCDCurveWindow;
    ShiftMenu*         pShiftMenu;
    HelpAbout*         pHelpAbout;
    HelpTutorial*      pHelpTutorial;

    // Ctor & Dtor...
    BracketingGUI();
    ~BracketingGUI();
    
    void clear();
    void clear_rest();
    bool rest_shown();
    
    bool check_for_init();
    bool check_for_camera();
    bool check_for_camera_or_init();
    bool check_for_CCD_curves();
    bool ccd_plot_created() { return (pCCDCurveWindow); }
    
    void do_FollowCurveWindow();
    void do_CCDCurveWindow();
    void do_ShiftMenu();
    
    void init_camera();
    void compute_FollowCurves();
    void make_CCD_curve();
    void complete_HDR();
    void make_HDR();
    
    // realy here?
    void show_HDR (const TNT::Array2D< Rgb<float> > & A);
};

// The singular global INSTANCE we name "BrGUI"... (forw. decl.)
extern BracketingGUI BrGUI;

#endif  // BrGUI_hpp

// END OF FILE
