#!/usr/bin/env vpython
#
# Copyright 2018 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""Creates a script to run blink tests using
blinkpy/web_tests/run_webkit_tests.py
"""

import argparse
import os
import re
import stat
import sys

CHROMIUM_SRC_DIR = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', '..'))

BASH_SCRIPT_TEMPLATE = """\
#!/bin/bash
#
# Generated by //testing/scripts/generators/gen_run_web_tests_script.py
{executable_path} {build_config_arg} "$@"
"""

BAT_SCRIPT_TEMPLATE = """\
@echo off
REM Generated by //testing/scripts/generators/gen_run_web_tests_script.py
CALL python {executable_path} {build_config_arg} %*
%*
"""

def main(args):
  parser = argparse.ArgumentParser()
  parser.add_argument(
      '--script-output-path', required=True, help='path to write the file to')
  parser.add_argument(
      '--build-type', required=True, choices=['debug', 'release'])
  options = parser.parse_args(args)

  if options.build_type == 'debug':
    build_config_arg = '--debug'
  else:
    build_config_arg = '--release'

  executable_path = os.path.join(
      CHROMIUM_SRC_DIR, 'third_party', 'blink', 'tools', 'run_web_tests.py')

  if options.script_output_path.endswith('.bat'):
    contents = BAT_SCRIPT_TEMPLATE.format(
        executable_path=executable_path, build_config_arg=build_config_arg)
  else:
    contents = BASH_SCRIPT_TEMPLATE.format(
        executable_path=executable_path, build_config_arg=build_config_arg)

  with open(options.script_output_path, 'w') as fp:
    fp.write(contents)

  os.chmod(options.script_output_path,
           stat.S_IRUSR | stat.S_IWUSR | stat.S_IXUSR |
           stat.S_IRGRP | stat.S_IWGRP | stat.S_IXGRP |
           stat.S_IROTH | stat.S_IWOTH | stat.S_IXOTH)


if __name__ == '__main__':
  sys.exit(main(sys.argv[1:]))
