// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/history/core/test/database_test_utils.h"

#include "base/files/file_path.h"
#include "base/path_service.h"
#include "sql/test/test_helpers.h"

namespace history {

namespace {

WARN_UNUSED_RESULT bool GetTestDataHistoryDir(base::FilePath* dir) {
  if (!PathService::Get(base::DIR_SOURCE_ROOT, dir))
    return false;
  *dir = dir->AppendASCII("components");
  *dir = dir->AppendASCII("test");
  *dir = dir->AppendASCII("data");
  *dir = dir->AppendASCII("history");
  return true;
}

}  // namespace

WARN_UNUSED_RESULT bool CreateDatabaseFromSQL(const base::FilePath& db_path,
                                              const char* ascii_path) {
  base::FilePath dir;
  if (!GetTestDataHistoryDir(&dir))
    return false;
  return sql::test::CreateDatabaseFromSQL(db_path, dir.AppendASCII(ascii_path));
}

}  // namespace history
