// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_COMMON_AUTOFILL_PREF_NAMES_H_
#define COMPONENTS_AUTOFILL_CORE_COMMON_AUTOFILL_PREF_NAMES_H_

namespace autofill {
namespace prefs {

// Alphabetical list of preference names specific to the Autofill
// component. Keep alphabetized, and document each in the .cc file.
extern const char kAutofillAuxiliaryProfilesEnabled[];
extern const char kAutofillEnabled[];
extern const char kAutofillMacAddressBookQueried[];
extern const char kAutofillMacAddressBookShowedCount[];
extern const char kAutofillNegativeUploadRate[];
extern const char kAutofillPositiveUploadRate[];
extern const char kAutofillUseMacAddressBook[];
extern const char kAutofillWalletImportEnabled[];
extern const char kAutofillWalletImportStorageCheckboxState[];
extern const char kAutofillWalletSyncExperimentEnabled[];

}  // namespace prefs
}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_CORE_COMMON_AUTOFILL_PREF_NAMES_H_
