// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// IPC messages for injected Java objects (Gin-based implementation).

// Multiply-included message file, hence no include guard.

#include "base/basictypes.h"
#include "content/common/content_export.h"
#include "ipc/ipc_message_macros.h"

#undef IPC_MESSAGE_EXPORT
#define IPC_MESSAGE_EXPORT CONTENT_EXPORT
#define IPC_MESSAGE_START GinJavaBridgeMsgStart

// Messages for handling Java objects injected into JavaScript -----------------

// Sent from browser to renderer to add a Java object with the given name.
// Object IDs are generated on the browser side.
IPC_MESSAGE_ROUTED2(GinJavaBridgeMsg_AddNamedObject,
                    std::string /* name */,
                    int32 /* object_id */)

// Sent from browser to renderer to remove a Java object with the given name.
IPC_MESSAGE_ROUTED1(GinJavaBridgeMsg_RemoveNamedObject,
                    std::string /* name */)

// Sent from renderer to browser to get information about methods of
// the given object. The query will only succeed if inspection of injected
// objects is enabled on the browser side.
IPC_SYNC_MESSAGE_ROUTED1_1(GinJavaBridgeHostMsg_GetMethods,
                           int32 /* object_id */,
                           std::set<std::string> /* returned_method_names */)

// Sent from renderer to browser to find out, if an object has a method with
// the given name.
IPC_SYNC_MESSAGE_ROUTED2_1(GinJavaBridgeHostMsg_HasMethod,
                           int32 /* object_id */,
                           std::string /* method_name */,
                           bool /* result */)

// Sent from renderer to browser to invoke a method. Method arguments
// are chained into |arguments| list. base::ListValue is used for |result| as
// a container to work around immutability of base::Value.
// Empty result list indicates that an error has happened on the Java side
// (either bridge-induced error or an unhandled Java exception) and an exception
// must be thrown into JavaScript.
// Some special value types that are not supported by base::Value are encoded
// as BinaryValues via GinJavaBridgeValue.
IPC_SYNC_MESSAGE_ROUTED3_1(GinJavaBridgeHostMsg_InvokeMethod,
                           int32 /* object_id */,
                           std::string /* method_name */,
                           base::ListValue /* arguments */,
                           base::ListValue /* result */)

// Sent from renderer to browser in two cases:
//
//  1. (Main usage) To inform that the JS wrapper of the object has
//     been completely dereferenced and garbage-collected.
//
//  2. To notify the browser that wrapper creation has failed.  The browser side
//     assumes optimistically that every time an object is returned from a
//     method, the corresponding wrapper object will be successfully created on
//     the renderer side. Sending of this message informs the browser whether
//     this expectation has failed.
IPC_MESSAGE_ROUTED1(GinJavaBridgeHostMsg_ObjectWrapperDeleted,
                    int32 /* object_id */)
