# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'google_toolbox_for_mac',
      'type': '<(component)',
      'include_dirs': [
        '.',
        'src',
        'src/AppKit',
        'src/DebugUtils',
        'src/Foundation',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '.',
          'src',
          'src/AppKit',
          'src/DebugUtils',
          'src/Foundation',
        ],
      },
      'sources': [
        'src/AddressBook/GTMABAddressBook.h',
        'src/AddressBook/GTMABAddressBook.m',
        'src/AppKit/GTMCarbonEvent.h',
        'src/AppKit/GTMCarbonEvent.m',
        'src/AppKit/GTMDelegatingTableColumn.h',
        'src/AppKit/GTMDelegatingTableColumn.m',
        'src/AppKit/GTMFadeTruncatingTextFieldCell.h',
        'src/AppKit/GTMFadeTruncatingTextFieldCell.m',
        'src/AppKit/GTMGetURLHandler.m',
        'src/AppKit/GTMGoogleSearch.h',
        'src/AppKit/GTMGoogleSearch.m',
        'src/AppKit/GTMHotKeyTextField.h',
        'src/AppKit/GTMHotKeyTextField.m',
        'src/AppKit/GTMIBArray.h',
        'src/AppKit/GTMIBArray.m',
        'src/AppKit/GTMKeyValueAnimation.h',
        'src/AppKit/GTMKeyValueAnimation.m',
        'src/AppKit/GTMLargeTypeWindow.h',
        'src/AppKit/GTMLargeTypeWindow.m',
        'src/AppKit/GTMLinearRGBShading.h',
        'src/AppKit/GTMLinearRGBShading.m',
        'src/AppKit/GTMLoginItems.h',
        'src/AppKit/GTMLoginItems.m',
        'src/AppKit/GTMNSAnimatablePropertyContainer.h',
        'src/AppKit/GTMNSAnimatablePropertyContainer.m',
        'src/AppKit/GTMNSAnimation+Duration.h',
        'src/AppKit/GTMNSAnimation+Duration.m',
        'src/AppKit/GTMNSBezierPath+CGPath.h',
        'src/AppKit/GTMNSBezierPath+CGPath.m',
        'src/AppKit/GTMNSBezierPath+RoundRect.h',
        'src/AppKit/GTMNSBezierPath+RoundRect.m',
        'src/AppKit/GTMNSBezierPath+Shading.h',
        'src/AppKit/GTMNSBezierPath+Shading.m',
        'src/AppKit/GTMNSColor+Luminance.h',
        'src/AppKit/GTMNSColor+Luminance.m',
        'src/AppKit/GTMNSImage+Scaling.h',
        'src/AppKit/GTMNSImage+Scaling.m',
        'src/AppKit/GTMNSImage+SearchCache.h',
        'src/AppKit/GTMNSImage+SearchCache.m',
        'src/AppKit/GTMNSWorkspace+Running.h',
        'src/AppKit/GTMNSWorkspace+Running.m',
        'src/AppKit/GTMShading.h',
        'src/AppKit/GTMUILocalizer.h',
        'src/AppKit/GTMUILocalizer.m',
        'src/AppKit/GTMUILocalizerAndLayoutTweaker.h',
        'src/AppKit/GTMUILocalizerAndLayoutTweaker.m',
        'src/AppKit/GTMWindowSheetController.h',
        'src/AppKit/GTMWindowSheetController.m',
        'src/DebugUtils/GTMDebugSelectorValidation.h',
        'src/DebugUtils/GTMDebugThreadValidation.h',
        'src/DebugUtils/GTMDebugThreadValidation.m',
        'src/DebugUtils/GTMMethodCheck.h',
        'src/DebugUtils/GTMMethodCheck.m',
        'src/DebugUtils/GTMTypeCasting.h',
        'src/Foundation/GTMAbstractDOListener.h',
        'src/Foundation/GTMAbstractDOListener.m',
        'src/Foundation/GTMCalculatedRange.h',
        'src/Foundation/GTMCalculatedRange.m',
        'src/Foundation/GTMExceptionalInlines.h',
        'src/Foundation/GTMExceptionalInlines.m',
        'src/Foundation/GTMFileSystemKQueue.h',
        'src/Foundation/GTMFileSystemKQueue.m',
        'src/Foundation/GTMFourCharCode.h',
        'src/Foundation/GTMFourCharCode.m',
        'src/Foundation/GTMGarbageCollection.h',
        'src/Foundation/GTMGeometryUtils.h',
        'src/Foundation/GTMGeometryUtils.m',
        'src/Foundation/GTMLightweightProxy.h',
        'src/Foundation/GTMLightweightProxy.m',
        'src/Foundation/GTMLocalizedString.h',
        'src/Foundation/GTMLogger+ASL.h',
        'src/Foundation/GTMLogger+ASL.m',
        'src/Foundation/GTMLogger.h',
        'src/Foundation/GTMLogger.m',
        'src/Foundation/GTMLoggerRingBufferWriter.h',
        'src/Foundation/GTMLoggerRingBufferWriter.m',
        'src/Foundation/GTMNSAppleEventDescriptor+Foundation.h',
        'src/Foundation/GTMNSAppleEventDescriptor+Foundation.m',
        'src/Foundation/GTMNSAppleEventDescriptor+Handler.h',
        'src/Foundation/GTMNSAppleEventDescriptor+Handler.m',
        'src/Foundation/GTMNSAppleScript+Handler.h',
        'src/Foundation/GTMNSAppleScript+Handler.m',
        'src/Foundation/GTMNSArray+Merge.h',
        'src/Foundation/GTMNSArray+Merge.m',
        'src/Foundation/GTMNSDictionary+CaseInsensitive.h',
        'src/Foundation/GTMNSDictionary+CaseInsensitive.m',
        'src/Foundation/GTMNSDictionary+URLArguments.h',
        'src/Foundation/GTMNSDictionary+URLArguments.m',
        'src/Foundation/GTMNSEnumerator+Filter.h',
        'src/Foundation/GTMNSEnumerator+Filter.m',
        'src/Foundation/GTMNSFileHandle+UniqueName.h',
        'src/Foundation/GTMNSFileHandle+UniqueName.m',
        'src/Foundation/GTMNSFileManager+Carbon.h',
        'src/Foundation/GTMNSFileManager+Carbon.m',
        'src/Foundation/GTMNSFileManager+Path.h',
        'src/Foundation/GTMNSFileManager+Path.m',
        'src/Foundation/GTMNSNumber+64Bit.h',
        'src/Foundation/GTMNSNumber+64Bit.m',
        'src/Foundation/GTMNSObject+KeyValueObserving.h',
        'src/Foundation/GTMNSObject+KeyValueObserving.m',
        'src/Foundation/GTMNSScanner+JSON.h',
        'src/Foundation/GTMNSScanner+JSON.m',
        'src/Foundation/GTMNSScanner+Unsigned.h',
        'src/Foundation/GTMNSScanner+Unsigned.m',
        'src/Foundation/GTMNSString+FindFolder.h',
        'src/Foundation/GTMNSString+FindFolder.m',
        'src/Foundation/GTMNSString+HTML.h',
        'src/Foundation/GTMNSString+HTML.m',
        'src/Foundation/GTMNSString+Replace.h',
        'src/Foundation/GTMNSString+Replace.m',
        'src/Foundation/GTMNSString+URLArguments.h',
        'src/Foundation/GTMNSString+URLArguments.m',
        'src/Foundation/GTMNSString+XML.h',
        'src/Foundation/GTMNSString+XML.m',
        'src/Foundation/GTMNSThread+Blocks.h',
        'src/Foundation/GTMNSThread+Blocks.m',
        'src/Foundation/GTMObjC2Runtime.h',
        'src/Foundation/GTMObjC2Runtime.m',
        'src/Foundation/GTMObjectSingleton.h',
        'src/Foundation/GTMPath.h',
        'src/Foundation/GTMPath.m',
        'src/Foundation/GTMRegex.h',
        'src/Foundation/GTMRegex.m',
        'src/Foundation/GTMScriptRunner.h',
        'src/Foundation/GTMScriptRunner.m',
        'src/Foundation/GTMServiceManagement.c',
        'src/Foundation/GTMServiceManagement.h',
        'src/Foundation/GTMSignalHandler.h',
        'src/Foundation/GTMSignalHandler.m',
        'src/Foundation/GTMStackTrace.h',
        'src/Foundation/GTMStackTrace.m',
        'src/Foundation/GTMStringEncoding.h',
        'src/Foundation/GTMStringEncoding.m',
        'src/Foundation/GTMSystemVersion.h',
        'src/Foundation/GTMSystemVersion.m',
        'src/Foundation/GTMTransientRootPortProxy.h',
        'src/Foundation/GTMTransientRootPortProxy.m',
        'src/Foundation/GTMTransientRootProxy.h',
        'src/Foundation/GTMTransientRootProxy.m',
        'src/Foundation/GTMURITemplate.h',
        'src/Foundation/GTMURITemplate.m',
        'src/Foundation/GTMValidatingContainers.h',
        'src/Foundation/GTMValidatingContainers.m',
        'src/GTMDefines.h',
        'src/iPhone/GTMFadeTruncatingLabel.h',
        'src/iPhone/GTMFadeTruncatingLabel.m',
        'src/iPhone/GTMRoundedRectPath.h',
        'src/iPhone/GTMRoundedRectPath.m',
        'src/iPhone/GTMUIImage+Resize.h',
        'src/iPhone/GTMUIImage+Resize.m',
        'src/iPhone/GTMUILocalizer.h',
        'src/iPhone/GTMUILocalizer.m',
      ],
      'conditions': [
        ['component=="shared_library"',
          {
            # GTM is third-party code, so we don't want to add _EXPORT
            # annotations to it, so build it without -fvisibility=hidden
            # (else the interface class symbols will be hidden in a 64bit
            # build). Only do this in a component build, so that the shipping
            # chrome binary doesn't end up with unnecessarily exported
            # symbols.
            'xcode_settings': {
              'GCC_SYMBOLS_PRIVATE_EXTERN': 'NO',
            },
          }
        ],
        ['OS!="ios"', {
          'sources/': [
            ['exclude', '^src/iPhone/'],
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/AppKit.framework',
              '$(SDKROOT)/System/Library/Frameworks/Carbon.framework',
              '$(SDKROOT)/System/Library/Frameworks/Cocoa.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
            ],
          },
        }, {  # OS=="ios"
          'sources/': [
            # Exclude everything except what's needed for iOS.
            ['exclude', '\\.(c|m)$'],
            ['include', '^src/DebugUtils/GTMMethodCheck\\.m$'],
            ['include', '^src/Foundation/GTMLightweightProxy\\.m$'],
            ['include', '^src/Foundation/GTMLogger\\.m$'],
            ['include', '^src/Foundation/GTMNSDictionary\\+URLArguments\\.m$'],
            ['include', '^src/Foundation/GTMNSObject\\+KeyValueObserving\\.m$'],
            ['include', '^src/Foundation/GTMNSString\\+HTML\\.m$'],
            ['include', '^src/Foundation/GTMNSString\\+URLArguments\\.m$'],
            ['include', '^src/Foundation/GTMRegex\\.m$'],
            ['include', '^src/Foundation/GTMStringEncoding\\.m$'],
            ['include', '^src/iPhone/'],
          ],
        }],
      ],
    },
  ],
}
