#!/bin/bash 
# install plugin in the standard childsplay path  

PREFIX=/usr/local
DESTDIR=$PREFIX/share/childsplay
ASSETMLDIR=/usr/share/assetml
###########################################################
#    DO NOT EDIT BEHIND THIS POINT
# Unless your know what to edit
##########################################################

# Dependency, which version of childsplay at least
DEPEN=0.81.7
 
set -e
CWD=`pwd`

USERID=`id | sed -e 's/).*//; s/^.*(//;'`
if [ "$USERID" != "root" ]; then
    echo " You must be root to install the plugins"
    echo " exit"
    exit 1
fi

echo -e "\n>>>>>>>>>>> Install childsplay plugins >>>>>>>>>>>>>>>>>>>>"
echo -e "\n This release depends on childsplay version $DEPEN"
echo -n " Cheking version = "
VERSION=$(childsplay --version)
echo $VERSION

if [ `expr $VERSION \< $DEPEN` -eq 1 ];then
    echo " Childsplay version incorrect, please upgrade to at least"
    echo " version $DEPEN"
    echo "exit"
    exit 1
fi
   
echo " Installing in $ASSETMLDIR"

echo " Copy assetml files"
cp -rf $CWD/assetml/* $ASSETMLDIR

echo -e "\n Everything installed, enjoy\n"
