/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2010-09-13 00:49
   Version 4.5.0 
   linux-unix-gnu-x86 [ manyargs dload ptables ]
   compiled 2010-05-25 on hd-t1179cl (Linux)
   command line: posixwin.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -no-warnings -explicit-use -no-trace -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>
#include <fcntl.h>
#include <direct.h>
#include <utime.h>
#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_lstat(fn)	    C_stat(fn)

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_a_mktime(ptr, c, v)  C_flonum(ptr, mktime(C_tm_set(v)))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static int set_file_mtime(char *filename, C_word tm)
{
  struct _utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return _utime(filename, &tb);
}

#include <signal.h>
#include <errno.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[395];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,54,56,32,108,111,99,54,57,32,109,115,103,55,48,32,46,32,97,114,103,115,55,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,48,32,108,105,110,107,56,49,32,101,114,114,56,50,32,108,111,99,56,51,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,116,97,116,32,102,57,53,32,46,32,116,109,112,57,52,57,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,49,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,50,48,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,50,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,50,52,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,50,54,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,49,51,56,32,108,105,110,107,49,52,54,32,101,114,114,49,52,55,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,101,114,114,49,52,49,32,37,108,105,110,107,49,51,54,49,53,53,41};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,108,105,110,107,49,52,48,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,51,52,32,46,32,116,109,112,49,51,51,49,51,53,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,49,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,49,57,50,54,32,102,105,108,101,49,54,50,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,16),40,102,95,49,57,51,54,32,102,105,108,101,49,54,51,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,16),40,102,95,49,57,52,54,32,102,105,108,101,49,54,52,41};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,16),40,102,95,49,57,53,54,32,102,105,108,101,49,54,53,41};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,16),40,102,95,49,57,54,54,32,102,105,108,101,49,54,54,41};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,54,55,41,0,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,49,55,52,49,55,53,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,56,54,41,0,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,50,48,48,32,115,112,101,99,50,48,56,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,48,57,41,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,48,51,32,37,115,112,101,99,49,57,56,50,51,51,41,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,50,48,50,41,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,49,57,54,49,57,55,41,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,7),40,97,50,50,51,49,41,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,11),40,103,50,54,55,32,109,50,54,57,41,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,50,54,49,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,46),40,97,50,50,51,55,32,100,105,114,50,52,51,50,52,52,50,52,57,32,102,105,108,50,52,53,50,52,54,50,53,48,32,101,120,116,50,52,55,50,52,56,50,53,49,41,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,50,52,49,41,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,50,51,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,7),40,97,50,51,56,55,41,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,7),40,97,50,51,57,50,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,50,52,49,54,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,50,57,55,32,114,50,57,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,13),40,102,95,50,52,55,49,32,120,50,57,53,41,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,15),40,102,95,50,52,57,48,32,46,32,95,50,56,57,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,15),40,102,95,50,52,56,50,32,46,32,95,50,56,56,41,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,72),40,35,35,115,121,115,35,102,105,110,100,45,102,105,108,101,115,32,100,105,114,50,55,53,32,112,114,101,100,50,55,54,32,97,99,116,105,111,110,50,55,55,32,105,100,50,55,56,32,108,105,109,105,116,50,55,57,32,100,111,116,50,56,49,32,108,111,99,50,56,50,41};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,42),40,98,111,100,121,51,51,49,32,112,114,101,100,51,52,49,32,97,99,116,105,111,110,51,52,50,32,105,100,51,52,51,32,108,105,109,105,116,51,52,52,41,0,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,50),40,100,101,102,45,108,105,109,105,116,51,51,54,32,37,112,114,101,100,51,50,55,51,52,54,32,37,97,99,116,105,111,110,51,50,56,51,52,55,32,37,105,100,51,50,57,51,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,37),40,100,101,102,45,105,100,51,51,53,32,37,112,114,101,100,51,50,55,51,53,48,32,37,97,99,116,105,111,110,51,50,56,51,53,49,41,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,17),40,97,50,53,50,55,32,120,51,53,52,32,121,51,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,97,99,116,105,111,110,51,51,52,32,37,112,114,101,100,51,50,55,51,53,51,41,0,0,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,14),40,97,50,53,51,56,32,46,32,95,51,53,55,41,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,112,114,101,100,51,51,51,41,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,50,54,52,48,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,50,54,52,51,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,50,54,52,54,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,50,54,52,57,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,18),40,102,95,50,54,53,53,32,120,51,55,54,32,121,51,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,50,54,53,50,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,102,95,50,54,54,51,32,46,32,95,51,55,52,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,7),40,97,50,54,54,48,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,19),40,97,50,54,49,54,32,46,32,116,109,112,51,55,49,51,55,50,41,0,0,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,29),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,51,49,57,32,46,32,97,114,103,115,51,50,48,41,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,52,48,54,32,102,108,97,103,115,52,48,55,32,46,32,109,111,100,101,52,48,56,41,0,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,52,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,52,50,48,32,115,105,122,101,52,50,49,32,46,32,98,117,102,102,101,114,52,50,50,41,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,52,51,49,32,98,117,102,102,101,114,52,51,50,32,46,32,115,105,122,101,52,51,51,41,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,52,52,51,41,0,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,52,53,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,20),40,102,54,49,52,53,32,102,110,97,109,101,52,53,52,54,49,52,52,41,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,20),40,102,54,49,51,57,32,102,110,97,109,101,52,53,52,54,49,51,56,41,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,20),40,102,54,49,51,51,32,102,110,97,109,101,52,53,52,54,49,51,50,41,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,20),40,102,54,49,50,55,32,102,110,97,109,101,52,53,52,54,49,50,54,41,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,52,53,57,32,112,111,115,52,54,48,32,46,32,119,104,101,110,99,101,52,54,49,41,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,11),40,103,53,48,50,32,120,53,48,52,41,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,52,57,53,32,103,52,57,57,53,48,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,52,56,50,32,46,32,116,109,112,52,56,49,52,56,51,41,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,53,50,54,41,0,0,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,53,51,54,32,105,110,112,53,51,55,32,114,53,51,56,41,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,53,52,50,32,46,32,109,53,52,51,41,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,53,53,49,32,46,32,109,53,53,50,41};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,53,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,7),40,97,51,50,57,55,41,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,20),40,97,51,51,48,51,32,46,32,114,101,115,117,108,116,115,53,55,56,41,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,53,55,52,32,112,114,111,99,53,55,53,32,46,32,109,111,100,101,53,55,54,41,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,7),40,97,51,51,50,49,41,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,20),40,97,51,51,50,55,32,46,32,114,101,115,117,108,116,115,53,56,52,41,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,53,56,48,32,112,114,111,99,53,56,49,32,46,32,109,111,100,101,53,56,50,41};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,20),40,97,51,51,52,54,32,46,32,114,101,115,117,108,116,115,53,57,49,41,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,53,56,54,32,116,104,117,110,107,53,56,55,32,46,32,109,111,100,101,53,56,56,41};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,20),40,97,51,51,54,54,32,46,32,114,101,115,117,108,116,115,54,48,48,41,0,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,53,57,53,32,116,104,117,110,107,53,57,54,32,46,32,109,111,100,101,53,57,55,41,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,54,49,50,54,49,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,54,50,49,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,54,50,51,32,112,114,111,99,54,50,52,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,54,50,56,32,115,116,97,116,101,54,50,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,54,51,52,32,109,54,51,53,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,54,52,48,32,97,99,99,54,52,49,32,108,111,99,54,52,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,54,52,54,41,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,54,52,55,41};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,54,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,54,53,52,32,109,54,53,53,32,108,111,99,54,53,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,25),40,99,104,101,99,107,32,102,100,54,54,54,32,105,110,112,54,54,55,32,114,54,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,54,55,50,32,46,32,109,54,55,51,41,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,54,55,53,32,46,32,109,54,55,54,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,54,56,49,41,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,54,56,54,32,46,32,110,101,119,54,56,55,41,0,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,54,57,52,32,118,97,108,54,57,53,41,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,54,57,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,55,49,51,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,55,49,48,41,0,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,55,49,54,32,116,109,55,49,55,41};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,55,50,52,55,50,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,55,51,53,55,51,54,41,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,55,53,50,55,53,51,41,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,55,55,56,32,46,32,116,109,112,55,55,55,55,55,57,41};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,55,56,57,41,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,17),40,95,101,120,105,116,32,46,32,99,111,100,101,56,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,56,48,49,41};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,23),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,56,48,53,41,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,56,48,54,32,109,111,100,101,56,48,55,32,46,32,115,105,122,101,56,48,56,41,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,50,56,41,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,21),40,110,101,101,100,115,45,113,117,111,116,105,110,103,63,32,115,56,50,53,41,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,105,108,115,116,56,51,52,32,111,108,115,116,56,51,53,41,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,35),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,56,50,50,32,101,120,97,99,116,102,56,50,51,41,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,32),40,115,101,116,97,114,103,32,97,56,52,51,56,52,55,32,97,56,52,50,56,52,56,32,97,56,52,49,56,52,57,41};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,32),40,115,101,116,101,110,118,32,97,56,53,51,56,53,55,32,97,56,53,50,56,53,56,32,97,56,53,49,56,53,57,41};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,21),40,100,111,108,111,111,112,56,54,53,32,108,56,54,55,32,105,56,54,56,41,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,57),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,56,54,49,32,108,115,116,56,54,50,32,97,114,103,118,101,99,45,115,101,116,116,101,114,56,54,51,32,105,100,120,56,54,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,62),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,56,55,52,32,102,105,108,101,110,97,109,101,56,55,53,32,97,114,103,108,115,116,56,55,54,32,101,110,118,108,115,116,56,55,55,32,101,120,97,99,116,102,56,55,56,41,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,49),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,56,56,54,32,109,115,103,56,56,55,32,102,105,108,101,110,97,109,101,56,56,56,32,114,101,115,56,56,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,57,48,52,32,97,114,103,108,115,116,57,49,51,32,101,110,118,108,115,116,57,49,52,32,101,120,97,99,116,102,57,49,53,41,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,57,48,56,32,37,97,114,103,108,115,116,57,48,49,57,49,56,32,37,101,110,118,108,115,116,57,48,50,57,49,57,41,0,0,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,57,48,55,32,37,97,114,103,108,115,116,57,48,49,57,50,49,41,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,57,48,54,41,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,41),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,56,57,57,32,46,32,116,109,112,56,57,56,57,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,57,52,49,32,97,114,103,108,115,116,57,53,48,32,101,110,118,108,115,116,57,53,49,32,101,120,97,99,116,102,57,53,50,41,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,57,52,53,32,37,97,114,103,108,115,116,57,51,56,57,53,53,32,37,101,110,118,108,115,116,57,51,57,57,53,54,41,0,0,0,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,57,52,52,32,37,97,114,103,108,115,116,57,51,56,57,53,56,41,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,57,52,51,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,47),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,57,51,53,32,102,105,108,101,110,97,109,101,57,51,54,32,46,32,116,109,112,57,51,52,57,51,55,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,57,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,114,117,110,32,102,57,55,51,32,46,32,97,114,103,115,57,55,52,41,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,48,49,53,32,99,109,100,49,48,49,54,32,97,114,103,115,49,48,49,55,32,101,110,118,49,48,49,56,32,115,116,100,111,117,116,102,49,48,49,57,32,115,116,100,105,110,102,49,48,50,48,32,115,116,100,101,114,114,102,49,48,50,49,32,46,32,116,109,112,49,48,49,52,49,48,50,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,21),40,97,52,56,53,56,32,103,49,48,56,53,49,48,56,54,49,48,56,55,41,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,48,55,54,41,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,52,56,55,54,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,38),40,97,52,56,56,50,32,105,110,49,48,57,51,32,111,117,116,49,48,57,52,32,112,105,100,49,48,57,53,32,101,114,114,49,48,57,54,41,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,63),40,37,112,114,111,99,101,115,115,32,108,111,99,49,48,54,57,32,101,114,114,63,49,48,55,48,32,99,109,100,49,48,55,49,32,97,114,103,115,49,48,55,50,32,101,110,118,49,48,55,51,32,101,120,97,99,116,102,49,48,55,52,41,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,49,49,49,32,97,114,103,115,49,49,50,48,32,101,110,118,49,49,50,49,32,101,120,97,99,116,102,49,49,50,50,41,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,49,49,53,32,37,97,114,103,115,49,49,48,56,49,49,50,52,32,37,101,110,118,49,49,48,57,49,49,50,53,41,0,0,0,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,49,49,52,32,37,97,114,103,115,49,49,48,56,49,49,50,55,41,0,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,49,49,51,41,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,49,48,54,32,46,32,116,109,112,49,49,48,53,49,49,48,55,41,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,49,52,54,32,97,114,103,115,49,49,53,53,32,101,110,118,49,49,53,54,32,101,120,97,99,116,102,49,49,53,55,41,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,49,53,48,32,37,97,114,103,115,49,49,52,51,49,49,53,57,32,37,101,110,118,49,49,52,52,49,49,54,48,41,0,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,49,52,57,32,37,97,114,103,115,49,49,52,51,49,49,54,50,41,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,49,52,56,41,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,49,52,49,32,46,32,116,109,112,49,49,52,48,49,49,52,50,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,49,55,49,32,110,111,104,97,110,103,49,49,55,50,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,7),40,97,53,49,48,50,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,36),40,97,53,49,48,56,32,101,112,105,100,49,49,56,50,32,101,110,111,114,109,49,49,56,51,32,101,99,111,100,101,49,49,56,52,41,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,49,55,51,32,46,32,97,114,103,115,49,49,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,13),40,115,108,101,101,112,32,116,49,49,56,55,41,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,49,50,50,48,49,50,50,51,41,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,49,50,50,54,49,50,50,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,49,50,51,49,49,50,51,52,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,50,51,54,49,50,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,49,50,52,49,49,50,52,52,41};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,49,50,52,54,49,50,52,57,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,49,50,53,49,49,50,53,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,49,50,53,54,49,50,53,57,41,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,49,50,54,49,49,50,54,52,41,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,32),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,46,32,95,49,50,54,54,49,50,54,57,41};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,49,50,55,49,49,50,55,52,41,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,49,50,55,54,49,50,55,57,41,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,49,50,56,49,49,50,56,52,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,49,50,56,54,49,50,56,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,49,50,57,49,49,50,57,52,41,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,49,50,57,54,49,50,57,57,41,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,49,51,48,49,49,51,48,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,49,51,48,54,49,51,48,57,41};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,51,49,49,49,51,49,52,41,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,49,51,49,54,49,51,49,57,41,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,40),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,46,32,95,49,51,50,49,49,51,50,52,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,49,51,50,54,49,51,50,57,41,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,49,51,51,49,49,51,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,49,51,51,54,49,51,51,57,41,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,49,51,52,49,49,51,52,52,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,51,52,54,49,51,52,57,41};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,49,51,53,49,49,51,53,52,41};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,51,53,54,49,51,53,57,41,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,49,51,54,49,49,51,54,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,51,54,54,49,51,54,57,41,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,49,51,55,49,49,51,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,51,55,54,49,51,55,57,41,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,49,51,56,49,49,51,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,49,51,56,54,49,51,56,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,51,57,49,49,51,57,52,41,0,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,49,51,57,54,49,51,57,57,41,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,49,52,48,49,49,52,48,52,41,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,49,52,48,54,49,52,48,57,41,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,36),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,46,32,95,49,52,49,49,49,52,49,52,41,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,52,49,54,49,52,49,57,41,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,49,52,50,49,49,52,50,52,41,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,49,52,50,54,49,52,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,49,52,51,48,41,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,95,49,52,51,49,41,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,15),40,97,53,52,55,55,32,112,111,114,116,52,55,48,41,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,12),40,97,53,53,49,56,32,102,49,48,50,41,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,17),40,97,53,53,50,52,32,102,49,48,52,32,116,49,48,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k4697 */
static C_word C_fcall stub985(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub985(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from current-process-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static C_word C_fcall stub966(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub966(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k4326 */
static C_word C_fcall stub854(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub854(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k4309 */
static C_word C_fcall stub844(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub844(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4102 */
static C_word C_fcall stub797(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub797(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub792(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub792(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
C_return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub767(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub767(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub761(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub761(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3950 */
static C_word C_fcall stub743(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub743(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3788 */
static C_word C_fcall stub705(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub705(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k5533 in k5556 in a5524 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static C_word C_fcall stub111(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub111(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k1687 */
static C_word C_fcall stub64(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub64(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1663)
static void C_ccall f_1663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1666)
static void C_ccall f_1666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1669)
static void C_ccall f_1669(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1672)
static void C_ccall f_1672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1675)
static void C_ccall f_1675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5525)
static void C_ccall f_5525(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5558)
static void C_ccall f_5558(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5535)
static void C_ccall f_5535(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5545)
static void C_fcall f_5545(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5519)
static void C_ccall f_5519(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5523)
static void C_ccall f_5523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5494)
static void C_ccall f_5494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5482)
static void C_ccall f_5482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5485)
static void C_ccall f_5485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2978)
static void C_ccall f_2978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3451)
static void C_ccall f_3451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5459)
static void C_ccall f_5459(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5456)
static void C_ccall f_5456(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5449)
static void C_ccall f_5449(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5443)
static void C_ccall f_5443(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5437)
static void C_ccall f_5437(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5431)
static void C_ccall f_5431(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5425)
static void C_ccall f_5425(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5419)
static void C_ccall f_5419(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5413)
static void C_ccall f_5413(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5407)
static void C_ccall f_5407(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5401)
static void C_ccall f_5401(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5395)
static void C_ccall f_5395(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5389)
static void C_ccall f_5389(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5383)
static void C_ccall f_5383(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5377)
static void C_ccall f_5377(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5371)
static void C_ccall f_5371(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5365)
static void C_ccall f_5365(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5359)
static void C_ccall f_5359(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5353)
static void C_ccall f_5353(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5341)
static void C_ccall f_5341(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5335)
static void C_ccall f_5335(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5329)
static void C_ccall f_5329(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5323)
static void C_ccall f_5323(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5317)
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5311)
static void C_ccall f_5311(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5305)
static void C_ccall f_5305(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5299)
static void C_ccall f_5299(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5293)
static void C_ccall f_5293(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5287)
static void C_ccall f_5287(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5281)
static void C_ccall f_5281(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5275)
static void C_ccall f_5275(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5269)
static void C_ccall f_5269(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5263)
static void C_ccall f_5263(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5257)
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5251)
static void C_ccall f_5251(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5245)
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5239)
static void C_ccall f_5239(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5233)
static void C_ccall f_5233(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5227)
static void C_ccall f_5227(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5221)
static void C_ccall f_5221(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5215)
static void C_ccall f_5215(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5209)
static void C_ccall f_5209(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5203)
static void C_ccall f_5203(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5188)
static void C_ccall f_5188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5198)
static void C_ccall f_5198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5157)
static void C_ccall f_5157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5183)
static void C_ccall f_5183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5168)
static void C_ccall f_5168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5172)
static void C_ccall f_5172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5176)
static void C_ccall f_5176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5180)
static void C_ccall f_5180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5145)
static void C_ccall f_5145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5142)
static void C_ccall f_5142(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5109)
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5119)
static void C_ccall f_5119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5103)
static void C_ccall f_5103(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5070)
static void C_ccall f_5070(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4990)
static void C_ccall f_4990(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4990)
static void C_ccall f_4990r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5007)
static void C_fcall f_5007(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5002)
static void C_fcall f_5002(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4997)
static void C_fcall f_4997(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4992)
static void C_fcall f_4992(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4927)
static void C_fcall f_4927(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4922)
static void C_fcall f_4922(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4917)
static void C_fcall f_4917(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4912)
static void C_fcall f_4912(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4848)
static void C_fcall f_4848(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4908)
static void C_ccall f_4908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4869)
static void C_ccall f_4869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4872)
static void C_ccall f_4872(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4883)
static void C_ccall f_4883(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4877)
static void C_ccall f_4877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4850)
static void C_fcall f_4850(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4859)
static void C_ccall f_4859(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4729)
static void C_ccall f_4729(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_4729)
static void C_ccall f_4729r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_4733)
static void C_ccall f_4733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4824)
static void C_ccall f_4824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4736)
static void C_ccall f_4736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4792)
static void C_ccall f_4792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4796)
static void C_ccall f_4796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4800)
static void C_ccall f_4800(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4804)
static void C_ccall f_4804(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4808)
static void C_ccall f_4808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4671)
static void C_ccall f_4671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4675)
static void C_ccall f_4675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4785)
static void C_ccall f_4785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4765)
static void C_ccall f_4765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4769)
static void C_ccall f_4769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4773)
static void C_ccall f_4773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4637)
static void C_ccall f_4637(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4637)
static void C_ccall f_4637r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4654)
static void C_ccall f_4654(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4658)
static void C_ccall f_4658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4631)
static void C_ccall f_4631(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4610)
static void C_ccall f_4610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4614)
static void C_ccall f_4614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4626)
static void C_ccall f_4626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4607)
static void C_ccall f_4607(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4520)
static void C_ccall f_4520(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4520)
static void C_ccall f_4520r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4544)
static void C_fcall f_4544(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4539)
static void C_fcall f_4539(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4534)
static void C_fcall f_4534(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4522)
static void C_fcall f_4522(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4526)
static void C_ccall f_4526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4433)
static void C_ccall f_4433(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4433)
static void C_ccall f_4433r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4457)
static void C_fcall f_4457(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4452)
static void C_fcall f_4452(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4447)
static void C_fcall f_4447(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4435)
static void C_fcall f_4435(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4439)
static void C_ccall f_4439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4418)
static void C_fcall f_4418(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4422)
static void C_ccall f_4422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4382)
static void C_fcall f_4382(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4389)
static void C_ccall f_4389(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4392)
static void C_ccall f_4392(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4409)
static void C_ccall f_4409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4395)
static void C_ccall f_4395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4398)
static void C_ccall f_4398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4405)
static void C_ccall f_4405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4332)
static void C_fcall f_4332(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4344)
static void C_fcall f_4344(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4363)
static void C_ccall f_4363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4315)
static void C_ccall f_4315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4219)
static void C_fcall f_4219(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4262)
static void C_fcall f_4262(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4293)
static void C_ccall f_4293(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4290)
static void C_ccall f_4290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4224)
static void C_fcall f_4224(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4228)
static void C_ccall f_4228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4233)
static void C_fcall f_4233(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4257)
static void C_ccall f_4257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4246)
static void C_ccall f_4246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4155)
static void C_ccall f_4155(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4155)
static void C_ccall f_4155r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4159)
static void C_ccall f_4159(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4165)
static void C_ccall f_4165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4174)
static void C_fcall f_4174(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4140)
static void C_ccall f_4140(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4147)
static void C_ccall f_4147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4121)
static void C_ccall f_4121(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4125)
static void C_ccall f_4125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4128)
static void C_ccall f_4128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4105)
static void C_ccall f_4105(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4105)
static void C_ccall f_4105r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4093)
static void C_ccall f_4093(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4078)
static void C_ccall f_4078(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4082)
static void C_ccall f_4082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4088)
static void C_ccall f_4088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4011)
static void C_ccall f_4011(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4011)
static void C_ccall f_4011r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4015)
static void C_ccall f_4015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4040)
static void C_ccall f_4040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4027)
static void C_ccall f_4027(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3957)
static void C_ccall f_3957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3960)
static void C_ccall f_3960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3909)
static void C_ccall f_3909(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3909)
static void C_ccall f_3909r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3913)
static void C_ccall f_3913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3875)
static void C_ccall f_3875(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3875)
static void C_ccall f_3875r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3879)
static void C_ccall f_3879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3856)
static void C_fcall f_3856(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3791)
static void C_ccall f_3791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3797)
static void C_fcall f_3797(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3801)
static void C_ccall f_3801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3809)
static void C_fcall f_3809(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3835)
static void C_ccall f_3835(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3839)
static void C_ccall f_3839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3827)
static void C_ccall f_3827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3771)
static void C_ccall f_3771(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3779)
static void C_ccall f_3779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3754)
static void C_ccall f_3754(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3765)
static void C_ccall f_3765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3769)
static void C_ccall f_3769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3724)
static void C_ccall f_3724(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3724)
static void C_ccall f_3724r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3731)
static void C_fcall f_3731(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3740)
static void C_ccall f_3740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3734)
static void C_ccall f_3734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3722)
static void C_ccall f_3722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3708)
static void C_ccall f_3708(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3702)
static void C_ccall f_3702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3675)
static void C_ccall f_3675(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3675)
static void C_ccall f_3675r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3687)
static void C_ccall f_3687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3661)
static void C_ccall f_3661(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3661)
static void C_ccall f_3661r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3673)
static void C_ccall f_3673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3643)
static void C_fcall f_3643(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3647)
static void C_ccall f_3647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3659)
static void C_ccall f_3659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3606)
static void C_fcall f_3606(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3614)
static void C_ccall f_3614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3597)
static void C_ccall f_3597(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3591)
static void C_ccall f_3591(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3561)
static void C_fcall f_3561(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3583)
static void C_ccall f_3583(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3579)
static void C_ccall f_3579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3571)
static void C_ccall f_3571(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3531)
static void C_ccall f_3531(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3559)
static void C_ccall f_3559(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3555)
static void C_ccall f_3555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3547)
static void C_ccall f_3547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3475)
static void C_ccall f_3475(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3485)
static void C_ccall f_3485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3462)
static void C_ccall f_3462(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3377)
static void C_ccall f_3377(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3377)
static void C_ccall f_3377r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3381)
static void C_ccall f_3381(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3393)
static void C_ccall f_3393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3384)
static void C_ccall f_3384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3357)
static void C_ccall f_3357(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3357)
static void C_ccall f_3357r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3361)
static void C_ccall f_3361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3367)
static void C_ccall f_3367(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3367)
static void C_ccall f_3367r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3371)
static void C_ccall f_3371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3337)
static void C_ccall f_3337(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3337)
static void C_ccall f_3337r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3341)
static void C_ccall f_3341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3347)
static void C_ccall f_3347(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3347)
static void C_ccall f_3347r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3313)
static void C_ccall f_3313(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3313)
static void C_ccall f_3313r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3317)
static void C_ccall f_3317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3328)
static void C_ccall f_3328(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3328)
static void C_ccall f_3328r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3332)
static void C_ccall f_3332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3322)
static void C_ccall f_3322(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3289)
static void C_ccall f_3289(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3289)
static void C_ccall f_3289r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3293)
static void C_ccall f_3293(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3304)
static void C_ccall f_3304(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3304)
static void C_ccall f_3304r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3308)
static void C_ccall f_3308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3298)
static void C_ccall f_3298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3270)
static void C_ccall f_3270(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3274)
static void C_ccall f_3274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3277)
static void C_ccall f_3277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3234)
static void C_ccall f_3234(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3234)
static void C_ccall f_3234r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3265)
static void C_ccall f_3265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3198)
static void C_ccall f_3198(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3198)
static void C_ccall f_3198r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3219)
static void C_ccall f_3219(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3212)
static void C_ccall f_3212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3180)
static void C_fcall f_3180(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3184)
static void C_ccall f_3184(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3196)
static void C_ccall f_3196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3137)
static void C_ccall f_3137(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3160)
static void C_ccall f_3160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3144)
static void C_ccall f_3144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3153)
static void C_ccall f_3153(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3147)
static void C_ccall f_3147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2984)
static void C_ccall f_2984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2990)
static void C_ccall f_2990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3113)
static void C_ccall f_3113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3105)
static void C_ccall f_3105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2998)
static void C_ccall f_2998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3010)
static void C_fcall f_3010(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3080)
static void C_ccall f_3080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3018)
static void C_fcall f_3018(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3023)
static void C_ccall f_3023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3036)
static void C_ccall f_3036(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3039)
static void C_ccall f_3039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3052)
static void C_fcall f_3052(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3071)
static void C_ccall f_3071(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3063)
static void C_ccall f_3063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2993)
static void C_ccall f_2993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2918)
static void C_ccall f_2918(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2918)
static void C_ccall f_2918r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2937)
static void C_ccall f_2937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f6127)
static void C_ccall f6127(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6133)
static void C_ccall f6133(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6139)
static void C_ccall f6139(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6145)
static void C_ccall f6145(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2889)
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2851)
static void C_ccall f_2851(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2858)
static void C_ccall f_2858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2861)
static void C_ccall f_2861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2881)
static void C_ccall f_2881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2864)
static void C_ccall f_2864(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2871)
static void C_ccall f_2871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2831)
static void C_ccall f_2831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2825)
static void C_ccall f_2825(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2764)
static void C_ccall f_2764(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2764)
static void C_ccall f_2764r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2774)
static void C_ccall f_2774(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2777)
static void C_ccall f_2777(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2789)
static void C_ccall f_2789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2780)
static void C_ccall f_2780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2746)
static void C_ccall f_2746(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2759)
static void C_ccall f_2759(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2705)
static void C_ccall f_2705(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2705)
static void C_ccall f_2705r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2738)
static void C_ccall f_2738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2722)
static void C_ccall f_2722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2731)
static void C_ccall f_2731(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2496)
static void C_ccall f_2496(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2496)
static void C_ccall f_2496r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2671)
static void C_ccall f_2671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2506)
static void C_fcall f_2506(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2617)
static void C_ccall f_2617(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2617)
static void C_ccall f_2617r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2661)
static void C_ccall f_2661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2663)
static void C_ccall f_2663(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2621)
static void C_ccall f_2621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2653)
static void C_ccall f_2653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2655)
static void C_ccall f_2655(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2624)
static void C_ccall f_2624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2650)
static void C_ccall f_2650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2627)
static void C_ccall f_2627(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2630)
static void C_ccall f_2630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2644)
static void C_ccall f_2644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2633)
static void C_ccall f_2633(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2636)
static void C_ccall f_2636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2533)
static void C_fcall f_2533(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2522)
static void C_fcall f_2522(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2528)
static void C_ccall f_2528(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2517)
static void C_fcall f_2517(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2512)
static void C_fcall f_2512(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2507)
static void C_fcall f_2507(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_2323)
static void C_fcall f_2323(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_2482)
static void C_ccall f_2482(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2490)
static void C_ccall f_2490(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2330)
static void C_fcall f_2330(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2467)
static void C_ccall f_2467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2470)
static void C_ccall f_2470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2471)
static void C_ccall f_2471(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2333)
static void C_fcall f_2333(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2457)
static void C_ccall f_2457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2340)
static void C_ccall f_2340(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2342)
static void C_fcall f_2342(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2361)
static void C_ccall f_2361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2443)
static void C_ccall f_2443(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2450)
static void C_ccall f_2450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2437)
static void C_ccall f_2437(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2376)
static void C_ccall f_2376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2430)
static void C_ccall f_2430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2427)
static void C_ccall f_2427(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2417)
static void C_ccall f_2417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2393)
static void C_ccall f_2393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2415)
static void C_ccall f_2415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2401)
static void C_ccall f_2401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2408)
static void C_ccall f_2408(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2405)
static void C_ccall f_2405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2388)
static void C_ccall f_2388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2386)
static void C_ccall f_2386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2217)
static void C_fcall f_2217(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2238)
static void C_ccall f_2238(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2317)
static void C_ccall f_2317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2242)
static void C_ccall f_2242(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2245)
static void C_ccall f_2245(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2252)
static void C_ccall f_2252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2254)
static void C_fcall f_2254(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2271)
static void C_ccall f_2271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2275)
static void C_fcall f_2275(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2283)
static void C_ccall f_2283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2287)
static void C_ccall f_2287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2232)
static void C_ccall f_2232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2054)
static void C_ccall f_2054(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2054)
static void C_ccall f_2054r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2159)
static void C_fcall f_2159(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2167)
static void C_ccall f_2167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2154)
static void C_fcall f_2154(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2056)
static void C_fcall f_2056(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2063)
static void C_ccall f_2063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2066)
static void C_ccall f_2066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2069)
static void C_ccall f_2069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2153)
static void C_ccall f_2153(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2073)
static void C_ccall f_2073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2087)
static void C_fcall f_2087(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2097)
static void C_ccall f_2097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2109)
static void C_fcall f_2109(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2119)
static void C_ccall f_2119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2032)
static void C_ccall f_2032(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2052)
static void C_ccall f_2052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2039)
static void C_ccall f_2039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2042)
static void C_ccall f_2042(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1986)
static void C_ccall f_1986(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1986)
static void C_ccall f_1986r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1990)
static void C_ccall f_1990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1999)
static void C_ccall f_1999(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2002)
static void C_ccall f_2002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1976)
static void C_ccall f_1976(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1984)
static void C_ccall f_1984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1966)
static void C_ccall f_1966(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1974)
static void C_ccall f_1974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1956)
static void C_ccall f_1956(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1964)
static void C_ccall f_1964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1946)
static void C_ccall f_1946(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1954)
static void C_ccall f_1954(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1936)
static void C_ccall f_1936(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1944)
static void C_ccall f_1944(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1926)
static void C_ccall f_1926(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1934)
static void C_ccall f_1934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1916)
static void C_ccall f_1916(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1924)
static void C_ccall f_1924(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1817)
static void C_ccall f_1817(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1817)
static void C_ccall f_1817r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1868)
static void C_fcall f_1868(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1863)
static void C_fcall f_1863(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1819)
static void C_fcall f_1819(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1826)
static void C_ccall f_1826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1811)
static void C_ccall f_1811(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1815)
static void C_ccall f_1815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1805)
static void C_ccall f_1805(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1809)
static void C_ccall f_1809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1799)
static void C_ccall f_1799(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1803)
static void C_ccall f_1803(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1793)
static void C_ccall f_1793(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1797)
static void C_ccall f_1797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1787)
static void C_ccall f_1787(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1791)
static void C_ccall f_1791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1752)
static void C_ccall f_1752(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1752)
static void C_ccall f_1752r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1756)
static void C_ccall f_1756(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1759)
static void C_ccall f_1759(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1708)
static void C_fcall f_1708(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_1747)
static void C_ccall f_1747(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1743)
static void C_ccall f_1743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1736)
static void C_ccall f_1736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1712)
static void C_ccall f_1712(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1694)
static void C_ccall f_1694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1705)
static void C_ccall f_1705(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1701)
static void C_ccall f_1701(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_5545)
static void C_fcall trf_5545(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5545(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5545(t0,t1);}

C_noret_decl(trf_5007)
static void C_fcall trf_5007(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5007(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5007(t0,t1);}

C_noret_decl(trf_5002)
static void C_fcall trf_5002(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5002(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5002(t0,t1,t2);}

C_noret_decl(trf_4997)
static void C_fcall trf_4997(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4997(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4997(t0,t1,t2,t3);}

C_noret_decl(trf_4992)
static void C_fcall trf_4992(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4992(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4992(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4927)
static void C_fcall trf_4927(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4927(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4927(t0,t1);}

C_noret_decl(trf_4922)
static void C_fcall trf_4922(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4922(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4922(t0,t1,t2);}

C_noret_decl(trf_4917)
static void C_fcall trf_4917(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4917(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4917(t0,t1,t2,t3);}

C_noret_decl(trf_4912)
static void C_fcall trf_4912(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4912(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4912(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4848)
static void C_fcall trf_4848(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4848(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4848(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4850)
static void C_fcall trf_4850(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4850(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4850(t0,t1,t2);}

C_noret_decl(trf_4544)
static void C_fcall trf_4544(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4544(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4544(t0,t1);}

C_noret_decl(trf_4539)
static void C_fcall trf_4539(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4539(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4539(t0,t1,t2);}

C_noret_decl(trf_4534)
static void C_fcall trf_4534(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4534(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4534(t0,t1,t2,t3);}

C_noret_decl(trf_4522)
static void C_fcall trf_4522(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4522(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4522(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4457)
static void C_fcall trf_4457(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4457(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4457(t0,t1);}

C_noret_decl(trf_4452)
static void C_fcall trf_4452(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4452(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4452(t0,t1,t2);}

C_noret_decl(trf_4447)
static void C_fcall trf_4447(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4447(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4447(t0,t1,t2,t3);}

C_noret_decl(trf_4435)
static void C_fcall trf_4435(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4435(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4435(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4418)
static void C_fcall trf_4418(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4418(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4418(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4382)
static void C_fcall trf_4382(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4382(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4382(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4332)
static void C_fcall trf_4332(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4332(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4332(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4344)
static void C_fcall trf_4344(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4344(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4344(t0,t1,t2,t3);}

C_noret_decl(trf_4219)
static void C_fcall trf_4219(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4219(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4219(t0,t1,t2,t3);}

C_noret_decl(trf_4262)
static void C_fcall trf_4262(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4262(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4262(t0,t1,t2,t3);}

C_noret_decl(trf_4224)
static void C_fcall trf_4224(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4224(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4224(t0,t1,t2);}

C_noret_decl(trf_4233)
static void C_fcall trf_4233(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4233(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4233(t0,t1,t2);}

C_noret_decl(trf_4174)
static void C_fcall trf_4174(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4174(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4174(t0,t1);}

C_noret_decl(trf_3856)
static void C_fcall trf_3856(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3856(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3856(t0,t1,t2);}

C_noret_decl(trf_3797)
static void C_fcall trf_3797(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3797(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3797(t0,t1,t2);}

C_noret_decl(trf_3809)
static void C_fcall trf_3809(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3809(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3809(t0,t1,t2);}

C_noret_decl(trf_3731)
static void C_fcall trf_3731(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3731(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3731(t0,t1);}

C_noret_decl(trf_3643)
static void C_fcall trf_3643(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3643(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3643(t0,t1,t2,t3);}

C_noret_decl(trf_3606)
static void C_fcall trf_3606(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3606(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3606(t0,t1,t2,t3);}

C_noret_decl(trf_3561)
static void C_fcall trf_3561(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3561(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3561(t0,t1,t2,t3);}

C_noret_decl(trf_3180)
static void C_fcall trf_3180(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3180(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3180(t0,t1,t2,t3);}

C_noret_decl(trf_3010)
static void C_fcall trf_3010(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3010(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3010(t0,t1,t2);}

C_noret_decl(trf_3018)
static void C_fcall trf_3018(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3018(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3018(t0,t1,t2);}

C_noret_decl(trf_3052)
static void C_fcall trf_3052(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3052(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3052(t0,t1);}

C_noret_decl(trf_2506)
static void C_fcall trf_2506(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2506(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2506(t0,t1);}

C_noret_decl(trf_2533)
static void C_fcall trf_2533(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2533(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2533(t0,t1);}

C_noret_decl(trf_2522)
static void C_fcall trf_2522(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2522(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2522(t0,t1,t2);}

C_noret_decl(trf_2517)
static void C_fcall trf_2517(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2517(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2517(t0,t1,t2,t3);}

C_noret_decl(trf_2512)
static void C_fcall trf_2512(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2512(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2512(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2507)
static void C_fcall trf_2507(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2507(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_2507(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_2323)
static void C_fcall trf_2323(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2323(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_2323(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_2330)
static void C_fcall trf_2330(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2330(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2330(t0,t1);}

C_noret_decl(trf_2333)
static void C_fcall trf_2333(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2333(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2333(t0,t1);}

C_noret_decl(trf_2342)
static void C_fcall trf_2342(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2342(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2342(t0,t1,t2,t3);}

C_noret_decl(trf_2217)
static void C_fcall trf_2217(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2217(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2217(t0,t1,t2);}

C_noret_decl(trf_2254)
static void C_fcall trf_2254(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2254(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2254(t0,t1,t2);}

C_noret_decl(trf_2275)
static void C_fcall trf_2275(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2275(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2275(t0,t1,t2);}

C_noret_decl(trf_2159)
static void C_fcall trf_2159(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2159(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2159(t0,t1);}

C_noret_decl(trf_2154)
static void C_fcall trf_2154(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2154(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2154(t0,t1,t2);}

C_noret_decl(trf_2056)
static void C_fcall trf_2056(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2056(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2056(t0,t1,t2,t3);}

C_noret_decl(trf_2087)
static void C_fcall trf_2087(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2087(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2087(t0,t1);}

C_noret_decl(trf_2109)
static void C_fcall trf_2109(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2109(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2109(t0,t1);}

C_noret_decl(trf_1868)
static void C_fcall trf_1868(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1868(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1868(t0,t1);}

C_noret_decl(trf_1863)
static void C_fcall trf_1863(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1863(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1863(t0,t1,t2);}

C_noret_decl(trf_1819)
static void C_fcall trf_1819(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1819(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1819(t0,t1,t2,t3);}

C_noret_decl(trf_1708)
static void C_fcall trf_1708(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1708(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_1708(t0,t1,t2,t3,t4);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3144)){
C_save(t1);
C_rereclaim2(3144*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,395);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],15,"\003sysposix-error");
lf[12]=C_h_intern(&lf[12],11,"\000file-error");
lf[13]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[14]=C_h_intern(&lf[14],17,"\003sysmake-c-string");
lf[15]=C_h_intern(&lf[15],27,"\003sysplatform-fixup-pathname");
lf[16]=C_h_intern(&lf[16],20,"\003sysexpand-home-path");
lf[17]=C_h_intern(&lf[17],11,"\000type-error");
lf[18]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[19]=C_h_intern(&lf[19],9,"file-stat");
lf[20]=C_h_intern(&lf[20],16,"_stat_st_blksize");
lf[21]=C_h_intern(&lf[21],15,"_stat_st_blocks");
lf[22]=C_h_intern(&lf[22],9,"\003syserror");
lf[23]=C_h_intern(&lf[23],22,"file-modification-time");
lf[24]=C_h_intern(&lf[24],16,"file-access-time");
lf[25]=C_h_intern(&lf[25],16,"file-change-time");
lf[26]=C_h_intern(&lf[26],10,"file-owner");
lf[27]=C_h_intern(&lf[27],16,"file-permissions");
lf[28]=C_h_intern(&lf[28],9,"file-size");
lf[29]=C_h_intern(&lf[29],9,"file-type");
lf[30]=C_h_intern(&lf[30],13,"symbolic-link");
lf[31]=C_h_intern(&lf[31],9,"directory");
lf[32]=C_h_intern(&lf[32],16,"character-device");
lf[33]=C_h_intern(&lf[33],12,"block-device");
lf[34]=C_h_intern(&lf[34],4,"fifo");
lf[35]=C_h_intern(&lf[35],6,"socket");
lf[36]=C_h_intern(&lf[36],12,"regular-file");
lf[37]=C_h_intern(&lf[37],13,"regular-file\077");
lf[38]=C_h_intern(&lf[38],14,"symbolic-link\077");
lf[39]=C_h_intern(&lf[39],13,"block-device\077");
lf[40]=C_h_intern(&lf[40],17,"character-device\077");
lf[41]=C_h_intern(&lf[41],5,"fifo\077");
lf[42]=C_h_intern(&lf[42],7,"socket\077");
lf[43]=C_h_intern(&lf[43],10,"directory\077");
lf[44]=C_h_intern(&lf[44],11,"make-string");
lf[45]=C_h_intern(&lf[45],17,"current-directory");
lf[46]=C_h_intern(&lf[46],16,"change-directory");
lf[47]=C_h_intern(&lf[47],13,"\003syssubstring");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[49]=C_h_intern(&lf[49],16,"delete-directory");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[52]=C_h_intern(&lf[52],16,"\003sysmake-pointer");
lf[53]=C_h_intern(&lf[53],4,"glob");
lf[54]=C_h_intern(&lf[54],18,"decompose-pathname");
lf[55]=C_h_intern(&lf[55],13,"make-pathname");
lf[56]=C_h_intern(&lf[56],12,"string-match");
lf[57]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[58]=C_h_intern(&lf[58],6,"regexp");
lf[59]=C_h_intern(&lf[59],12,"glob->regexp");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[62]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[65]=C_h_intern(&lf[65],16,"\003sysdynamic-wind");
lf[66]=C_h_intern(&lf[66],13,"pathname-file");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\002\077*");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[69]=C_h_intern(&lf[69],7,"regexp\077");
lf[70]=C_h_intern(&lf[70],10,"find-files");
lf[71]=C_h_intern(&lf[71],15,"\003sysget-keyword");
lf[72]=C_h_intern(&lf[72],16,"\000follow-symlinks");
lf[73]=C_h_intern(&lf[73],9,"\000dotfiles");
lf[74]=C_h_intern(&lf[74],6,"\000limit");
lf[75]=C_h_intern(&lf[75],5,"\000seed");
lf[76]=C_h_intern(&lf[76],7,"\000action");
lf[77]=C_h_intern(&lf[77],5,"\000test");
lf[78]=C_h_intern(&lf[78],8,"keyword\077");
lf[79]=C_h_intern(&lf[79],8,"pipe/buf");
lf[80]=C_h_intern(&lf[80],11,"open/rdonly");
lf[81]=C_h_intern(&lf[81],11,"open/wronly");
lf[82]=C_h_intern(&lf[82],9,"open/rdwr");
lf[83]=C_h_intern(&lf[83],9,"open/read");
lf[84]=C_h_intern(&lf[84],10,"open/write");
lf[85]=C_h_intern(&lf[85],10,"open/creat");
lf[86]=C_h_intern(&lf[86],11,"open/append");
lf[87]=C_h_intern(&lf[87],9,"open/excl");
lf[88]=C_h_intern(&lf[88],10,"open/trunc");
lf[89]=C_h_intern(&lf[89],11,"open/binary");
lf[90]=C_h_intern(&lf[90],9,"open/text");
lf[91]=C_h_intern(&lf[91],14,"open/noinherit");
lf[92]=C_h_intern(&lf[92],10,"perm/irusr");
lf[93]=C_h_intern(&lf[93],10,"perm/iwusr");
lf[94]=C_h_intern(&lf[94],10,"perm/ixusr");
lf[95]=C_h_intern(&lf[95],10,"perm/irgrp");
lf[96]=C_h_intern(&lf[96],10,"perm/iwgrp");
lf[97]=C_h_intern(&lf[97],10,"perm/ixgrp");
lf[98]=C_h_intern(&lf[98],10,"perm/iroth");
lf[99]=C_h_intern(&lf[99],10,"perm/iwoth");
lf[100]=C_h_intern(&lf[100],10,"perm/ixoth");
lf[101]=C_h_intern(&lf[101],10,"perm/irwxu");
lf[102]=C_h_intern(&lf[102],10,"perm/irwxg");
lf[103]=C_h_intern(&lf[103],10,"perm/irwxo");
lf[104]=C_h_intern(&lf[104],9,"file-open");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[106]=C_h_intern(&lf[106],10,"file-close");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[108]=C_h_intern(&lf[108],9,"file-read");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[111]=C_h_intern(&lf[111],10,"file-write");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[113]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[114]=C_h_intern(&lf[114],13,"string-length");
lf[115]=C_h_intern(&lf[115],12,"file-mkstemp");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[117]=C_h_intern(&lf[117],8,"seek/set");
lf[118]=C_h_intern(&lf[118],8,"seek/end");
lf[119]=C_h_intern(&lf[119],8,"seek/cur");
lf[120]=C_h_intern(&lf[120],18,"set-file-position!");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[122]=C_h_intern(&lf[122],6,"stream");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[124]=C_h_intern(&lf[124],5,"port\077");
lf[125]=C_h_intern(&lf[125],13,"\000bounds-error");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[127]=C_h_intern(&lf[127],13,"file-position");
lf[128]=C_h_intern(&lf[128],16,"create-directory");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[130]=C_h_intern(&lf[130],13,"\003sysfile-info");
lf[131]=C_h_intern(&lf[131],12,"file-exists\077");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[133]=C_h_intern(&lf[133],12,"string-split");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[135]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[137]=C_h_intern(&lf[137],13,"\003sysmake-port");
lf[138]=C_h_intern(&lf[138],21,"\003sysstream-port-class");
lf[139]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[140]=C_h_intern(&lf[140],15,"open-input-pipe");
lf[141]=C_h_intern(&lf[141],5,"\000text");
lf[142]=C_h_intern(&lf[142],7,"\000binary");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[144]=C_h_intern(&lf[144],16,"open-output-pipe");
lf[145]=C_h_intern(&lf[145],16,"close-input-pipe");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[147]=C_h_intern(&lf[147],14,"\003syscheck-port");
lf[148]=C_h_intern(&lf[148],17,"close-output-pipe");
lf[149]=C_h_intern(&lf[149],20,"call-with-input-pipe");
lf[150]=C_h_intern(&lf[150],21,"call-with-output-pipe");
lf[151]=C_h_intern(&lf[151],20,"with-input-from-pipe");
lf[152]=C_h_intern(&lf[152],18,"\003sysstandard-input");
lf[153]=C_h_intern(&lf[153],19,"with-output-to-pipe");
lf[154]=C_h_intern(&lf[154],19,"\003sysstandard-output");
lf[155]=C_h_intern(&lf[155],11,"create-pipe");
lf[156]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[157]=C_h_intern(&lf[157],11,"signal/term");
lf[158]=C_h_intern(&lf[158],10,"signal/int");
lf[159]=C_h_intern(&lf[159],10,"signal/fpe");
lf[160]=C_h_intern(&lf[160],10,"signal/ill");
lf[161]=C_h_intern(&lf[161],11,"signal/segv");
lf[162]=C_h_intern(&lf[162],11,"signal/abrt");
lf[163]=C_h_intern(&lf[163],12,"signal/break");
lf[164]=C_h_intern(&lf[164],11,"signal/alrm");
lf[165]=C_h_intern(&lf[165],11,"signal/chld");
lf[166]=C_h_intern(&lf[166],11,"signal/cont");
lf[167]=C_h_intern(&lf[167],10,"signal/hup");
lf[168]=C_h_intern(&lf[168],9,"signal/io");
lf[169]=C_h_intern(&lf[169],11,"signal/kill");
lf[170]=C_h_intern(&lf[170],11,"signal/pipe");
lf[171]=C_h_intern(&lf[171],11,"signal/prof");
lf[172]=C_h_intern(&lf[172],11,"signal/quit");
lf[173]=C_h_intern(&lf[173],11,"signal/stop");
lf[174]=C_h_intern(&lf[174],11,"signal/trap");
lf[175]=C_h_intern(&lf[175],11,"signal/tstp");
lf[176]=C_h_intern(&lf[176],10,"signal/urg");
lf[177]=C_h_intern(&lf[177],11,"signal/usr1");
lf[178]=C_h_intern(&lf[178],11,"signal/usr2");
lf[179]=C_h_intern(&lf[179],13,"signal/vtalrm");
lf[180]=C_h_intern(&lf[180],12,"signal/winch");
lf[181]=C_h_intern(&lf[181],11,"signal/xcpu");
lf[182]=C_h_intern(&lf[182],11,"signal/xfsz");
lf[183]=C_h_intern(&lf[183],12,"signals-list");
lf[184]=C_h_intern(&lf[184],18,"\003sysinterrupt-hook");
lf[185]=C_h_intern(&lf[185],14,"signal-handler");
lf[186]=C_h_intern(&lf[186],19,"set-signal-handler!");
lf[187]=C_h_intern(&lf[187],10,"errno/perm");
lf[188]=C_h_intern(&lf[188],11,"errno/noent");
lf[189]=C_h_intern(&lf[189],10,"errno/srch");
lf[190]=C_h_intern(&lf[190],10,"errno/intr");
lf[191]=C_h_intern(&lf[191],8,"errno/io");
lf[192]=C_h_intern(&lf[192],12,"errno/noexec");
lf[193]=C_h_intern(&lf[193],10,"errno/badf");
lf[194]=C_h_intern(&lf[194],11,"errno/child");
lf[195]=C_h_intern(&lf[195],11,"errno/nomem");
lf[196]=C_h_intern(&lf[196],11,"errno/acces");
lf[197]=C_h_intern(&lf[197],11,"errno/fault");
lf[198]=C_h_intern(&lf[198],10,"errno/busy");
lf[199]=C_h_intern(&lf[199],11,"errno/exist");
lf[200]=C_h_intern(&lf[200],12,"errno/notdir");
lf[201]=C_h_intern(&lf[201],11,"errno/isdir");
lf[202]=C_h_intern(&lf[202],11,"errno/inval");
lf[203]=C_h_intern(&lf[203],11,"errno/mfile");
lf[204]=C_h_intern(&lf[204],11,"errno/nospc");
lf[205]=C_h_intern(&lf[205],11,"errno/spipe");
lf[206]=C_h_intern(&lf[206],10,"errno/pipe");
lf[207]=C_h_intern(&lf[207],11,"errno/again");
lf[208]=C_h_intern(&lf[208],10,"errno/rofs");
lf[209]=C_h_intern(&lf[209],10,"errno/nxio");
lf[210]=C_h_intern(&lf[210],10,"errno/2big");
lf[211]=C_h_intern(&lf[211],10,"errno/xdev");
lf[212]=C_h_intern(&lf[212],11,"errno/nodev");
lf[213]=C_h_intern(&lf[213],11,"errno/nfile");
lf[214]=C_h_intern(&lf[214],11,"errno/notty");
lf[215]=C_h_intern(&lf[215],10,"errno/fbig");
lf[216]=C_h_intern(&lf[216],11,"errno/mlink");
lf[217]=C_h_intern(&lf[217],9,"errno/dom");
lf[218]=C_h_intern(&lf[218],11,"errno/range");
lf[219]=C_h_intern(&lf[219],12,"errno/deadlk");
lf[220]=C_h_intern(&lf[220],17,"errno/nametoolong");
lf[221]=C_h_intern(&lf[221],11,"errno/nolck");
lf[222]=C_h_intern(&lf[222],11,"errno/nosys");
lf[223]=C_h_intern(&lf[223],14,"errno/notempty");
lf[224]=C_h_intern(&lf[224],11,"errno/ilseq");
lf[225]=C_h_intern(&lf[225],16,"change-file-mode");
lf[226]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[227]=C_h_intern(&lf[227],17,"file-read-access\077");
lf[228]=C_h_intern(&lf[228],18,"file-write-access\077");
lf[229]=C_h_intern(&lf[229],20,"file-execute-access\077");
lf[230]=C_h_intern(&lf[230],12,"fileno/stdin");
lf[231]=C_h_intern(&lf[231],13,"fileno/stdout");
lf[232]=C_h_intern(&lf[232],13,"fileno/stderr");
lf[233]=C_h_intern(&lf[233],7,"\000append");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[237]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[240]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[241]=C_h_intern(&lf[241],16,"open-input-file*");
lf[242]=C_h_intern(&lf[242],17,"open-output-file*");
lf[243]=C_h_intern(&lf[243],12,"port->fileno");
lf[244]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[245]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[246]=C_h_intern(&lf[246],25,"\003syspeek-unsigned-integer");
lf[247]=C_h_intern(&lf[247],16,"duplicate-fileno");
lf[248]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[249]=C_h_intern(&lf[249],6,"setenv");
lf[250]=C_h_intern(&lf[250],8,"unsetenv");
lf[251]=C_h_intern(&lf[251],9,"substring");
lf[252]=C_h_intern(&lf[252],25,"get-environment-variables");
lf[254]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[255]=C_h_intern(&lf[255],19,"seconds->local-time");
lf[256]=C_h_intern(&lf[256],18,"\003sysdecode-seconds");
lf[257]=C_h_intern(&lf[257],15,"current-seconds");
lf[258]=C_h_intern(&lf[258],17,"seconds->utc-time");
lf[259]=C_h_intern(&lf[259],15,"seconds->string");
lf[260]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[261]=C_h_intern(&lf[261],12,"time->string");
lf[262]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[264]=C_h_intern(&lf[264],19,"local-time->seconds");
lf[265]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[266]=C_h_intern(&lf[266],3,"fp=");
lf[267]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[268]=C_h_intern(&lf[268],27,"local-timezone-abbreviation");
lf[269]=C_h_intern(&lf[269],5,"_exit");
lf[270]=C_h_intern(&lf[270],14,"terminal-port\077");
lf[271]=C_h_intern(&lf[271],13,"terminal-size");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[273]=C_h_intern(&lf[273],19,"set-buffering-mode!");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[275]=C_h_intern(&lf[275],5,"\000full");
lf[276]=C_h_intern(&lf[276],5,"\000line");
lf[277]=C_h_intern(&lf[277],5,"\000none");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[279]=C_h_intern(&lf[279],13,"spawn/overlay");
lf[280]=C_h_intern(&lf[280],10,"spawn/wait");
lf[281]=C_h_intern(&lf[281],12,"spawn/nowait");
lf[282]=C_h_intern(&lf[282],13,"spawn/nowaito");
lf[283]=C_h_intern(&lf[283],12,"spawn/detach");
lf[284]=C_h_intern(&lf[284],16,"char-whitespace\077");
lf[285]=C_h_intern(&lf[285],10,"string-ref");
lf[287]=C_h_intern(&lf[287],7,"reverse");
lf[288]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[291]=C_h_intern(&lf[291],24,"pathname-strip-directory");
lf[293]=C_h_intern(&lf[293],15,"process-execute");
lf[294]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[295]=C_h_intern(&lf[295],13,"process-spawn");
lf[296]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[297]=C_h_intern(&lf[297],18,"current-process-id");
lf[298]=C_h_intern(&lf[298],17,"\003sysshell-command");
lf[299]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[300]=C_h_intern(&lf[300],24,"get-environment-variable");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[302]=C_h_intern(&lf[302],27,"\003sysshell-command-arguments");
lf[303]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[304]=C_h_intern(&lf[304],11,"process-run");
lf[305]=C_h_intern(&lf[305],11,"\003sysprocess");
lf[306]=C_h_intern(&lf[306],14,"\000process-error");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[308]=C_h_intern(&lf[308],17,"\003sysmake-locative");
lf[309]=C_h_intern(&lf[309],8,"location");
lf[310]=C_h_intern(&lf[310],18,"string-intersperse");
lf[311]=C_h_intern(&lf[311],16,"\003syscheck-string");
lf[312]=C_h_intern(&lf[312],12,"\003sysfor-each");
lf[313]=C_h_intern(&lf[313],7,"process");
lf[314]=C_h_intern(&lf[314],8,"process*");
lf[315]=C_h_intern(&lf[315],16,"\003sysprocess-wait");
lf[316]=C_h_intern(&lf[316],12,"process-wait");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[318]=C_h_intern(&lf[318],5,"sleep");
lf[319]=C_h_intern(&lf[319],13,"get-host-name");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[321]=C_h_intern(&lf[321],18,"system-information");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[324]=C_h_intern(&lf[324],17,"current-user-name");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[326]=C_h_intern(&lf[326],17,"change-file-owner");
lf[327]=C_h_intern(&lf[327],5,"error");
lf[328]=C_h_intern(&lf[328],11,"create-fifo");
lf[329]=C_h_intern(&lf[329],14,"create-session");
lf[330]=C_h_intern(&lf[330],20,"create-symbolic-link");
lf[331]=C_h_intern(&lf[331],26,"current-effective-group-id");
lf[332]=C_h_intern(&lf[332],25,"current-effective-user-id");
lf[333]=C_h_intern(&lf[333],27,"current-effective-user-name");
lf[334]=C_h_intern(&lf[334],16,"current-group-id");
lf[335]=C_h_intern(&lf[335],15,"current-user-id");
lf[336]=C_h_intern(&lf[336],18,"map-file-to-memory");
lf[337]=C_h_intern(&lf[337],9,"file-link");
lf[338]=C_h_intern(&lf[338],9,"file-lock");
lf[339]=C_h_intern(&lf[339],18,"file-lock/blocking");
lf[340]=C_h_intern(&lf[340],11,"file-select");
lf[341]=C_h_intern(&lf[341],14,"file-test-lock");
lf[342]=C_h_intern(&lf[342],13,"file-truncate");
lf[343]=C_h_intern(&lf[343],11,"file-unlock");
lf[344]=C_h_intern(&lf[344],10,"get-groups");
lf[345]=C_h_intern(&lf[345],17,"group-information");
lf[346]=C_h_intern(&lf[346],17,"initialize-groups");
lf[347]=C_h_intern(&lf[347],26,"memory-mapped-file-pointer");
lf[348]=C_h_intern(&lf[348],17,"parent-process-id");
lf[349]=C_h_intern(&lf[349],12,"process-fork");
lf[350]=C_h_intern(&lf[350],16,"process-group-id");
lf[351]=C_h_intern(&lf[351],14,"process-signal");
lf[352]=C_h_intern(&lf[352],18,"read-symbolic-link");
lf[353]=C_h_intern(&lf[353],10,"set-alarm!");
lf[354]=C_h_intern(&lf[354],13,"set-group-id!");
lf[355]=C_h_intern(&lf[355],11,"set-groups!");
lf[356]=C_h_intern(&lf[356],21,"set-process-group-id!");
lf[357]=C_h_intern(&lf[357],19,"set-root-directory!");
lf[358]=C_h_intern(&lf[358],16,"set-signal-mask!");
lf[359]=C_h_intern(&lf[359],12,"set-user-id!");
lf[360]=C_h_intern(&lf[360],11,"signal-mask");
lf[361]=C_h_intern(&lf[361],12,"signal-mask!");
lf[362]=C_h_intern(&lf[362],14,"signal-masked\077");
lf[363]=C_h_intern(&lf[363],14,"signal-unmask!");
lf[364]=C_h_intern(&lf[364],13,"terminal-name");
lf[365]=C_h_intern(&lf[365],22,"unmap-file-from-memory");
lf[366]=C_h_intern(&lf[366],16,"user-information");
lf[367]=C_h_intern(&lf[367],17,"utc-time->seconds");
lf[368]=C_h_intern(&lf[368],12,"string->time");
lf[369]=C_h_intern(&lf[369],16,"errno/wouldblock");
lf[370]=C_h_intern(&lf[370],19,"memory-mapped-file\077");
lf[371]=C_h_intern(&lf[371],13,"map/anonymous");
lf[372]=C_h_intern(&lf[372],8,"map/file");
lf[373]=C_h_intern(&lf[373],9,"map/fixed");
lf[374]=C_h_intern(&lf[374],11,"map/private");
lf[375]=C_h_intern(&lf[375],10,"map/shared");
lf[376]=C_h_intern(&lf[376],10,"open/fsync");
lf[377]=C_h_intern(&lf[377],11,"open/noctty");
lf[378]=C_h_intern(&lf[378],13,"open/nonblock");
lf[379]=C_h_intern(&lf[379],9,"open/sync");
lf[380]=C_h_intern(&lf[380],10,"perm/isgid");
lf[381]=C_h_intern(&lf[381],10,"perm/isuid");
lf[382]=C_h_intern(&lf[382],10,"perm/isvtx");
lf[383]=C_h_intern(&lf[383],9,"prot/exec");
lf[384]=C_h_intern(&lf[384],9,"prot/none");
lf[385]=C_h_intern(&lf[385],9,"prot/read");
lf[386]=C_h_intern(&lf[386],10,"prot/write");
lf[387]=C_h_intern(&lf[387],11,"make-vector");
lf[388]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[389]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[390]=C_h_intern(&lf[390],18,"getter-with-setter");
lf[391]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[392]=C_h_intern(&lf[392],26,"set-file-modification-time");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,395,create_ptable());
t2=C_mutate(&lf[0] /* (set! c1224 ...) */,lf[1]);
t3=C_mutate(&lf[2] /* (set! c100 ...) */,lf[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1663,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t4);}

/* k1661 */
static void C_ccall f_1663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1663,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1666,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1664 in k1661 */
static void C_ccall f_1666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1666,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1669,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1667 in k1664 in k1661 */
static void C_ccall f_1669(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1669,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1672,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1672,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1675,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1675,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1678,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1678,2,t0,t1);}
t2=*((C_word*)lf[4]+1);
t3=C_mutate(&lf[5] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1690,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[10]+1 /* (set! ##sys#posix-error ...) */,lf[5]);
t5=C_mutate(&lf[11] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1708,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[19]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1752,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1785,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5519,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5525,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:128: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[390]+1)))(5,*((C_word*)lf[390]+1),t7,t8,t9,lf[394]);}

/* a5524 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5525(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5525,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[392]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5545,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5558,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:134: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t6,t2);}

/* k5556 in a5524 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5558,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5535,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t4=C_i_foreign_string_argumentp(t1);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,t4);}
else{
t4=((C_word*)t0)[2];
f_5545(t4,stub111(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t2));}}

/* k5533 in k5556 in a5524 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_5545(t2,stub111(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[2]));}

/* k5543 in a5524 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_5545(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:136: posix-error */
t2=lf[5];
f_1690(7,t2,((C_word*)t0)[4],lf[12],lf[392],lf[393],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* a5518 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5519(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5519,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5523,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:130: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[23]);}

/* k5521 in a5518 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5523,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word ab[105],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1785,2,t0,t1);}
t2=C_mutate((C_word*)lf[23]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate((C_word*)lf[24]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1787,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[25]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1793,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[26]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1799,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[27]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1805,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[28]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1811,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[29]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1817,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[37]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1916,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[38]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1926,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[39]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1936,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[40]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1946,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[41]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1956,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[42]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1966,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[43]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1976,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t16=*((C_word*)lf[44]+1);
t17=C_mutate((C_word*)lf[45]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1986,a[2]=t16,a[3]=((C_word)li19),tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[49]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2032,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t19=*((C_word*)lf[44]+1);
t20=C_mutate((C_word*)lf[31]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2054,a[2]=t19,a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp));
t21=C_mutate((C_word*)lf[53]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2211,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate(&lf[61] /* (set! ##sys#find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2323,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[70]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2496,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[79]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t25=C_mutate((C_word*)lf[80]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t26=C_mutate((C_word*)lf[81]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t27=C_mutate((C_word*)lf[82]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t28=C_mutate((C_word*)lf[83]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t29=C_mutate((C_word*)lf[84]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t30=C_mutate((C_word*)lf[85]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t31=C_mutate((C_word*)lf[86]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t32=C_mutate((C_word*)lf[87]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t33=C_mutate((C_word*)lf[88]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t34=C_mutate((C_word*)lf[89]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t35=C_mutate((C_word*)lf[90]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t36=C_mutate((C_word*)lf[91]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t37=C_mutate((C_word*)lf[92]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t38=C_mutate((C_word*)lf[93]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t39=C_mutate((C_word*)lf[94]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t40=C_mutate((C_word*)lf[95]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t41=C_mutate((C_word*)lf[96]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t42=C_mutate((C_word*)lf[97]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t43=C_mutate((C_word*)lf[98]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t44=C_mutate((C_word*)lf[99]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t45=C_mutate((C_word*)lf[100]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t46=C_mutate((C_word*)lf[101]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t47=C_mutate((C_word*)lf[102]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t48=C_mutate((C_word*)lf[103]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t49=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t50=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t49);
t51=C_mutate((C_word*)lf[104]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2705,a[2]=t50,a[3]=((C_word)li57),tmp=(C_word)a,a+=4,tmp));
t52=C_mutate((C_word*)lf[106]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2746,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t53=*((C_word*)lf[44]+1);
t54=C_mutate((C_word*)lf[108]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2764,a[2]=t53,a[3]=((C_word)li59),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[111]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2809,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp));
t56=*((C_word*)lf[114]+1);
t57=C_mutate((C_word*)lf[115]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2851,a[2]=t56,a[3]=((C_word)li61),tmp=(C_word)a,a+=4,tmp));
t58=C_mutate((C_word*)lf[117]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t59=C_mutate((C_word*)lf[118]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t60=C_mutate((C_word*)lf[119]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t61=C_mutate((C_word*)lf[38]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2889,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t62=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6145,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp);
t63=C_mutate((C_word*)lf[40]+1 /* (set! character-device? ...) */,t62);
t64=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6139,a[2]=((C_word)li64),tmp=(C_word)a,a+=3,tmp);
t65=C_mutate((C_word*)lf[39]+1 /* (set! block-device? ...) */,t64);
t66=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6133,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp);
t67=C_mutate((C_word*)lf[41]+1 /* (set! fifo? ...) */,t66);
t68=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6127,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp);
t69=C_mutate((C_word*)lf[42]+1 /* (set! socket? ...) */,t68);
t70=C_mutate((C_word*)lf[120]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2918,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t71=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2978,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t72=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5478,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1069: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[390]+1)))(5,*((C_word*)lf[390]+1),t71,t72,*((C_word*)lf[120]+1),lf[391]);}

/* a5477 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5478(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5478,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5482,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5494,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1071: port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[124]+1)))(3,*((C_word*)lf[124]+1),t4,t2);}

/* k5492 in a5477 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[3],C_fix(7));
t3=C_eqp(t2,lf[122]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_5482(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_5482(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t2=C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[2];
f_5482(2,t3,t2);}
else{
/* posixwin.scm:1078: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[2],lf[17],lf[127],lf[389],((C_word*)t0)[3]);}}}

/* k5480 in a5477 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5482,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5485,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posixwin.scm:1080: posix-error */
t3=lf[5];
f_1690(6,t3,t2,lf[12],lf[127],lf[388],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5483 in k5480 in a5477 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word ab[68],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2978,2,t0,t1);}
t2=C_mutate((C_word*)lf[127]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[128]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2980,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[46]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3137,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3180,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp);
t6=C_mutate((C_word*)lf[140]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3198,a[2]=t5,a[3]=((C_word)li73),tmp=(C_word)a,a+=4,tmp));
t7=C_mutate((C_word*)lf[144]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3234,a[2]=t5,a[3]=((C_word)li74),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[145]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3270,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[148]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[145]+1));
t10=*((C_word*)lf[140]+1);
t11=*((C_word*)lf[144]+1);
t12=*((C_word*)lf[145]+1);
t13=*((C_word*)lf[148]+1);
t14=C_mutate((C_word*)lf[149]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3289,a[2]=t10,a[3]=t12,a[4]=((C_word)li78),tmp=(C_word)a,a+=5,tmp));
t15=C_mutate((C_word*)lf[150]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3313,a[2]=t11,a[3]=t13,a[4]=((C_word)li81),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate((C_word*)lf[151]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3337,a[2]=t10,a[3]=t12,a[4]=((C_word)li83),tmp=(C_word)a,a+=5,tmp));
t17=C_mutate((C_word*)lf[153]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3357,a[2]=t11,a[3]=t13,a[4]=((C_word)li85),tmp=(C_word)a,a+=5,tmp));
t18=C_mutate((C_word*)lf[155]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3377,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[157]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t20=C_mutate((C_word*)lf[158]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t21=C_mutate((C_word*)lf[159]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t22=C_mutate((C_word*)lf[160]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t23=C_mutate((C_word*)lf[161]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t24=C_mutate((C_word*)lf[162]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t25=C_mutate((C_word*)lf[163]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t26=C_set_block_item(lf[164] /* signal/alrm */,0,C_fix(0));
t27=C_set_block_item(lf[165] /* signal/chld */,0,C_fix(0));
t28=C_set_block_item(lf[166] /* signal/cont */,0,C_fix(0));
t29=C_set_block_item(lf[167] /* signal/hup */,0,C_fix(0));
t30=C_set_block_item(lf[168] /* signal/io */,0,C_fix(0));
t31=C_set_block_item(lf[169] /* signal/kill */,0,C_fix(0));
t32=C_set_block_item(lf[170] /* signal/pipe */,0,C_fix(0));
t33=C_set_block_item(lf[171] /* signal/prof */,0,C_fix(0));
t34=C_set_block_item(lf[172] /* signal/quit */,0,C_fix(0));
t35=C_set_block_item(lf[173] /* signal/stop */,0,C_fix(0));
t36=C_set_block_item(lf[174] /* signal/trap */,0,C_fix(0));
t37=C_set_block_item(lf[175] /* signal/tstp */,0,C_fix(0));
t38=C_set_block_item(lf[176] /* signal/urg */,0,C_fix(0));
t39=C_set_block_item(lf[177] /* signal/usr1 */,0,C_fix(0));
t40=C_set_block_item(lf[178] /* signal/usr2 */,0,C_fix(0));
t41=C_set_block_item(lf[179] /* signal/vtalrm */,0,C_fix(0));
t42=C_set_block_item(lf[180] /* signal/winch */,0,C_fix(0));
t43=C_set_block_item(lf[181] /* signal/xcpu */,0,C_fix(0));
t44=C_set_block_item(lf[182] /* signal/xfsz */,0,C_fix(0));
t45=C_a_i_list(&a,7,*((C_word*)lf[157]+1),*((C_word*)lf[158]+1),*((C_word*)lf[159]+1),*((C_word*)lf[160]+1),*((C_word*)lf[161]+1),*((C_word*)lf[162]+1),*((C_word*)lf[163]+1));
t46=C_mutate((C_word*)lf[183]+1 /* (set! signals-list ...) */,t45);
t47=*((C_word*)lf[184]+1);
t48=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3451,a[2]=((C_word*)t0)[2],a[3]=t47,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1272: make-vector */
((C_proc4)C_retrieve_proc(*((C_word*)lf[387]+1)))(4,*((C_word*)lf[387]+1),t48,C_fix(256),C_SCHEME_FALSE);}

/* k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word ab[307],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3451,2,t0,t1);}
t2=C_mutate((C_word*)lf[185]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3453,a[2]=t1,a[3]=((C_word)li87),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[186]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3462,a[2]=t1,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[184]+1 /* (set! ##sys#interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3475,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li89),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[187]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[188]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[189]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[190]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[191]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[192]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[193]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[194]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[195]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[196]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[197]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[198]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[199]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[200]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[201]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[202]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[203]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[204]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[205]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[206]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[207]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[208]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[209]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[210]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[211]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[212]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[213]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[214]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[215]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[216]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[217]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[218]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[219]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[220]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[221]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[222]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[223]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[224]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[225]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3531,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3561,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp);
t45=C_mutate((C_word*)lf[227]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3585,a[2]=t44,a[3]=((C_word)li92),tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[228]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3591,a[2]=t44,a[3]=((C_word)li93),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[229]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3597,a[2]=t44,a[3]=((C_word)li94),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[230]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[231]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[232]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t51=C_SCHEME_UNDEFINED;
t52=(*a=C_VECTOR_TYPE|1,a[1]=t51,tmp=(C_word)a,a+=2,tmp);
t53=C_SCHEME_UNDEFINED;
t54=(*a=C_VECTOR_TYPE|1,a[1]=t53,tmp=(C_word)a,a+=2,tmp);
t55=C_set_block_item(t52,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3606,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t56=C_set_block_item(t54,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3643,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[241]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3661,a[2]=t52,a[3]=t54,a[4]=((C_word)li97),tmp=(C_word)a,a+=5,tmp));
t58=C_mutate((C_word*)lf[242]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3675,a[2]=t52,a[3]=t54,a[4]=((C_word)li98),tmp=(C_word)a,a+=5,tmp));
t59=C_mutate((C_word*)lf[243]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3689,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[247]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3724,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[249]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3754,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[250]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3771,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t63=*((C_word*)lf[251]+1);
t64=C_mutate((C_word*)lf[252]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3791,a[2]=t63,a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp));
t65=C_mutate(&lf[253] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3856,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[255]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3875,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[258]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3909,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[259]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3953,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[261]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4011,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[264]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4078,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[268]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4093,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[269]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4105,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[270]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4121,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[271]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4140,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[273]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4155,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[279]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t77=C_mutate((C_word*)lf[280]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t78=C_mutate((C_word*)lf[281]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t79=C_mutate((C_word*)lf[282]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t80=C_mutate((C_word*)lf[283]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t81=*((C_word*)lf[284]+1);
t82=*((C_word*)lf[114]+1);
t83=*((C_word*)lf[285]+1);
t84=*((C_word*)lf[4]+1);
t85=C_mutate(&lf[286] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4219,a[2]=t84,a[3]=t82,a[4]=t83,a[5]=t81,a[6]=((C_word)li120),tmp=(C_word)a,a+=7,tmp));
t86=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4298,a[2]=((C_word)li121),tmp=(C_word)a,a+=3,tmp);
t87=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4315,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp);
t88=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4332,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp);
t89=C_mutate(&lf[290] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4382,a[2]=t86,a[3]=t87,a[4]=t88,a[5]=((C_word)li125),tmp=(C_word)a,a+=6,tmp));
t90=C_mutate(&lf[292] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4418,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[293]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4433,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t92=C_mutate((C_word*)lf[295]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4520,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[297]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4607,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[298]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4610,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[302]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4631,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[304]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4637,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[305]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4729,a[2]=((C_word)li141),tmp=(C_word)a,a+=3,tmp));
t98=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4848,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp);
t99=C_mutate((C_word*)lf[313]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4910,a[2]=t98,a[3]=((C_word)li151),tmp=(C_word)a,a+=4,tmp));
t100=C_mutate((C_word*)lf[314]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4990,a[2]=t98,a[3]=((C_word)li156),tmp=(C_word)a,a+=4,tmp));
t101=C_mutate((C_word*)lf[315]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5070,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[316]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5082,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[318]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5142,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[319]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5145,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[321]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5157,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[324]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5188,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[326]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5203,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[328]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5209,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[329]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5215,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[330]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5221,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[331]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5227,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[332]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5233,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t113=C_mutate((C_word*)lf[333]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5239,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t114=C_mutate((C_word*)lf[334]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5245,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t115=C_mutate((C_word*)lf[335]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5251,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t116=C_mutate((C_word*)lf[336]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5257,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t117=C_mutate((C_word*)lf[337]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5263,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t118=C_mutate((C_word*)lf[338]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5269,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[339]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5275,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[340]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5281,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[341]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5287,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[342]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5293,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[343]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5299,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[344]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5305,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[345]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5311,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[346]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5317,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[347]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5323,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[348]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5329,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[349]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5335,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[350]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5341,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[351]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5347,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[352]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5353,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[353]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5359,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[354]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5365,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[355]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5371,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[356]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5377,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[357]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5383,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[358]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5389,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[359]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5395,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[360]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5401,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[361]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5407,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[362]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5413,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[363]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5419,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[364]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5425,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[365]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5431,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[366]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5437,a[2]=((C_word)li204),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[367]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5443,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[368]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5449,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp));
t149=C_set_block_item(lf[369] /* errno/wouldblock */,0,C_fix(0));
t150=C_mutate((C_word*)lf[41]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5456,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[370]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5459,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp));
t152=C_set_block_item(lf[371] /* map/anonymous */,0,C_fix(0));
t153=C_set_block_item(lf[372] /* map/file */,0,C_fix(0));
t154=C_set_block_item(lf[373] /* map/fixed */,0,C_fix(0));
t155=C_set_block_item(lf[374] /* map/private */,0,C_fix(0));
t156=C_set_block_item(lf[375] /* map/shared */,0,C_fix(0));
t157=C_set_block_item(lf[376] /* open/fsync */,0,C_fix(0));
t158=C_set_block_item(lf[377] /* open/noctty */,0,C_fix(0));
t159=C_set_block_item(lf[378] /* open/nonblock */,0,C_fix(0));
t160=C_set_block_item(lf[379] /* open/sync */,0,C_fix(0));
t161=C_set_block_item(lf[380] /* perm/isgid */,0,C_fix(0));
t162=C_set_block_item(lf[381] /* perm/isuid */,0,C_fix(0));
t163=C_set_block_item(lf[382] /* perm/isvtx */,0,C_fix(0));
t164=C_set_block_item(lf[383] /* prot/exec */,0,C_fix(0));
t165=C_set_block_item(lf[384] /* prot/none */,0,C_fix(0));
t166=C_set_block_item(lf[385] /* prot/read */,0,C_fix(0));
t167=C_set_block_item(lf[386] /* prot/write */,0,C_fix(0));
t168=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t168+1)))(2,t168,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5459(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5459,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5456(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5456,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5449(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5449,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[368],lf[0]);}

/* utc-time->seconds in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5443(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5443,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[367],lf[0]);}

/* user-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5437(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5437,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[366],lf[0]);}

/* unmap-file-from-memory in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5431(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5431,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[365],lf[0]);}

/* terminal-name in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5425(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5425,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[364],lf[0]);}

/* signal-unmask! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5419(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5419,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[363],lf[0]);}

/* signal-masked? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5413(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5413,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[362],lf[0]);}

/* signal-mask! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5407(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5407,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[361],lf[0]);}

/* signal-mask in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5401(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5401,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[360],lf[0]);}

/* set-user-id! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5395(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5395,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[359],lf[0]);}

/* set-signal-mask! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5389(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5389,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[358],lf[0]);}

/* set-root-directory! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5383(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5383,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[357],lf[0]);}

/* set-process-group-id! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5377(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5377,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[356],lf[0]);}

/* set-groups! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5371(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5371,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[355],lf[0]);}

/* set-group-id! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5365(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5365,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[354],lf[0]);}

/* set-alarm! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5359(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5359,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[353],lf[0]);}

/* read-symbolic-link in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5353(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5353,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[352],lf[0]);}

/* process-signal in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5347(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5347,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[351],lf[0]);}

/* process-group-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5341(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5341,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[350],lf[0]);}

/* process-fork in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5335(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5335,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[349],lf[0]);}

/* parent-process-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5329(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5329,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[348],lf[0]);}

/* memory-mapped-file-pointer in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5323(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5323,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[347],lf[0]);}

/* initialize-groups in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5317,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[346],lf[0]);}

/* group-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5311(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5311,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[345],lf[0]);}

/* get-groups in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5305(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5305,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[344],lf[0]);}

/* file-unlock in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5299(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5299,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[343],lf[0]);}

/* file-truncate in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5293(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5293,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[342],lf[0]);}

/* file-test-lock in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5287(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5287,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[341],lf[0]);}

/* file-select in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5281(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5281,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[340],lf[0]);}

/* file-lock/blocking in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5275(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5275,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[339],lf[0]);}

/* file-lock in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5269(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5269,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[338],lf[0]);}

/* file-link in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5263(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5263,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[337],lf[0]);}

/* map-file-to-memory in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5257,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[336],lf[0]);}

/* current-user-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5251(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5251,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[335],lf[0]);}

/* current-group-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5245,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[334],lf[0]);}

/* current-effective-user-name in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5239(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5239,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[333],lf[0]);}

/* current-effective-user-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5233(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5233,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[332],lf[0]);}

/* current-effective-group-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5227(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5227,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[331],lf[0]);}

/* create-symbolic-link in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5221(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5221,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[330],lf[0]);}

/* create-session in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5215(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5215,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[329],lf[0]);}

/* create-fifo in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5209(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5209,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[328],lf[0]);}

/* change-file-owner in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5203(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5203,2,t0,t1);}
/* error */
((C_proc4)C_retrieve_proc(*((C_word*)lf[327]+1)))(4,*((C_word*)lf[327]+1),t1,lf[326],lf[0]);}

/* current-user-name in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5188,2,t0,t1);}
if(C_truep(C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5198,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1808: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t2);}}

/* k5196 in current-user-name in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1809: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[324],lf[325]);}

/* system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5157,2,t0,t1);}
if(C_truep(C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5168,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5183,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1799: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t2);}}

/* k5181 in system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1800: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[321],lf[323]);}

/* k5166 in system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5168,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5172,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k5170 in k5166 in system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5172,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5176,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k5174 in k5170 in k5166 in system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5176,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5180,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k5178 in k5174 in k5170 in k5166 in system-information in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5180,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,5,lf[322],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5145,2,t0,t1);}
if(C_truep(C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm:1789: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[319],lf[320]);}}

/* sleep in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5142(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5142,3,t0,t1,t2);}
t3=C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5082(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3r,(void*)f_5082r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5082r(t0,t1,t2,t3);}}

static void C_ccall f_5082r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(9);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
if(C_truep(C_i_nullp(t7))){
t8=C_i_check_exact_2(t2,lf[316]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5103,a[2]=t5,a[3]=t2,a[4]=((C_word)li158),tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5109,a[2]=t2,a[3]=((C_word)li159),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}
else{
/* ##sys#error */
t8=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t1,lf[2],t7);}}

/* a5108 in process-wait in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5109,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5119,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1771: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t6);}
else{
/* posixwin.scm:1773: values */
C_values(5,0,t1,t2,t3,t4);}}

/* k5117 in a5108 in process-wait in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1772: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[306],lf[316],lf[317],((C_word*)t0)[2]);}

/* a5102 in process-wait in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5103(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5103,2,t0,t1);}
/* posixwin.scm:1768: ##sys#process-wait */
t2=*((C_word*)lf[315]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_5070(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5070,4,t0,t1,t2,t3);}
if(C_truep(C_process_wait(t2,t3))){
/* posixwin.scm:1761: values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm:1762: values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4990(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4990r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4990r(t0,t1,t2,t3);}}

static void C_ccall f_4990r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4992,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li152),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4997,a[2]=t4,a[3]=((C_word)li153),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5002,a[2]=t5,a[3]=((C_word)li154),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5007,a[2]=t6,a[3]=((C_word)li155),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args11481163 */
t8=t7;
f_5007(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-env11491161 */
t10=t6;
f_5002(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf11501158 */
t12=t5;
f_4997(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body11461154 */
t14=t4;
f_4992(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1148 in process* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_5007(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5007,NULL,2,t0,t1);}
/* def-env11491161 */
t2=((C_word*)t0)[2];
f_5002(t2,t1,C_SCHEME_FALSE);}

/* def-env1149 in process* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_5002(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5002,NULL,3,t0,t1,t2);}
/* def-exactf11501158 */
t3=((C_word*)t0)[2];
f_4997(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1150 in process* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4997(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4997,NULL,4,t0,t1,t2,t3);}
/* body11461154 */
t4=((C_word*)t0)[2];
f_4992(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1146 in process* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4992(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4992,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm:1755: %process */
f_4848(t1,lf[314],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4910(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4910r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4910r(t0,t1,t2,t3);}}

static void C_ccall f_4910r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4912,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li147),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4917,a[2]=t4,a[3]=((C_word)li148),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4922,a[2]=t5,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4927,a[2]=t6,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args11131128 */
t8=t7;
f_4927(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-env11141126 */
t10=t6;
f_4922(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf11151123 */
t12=t5;
f_4917(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body11111119 */
t14=t4;
f_4912(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1113 in process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4927(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4927,NULL,2,t0,t1);}
/* def-env11141126 */
t2=((C_word*)t0)[2];
f_4922(t2,t1,C_SCHEME_FALSE);}

/* def-env1114 in process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4922(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4922,NULL,3,t0,t1,t2);}
/* def-exactf11151123 */
t3=((C_word*)t0)[2];
f_4917(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1115 in process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4917(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4917,NULL,4,t0,t1,t2,t3);}
/* body11111119 */
t4=((C_word*)t0)[2];
f_4912(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1111 in process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4912(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4912,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm:1752: %process */
f_4848(t1,lf[313],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4848(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4848,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4850,a[2]=t2,a[3]=((C_word)li143),tmp=(C_word)a,a+=4,tmp);
t12=C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4869,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm:1740: chkstrlst */
t14=t11;
f_4850(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4904,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1743: ##sys#shell-command-arguments */
t16=*((C_word*)lf[302]+1);
((C_proc3)(void*)(*((C_word*)t16+1)))(3,t16,t15,((C_word*)t8)[1]);}}

/* k4902 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4904(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4904,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4908,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1744: ##sys#shell-command */
t4=*((C_word*)lf[298]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4906 in k4902 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_4869(2,t3,t2);}

/* k4867 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4869,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4872,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm:1745: chkstrlst */
t3=((C_word*)t0)[2];
f_4850(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_4872(2,t3,C_SCHEME_UNDEFINED);}}

/* k4870 in k4867 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4872(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4872,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4877,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li144),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4883,a[2]=((C_word*)t0)[4],a[3]=((C_word)li145),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4882 in k4870 in k4867 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4883(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4883,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm:1748: values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm:1749: values */
C_values(5,0,t1,t2,t3,t4);}}

/* a4876 in k4870 in k4867 in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4877,2,t0,t1);}
/* posixwin.scm:1746: ##sys#process */
t2=*((C_word*)lf[305]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4850(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4850,NULL,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4859,a[2]=((C_word*)t0)[2],a[3]=((C_word)li142),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[312]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a4858 in chkstrlst in %process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4859(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4859,3,t0,t1,t2);}
t3=*((C_word*)lf[311]+1);
/* g10881089 */
t4=t3;
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,((C_word*)t0)[2]);}

/* ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4729(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr9r,(void*)f_4729r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_4729r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_4729r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4733,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=t7,a[6]=t8,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_i_nullp(t9))){
t11=t10;
f_4733(2,t11,C_SCHEME_FALSE);}
else{
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
t12=t10;
f_4733(2,t12,C_i_car(t9));}
else{
/* ##sys#error */
t12=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,lf[2],t9);}}}

/* k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4733,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4736,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4824,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,((C_word*)t0)[8],((C_word*)t0)[2]);
/* posixwin.scm:1712: $quote-args-list */
t5=lf[286];
f_4219(t5,t3,t4,t1);}

/* k4822 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1712: string-intersperse */
((C_proc3)C_retrieve_proc(*((C_word*)lf[310]+1)))(3,*((C_word*)lf[310]+1),((C_word*)t0)[2],t1);}

/* k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4736,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_i_foreign_fixnum_argumentp(C_fix(-1));
t4=((*(int *)C_data_pointer(t2))=C_unfix(t3),C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(1));
t6=C_i_foreign_fixnum_argumentp(C_fix(-1));
t7=((*(int *)C_data_pointer(t5))=C_unfix(t6),C_SCHEME_UNDEFINED);
t8=C_a_i_bytevector(&a,1,C_fix(1));
t9=C_i_foreign_fixnum_argumentp(C_fix(-1));
t10=((*(int *)C_data_pointer(t8))=C_unfix(t9),C_SCHEME_UNDEFINED);
t11=C_a_i_bytevector(&a,1,C_fix(1));
t12=C_i_foreign_fixnum_argumentp(C_fix(-1));
t13=((*(int *)C_data_pointer(t11))=C_unfix(t12),C_SCHEME_UNDEFINED);
t14=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4792,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=((C_word*)t0)[3],a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=t11,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[308]+1)))(6,*((C_word*)lf[308]+1),t14,t2,C_fix(0),C_SCHEME_FALSE,lf[309]);}

/* k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4792,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4796,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[308]+1)))(6,*((C_word*)lf[308]+1),t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[309]);}

/* k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4796,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4800,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[308]+1)))(6,*((C_word*)lf[308]+1),t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[309]);}

/* k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4800(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4800,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_4804,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[308]+1)))(6,*((C_word*)lf[308]+1),t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[309]);}

/* k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4804(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4804,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_4808,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
if(C_truep(((C_word*)t0)[8])){
/* posixwin.scm:1719: + */
C_plus(5,0,t2,t3,t4,C_fix(0));}
else{
/* posixwin.scm:1719: + */
C_plus(5,0,t2,t3,t4,C_fix(4));}}

/* k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4808,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4671,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
t9=C_i_foreign_string_argumentp(t2);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t8,t9);}
else{
t9=t8;
f_4671(2,t9,C_SCHEME_FALSE);}}

/* k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4671,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4675,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t1,a[13]=((C_word*)t0)[13],a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t2,t3);}
else{
t3=t2;
f_4675(2,t3,C_SCHEME_FALSE);}}

/* k4673 in k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4675,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[13]);
if(C_truep(stub985(C_SCHEME_UNDEFINED,((C_word*)t0)[12],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6))){
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4765,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1722: open-input-file* */
t8=*((C_word*)lf[241]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t8=t7;
f_4765(2,t8,C_SCHEME_FALSE);}}
else{
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4785,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1727: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t7);}}

/* k4783 in k4673 in k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1728: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[306],((C_word*)t0)[3],lf[307],((C_word*)t0)[2]);}

/* k4763 in k4673 in k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4765,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4769,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm:1723: open-output-file* */
t3=*((C_word*)lf[242]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4769(2,t3,C_SCHEME_FALSE);}}

/* k4767 in k4763 in k4673 in k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4769,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4773,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm:1725: open-input-file* */
t3=*((C_word*)lf[241]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixwin.scm:1721: values */
C_values(6,0,((C_word*)t0)[6],((C_word*)t0)[5],t1,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))),C_SCHEME_FALSE);}}

/* k4771 in k4767 in k4763 in k4673 in k4669 in k4806 in k4802 in k4798 in k4794 in k4790 in k4734 in k4731 in ##sys#process in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1721: values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* process-run in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4637(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4637r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4637r(t0,t1,t2,t3);}}

static void C_ccall f_4637r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_i_car(t3):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm:1683: process-spawn */
t6=*((C_word*)lf[295]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,*((C_word*)lf[281]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4654,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1684: ##sys#shell-command */
t7=*((C_word*)lf[298]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k4652 in process-run in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4654(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4654,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4658,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1684: ##sys#shell-command-arguments */
t3=*((C_word*)lf[302]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4656 in k4652 in process-run in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1684: process-spawn */
t2=*((C_word*)lf[295]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],*((C_word*)lf[281]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4631(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4631,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list(&a,2,lf[303],t2));}

/* ##sys#shell-command in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4610,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4614,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1669: get-environment-variable */
((C_proc3)C_retrieve_proc(*((C_word*)lf[300]+1)))(3,*((C_word*)lf[300]+1),t2,lf[301]);}

/* k4612 in ##sys#shell-command in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4614,2,t0,t1);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
if(C_truep(C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4626,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1673: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t2);}}}

/* k4624 in k4612 in ##sys#shell-command in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1674: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[298],lf[299]);}

/* current-process-id in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4607,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub966(C_SCHEME_UNDEFINED));}

/* process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4520(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4520r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4520r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4520r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4522,a[2]=t3,a[3]=t2,a[4]=((C_word)li132),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4534,a[2]=t5,a[3]=((C_word)li133),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4539,a[2]=t6,a[3]=((C_word)li134),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4544,a[2]=t7,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t4))){
/* def-arglst943959 */
t9=t8;
f_4544(t9,t1);}
else{
t9=C_i_car(t4);
t10=C_i_cdr(t4);
if(C_truep(C_i_nullp(t10))){
/* def-envlst944957 */
t11=t7;
f_4539(t11,t1,t9);}
else{
t11=C_i_car(t10);
t12=C_i_cdr(t10);
if(C_truep(C_i_nullp(t12))){
/* def-exactf945954 */
t13=t6;
f_4534(t13,t1,t9,t11);}
else{
t13=C_i_car(t12);
t14=C_i_cdr(t12);
if(C_truep(C_i_nullp(t14))){
/* body941949 */
t15=t5;
f_4522(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-arglst943 in process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4544(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4544,NULL,2,t0,t1);}
/* def-envlst944957 */
t2=((C_word*)t0)[2];
f_4539(t2,t1,C_SCHEME_FALSE);}

/* def-envlst944 in process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4539(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4539,NULL,3,t0,t1,t2);}
/* def-exactf945954 */
t3=((C_word*)t0)[2];
f_4534(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf945 in process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4534(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4534,NULL,4,t0,t1,t2,t3);}
/* body941949 */
t4=((C_word*)t0)[2];
f_4522(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body941 in process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4522(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4522,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4526,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1660: $exec-setup */
t6=lf[290];
f_4382(t6,t5,lf[295],((C_word*)t0)[2],t2,t3,t4);}

/* k4524 in body941 in process-spawn in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=C_spawnvpe(((C_word*)t0)[4],t1);
/* posixwin.scm:1661: $exec-teardown */
f_4418(((C_word*)t0)[3],lf[295],lf[296],((C_word*)t0)[2],t2);}
else{
t2=C_spawnvp(((C_word*)t0)[4],t1);
/* posixwin.scm:1661: $exec-teardown */
f_4418(((C_word*)t0)[3],lf[295],lf[296],((C_word*)t0)[2],t2);}}

/* process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4433(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr3r,(void*)f_4433r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4433r(t0,t1,t2,t3);}}

static void C_ccall f_4433r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4435,a[2]=t2,a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4447,a[2]=t4,a[3]=((C_word)li128),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4452,a[2]=t5,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4457,a[2]=t6,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-arglst906922 */
t8=t7;
f_4457(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-envlst907920 */
t10=t6;
f_4452(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf908917 */
t12=t5;
f_4447(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body904912 */
t14=t4;
f_4435(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-arglst906 in process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4457(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4457,NULL,2,t0,t1);}
/* def-envlst907920 */
t2=((C_word*)t0)[2];
f_4452(t2,t1,C_SCHEME_FALSE);}

/* def-envlst907 in process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4452(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4452,NULL,3,t0,t1,t2);}
/* def-exactf908917 */
t3=((C_word*)t0)[2];
f_4447(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf908 in process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4447(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4447,NULL,4,t0,t1,t2,t3);}
/* body904912 */
t4=((C_word*)t0)[2];
f_4435(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body904 in process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4435(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4435,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4439,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1655: $exec-setup */
t6=lf[290];
f_4382(t6,t5,lf[293],((C_word*)t0)[2],t2,t3,t4);}

/* k4437 in body904 in process-execute in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=C_execve(t1);
/* posixwin.scm:1656: $exec-teardown */
f_4418(((C_word*)t0)[3],lf[293],lf[294],((C_word*)t0)[2],t2);}
else{
t2=C_execvp(t1);
/* posixwin.scm:1656: $exec-teardown */
f_4418(((C_word*)t0)[3],lf[293],lf[294],((C_word*)t0)[2],t2);}}

/* $exec-teardown in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4418(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4418,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4422,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:1647: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t6);}

/* k4420 in $exec-teardown in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_free_exec_args();
t3=C_free_exec_env();
t4=C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm:1651: ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[6];
t6=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4382(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4382,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4389,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=t3,a[9]=t2,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1639: pathname-strip-directory */
((C_proc3)C_retrieve_proc(*((C_word*)lf[291]+1)))(3,*((C_word*)lf[291]+1),t8,t3);}

/* k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4389,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4392,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=C_block_size(t1);
/* posixwin.scm:1640: setarg */
t4=((C_word*)t0)[4];
f_4298(5,t4,t2,C_fix(0),t1,t3);}

/* k4390 in k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4392(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4392,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4395,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4409,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[9],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm:1641: $quote-args-list */
t4=lf[286];
f_4219(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm:1641: build-exec-argvec */
f_4332(t2,((C_word*)t0)[9],C_SCHEME_FALSE,((C_word*)t0)[4],C_fix(1));}}

/* k4407 in k4390 in k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1641: build-exec-argvec */
f_4332(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k4393 in k4390 in k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4395,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4398,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1642: build-exec-argvec */
f_4332(t2,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k4396 in k4393 in k4390 in k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4398,2,t0,t1);}
t2=C_flushall();
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4405,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1644: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t3,((C_word*)t0)[2]);}

/* k4403 in k4396 in k4393 in k4390 in k4387 in $exec-setup in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1644: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* build-exec-argvec in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4332(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4332,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4344,a[2]=t8,a[3]=t2,a[4]=t4,a[5]=((C_word)li123),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_4344(t10,t1,t3,t5);}
else{
/* posixwin.scm:1636: argvec-setter */
t6=t4;
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* doloop865 in build-exec-argvec in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4344(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4344,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1632: argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4363,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixwin.scm:1635: argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* k4361 in doloop865 in build-exec-argvec in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_i_cdr(((C_word*)t0)[5]);
t3=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_4344(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4315,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub854(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* setarg in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4298,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub844(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4219(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4219,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4224,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li118),tmp=(C_word)a,a+=6,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4262,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li119),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_4262(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4262(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4262,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1614: reverse */
((C_proc3)C_retrieve_proc(*((C_word*)lf[287]+1)))(3,*((C_word*)lf[287]+1),t1,t3);}
else{
t4=C_i_car(t2);
t5=C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4290,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4293,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=t4,a[7]=t6,a[8]=((C_word*)t0)[3],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm:1619: needs-quoting? */
t8=((C_word*)t0)[2];
f_4224(t8,t7,t4);}}

/* k4291 in loop in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4293,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1619: string-append */
t2=((C_word*)t0)[8];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[7],lf[288],((C_word*)t0)[6],lf[289]);}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[6],((C_word*)t0)[5]);
/* posixwin.scm:1616: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4262(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k4288 in loop in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4290,2,t0,t1);}
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm:1616: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4262(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4224(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4224,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4228,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1606: string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t2);}

/* k4226 in needs-quoting? in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4228,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4233,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,a[7]=((C_word)li117),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_4233(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k4226 in needs-quoting? in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4233(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4233,NULL,3,t0,t1,t2);}
t3=C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4246,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4257,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1610: string-ref */
t6=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k4255 in loop in k4226 in needs-quoting? in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1610: char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4244 in loop in k4226 in needs-quoting? in $quote-args-list in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm:1611: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_4233(t3,((C_word*)t0)[4],t2);}}

/* set-buffering-mode! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4155(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4155r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4155r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4155r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4159,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1563: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[147]+1)))(4,*((C_word*)lf[147]+1),t5,t2,lf[273]);}

/* k4157 in set-buffering-mode! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4159,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4165,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(t4,lf[275]);
if(C_truep(t6)){
t7=t5;
f_4165(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=C_eqp(t4,lf[276]);
if(C_truep(t7)){
t8=C_fix((C_word)_IOLBF);
t9=t5;
f_4165(2,t9,t8);}
else{
t8=C_eqp(t4,lf[277]);
if(C_truep(t8)){
t9=t5;
f_4165(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm:1569: ##sys#error */
t9=*((C_word*)lf[22]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[273],lf[278],((C_word*)t0)[4],((C_word*)t0)[2]);}}}}

/* k4163 in k4157 in set-buffering-mode! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4165,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[4],lf[273]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4174,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=C_slot(((C_word*)t0)[2],C_fix(7));
t5=C_eqp(lf[122],t4);
if(C_truep(t5)){
t6=C_setvbuf(((C_word*)t0)[2],t1,((C_word*)t0)[4]);
t7=t3;
f_4174(t7,C_fixnum_lessp(t6,C_fix(0)));}
else{
t6=t3;
f_4174(t6,C_SCHEME_TRUE);}}

/* k4172 in k4163 in k4157 in set-buffering-mode! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_4174(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1575: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[273],lf[274],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* terminal-size in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4140(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4140,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4147,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1552: terminal-port? */
t4=*((C_word*)lf[270]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k4145 in terminal-size in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1553: values */
C_values(4,0,((C_word*)t0)[3],C_fix(0),C_fix(0));}
else{
/* posixwin.scm:1554: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[271],lf[272],((C_word*)t0)[2]);}}

/* terminal-port? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4121(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4121,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4125,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1547: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[147]+1)))(4,*((C_word*)lf[147]+1),t3,t2,lf[270]);}

/* k4123 in terminal-port? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4125,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4128,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1548: ##sys#peek-unsigned-integer */
((C_proc4)C_retrieve_proc(*((C_word*)lf[246]+1)))(4,*((C_word*)lf[246]+1),t2,((C_word*)t0)[2],C_fix(0));}

/* k4126 in k4123 in terminal-port? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* _exit in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4105(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_4105r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4105r(t0,t1,t2);}}

static void C_ccall f_4105r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_i_pairp(t2))){
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub797(C_SCHEME_UNDEFINED,t5));}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub797(C_SCHEME_UNDEFINED,t4));}}

/* local-timezone-abbreviation in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4093,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,stub792(t2),C_fix(0));}

/* local-time->seconds in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4078(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4078,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4082,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1528: check-time-vector */
f_3856(t3,lf[264],t2);}

/* k4080 in local-time->seconds in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4082,2,t0,t1);}
t2=C_a_mktime(&a,1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4088,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1530: fp= */
((C_proc4)C_retrieve_proc(*((C_word*)lf[266]+1)))(4,*((C_word*)lf[266]+1),t3,t2,lf[267]);}

/* k4086 in k4080 in local-time->seconds in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1531: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[264],lf[265],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4011(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4011r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4011r(t0,t1,t2,t3);}}

static void C_ccall f_4011r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4015,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_4015(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_4015(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k4013 in time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4015,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4018,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1516: check-time-vector */
f_3856(t2,lf[261],((C_word*)t0)[2]);}

/* k4016 in k4013 in time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4018,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=C_i_check_string_2(((C_word*)t0)[4],lf[261]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4027,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4037,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1520: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t4,((C_word*)t0)[4],lf[261]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4040,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,stub761(t4,t3),C_fix(0));}}

/* k4038 in k4016 in k4013 in time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm:1524: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[47]+1)))(5,*((C_word*)lf[47]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm:1525: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[261],lf[263],((C_word*)t0)[2]);}}

/* k4035 in k4016 in k4013 in time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4037,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],stub767(t3,t2,t1),C_fix(0));}

/* k4025 in k4016 in k4013 in time->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_4027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm:1521: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[261],lf[262],((C_word*)t0)[2]);}}

/* seconds->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3953(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3953r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3953r(t0,t1,t2);}}

static void C_ccall f_3953r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3957,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1506: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[257]+1)))(2,*((C_word*)lf[257]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_3957(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3955 in seconds->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3957,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3960,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=t1;
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_integer_argumentp(t3);
t6=stub743(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* k3958 in k3955 in seconds->string in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm:1509: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[47]+1)))(5,*((C_word*)lf[47]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm:1510: ##sys#error */
t2=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[259],lf[260],((C_word*)t0)[2]);}}

/* seconds->utc-time in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3909(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3909r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3909r(t0,t1,t2);}}

static void C_ccall f_3909r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3913,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1500: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[257]+1)))(2,*((C_word*)lf[257]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[258]);
/* posixwin.scm:1502: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[256]+1)))(4,*((C_word*)lf[256]+1),t1,t5,C_SCHEME_TRUE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3911 in seconds->utc-time in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[258]);
/* posixwin.scm:1502: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[256]+1)))(4,*((C_word*)lf[256]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* seconds->local-time in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3875(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3875r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3875r(t0,t1,t2);}}

static void C_ccall f_3875r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3879,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1496: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[257]+1)))(2,*((C_word*)lf[257]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[255]);
/* posixwin.scm:1498: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[256]+1)))(4,*((C_word*)lf[256]+1),t1,t5,C_SCHEME_FALSE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3877 in seconds->local-time in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[255]);
/* posixwin.scm:1498: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[256]+1)))(4,*((C_word*)lf[256]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* check-time-vector in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3856(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3856,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm:1494: ##sys#error */
t6=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[254],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3791,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3797,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3797(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3797(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3797,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3801,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub705(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3799 in loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3801,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3809,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word)li103),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3809(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3799 in loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3809(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3809,NULL,3,t0,t1,t2);}
t3=C_eqp(C_make_character(61),C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3835,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm:1484: substring */
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm:1485: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3833 in scan in k3799 in loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3835,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3839,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=C_block_size(((C_word*)t0)[3]);
/* posixwin.scm:1484: substring */
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3837 in k3833 in scan in k3799 in loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3839,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3827,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm:1484: loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3797(t5,t3,t4);}

/* k3825 in k3837 in k3833 in scan in k3799 in loop in get-environment-variables in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3827,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3771(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3771,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[250]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3779,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1472: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t4,t2,lf[250]);}

/* k3777 in unsetenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3754(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3754,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[249]);
t5=C_i_check_string_2(t3,lf[249]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3765,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1467: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t6,t2,lf[249]);}

/* k3763 in setenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3765,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3769,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1467: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t2,((C_word*)t0)[2],lf[249]);}

/* k3767 in k3763 in setenv in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3724(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3724r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3724r(t0,t1,t2,t3);}}

static void C_ccall f_3724r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[247]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3731,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_3731(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[247]);
t8=t5;
f_3731(t8,C_dup2(t2,t6));}}

/* k3729 in duplicate-fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3731(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3731,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3734,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3740,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1456: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k3738 in k3729 in duplicate-fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1457: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[247],lf[248],((C_word*)t0)[2]);}

/* k3732 in k3729 in duplicate-fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3689,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3693,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1438: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[147]+1)))(4,*((C_word*)lf[147]+1),t3,t2,lf[243]);}

/* k3691 in port->fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3693,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3722,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1439: ##sys#peek-unsigned-integer */
((C_proc4)C_retrieve_proc(*((C_word*)lf[246]+1)))(4,*((C_word*)lf[246]+1),t2,((C_word*)t0)[2],C_fix(0));}

/* k3720 in k3691 in port->fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3722,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posixwin.scm:1445: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[17],lf[243],lf[244],((C_word*)t0)[2]);}
else{
t2=C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3702,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3708,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1442: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* k3706 in k3720 in k3691 in port->fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1443: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[243],lf[245],((C_word*)t0)[2]);}

/* k3700 in k3720 in k3691 in port->fileno in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3675(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3675r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3675r(t0,t1,t2,t3);}}

static void C_ccall f_3675r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[242]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3687,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1434: mode */
f_3606(t5,C_SCHEME_FALSE,t3,lf[242]);}

/* k3685 in open-output-file* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3687,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm:1434: check */
f_3643(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3661(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3661r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3661r(t0,t1,t2,t3);}}

static void C_ccall f_3661r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[241]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3673,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1430: mode */
f_3606(t5,C_SCHEME_TRUE,t3,lf[241]);}

/* k3671 in open-input-file* in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3673,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm:1430: check */
f_3643(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3643(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3643,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3647,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1421: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t5);}

/* k3645 in check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3647,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm:1423: ##sys#signal-hook */
((C_proc5)C_retrieve_proc(*((C_word*)lf[6]+1)))(5,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[12],lf[239],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3659,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1424: ##sys#make-port */
((C_proc6)C_retrieve_proc(*((C_word*)lf[137]+1)))(6,*((C_word*)lf[137]+1),t2,((C_word*)t0)[2],*((C_word*)lf[138]+1),lf[240],lf[122]);}}

/* k3657 in k3645 in check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3606(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3606,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3614,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=C_i_car(t3);
t7=C_eqp(t6,lf[233]);
if(C_truep(t7)){
t8=t2;
if(C_truep(t8)){
/* posixwin.scm:1415: ##sys#error */
t9=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[234],t6);}
else{
/* posixwin.scm:1411: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t1,lf[235],t4);}}
else{
/* posixwin.scm:1416: ##sys#error */
t8=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t5,lf[236],t6);}}
else{
if(C_truep(t2)){
/* posixwin.scm:1411: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t1,lf[237],t4);}
else{
/* posixwin.scm:1411: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t1,lf[238],t4);}}}

/* k3612 in mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1411: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* file-execute-access? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3597(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3597,3,t0,t1,t2);}
/* posixwin.scm:1395: check */
f_3561(t1,t2,C_fix((C_word)2),lf[229]);}

/* file-write-access? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3591(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3591,3,t0,t1,t2);}
/* posixwin.scm:1394: check */
f_3561(t1,t2,C_fix((C_word)4),lf[228]);}

/* file-read-access? in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3585(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3585,3,t0,t1,t2);}
/* posixwin.scm:1393: check */
f_3561(t1,t2,C_fix((C_word)2),lf[227]);}

/* check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3561(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3561,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3579,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3583,a[2]=t4,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1390: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t7,t2);}

/* k3581 in check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1390: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3577 in check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3579,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[3]);
t3=C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3571,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}
else{
/* posixwin.scm:1391: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}}

/* k3569 in k3577 in check in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3531(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3531,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[225]);
t5=C_i_check_exact_2(t3,lf[225]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3555,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3559,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1379: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t7,t2);}

/* k3557 in change-file-mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3559(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1379: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[2],t1,lf[225]);}

/* k3553 in change-file-mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3555,2,t0,t1);}
t2=C_chmod(t1,((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3547,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1380: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3545 in k3553 in change-file-mode in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1381: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[6]+1)))(7,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[12],lf[225],lf[226],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3475(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3475,4,t0,t1,t2,t3);}
t4=C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3485,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1287: h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm:1289: oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k3483 in ##sys#interrupt-hook in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1288: ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3462(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3462,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[186]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(((C_word*)t0)[2],t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(((C_word*)t0)[2],t2,t3));}}

/* signal-handler in k3449 in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3453,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[185]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3377(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3377r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3377r(t0,t1,t2);}}

static void C_ccall f_3377r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3381,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t4=t3;
f_3381(2,t4,C_fixnum_or(*((C_word*)lf[89]+1),*((C_word*)lf[91]+1)));}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_3381(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3379 in create-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3381(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3381,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3384,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_pipe(C_SCHEME_FALSE,t1),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3393,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1224: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t3);}
else{
/* posixwin.scm:1226: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* k3391 in k3379 in create-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1225: ##sys#signal-hook */
((C_proc5)C_retrieve_proc(*((C_word*)lf[6]+1)))(5,*((C_word*)lf[6]+1),((C_word*)t0)[2],lf[12],lf[155],lf[156]);}

/* k3382 in k3379 in create-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1226: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3357(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3357r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3357r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3357r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[154]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3361,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3359 in with-output-to-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3361,2,t0,t1);}
t2=C_mutate((C_word*)lf[154]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3367,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li84),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1209: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3366 in k3359 in with-output-to-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3367(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3367r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3367r(t0,t1,t2);}}

static void C_ccall f_3367r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3371,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1211: close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3369 in a3366 in k3359 in with-output-to-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[154]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3337(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3337r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3337r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3337r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[152]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3341,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3339 in with-input-from-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3341,2,t0,t1);}
t2=C_mutate((C_word*)lf[152]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3347,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li82),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1199: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3346 in k3339 in with-input-from-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3347(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3347r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3347r(t0,t1,t2);}}

static void C_ccall f_3347r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3351,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1201: close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3349 in a3346 in k3339 in with-input-from-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[152]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3313(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3313r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3313r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3313r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3317,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3315 in call-with-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3317,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3322,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li79),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3328,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li80),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1189: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3327 in k3315 in call-with-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3328(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3328r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3328r(t0,t1,t2);}}

static void C_ccall f_3328r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3332,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1192: close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3330 in a3327 in k3315 in call-with-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3321 in k3315 in call-with-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3322,2,t0,t1);}
/* posixwin.scm:1190: proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3289(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3289r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3289r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3289r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3293,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3291 in call-with-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3293,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3298,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li76),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3304,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li77),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1181: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3303 in k3291 in call-with-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3304(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3304r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3304r(t0,t1,t2);}}

static void C_ccall f_3304r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3308,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1184: close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3306 in a3303 in k3291 in call-with-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3297 in k3291 in call-with-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3298,2,t0,t1);}
/* posixwin.scm:1182: proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3270(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3270,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3274,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1168: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[147]+1)))(4,*((C_word*)lf[147]+1),t3,t2,lf[145]);}

/* k3272 in close-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3274,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3277,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1170: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t3);}

/* k3275 in k3272 in close-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm:1171: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[145],lf[146],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* open-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3234(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3234r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3234r(t0,t1,t2,t3);}}

static void C_ccall f_3234r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[144]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[141]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3248,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[141]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3255,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1163: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t9,t2,lf[144]);}
else{
t9=C_eqp(t6,lf[142]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3265,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1164: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t10,t2,lf[144]);}
else{
/* posixwin.scm:1138: ##sys#error */
t10=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[143],t6);}}}

/* k3263 in open-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3265,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixwin.scm:1160: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3253 in open-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3255,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixwin.scm:1160: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3246 in open-output-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1160: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3198(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3198r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3198r(t0,t1,t2,t3);}}

static void C_ccall f_3198r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[140]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[141]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3212,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[141]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3219,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1153: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t9,t2,lf[140]);}
else{
t9=C_eqp(t6,lf[142]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3229,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1154: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t10,t2,lf[140]);}
else{
/* posixwin.scm:1138: ##sys#error */
t10=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[143],t6);}}}

/* k3227 in open-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3229,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixwin.scm:1150: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3217 in open-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3219,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixwin.scm:1150: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3210 in open-input-pipe in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1150: check */
f_3180(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3180(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3180,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3184,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1140: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t5);}

/* k3182 in check in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3184,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm:1142: ##sys#signal-hook */
((C_proc5)C_retrieve_proc(*((C_word*)lf[6]+1)))(5,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[12],lf[136],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3196,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1143: ##sys#make-port */
((C_proc6)C_retrieve_proc(*((C_word*)lf[137]+1)))(6,*((C_word*)lf[137]+1),t2,((C_word*)t0)[2],*((C_word*)lf[138]+1),lf[139],lf[122]);}}

/* k3194 in k3182 in check in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* change-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3137(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3137,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[46]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3144,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3160,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1126: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t5,t2);}

/* k3158 in change-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1126: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[2],t1,lf[46]);}

/* k3142 in change-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3144,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3147,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_chdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3153,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1128: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}}

/* k3151 in k3142 in change-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3153(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1129: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[46],lf[135],((C_word*)t0)[2]);}

/* k3145 in k3142 in change-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2980(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2980r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2980r(t0,t1,t2,t3);}}

static void C_ccall f_2980r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2984,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_2984(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_2984(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2984,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[3],lf[128]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2990,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1117: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t3,((C_word*)t0)[3]);}

/* k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2990,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2993,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=t1;
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2998,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1106: string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[133]+1)))(4,*((C_word*)lf[133]+1),t4,t3,lf[134]);}
else{
t3=t1;
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3113,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1089: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t4,t3,lf[128]);}}

/* k3111 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3113,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[4]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3105,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1090: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}}

/* k3103 in k3111 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1091: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[128],lf[129],((C_word*)t0)[2]);}

/* k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2998,2,t0,t1);}
t2=C_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_i_cdr(t1);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3010,a[2]=t7,a[3]=t4,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_3010(t9,((C_word*)t0)[2],t5);}

/* loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3010(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3010,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3018,a[2]=((C_word*)t0)[3],a[3]=((C_word)li68),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3080,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_slot(t2,C_fix(0));
/* g502503 */
t6=t3;
f_3018(t6,t4,t5);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3078 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[4],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3010(t3,((C_word*)t0)[2],t2);}

/* g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3018(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3018,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3023,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1110: string-append */
((C_proc5)C_retrieve_proc(*((C_word*)lf[4]+1)))(5,*((C_word*)lf[4]+1),t3,((C_word*)((C_word*)t0)[2])[1],lf[132],t2);}

/* k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3023,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
t4=((C_word*)((C_word*)t0)[3])[1];
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3052,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3036,a[2]=t4,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1095: file-exists? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[131]+1)))(3,*((C_word*)lf[131]+1),t6,t4);}

/* k3034 in k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3036,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3039,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1096: ##sys#file-info */
((C_proc3)C_retrieve_proc(*((C_word*)lf[130]+1)))(3,*((C_word*)lf[130]+1),t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_3052(t2,C_SCHEME_FALSE);}}

/* k3037 in k3034 in k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_3052(t3,C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_3052(t2,C_SCHEME_FALSE);}}

/* k3050 in k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_3052(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3052,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3071,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1089: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t2,((C_word*)t0)[2],lf[128]);}}

/* k3069 in k3050 in k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3071(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3071,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3063,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1090: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}}

/* k3061 in k3069 in k3050 in k3021 in g502 in loop495 in k2996 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_3063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1091: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[128],lf[129],((C_word*)t0)[2]);}

/* k2991 in k2988 in k2982 in create-directory in k2976 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-file-position! in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2918(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2918r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2918r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2918r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):C_fix((C_word)SEEK_SET));
t7=C_i_check_exact_2(t3,lf[120]);
t8=C_i_check_exact_2(t6,lf[120]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2931,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_negativep(t3))){
/* posixwin.scm:1058: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[6]+1)))(7,*((C_word*)lf[6]+1),t9,lf[125],lf[120],lf[126],t3,t2);}
else{
t10=t9;
f_2931(2,t10,C_SCHEME_UNDEFINED);}}

/* k2929 in set-file-position! in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2931,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2937,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2943,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1059: port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[124]+1)))(3,*((C_word*)lf[124]+1),t3,((C_word*)t0)[4]);}

/* k2941 in k2929 in set-file-position! in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[5],C_fix(7));
t3=C_eqp(t2,lf[122]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_2937(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_2937(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t2=C_lseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
f_2937(2,t3,t2);}
else{
/* posixwin.scm:1065: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[2],lf[17],lf[120],lf[123],((C_word*)t0)[5]);}}}

/* k2935 in k2929 in set-file-position! in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixwin.scm:1066: posix-error */
t2=lf[5];
f_1690(7,t2,((C_word*)t0)[4],lf[12],lf[120],lf[121],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* f6127 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f6127(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6127,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[42]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6133 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f6133(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6133,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[41]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6139 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f6139(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6139,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[39]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6145 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f6145(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6145,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[40]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2889,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[38]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2851(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2851,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[115]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2858,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1019: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),t4,t2,lf[115]);}

/* k2856 in file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2858,2,t0,t1);}
t2=C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2861,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1021: string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k2859 in k2856 in file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2861,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2864,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2881,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1023: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}
else{
t4=t2;
f_2864(2,t4,C_SCHEME_UNDEFINED);}}

/* k2879 in k2859 in k2856 in file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1024: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[115],lf[116],((C_word*)t0)[2]);}

/* k2862 in k2859 in k2856 in file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2864,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2871,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm:1025: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[47]+1)))(5,*((C_word*)lf[47]+1),t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k2869 in k2862 in k2859 in k2856 in file-mkstemp in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1025: values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2809r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2809r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2809r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[111]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2816,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_2816(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:1006: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),t6,lf[17],lf[111],lf[113],t3);}}
else{
/* posixwin.scm:1006: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),t6,lf[17],lf[111],lf[113],t3);}}

/* k2814 in file-write in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2816,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_block_size(((C_word*)t0)[4]));
t4=C_i_check_exact_2(t3,lf[111]);
t5=C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2825,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2831,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1011: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t8);}
else{
t8=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t5);}}

/* k2829 in k2814 in file-write in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1012: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[6]+1)))(7,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[12],lf[111],lf[112],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2823 in k2814 in file-write in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2764(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2764r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2764r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2764r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[108]);
t6=C_i_check_exact_2(t3,lf[108]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2774,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t7;
f_2774(2,t8,C_i_car(t4));}
else{
/* posixwin.scm:993: make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k2772 in file-read in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2774,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2777,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_byteblockp(t1))){
t3=t2;
f_2777(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:995: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),t2,lf[17],lf[108],lf[110],t1);}}
else{
/* posixwin.scm:995: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),t2,lf[17],lf[108],lf[110],t1);}}

/* k2775 in k2772 in file-read in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2777,2,t0,t1);}
t2=C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2780,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2789,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:998: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t5);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list(&a,2,((C_word*)t0)[4],t2));}}

/* k2787 in k2775 in k2772 in file-read in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:999: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[6]+1)))(7,*((C_word*)lf[6]+1),((C_word*)t0)[4],lf[12],lf[108],lf[109],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2778 in k2775 in k2772 in file-read in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2780,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2746(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2746,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[106]);
if(C_truep(C_fixnum_lessp(C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2759,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:985: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2757 in file-close in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2759(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:986: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[106],lf[107],((C_word*)t0)[2]);}

/* file-open in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2705(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4r,(void*)f_2705r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2705r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2705r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):((C_word*)t0)[2]);
t7=C_i_check_string_2(t2,lf[104]);
t8=C_i_check_exact_2(t3,lf[104]);
t9=C_i_check_exact_2(t6,lf[104]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2722,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2738,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:975: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t11,t2);}

/* k2736 in file-open in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:975: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[2],t1,lf[104]);}

/* k2720 in file-open in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2722,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2725,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2731,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:977: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k2729 in k2720 in file-open in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2731(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:978: ##sys#signal-hook */
((C_proc8)C_retrieve_proc(*((C_word*)lf[6]+1)))(8,*((C_word*)lf[6]+1),((C_word*)t0)[5],lf[12],lf[104],lf[105],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2723 in k2720 in file-open in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2496(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_2496r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2496r(t0,t1,t2,t3);}}

static void C_ccall f_2496r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2506,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;
f_2506(t6,t4);}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2671,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=C_i_car(t3);
/* posix-common.scm:284: keyword? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[78]+1)))(3,*((C_word*)lf[78]+1),t6,t7);}}

/* k2669 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2506(t2,C_i_not(t1));}

/* k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2506(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2506,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2507,a[2]=((C_word*)t0)[3],a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2512,a[2]=t3,a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2517,a[2]=t4,a[3]=((C_word)li42),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2522,a[2]=t5,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2533,a[2]=t6,a[3]=((C_word)li46),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* def-pred333356 */
t8=t7;
f_2533(t8,((C_word*)t0)[2]);}
else{
t8=C_i_car(t2);
t9=C_i_cdr(t2);
if(C_truep(C_i_nullp(t9))){
/* def-action334352 */
t10=t6;
f_2522(t10,((C_word*)t0)[2],t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-id335349 */
t12=t5;
f_2517(t12,((C_word*)t0)[2],t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* def-limit336345 */
t14=t4;
f_2512(t14,((C_word*)t0)[2],t8,t10,t12);}
else{
t14=C_i_car(t13);
t15=C_i_cdr(t13);
if(C_truep(C_i_nullp(t15))){
/* body331340 */
t16=t3;
f_2507(t16,((C_word*)t0)[2],t8,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,((C_word*)t0)[2],lf[2],t15);}}}}}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2617,a[2]=((C_word*)t0)[3],a[3]=((C_word)li55),tmp=(C_word)a,a+=4,tmp);
C_apply(4,0,((C_word*)t0)[2],t2,((C_word*)t0)[4]);}}

/* a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2617(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr2r,(void*)f_2617r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2617r(t0,t1,t2);}}

static void C_ccall f_2617r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2621,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2661,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t3,lf[77],t2,t4);}

/* a2660 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2661,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2663,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));}

/* f_2663 in a2660 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2663(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2663,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2621,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2624,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2653,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t2,lf[76],((C_word*)t0)[2],t3);}

/* a2652 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2653,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2655,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));}

/* f_2655 in a2652 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2655(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2655,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2624,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2627,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2650,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t2,lf[75],((C_word*)t0)[2],t3);}

/* a2649 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2650,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2627,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2630,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2647,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t2,lf[74],((C_word*)t0)[2],t3);}

/* a2646 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2647,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k2628 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2630,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2633,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2644,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t2,lf[73],((C_word*)t0)[2],t3);}

/* a2643 in k2628 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2644,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k2631 in k2628 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2633,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2636,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2641,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[71]+1)))(5,*((C_word*)lf[71]+1),t2,lf[72],((C_word*)t0)[2],t3);}

/* a2640 in k2631 in k2628 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2641,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k2634 in k2631 in k2628 in k2625 in k2622 in k2619 in a2616 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:299: ##sys#find-files */
f_2323(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],lf[70]);}

/* def-pred333 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2533(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2533,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2539,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* def-action334352 */
t3=((C_word*)t0)[2];
f_2522(t3,t1,t2);}

/* a2538 in def-pred333 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2539(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2539,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* def-action334 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2522(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2522,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2528,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* def-id335349 */
t4=((C_word*)t0)[2];
f_2517(t4,t1,t2,t3);}

/* a2527 in def-action334 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2528(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2528,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* def-id335 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2517(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2517,NULL,4,t0,t1,t2,t3);}
/* def-limit336345 */
t4=((C_word*)t0)[2];
f_2512(t4,t1,t2,t3,C_SCHEME_END_OF_LIST);}

/* def-limit336 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2512(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2512,NULL,5,t0,t1,t2,t3,t4);}
/* body331340 */
t5=((C_word*)t0)[2];
f_2507(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body331 in k2504 in find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2507(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2507,NULL,6,t0,t1,t2,t3,t4,t5);}
/* posix-common.scm:290: ##sys#find-files */
f_2323(t1,((C_word*)t0)[2],t2,t3,t4,t5,C_SCHEME_FALSE,lf[70]);}

/* ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2323(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2323,NULL,8,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=C_i_check_string_2(t2,t8);
t10=C_fix(0);
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2330,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=t5,a[6]=t1,a[7]=t4,a[8]=t11,tmp=(C_word)a,a+=9,tmp);
t13=t6;
if(C_truep(t13)){
if(C_truep(C_fixnump(t6))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2490,a[2]=t6,a[3]=t11,a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
t15=t12;
f_2330(t15,t14);}
else{
t14=t6;
t15=t12;
f_2330(t15,t14);}}
else{
t14=t12;
f_2330(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2482,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));}}

/* f_2482 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2482(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2482,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_2490 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2490(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2490,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2330(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2330,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2333,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t1,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=C_i_stringp(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2467,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2467(2,t5,t3);}
else{
/* posix-common.scm:262: regexp? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[69]+1)))(3,*((C_word*)lf[69]+1),t4,((C_word*)t0)[2]);}}

/* k2465 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2467,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2470,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:263: regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[58]+1)))(3,*((C_word*)lf[58]+1),t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2333(t2,((C_word*)t0)[2]);}}

/* k2468 in k2465 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2470,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2333(t2,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2471,a[2]=t1,a[3]=((C_word)li36),tmp=(C_word)a,a+=4,tmp));}

/* f_2471 in k2468 in k2465 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2471(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2471,3,t0,t1,t2);}
/* posix-common.scm:264: string-match */
((C_proc4)C_retrieve_proc(*((C_word*)lf[56]+1)))(4,*((C_word*)lf[56]+1),t1,((C_word*)t0)[2],t2);}

/* k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2333(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2333,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2340,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2457,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posix-common.scm:266: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[55]+1)))(4,*((C_word*)lf[55]+1),t3,((C_word*)t0)[2],lf[67]);}
else{
/* posix-common.scm:266: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[55]+1)))(4,*((C_word*)lf[55]+1),t3,((C_word*)t0)[2],lf[68]);}}

/* k2455 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:266: glob */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2340(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2340,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2342,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t3,a[7]=((C_word)li35),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2342(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2342(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2342,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2361,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=t5,a[9]=t1,a[10]=((C_word*)t0)[6],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:272: directory? */
t7=*((C_word*)lf[43]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2361,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2437,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:273: pathname-file */
((C_proc3)C_retrieve_proc(*((C_word*)lf[66]+1)))(3,*((C_word*)lf[66]+1),t2,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2443,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:280: pproc */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[4]);}}

/* k2441 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2443(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2443,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2450,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:280: action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posix-common.scm:281: loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_2342(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k2448 in k2441 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:280: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2342(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2437(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2437,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[62]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[63]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:273: loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_2342(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2376,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:274: lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[4]);}}

/* k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2376,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2386,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2388,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=((C_word)li32),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2393,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word)li33),tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2417,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=((C_word)li34),tmp=(C_word)a,a+=6,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2427,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2430,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t2,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:279: pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}}

/* k2428 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:279: action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:279: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2342(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k2425 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2427(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:279: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2342(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2416 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2417,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a2392 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2393,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2401,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2415,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:277: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[55]+1)))(4,*((C_word*)lf[55]+1),t3,((C_word*)t0)[4],lf[64]);}

/* k2413 in a2392 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:277: glob */
t2=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2399 in a2392 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2401,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2405,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2408,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t2,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:278: pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k2406 in k2399 in a2392 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:278: action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:277: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2342(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k2403 in k2399 in a2392 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:277: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2342(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2387 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2388,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k2384 in k2374 in k2435 in k2359 in loop in k2338 in k2331 in k2328 in ##sys#find-files in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:275: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2342(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_2211r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2211r(t0,t1,t2);}}

static void C_ccall f_2211r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2217,a[2]=t4,a[3]=((C_word)li30),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2217(t6,t1,t2);}

/* conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2217(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2217,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2232,a[2]=t3,a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2238,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li29),tmp=(C_word)a,a+=5,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2238(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2238,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2242,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2317,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t7=t3;
/* posix-common.scm:242: make-pathname */
((C_proc5)C_retrieve_proc(*((C_word*)lf[55]+1)))(5,*((C_word*)lf[55]+1),t6,C_SCHEME_FALSE,t7,t4);}
else{
/* posix-common.scm:242: make-pathname */
((C_proc5)C_retrieve_proc(*((C_word*)lf[55]+1)))(5,*((C_word*)lf[55]+1),t6,C_SCHEME_FALSE,lf[60],t4);}}

/* k2315 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:242: glob->regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[59]+1)))(3,*((C_word*)lf[59]+1),((C_word*)t0)[2],t1);}

/* k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2242,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2245,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:243: regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[58]+1)))(3,*((C_word*)lf[58]+1),t2,t1);}

/* k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2245,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2252,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=((C_word*)t0)[3];
/* posix-common.scm:244: directory */
t4=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}
else{
/* posix-common.scm:244: directory */
t3=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[57],C_SCHEME_TRUE);}}

/* k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2252,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2254,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li28),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2254(t5,((C_word*)t0)[2],t1);}

/* loop in k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2254(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2254,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[6]);
/* posix-common.scm:245: conc-loop */
t4=((C_word*)((C_word*)t0)[5])[1];
f_2217(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2271,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:246: string-match */
((C_proc4)C_retrieve_proc(*((C_word*)lf[56]+1)))(4,*((C_word*)lf[56]+1),t3,((C_word*)t0)[2],t4);}}

/* k2269 in loop in k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2271,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2275,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li27),tmp=(C_word)a,a+=6,tmp);
/* g267268 */
t3=t2;
f_2275(t3,((C_word*)t0)[2],t1);}
else{
t2=C_i_cdr(((C_word*)t0)[5]);
/* posix-common.scm:248: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2254(t3,((C_word*)t0)[2],t2);}}

/* g267 in k2269 in loop in k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2275(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2275,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2283,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_i_car(t2);
/* posix-common.scm:247: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[55]+1)))(4,*((C_word*)lf[55]+1),t3,((C_word*)t0)[2],t4);}

/* k2281 in g267 in k2269 in loop in k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2283,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2287,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:247: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2254(t4,t2,t3);}

/* k2285 in k2281 in g267 in k2269 in loop in k2250 in k2243 in k2240 in a2237 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2287,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a2231 in conc-loop in glob in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2232,2,t0,t1);}
/* posix-common.scm:241: decompose-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[54]+1)))(3,*((C_word*)lf[54]+1),t1,((C_word*)t0)[2]);}

/* directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2054(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_2054r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2054r(t0,t1,t2);}}

static void C_ccall f_2054r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2056,a[2]=((C_word*)t0)[2],a[3]=((C_word)li22),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2154,a[2]=t3,a[3]=((C_word)li23),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2159,a[2]=t4,a[3]=((C_word)li24),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* def-spec202234 */
t6=t5;
f_2159(t6,t1);}
else{
t6=C_i_car(t2);
t7=C_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
/* def-show-dotfiles?203232 */
t8=t4;
f_2154(t8,t1,t6);}
else{
t8=C_i_car(t7);
t9=C_i_cdr(t7);
if(C_truep(C_i_nullp(t9))){
/* body200207 */
t10=t3;
f_2056(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[2],t9);}}}}

/* def-spec202 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2159(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2159,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2167,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:205: current-directory */
t3=*((C_word*)lf[45]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2165 in def-spec202 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?203232 */
t2=((C_word*)t0)[3];
f_2154(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?203 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2154(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2154,NULL,3,t0,t1,t2);}
/* body200207 */
t3=((C_word*)t0)[2];
f_2056(t3,t1,t2,C_SCHEME_FALSE);}

/* body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2056(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2056,NULL,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[31]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2063,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:207: make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2063,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2066,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:208: ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[52]+1)))(2,*((C_word*)lf[52]+1),t2);}

/* k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2066,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2069,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:209: ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[52]+1)))(2,*((C_word*)lf[52]+1),t2);}

/* k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2069,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2073,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2153,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:212: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t3,((C_word*)t0)[4]);}

/* k2151 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2153(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:212: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[2],t1,lf[31]);}

/* k2071 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2073,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[7]);
if(C_truep(C_null_pointerp(((C_word*)t0)[7]))){
/* posix-common.scm:214: posix-error */
t3=lf[5];
f_1690(6,t3,((C_word*)t0)[6],lf[12],lf[31],lf[51],((C_word*)t0)[5]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2087,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word)li21),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2087(t6,((C_word*)t0)[6]);}}

/* loop in k2071 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2087(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2087,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
t3=C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2097,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:222: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[47]+1)))(5,*((C_word*)lf[47]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2095 in loop in k2071 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2097,2,t0,t1);}
t2=C_i_string_ref(t1,C_fix(0));
t3=C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2109,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(C_make_character(46),t2);
if(C_truep(t6)){
t7=C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_2109(t8,t7);}
else{
t8=C_eqp(C_make_character(46),t4);
if(C_truep(t8)){
t9=C_eqp(C_fix(2),((C_word*)t0)[5]);
t10=t5;
f_2109(t10,(C_truep(t9)?t9:C_i_not(((C_word*)t0)[2])));}
else{
t9=t5;
f_2109(t9,C_i_not(((C_word*)t0)[2]));}}}
else{
t7=t5;
f_2109(t7,C_SCHEME_FALSE);}}

/* k2107 in k2095 in loop in k2071 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_2109(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2109,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:229: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2087(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2119,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:230: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2087(t3,t2);}}

/* k2117 in k2107 in k2095 in loop in k2071 in k2067 in k2064 in k2061 in body200 in directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2119,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2032(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2032,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[49]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2039,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2052,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:198: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t5,t2);}

/* k2050 in delete-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:198: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[2],t1,lf[49]);}

/* k2037 in delete-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2039,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2042,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_rmdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
/* posix-common.scm:200: posix-error */
t4=lf[5];
f_1690(6,t4,t2,lf[12],lf[49],lf[50],((C_word*)t0)[2]);}}

/* k2040 in k2037 in delete-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* current-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1986(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1986r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1986r(t0,t1,t2);}}

static void C_ccall f_1986r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1990,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
t4=t3;
f_1990(2,t4,C_SCHEME_FALSE);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_1990(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k1988 in current-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1990,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:186: change-directory */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1999,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:187: make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(1024));}}

/* k1997 in k1988 in current-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1999(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1999,2,t0,t1);}
t2=C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2002,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:190: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t3);}

/* k2000 in k1997 in k1988 in current-directory in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_2002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:192: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[47]+1)))(5,*((C_word*)lf[47]+1),((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posix-common.scm:193: ##sys#signal-hook */
((C_proc5)C_retrieve_proc(*((C_word*)lf[6]+1)))(5,*((C_word*)lf[6]+1),((C_word*)t0)[3],lf[12],lf[45],lf[48]);}}

/* directory? in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1976(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1976,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1984,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:177: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1982 in directory? in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[31],t1));}

/* f_1966 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1966(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1966,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1974,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:174: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1972 */
static void C_ccall f_1974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[35],t1));}

/* f_1956 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1956(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1956,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1964,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:171: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1962 */
static void C_ccall f_1964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[34],t1));}

/* f_1946 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1946(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1946,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1954,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:168: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1952 */
static void C_ccall f_1954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[32],t1));}

/* f_1936 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1936(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1936,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1944,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:165: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1942 */
static void C_ccall f_1944(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[33],t1));}

/* f_1926 in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1926(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1926,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1934,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:162: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* k1932 */
static void C_ccall f_1934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[30],t1));}

/* regular-file? in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1916(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1916,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1924,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:159: file-type */
t4=*((C_word*)lf[29]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k1922 in regular-file? in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[36],t1));}

/* file-type in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1817(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_1817r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1817r(t0,t1,t2,t3);}}

static void C_ccall f_1817r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1819,a[2]=t2,a[3]=((C_word)li8),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1863,a[2]=t4,a[3]=((C_word)li9),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1868,a[2]=t5,a[3]=((C_word)li10),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-link140156 */
t7=t6;
f_1868(t7,t1);}
else{
t7=C_i_car(t3);
t8=C_i_cdr(t3);
if(C_truep(C_i_nullp(t8))){
/* def-err141154 */
t9=t5;
f_1863(t9,t1,t7);}
else{
t9=C_i_car(t8);
t10=C_i_cdr(t8);
if(C_truep(C_i_nullp(t10))){
/* body138145 */
t11=t4;
f_1819(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[2],t10);}}}}

/* def-link140 in file-type in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_1868(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1868,NULL,2,t0,t1);}
/* def-err141154 */
t2=((C_word*)t0)[2];
f_1863(t2,t1,C_SCHEME_FALSE);}

/* def-err141 in file-type in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_1863(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1863,NULL,3,t0,t1,t2);}
/* body138145 */
t3=((C_word*)t0)[2];
f_1819(t3,t1,t2,C_SCHEME_TRUE);}

/* body138 in file-type in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_1819(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1819,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1826,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:148: ##sys#stat */
f_1708(t4,((C_word*)t0)[2],t2,t3,lf[29]);}

/* k1824 in body138 in file-type in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[30]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[31]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[32]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[33]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[34]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[35]:lf[36]));}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-size in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1811(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1811,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1815,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:145: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[28]);}

/* k1813 in file-size in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1815,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-permissions in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1805(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1805,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1809,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:144: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[27]);}

/* k1807 in file-permissions in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1799(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1799,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1803,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:143: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[26]);}

/* k1801 in file-owner in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1803(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1793(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1793,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1797,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:142: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[25]);}

/* k1795 in file-change-time in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1797,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1787(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1787,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1791,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:141: ##sys#stat */
f_1708(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[24]);}

/* k1789 in file-access-time in k1783 in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1791,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1752(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_1752r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1752r(t0,t1,t2,t3);}}

static void C_ccall f_1752r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1756,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_1756(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_1756(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[22]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k1754 in file-stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1756,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1759,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:120: ##sys#stat */
f_1708(t2,((C_word*)t0)[2],t1,C_SCHEME_TRUE,lf[19]);}

/* k1757 in k1754 in file-stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1759(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1759,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),*((C_word*)lf[20]+1),*((C_word*)lf[21]+1)));}

/* ##sys#stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_fcall f_1708(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1708,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1712,a[2]=t2,a[3]=t5,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_1712(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1736,a[2]=t3,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1743,a[2]=t5,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1747,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:105: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[16]+1)))(3,*((C_word*)lf[16]+1),t9,t2);}
else{
/* posix-common.scm:111: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[6]+1)))(6,*((C_word*)lf[6]+1),t6,lf[17],t5,lf[18],t2);}}}

/* k1745 in ##sys#stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1747(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:104: ##sys#platform-fixup-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[15]+1)))(3,*((C_word*)lf[15]+1),((C_word*)t0)[2],t1);}

/* k1741 in ##sys#stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:103: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[14]+1)))(4,*((C_word*)lf[14]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k1734 in ##sys#stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1712(2,t2,(C_truep(((C_word*)t0)[2])?C_lstat(t1):C_stat(t1)));}

/* k1710 in ##sys#stat in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1712(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[5])){
/* posix-common.scm:115: posix-error */
t2=lf[5];
f_1690(6,t2,((C_word*)t0)[4],lf[12],((C_word*)t0)[3],lf[13],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* posix-error in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1690(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1690r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1690r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1690r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1694,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:63: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[9]+1)))(2,*((C_word*)lf[9]+1),t6);}

/* k1692 in posix-error in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1694,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1701,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1705,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub64(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1703 in k1692 in posix-error in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:64: string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1699 in k1692 in posix-error in k1676 in k1673 in k1670 in k1667 in k1664 in k1661 */
static void C_ccall f_1701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[445] = {
{"toplevel:posixwin_scm",(void*)C_posix_toplevel},
{"f_1663:posixwin_scm",(void*)f_1663},
{"f_1666:posixwin_scm",(void*)f_1666},
{"f_1669:posixwin_scm",(void*)f_1669},
{"f_1672:posixwin_scm",(void*)f_1672},
{"f_1675:posixwin_scm",(void*)f_1675},
{"f_1678:posixwin_scm",(void*)f_1678},
{"f_5525:posixwin_scm",(void*)f_5525},
{"f_5558:posixwin_scm",(void*)f_5558},
{"f_5535:posixwin_scm",(void*)f_5535},
{"f_5545:posixwin_scm",(void*)f_5545},
{"f_5519:posixwin_scm",(void*)f_5519},
{"f_5523:posixwin_scm",(void*)f_5523},
{"f_1785:posixwin_scm",(void*)f_1785},
{"f_5478:posixwin_scm",(void*)f_5478},
{"f_5494:posixwin_scm",(void*)f_5494},
{"f_5482:posixwin_scm",(void*)f_5482},
{"f_5485:posixwin_scm",(void*)f_5485},
{"f_2978:posixwin_scm",(void*)f_2978},
{"f_3451:posixwin_scm",(void*)f_3451},
{"f_5459:posixwin_scm",(void*)f_5459},
{"f_5456:posixwin_scm",(void*)f_5456},
{"f_5449:posixwin_scm",(void*)f_5449},
{"f_5443:posixwin_scm",(void*)f_5443},
{"f_5437:posixwin_scm",(void*)f_5437},
{"f_5431:posixwin_scm",(void*)f_5431},
{"f_5425:posixwin_scm",(void*)f_5425},
{"f_5419:posixwin_scm",(void*)f_5419},
{"f_5413:posixwin_scm",(void*)f_5413},
{"f_5407:posixwin_scm",(void*)f_5407},
{"f_5401:posixwin_scm",(void*)f_5401},
{"f_5395:posixwin_scm",(void*)f_5395},
{"f_5389:posixwin_scm",(void*)f_5389},
{"f_5383:posixwin_scm",(void*)f_5383},
{"f_5377:posixwin_scm",(void*)f_5377},
{"f_5371:posixwin_scm",(void*)f_5371},
{"f_5365:posixwin_scm",(void*)f_5365},
{"f_5359:posixwin_scm",(void*)f_5359},
{"f_5353:posixwin_scm",(void*)f_5353},
{"f_5347:posixwin_scm",(void*)f_5347},
{"f_5341:posixwin_scm",(void*)f_5341},
{"f_5335:posixwin_scm",(void*)f_5335},
{"f_5329:posixwin_scm",(void*)f_5329},
{"f_5323:posixwin_scm",(void*)f_5323},
{"f_5317:posixwin_scm",(void*)f_5317},
{"f_5311:posixwin_scm",(void*)f_5311},
{"f_5305:posixwin_scm",(void*)f_5305},
{"f_5299:posixwin_scm",(void*)f_5299},
{"f_5293:posixwin_scm",(void*)f_5293},
{"f_5287:posixwin_scm",(void*)f_5287},
{"f_5281:posixwin_scm",(void*)f_5281},
{"f_5275:posixwin_scm",(void*)f_5275},
{"f_5269:posixwin_scm",(void*)f_5269},
{"f_5263:posixwin_scm",(void*)f_5263},
{"f_5257:posixwin_scm",(void*)f_5257},
{"f_5251:posixwin_scm",(void*)f_5251},
{"f_5245:posixwin_scm",(void*)f_5245},
{"f_5239:posixwin_scm",(void*)f_5239},
{"f_5233:posixwin_scm",(void*)f_5233},
{"f_5227:posixwin_scm",(void*)f_5227},
{"f_5221:posixwin_scm",(void*)f_5221},
{"f_5215:posixwin_scm",(void*)f_5215},
{"f_5209:posixwin_scm",(void*)f_5209},
{"f_5203:posixwin_scm",(void*)f_5203},
{"f_5188:posixwin_scm",(void*)f_5188},
{"f_5198:posixwin_scm",(void*)f_5198},
{"f_5157:posixwin_scm",(void*)f_5157},
{"f_5183:posixwin_scm",(void*)f_5183},
{"f_5168:posixwin_scm",(void*)f_5168},
{"f_5172:posixwin_scm",(void*)f_5172},
{"f_5176:posixwin_scm",(void*)f_5176},
{"f_5180:posixwin_scm",(void*)f_5180},
{"f_5145:posixwin_scm",(void*)f_5145},
{"f_5142:posixwin_scm",(void*)f_5142},
{"f_5082:posixwin_scm",(void*)f_5082},
{"f_5109:posixwin_scm",(void*)f_5109},
{"f_5119:posixwin_scm",(void*)f_5119},
{"f_5103:posixwin_scm",(void*)f_5103},
{"f_5070:posixwin_scm",(void*)f_5070},
{"f_4990:posixwin_scm",(void*)f_4990},
{"f_5007:posixwin_scm",(void*)f_5007},
{"f_5002:posixwin_scm",(void*)f_5002},
{"f_4997:posixwin_scm",(void*)f_4997},
{"f_4992:posixwin_scm",(void*)f_4992},
{"f_4910:posixwin_scm",(void*)f_4910},
{"f_4927:posixwin_scm",(void*)f_4927},
{"f_4922:posixwin_scm",(void*)f_4922},
{"f_4917:posixwin_scm",(void*)f_4917},
{"f_4912:posixwin_scm",(void*)f_4912},
{"f_4848:posixwin_scm",(void*)f_4848},
{"f_4904:posixwin_scm",(void*)f_4904},
{"f_4908:posixwin_scm",(void*)f_4908},
{"f_4869:posixwin_scm",(void*)f_4869},
{"f_4872:posixwin_scm",(void*)f_4872},
{"f_4883:posixwin_scm",(void*)f_4883},
{"f_4877:posixwin_scm",(void*)f_4877},
{"f_4850:posixwin_scm",(void*)f_4850},
{"f_4859:posixwin_scm",(void*)f_4859},
{"f_4729:posixwin_scm",(void*)f_4729},
{"f_4733:posixwin_scm",(void*)f_4733},
{"f_4824:posixwin_scm",(void*)f_4824},
{"f_4736:posixwin_scm",(void*)f_4736},
{"f_4792:posixwin_scm",(void*)f_4792},
{"f_4796:posixwin_scm",(void*)f_4796},
{"f_4800:posixwin_scm",(void*)f_4800},
{"f_4804:posixwin_scm",(void*)f_4804},
{"f_4808:posixwin_scm",(void*)f_4808},
{"f_4671:posixwin_scm",(void*)f_4671},
{"f_4675:posixwin_scm",(void*)f_4675},
{"f_4785:posixwin_scm",(void*)f_4785},
{"f_4765:posixwin_scm",(void*)f_4765},
{"f_4769:posixwin_scm",(void*)f_4769},
{"f_4773:posixwin_scm",(void*)f_4773},
{"f_4637:posixwin_scm",(void*)f_4637},
{"f_4654:posixwin_scm",(void*)f_4654},
{"f_4658:posixwin_scm",(void*)f_4658},
{"f_4631:posixwin_scm",(void*)f_4631},
{"f_4610:posixwin_scm",(void*)f_4610},
{"f_4614:posixwin_scm",(void*)f_4614},
{"f_4626:posixwin_scm",(void*)f_4626},
{"f_4607:posixwin_scm",(void*)f_4607},
{"f_4520:posixwin_scm",(void*)f_4520},
{"f_4544:posixwin_scm",(void*)f_4544},
{"f_4539:posixwin_scm",(void*)f_4539},
{"f_4534:posixwin_scm",(void*)f_4534},
{"f_4522:posixwin_scm",(void*)f_4522},
{"f_4526:posixwin_scm",(void*)f_4526},
{"f_4433:posixwin_scm",(void*)f_4433},
{"f_4457:posixwin_scm",(void*)f_4457},
{"f_4452:posixwin_scm",(void*)f_4452},
{"f_4447:posixwin_scm",(void*)f_4447},
{"f_4435:posixwin_scm",(void*)f_4435},
{"f_4439:posixwin_scm",(void*)f_4439},
{"f_4418:posixwin_scm",(void*)f_4418},
{"f_4422:posixwin_scm",(void*)f_4422},
{"f_4382:posixwin_scm",(void*)f_4382},
{"f_4389:posixwin_scm",(void*)f_4389},
{"f_4392:posixwin_scm",(void*)f_4392},
{"f_4409:posixwin_scm",(void*)f_4409},
{"f_4395:posixwin_scm",(void*)f_4395},
{"f_4398:posixwin_scm",(void*)f_4398},
{"f_4405:posixwin_scm",(void*)f_4405},
{"f_4332:posixwin_scm",(void*)f_4332},
{"f_4344:posixwin_scm",(void*)f_4344},
{"f_4363:posixwin_scm",(void*)f_4363},
{"f_4315:posixwin_scm",(void*)f_4315},
{"f_4298:posixwin_scm",(void*)f_4298},
{"f_4219:posixwin_scm",(void*)f_4219},
{"f_4262:posixwin_scm",(void*)f_4262},
{"f_4293:posixwin_scm",(void*)f_4293},
{"f_4290:posixwin_scm",(void*)f_4290},
{"f_4224:posixwin_scm",(void*)f_4224},
{"f_4228:posixwin_scm",(void*)f_4228},
{"f_4233:posixwin_scm",(void*)f_4233},
{"f_4257:posixwin_scm",(void*)f_4257},
{"f_4246:posixwin_scm",(void*)f_4246},
{"f_4155:posixwin_scm",(void*)f_4155},
{"f_4159:posixwin_scm",(void*)f_4159},
{"f_4165:posixwin_scm",(void*)f_4165},
{"f_4174:posixwin_scm",(void*)f_4174},
{"f_4140:posixwin_scm",(void*)f_4140},
{"f_4147:posixwin_scm",(void*)f_4147},
{"f_4121:posixwin_scm",(void*)f_4121},
{"f_4125:posixwin_scm",(void*)f_4125},
{"f_4128:posixwin_scm",(void*)f_4128},
{"f_4105:posixwin_scm",(void*)f_4105},
{"f_4093:posixwin_scm",(void*)f_4093},
{"f_4078:posixwin_scm",(void*)f_4078},
{"f_4082:posixwin_scm",(void*)f_4082},
{"f_4088:posixwin_scm",(void*)f_4088},
{"f_4011:posixwin_scm",(void*)f_4011},
{"f_4015:posixwin_scm",(void*)f_4015},
{"f_4018:posixwin_scm",(void*)f_4018},
{"f_4040:posixwin_scm",(void*)f_4040},
{"f_4037:posixwin_scm",(void*)f_4037},
{"f_4027:posixwin_scm",(void*)f_4027},
{"f_3953:posixwin_scm",(void*)f_3953},
{"f_3957:posixwin_scm",(void*)f_3957},
{"f_3960:posixwin_scm",(void*)f_3960},
{"f_3909:posixwin_scm",(void*)f_3909},
{"f_3913:posixwin_scm",(void*)f_3913},
{"f_3875:posixwin_scm",(void*)f_3875},
{"f_3879:posixwin_scm",(void*)f_3879},
{"f_3856:posixwin_scm",(void*)f_3856},
{"f_3791:posixwin_scm",(void*)f_3791},
{"f_3797:posixwin_scm",(void*)f_3797},
{"f_3801:posixwin_scm",(void*)f_3801},
{"f_3809:posixwin_scm",(void*)f_3809},
{"f_3835:posixwin_scm",(void*)f_3835},
{"f_3839:posixwin_scm",(void*)f_3839},
{"f_3827:posixwin_scm",(void*)f_3827},
{"f_3771:posixwin_scm",(void*)f_3771},
{"f_3779:posixwin_scm",(void*)f_3779},
{"f_3754:posixwin_scm",(void*)f_3754},
{"f_3765:posixwin_scm",(void*)f_3765},
{"f_3769:posixwin_scm",(void*)f_3769},
{"f_3724:posixwin_scm",(void*)f_3724},
{"f_3731:posixwin_scm",(void*)f_3731},
{"f_3740:posixwin_scm",(void*)f_3740},
{"f_3734:posixwin_scm",(void*)f_3734},
{"f_3689:posixwin_scm",(void*)f_3689},
{"f_3693:posixwin_scm",(void*)f_3693},
{"f_3722:posixwin_scm",(void*)f_3722},
{"f_3708:posixwin_scm",(void*)f_3708},
{"f_3702:posixwin_scm",(void*)f_3702},
{"f_3675:posixwin_scm",(void*)f_3675},
{"f_3687:posixwin_scm",(void*)f_3687},
{"f_3661:posixwin_scm",(void*)f_3661},
{"f_3673:posixwin_scm",(void*)f_3673},
{"f_3643:posixwin_scm",(void*)f_3643},
{"f_3647:posixwin_scm",(void*)f_3647},
{"f_3659:posixwin_scm",(void*)f_3659},
{"f_3606:posixwin_scm",(void*)f_3606},
{"f_3614:posixwin_scm",(void*)f_3614},
{"f_3597:posixwin_scm",(void*)f_3597},
{"f_3591:posixwin_scm",(void*)f_3591},
{"f_3585:posixwin_scm",(void*)f_3585},
{"f_3561:posixwin_scm",(void*)f_3561},
{"f_3583:posixwin_scm",(void*)f_3583},
{"f_3579:posixwin_scm",(void*)f_3579},
{"f_3571:posixwin_scm",(void*)f_3571},
{"f_3531:posixwin_scm",(void*)f_3531},
{"f_3559:posixwin_scm",(void*)f_3559},
{"f_3555:posixwin_scm",(void*)f_3555},
{"f_3547:posixwin_scm",(void*)f_3547},
{"f_3475:posixwin_scm",(void*)f_3475},
{"f_3485:posixwin_scm",(void*)f_3485},
{"f_3462:posixwin_scm",(void*)f_3462},
{"f_3453:posixwin_scm",(void*)f_3453},
{"f_3377:posixwin_scm",(void*)f_3377},
{"f_3381:posixwin_scm",(void*)f_3381},
{"f_3393:posixwin_scm",(void*)f_3393},
{"f_3384:posixwin_scm",(void*)f_3384},
{"f_3357:posixwin_scm",(void*)f_3357},
{"f_3361:posixwin_scm",(void*)f_3361},
{"f_3367:posixwin_scm",(void*)f_3367},
{"f_3371:posixwin_scm",(void*)f_3371},
{"f_3337:posixwin_scm",(void*)f_3337},
{"f_3341:posixwin_scm",(void*)f_3341},
{"f_3347:posixwin_scm",(void*)f_3347},
{"f_3351:posixwin_scm",(void*)f_3351},
{"f_3313:posixwin_scm",(void*)f_3313},
{"f_3317:posixwin_scm",(void*)f_3317},
{"f_3328:posixwin_scm",(void*)f_3328},
{"f_3332:posixwin_scm",(void*)f_3332},
{"f_3322:posixwin_scm",(void*)f_3322},
{"f_3289:posixwin_scm",(void*)f_3289},
{"f_3293:posixwin_scm",(void*)f_3293},
{"f_3304:posixwin_scm",(void*)f_3304},
{"f_3308:posixwin_scm",(void*)f_3308},
{"f_3298:posixwin_scm",(void*)f_3298},
{"f_3270:posixwin_scm",(void*)f_3270},
{"f_3274:posixwin_scm",(void*)f_3274},
{"f_3277:posixwin_scm",(void*)f_3277},
{"f_3234:posixwin_scm",(void*)f_3234},
{"f_3265:posixwin_scm",(void*)f_3265},
{"f_3255:posixwin_scm",(void*)f_3255},
{"f_3248:posixwin_scm",(void*)f_3248},
{"f_3198:posixwin_scm",(void*)f_3198},
{"f_3229:posixwin_scm",(void*)f_3229},
{"f_3219:posixwin_scm",(void*)f_3219},
{"f_3212:posixwin_scm",(void*)f_3212},
{"f_3180:posixwin_scm",(void*)f_3180},
{"f_3184:posixwin_scm",(void*)f_3184},
{"f_3196:posixwin_scm",(void*)f_3196},
{"f_3137:posixwin_scm",(void*)f_3137},
{"f_3160:posixwin_scm",(void*)f_3160},
{"f_3144:posixwin_scm",(void*)f_3144},
{"f_3153:posixwin_scm",(void*)f_3153},
{"f_3147:posixwin_scm",(void*)f_3147},
{"f_2980:posixwin_scm",(void*)f_2980},
{"f_2984:posixwin_scm",(void*)f_2984},
{"f_2990:posixwin_scm",(void*)f_2990},
{"f_3113:posixwin_scm",(void*)f_3113},
{"f_3105:posixwin_scm",(void*)f_3105},
{"f_2998:posixwin_scm",(void*)f_2998},
{"f_3010:posixwin_scm",(void*)f_3010},
{"f_3080:posixwin_scm",(void*)f_3080},
{"f_3018:posixwin_scm",(void*)f_3018},
{"f_3023:posixwin_scm",(void*)f_3023},
{"f_3036:posixwin_scm",(void*)f_3036},
{"f_3039:posixwin_scm",(void*)f_3039},
{"f_3052:posixwin_scm",(void*)f_3052},
{"f_3071:posixwin_scm",(void*)f_3071},
{"f_3063:posixwin_scm",(void*)f_3063},
{"f_2993:posixwin_scm",(void*)f_2993},
{"f_2918:posixwin_scm",(void*)f_2918},
{"f_2931:posixwin_scm",(void*)f_2931},
{"f_2943:posixwin_scm",(void*)f_2943},
{"f_2937:posixwin_scm",(void*)f_2937},
{"f6127:posixwin_scm",(void*)f6127},
{"f6133:posixwin_scm",(void*)f6133},
{"f6139:posixwin_scm",(void*)f6139},
{"f6145:posixwin_scm",(void*)f6145},
{"f_2889:posixwin_scm",(void*)f_2889},
{"f_2851:posixwin_scm",(void*)f_2851},
{"f_2858:posixwin_scm",(void*)f_2858},
{"f_2861:posixwin_scm",(void*)f_2861},
{"f_2881:posixwin_scm",(void*)f_2881},
{"f_2864:posixwin_scm",(void*)f_2864},
{"f_2871:posixwin_scm",(void*)f_2871},
{"f_2809:posixwin_scm",(void*)f_2809},
{"f_2816:posixwin_scm",(void*)f_2816},
{"f_2831:posixwin_scm",(void*)f_2831},
{"f_2825:posixwin_scm",(void*)f_2825},
{"f_2764:posixwin_scm",(void*)f_2764},
{"f_2774:posixwin_scm",(void*)f_2774},
{"f_2777:posixwin_scm",(void*)f_2777},
{"f_2789:posixwin_scm",(void*)f_2789},
{"f_2780:posixwin_scm",(void*)f_2780},
{"f_2746:posixwin_scm",(void*)f_2746},
{"f_2759:posixwin_scm",(void*)f_2759},
{"f_2705:posixwin_scm",(void*)f_2705},
{"f_2738:posixwin_scm",(void*)f_2738},
{"f_2722:posixwin_scm",(void*)f_2722},
{"f_2731:posixwin_scm",(void*)f_2731},
{"f_2725:posixwin_scm",(void*)f_2725},
{"f_2496:posixwin_scm",(void*)f_2496},
{"f_2671:posixwin_scm",(void*)f_2671},
{"f_2506:posixwin_scm",(void*)f_2506},
{"f_2617:posixwin_scm",(void*)f_2617},
{"f_2661:posixwin_scm",(void*)f_2661},
{"f_2663:posixwin_scm",(void*)f_2663},
{"f_2621:posixwin_scm",(void*)f_2621},
{"f_2653:posixwin_scm",(void*)f_2653},
{"f_2655:posixwin_scm",(void*)f_2655},
{"f_2624:posixwin_scm",(void*)f_2624},
{"f_2650:posixwin_scm",(void*)f_2650},
{"f_2627:posixwin_scm",(void*)f_2627},
{"f_2647:posixwin_scm",(void*)f_2647},
{"f_2630:posixwin_scm",(void*)f_2630},
{"f_2644:posixwin_scm",(void*)f_2644},
{"f_2633:posixwin_scm",(void*)f_2633},
{"f_2641:posixwin_scm",(void*)f_2641},
{"f_2636:posixwin_scm",(void*)f_2636},
{"f_2533:posixwin_scm",(void*)f_2533},
{"f_2539:posixwin_scm",(void*)f_2539},
{"f_2522:posixwin_scm",(void*)f_2522},
{"f_2528:posixwin_scm",(void*)f_2528},
{"f_2517:posixwin_scm",(void*)f_2517},
{"f_2512:posixwin_scm",(void*)f_2512},
{"f_2507:posixwin_scm",(void*)f_2507},
{"f_2323:posixwin_scm",(void*)f_2323},
{"f_2482:posixwin_scm",(void*)f_2482},
{"f_2490:posixwin_scm",(void*)f_2490},
{"f_2330:posixwin_scm",(void*)f_2330},
{"f_2467:posixwin_scm",(void*)f_2467},
{"f_2470:posixwin_scm",(void*)f_2470},
{"f_2471:posixwin_scm",(void*)f_2471},
{"f_2333:posixwin_scm",(void*)f_2333},
{"f_2457:posixwin_scm",(void*)f_2457},
{"f_2340:posixwin_scm",(void*)f_2340},
{"f_2342:posixwin_scm",(void*)f_2342},
{"f_2361:posixwin_scm",(void*)f_2361},
{"f_2443:posixwin_scm",(void*)f_2443},
{"f_2450:posixwin_scm",(void*)f_2450},
{"f_2437:posixwin_scm",(void*)f_2437},
{"f_2376:posixwin_scm",(void*)f_2376},
{"f_2430:posixwin_scm",(void*)f_2430},
{"f_2427:posixwin_scm",(void*)f_2427},
{"f_2417:posixwin_scm",(void*)f_2417},
{"f_2393:posixwin_scm",(void*)f_2393},
{"f_2415:posixwin_scm",(void*)f_2415},
{"f_2401:posixwin_scm",(void*)f_2401},
{"f_2408:posixwin_scm",(void*)f_2408},
{"f_2405:posixwin_scm",(void*)f_2405},
{"f_2388:posixwin_scm",(void*)f_2388},
{"f_2386:posixwin_scm",(void*)f_2386},
{"f_2211:posixwin_scm",(void*)f_2211},
{"f_2217:posixwin_scm",(void*)f_2217},
{"f_2238:posixwin_scm",(void*)f_2238},
{"f_2317:posixwin_scm",(void*)f_2317},
{"f_2242:posixwin_scm",(void*)f_2242},
{"f_2245:posixwin_scm",(void*)f_2245},
{"f_2252:posixwin_scm",(void*)f_2252},
{"f_2254:posixwin_scm",(void*)f_2254},
{"f_2271:posixwin_scm",(void*)f_2271},
{"f_2275:posixwin_scm",(void*)f_2275},
{"f_2283:posixwin_scm",(void*)f_2283},
{"f_2287:posixwin_scm",(void*)f_2287},
{"f_2232:posixwin_scm",(void*)f_2232},
{"f_2054:posixwin_scm",(void*)f_2054},
{"f_2159:posixwin_scm",(void*)f_2159},
{"f_2167:posixwin_scm",(void*)f_2167},
{"f_2154:posixwin_scm",(void*)f_2154},
{"f_2056:posixwin_scm",(void*)f_2056},
{"f_2063:posixwin_scm",(void*)f_2063},
{"f_2066:posixwin_scm",(void*)f_2066},
{"f_2069:posixwin_scm",(void*)f_2069},
{"f_2153:posixwin_scm",(void*)f_2153},
{"f_2073:posixwin_scm",(void*)f_2073},
{"f_2087:posixwin_scm",(void*)f_2087},
{"f_2097:posixwin_scm",(void*)f_2097},
{"f_2109:posixwin_scm",(void*)f_2109},
{"f_2119:posixwin_scm",(void*)f_2119},
{"f_2032:posixwin_scm",(void*)f_2032},
{"f_2052:posixwin_scm",(void*)f_2052},
{"f_2039:posixwin_scm",(void*)f_2039},
{"f_2042:posixwin_scm",(void*)f_2042},
{"f_1986:posixwin_scm",(void*)f_1986},
{"f_1990:posixwin_scm",(void*)f_1990},
{"f_1999:posixwin_scm",(void*)f_1999},
{"f_2002:posixwin_scm",(void*)f_2002},
{"f_1976:posixwin_scm",(void*)f_1976},
{"f_1984:posixwin_scm",(void*)f_1984},
{"f_1966:posixwin_scm",(void*)f_1966},
{"f_1974:posixwin_scm",(void*)f_1974},
{"f_1956:posixwin_scm",(void*)f_1956},
{"f_1964:posixwin_scm",(void*)f_1964},
{"f_1946:posixwin_scm",(void*)f_1946},
{"f_1954:posixwin_scm",(void*)f_1954},
{"f_1936:posixwin_scm",(void*)f_1936},
{"f_1944:posixwin_scm",(void*)f_1944},
{"f_1926:posixwin_scm",(void*)f_1926},
{"f_1934:posixwin_scm",(void*)f_1934},
{"f_1916:posixwin_scm",(void*)f_1916},
{"f_1924:posixwin_scm",(void*)f_1924},
{"f_1817:posixwin_scm",(void*)f_1817},
{"f_1868:posixwin_scm",(void*)f_1868},
{"f_1863:posixwin_scm",(void*)f_1863},
{"f_1819:posixwin_scm",(void*)f_1819},
{"f_1826:posixwin_scm",(void*)f_1826},
{"f_1811:posixwin_scm",(void*)f_1811},
{"f_1815:posixwin_scm",(void*)f_1815},
{"f_1805:posixwin_scm",(void*)f_1805},
{"f_1809:posixwin_scm",(void*)f_1809},
{"f_1799:posixwin_scm",(void*)f_1799},
{"f_1803:posixwin_scm",(void*)f_1803},
{"f_1793:posixwin_scm",(void*)f_1793},
{"f_1797:posixwin_scm",(void*)f_1797},
{"f_1787:posixwin_scm",(void*)f_1787},
{"f_1791:posixwin_scm",(void*)f_1791},
{"f_1752:posixwin_scm",(void*)f_1752},
{"f_1756:posixwin_scm",(void*)f_1756},
{"f_1759:posixwin_scm",(void*)f_1759},
{"f_1708:posixwin_scm",(void*)f_1708},
{"f_1747:posixwin_scm",(void*)f_1747},
{"f_1743:posixwin_scm",(void*)f_1743},
{"f_1736:posixwin_scm",(void*)f_1736},
{"f_1712:posixwin_scm",(void*)f_1712},
{"f_1690:posixwin_scm",(void*)f_1690},
{"f_1694:posixwin_scm",(void*)f_1694},
{"f_1705:posixwin_scm",(void*)f_1705},
{"f_1701:posixwin_scm",(void*)f_1701},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
