/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2009-09-21 21:26
   Version 4.0.1 - SVN rev. 14292
   linux-unix-gnu-x86 [ manyargs dload ptables applyhook ]
   compiled 2009-05-12 on galinha (Linux)
   command line: posixwin.scm -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)	    (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)	    C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)	    C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)	    C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[399];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,51,48,32,108,111,99,51,49,32,109,115,103,51,50,32,46,32,97,114,103,115,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,56,57,32,102,108,97,103,115,57,48,32,46,32,109,111,100,101,57,49,41,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,49,48,53,41,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,49,49,52,32,115,105,122,101,49,49,53,32,46,32,98,117,102,102,101,114,49,49,54,41,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,49,51,52,32,98,117,102,102,101,114,49,51,53,32,46,32,115,105,122,101,49,51,54,41,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,49,53,54,41,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,49,56,56,41,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,50,49,48,32,46,32,116,109,112,50,48,57,50,49,49,41,0,0,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,50,50,55,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,29),40,102,105,108,101,45,109,111,100,105,102,105,99,97,116,105,111,110,45,116,105,109,101,32,102,50,51,50,41,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,50,51,55,41,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,50,52,50,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,50,52,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,50,53,50,41,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,24),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,110,97,109,101,50,53,55,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,50,54,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,17),40,102,95,51,48,51,54,32,102,110,97,109,101,50,55,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,19),40,115,116,97,116,45,116,121,112,101,32,110,97,109,101,50,55,49,41,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,50,56,56,32,112,111,115,50,56,57,32,46,32,119,104,101,110,99,101,50,57,48,41,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,12),40,97,51,49,55,49,32,120,51,54,52,41,0,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,51,52,50,32,46,32,116,109,112,51,52,49,51,52,51,41,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,51,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,52,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,52,50,54,32,115,112,101,99,52,51,54,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,52,51,55,41,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,52,50,57,32,37,115,112,101,99,52,50,52,52,56,51,41,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,52,50,56,41,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,52,49,54,52,49,55,41,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,52,57,56,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,53,49,51,53,49,52,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,20),40,105,115,112,101,114,115,101,32,103,53,53,57,53,54,48,53,54,49,41,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,6),40,115,101,112,63,41,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,7),40,97,51,53,56,57,41,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,19),40,97,51,53,56,51,32,101,120,118,97,114,53,55,51,53,56,57,41,0,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,51,54,48,55,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,7),40,97,51,54,49,57,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,20),40,97,51,54,49,51,32,46,32,97,114,103,115,53,56,50,54,48,55,41,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,7),40,97,51,54,48,49,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,15),40,97,51,53,55,55,32,107,53,56,49,53,56,55,41,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,5),40,99,119,100,41,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,54,51,54,32,114,54,51,55,41};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,24),40,99,97,110,111,110,105,99,97,108,45,112,97,116,104,32,112,97,116,104,54,49,49,41};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,6),40,109,111,100,101,41,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,14),40,98,97,100,109,111,100,101,32,109,54,52,57,41,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,54,53,49,32,105,110,112,54,53,50,32,114,54,53,51,41,0,0,0,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,54,53,57,32,46,32,109,54,54,48,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,54,55,50,32,46,32,109,54,55,51,41};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,54,56,53,41,0,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,52,49,49,55,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,20),40,97,52,49,50,51,32,46,32,114,101,115,117,108,116,115,55,49,50,41,0,0,0,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,55,48,53,32,112,114,111,99,55,48,54,32,46,32,109,111,100,101,55,48,55,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,7),40,97,52,49,52,49,41,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,20),40,97,52,49,52,55,32,46,32,114,101,115,117,108,116,115,55,50,50,41,0,0,0,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,55,49,53,32,112,114,111,99,55,49,54,32,46,32,109,111,100,101,55,49,55,41};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,20),40,97,52,49,54,54,32,46,32,114,101,115,117,108,116,115,55,51,50,41,0,0,0,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,55,50,53,32,116,104,117,110,107,55,50,54,32,46,32,109,111,100,101,55,50,55,41};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,20),40,97,52,49,56,54,32,46,32,114,101,115,117,108,116,115,55,52,52,41,0,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,55,51,55,32,116,104,117,110,107,55,51,56,32,46,32,109,111,100,101,55,51,57,41,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,55,54,48,55,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,56,49,54,41,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,56,49,57,32,112,114,111,99,56,50,48,41,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,56,50,54,32,115,116,97,116,101,56,50,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,57,49,50,32,109,57,49,51,41};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,57,50,54,32,97,99,99,57,50,55,32,108,111,99,57,50,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,51,54,41,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,51,56,41};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,57,52,48,41,0,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,18),40,109,111,100,101,32,105,110,112,57,53,54,32,109,57,53,55,41,0,0,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,25),40,99,104,101,99,107,32,102,100,57,55,53,32,105,110,112,57,55,54,32,114,57,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,57,56,51,32,46,32,109,57,56,52,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,57,56,55,32,46,32,109,57,56,56,41};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,57,57,53,41,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,36),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,49,48,48,53,32,46,32,110,101,119,49,48,48,54,41,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,24),40,115,101,116,101,110,118,32,118,97,114,49,48,49,57,32,118,97,108,49,48,50,48,41};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,18),40,117,110,115,101,116,101,110,118,32,118,97,114,49,48,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,12),40,115,99,97,110,32,106,49,48,53,49,41,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,48,52,53,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,34),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,49,48,54,48,32,116,109,49,48,54,49,41,0,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,30),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,115,101,99,115,49,48,54,56,41,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,28),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,115,101,99,115,49,48,55,51,41,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,26),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,115,101,99,115,49,48,56,54,41,0,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,35),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,49,49,49,54,32,46,32,116,109,112,49,49,49,53,49,49,49,55,41,0,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,28),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,49,52,49,41,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,49,53,56,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,49,54,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,49,55,48,32,109,111,100,101,49,49,55,49,32,46,32,115,105,122,101,49,49,55,50,41,0,0,0,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,7),40,97,52,57,53,50,41,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,102,110,115,49,50,51,53,41,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,55),40,97,52,57,53,56,32,100,105,114,49,50,48,53,49,50,48,54,49,50,49,51,32,102,105,108,49,50,48,55,49,50,48,56,49,50,49,52,32,101,120,116,49,50,48,57,49,50,49,48,49,50,49,53,41,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,21),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,49,50,48,48,41,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,18),40,103,108,111,98,32,46,32,112,97,116,104,115,49,49,57,54,41,0,0,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,56,54,41,0,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,115,45,113,117,111,116,105,110,103,63,32,115,49,50,56,48,41,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,105,108,115,116,49,51,48,48,32,111,108,115,116,49,51,48,49,41};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,37),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,49,50,55,54,32,101,120,97,99,116,102,49,50,55,55,41,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,38),40,115,101,116,97,114,103,32,97,49,51,49,52,49,51,49,56,32,97,49,51,49,51,49,51,49,57,32,97,49,51,49,50,49,51,50,48,41,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,38),40,115,101,116,101,110,118,32,97,49,51,50,54,49,51,51,48,32,97,49,51,50,53,49,51,51,49,32,97,49,51,50,52,49,51,51,50,41,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,24),40,100,111,108,111,111,112,49,51,52,49,32,108,49,51,52,55,32,105,49,51,52,56,41};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,61),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,49,51,51,54,32,108,115,116,49,51,51,55,32,97,114,103,118,101,99,45,115,101,116,116,101,114,49,51,51,56,32,105,100,120,49,51,51,57,41,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,67),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,49,51,53,57,32,102,105,108,101,110,97,109,101,49,51,54,48,32,97,114,103,108,115,116,49,51,54,49,32,101,110,118,108,115,116,49,51,54,50,32,101,120,97,99,116,102,49,51,54,51,41,0,0,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,53),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,49,51,55,52,32,109,115,103,49,51,55,53,32,102,105,108,101,110,97,109,101,49,51,55,54,32,114,101,115,49,51,55,55,41,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,43),40,98,111,100,121,49,52,48,49,32,97,114,103,108,115,116,49,52,49,50,32,101,110,118,108,115,116,49,52,49,51,32,101,120,97,99,116,102,49,52,49,52,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,48),40,100,101,102,45,101,120,97,99,116,102,49,52,48,53,32,37,97,114,103,108,115,116,49,51,57,56,49,52,50,48,32,37,101,110,118,108,115,116,49,51,57,57,49,52,50,49,41};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,32),40,100,101,102,45,101,110,118,108,115,116,49,52,48,52,32,37,97,114,103,108,115,116,49,51,57,56,49,52,50,53,41};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,114,103,108,115,116,49,52,48,51,41};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,51,57,48,32,46,32,116,109,112,49,51,56,57,49,51,57,49,41,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,43),40,98,111,100,121,49,52,54,49,32,97,114,103,108,115,116,49,52,55,50,32,101,110,118,108,115,116,49,52,55,51,32,101,120,97,99,116,102,49,52,55,52,41,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,48),40,100,101,102,45,101,120,97,99,116,102,49,52,54,53,32,37,97,114,103,108,115,116,49,52,53,56,49,52,56,48,32,37,101,110,118,108,115,116,49,52,53,57,49,52,56,49,41};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,32),40,100,101,102,45,101,110,118,108,115,116,49,52,54,52,32,37,97,114,103,108,115,116,49,52,53,56,49,52,56,53,41};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,114,103,108,115,116,49,52,54,51,41};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,51),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,49,52,52,57,32,102,105,108,101,110,97,109,101,49,52,53,48,32,46,32,116,109,112,49,52,52,56,49,52,53,49,41,0,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,53,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,53,50,52,32,46,32,97,114,103,115,49,53,50,53,41,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,53,56,49,32,99,109,100,49,53,56,50,32,97,114,103,115,49,53,56,51,32,101,110,118,49,53,56,52,32,115,116,100,111,117,116,102,49,53,56,53,32,115,116,100,105,110,102,49,53,56,54,32,115,116,100,101,114,114,102,49,53,56,55,32,46,32,116,109,112,49,53,56,48,49,53,56,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,21),40,97,53,54,56,48,32,103,49,54,55,57,49,54,56,48,49,54,56,49,41,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,54,55,50,41,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,7),40,97,53,54,57,56,41,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,38),40,97,53,55,48,52,32,105,110,49,54,57,50,32,111,117,116,49,54,57,51,32,112,105,100,49,54,57,52,32,101,114,114,49,54,57,53,41,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,63),40,37,112,114,111,99,101,115,115,32,108,111,99,49,54,54,52,32,101,114,114,63,49,54,54,53,32,99,109,100,49,54,54,54,32,97,114,103,115,49,54,54,55,32,101,110,118,49,54,54,56,32,101,120,97,99,116,102,49,54,54,57,41,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,55,49,56,32,97,114,103,115,49,55,50,57,32,101,110,118,49,55,51,48,32,101,120,97,99,116,102,49,55,51,49,41,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,55,50,50,32,37,97,114,103,115,49,55,49,53,49,55,51,53,32,37,101,110,118,49,55,49,54,49,55,51,54,41,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,55,50,49,32,37,97,114,103,115,49,55,49,53,49,55,52,48,41,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,55,50,48,41,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,55,48,55,32,46,32,116,109,112,49,55,48,54,49,55,48,56,41,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,55,55,51,32,97,114,103,115,49,55,56,52,32,101,110,118,49,55,56,53,32,101,120,97,99,116,102,49,55,56,54,41,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,55,55,55,32,37,97,114,103,115,49,55,55,48,49,55,57,48,32,37,101,110,118,49,55,55,49,49,55,57,49,41,0,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,55,55,54,32,37,97,114,103,115,49,55,55,48,49,55,57,53,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,55,55,53,41,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,55,54,50,32,46,32,116,109,112,49,55,54,49,49,55,54,51,41};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,56,49,53,32,110,111,104,97,110,103,49,56,49,54,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,97,53,57,50,52,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,36),40,97,53,57,51,48,32,101,112,105,100,49,56,51,56,32,101,110,111,114,109,49,56,51,57,32,101,99,111,100,101,49,56,52,48,41,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,56,49,57,32,46,32,97,114,103,115,49,56,50,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,13),40,115,108,101,101,112,32,116,49,56,52,53,41,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,14),40,102,95,54,49,52,53,32,120,49,57,49,50,41,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,97,54,48,57,49,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,7),40,97,54,48,57,54,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,54,49,49,48,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,19),40,108,111,111,112,32,102,115,49,57,49,56,32,114,49,57,49,57,41,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,16),40,102,95,54,49,54,49,32,46,32,95,49,57,48,56,41};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,16),40,102,95,54,49,53,51,32,46,32,95,49,57,48,54,41};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,56,56,48,32,97,99,116,105,111,110,49,56,57,49,32,105,100,49,56,57,50,32,108,105,109,105,116,49,56,57,51,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,108,105,109,105,116,49,56,56,52,32,37,97,99,116,105,111,110,49,56,55,55,49,57,53,57,32,37,105,100,49,56,55,56,49,57,54,48,41,0,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,28),40,100,101,102,45,105,100,49,56,56,51,32,37,97,99,116,105,111,110,49,56,55,55,49,57,54,52,41,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,19),40,97,54,49,56,49,32,120,49,57,54,57,32,121,49,57,55,48,41,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,99,116,105,111,110,49,56,56,50,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,51),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,49,56,54,56,32,112,114,101,100,49,56,54,57,32,46,32,97,99,116,105,111,110,45,105,100,45,108,105,109,105,116,49,56,55,48,41,0,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,50,48,50,53,50,48,50,57,41,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,50,48,51,52,50,48,51,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,50,48,52,50,50,48,52,54,41,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,50,48,53,48,50,48,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,50,48,53,56,50,48,54,50,41};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,50,48,54,54,50,48,55,48,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,50,48,55,52,50,48,55,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,50,48,56,50,50,48,56,54,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,50,48,57,48,50,48,57,52,41,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,32),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,46,32,95,50,48,57,56,50,49,48,50,41};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,50,49,48,54,50,49,49,48,41,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,50,49,49,52,50,49,49,56,41,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,50,49,50,50,50,49,50,54,41};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,50,49,51,48,50,49,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,50,49,51,56,50,49,52,50,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,50,49,52,54,50,49,53,48,41,0,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,50,49,53,52,50,49,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,50,49,54,50,50,49,54,54,41};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,50,49,55,48,50,49,55,52,41,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,50,49,55,56,50,49,56,50,41,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,40),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,46,32,95,50,49,56,54,50,49,57,48,41};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,50,49,57,52,50,49,57,56,41,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,50,50,48,50,50,50,48,54,41,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,50,50,49,48,50,50,49,52,41,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,50,50,49,56,50,50,50,50,41,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,50,50,50,54,50,50,51,48,41};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,50,50,51,52,50,50,51,56,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,50,50,52,50,50,50,52,54,41,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,50,50,53,48,50,50,53,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,50,50,53,56,50,50,54,50,41,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,50,50,54,54,50,50,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,50,50,55,52,50,50,55,56,41,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,50,50,56,50,50,50,56,54,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,50,50,57,48,50,50,57,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,50,50,57,56,50,51,48,50,41,0,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,50,51,48,54,50,51,49,48,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,50,51,49,52,50,51,49,56,41,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,50,51,50,50,50,51,50,54,41,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,46,32,95,50,51,51,48,50,51,51,52,41,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,36),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,46,32,95,50,51,51,56,50,51,52,50,41,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,50,51,52,54,50,51,53,48,41,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,50,51,53,52,50,51,53,56,41,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,50,51,54,50,50,51,54,54,41,0,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,50,51,55,49,41,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,95,50,51,55,53,41,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,15),40,97,54,53,50,53,32,112,111,114,116,51,49,50,41,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k5519 */
static C_word C_fcall stub1542(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub1542(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from current-process-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall stub1502(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1502(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k5151 */
static C_word C_fcall stub1327(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1327(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k5134 */
static C_word C_fcall stub1315(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1315(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4848 */
static C_word C_fcall stub1153(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1153(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1145(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1145(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub1102(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1102(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub1094(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1094(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k4721 */
static C_word C_fcall stub1079(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1079(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k4608 */
static C_word C_fcall stub1035(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1035(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k2668 */
static C_word C_fcall stub23(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub23(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2644)
static void C_ccall f_2644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2650)
static void C_ccall f_2650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2653)
static void C_ccall f_2653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2659)
static void C_ccall f_2659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3049)
static void C_ccall f_3049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3053)
static void C_ccall f_3053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3057)
static void C_ccall f_3057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3061)
static void C_ccall f_3061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3069)
static void C_ccall f_3069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3073)
static void C_ccall f_3073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3077)
static void C_ccall f_3077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3081)
static void C_ccall f_3081(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6526)
static void C_ccall f_6526(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6545)
static void C_ccall f_6545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6530)
static void C_ccall f_6530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6539)
static void C_ccall f_6539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6533)
static void C_ccall f_6533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3146)
static void C_ccall f_3146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4271)
static void C_ccall f_4271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6507)
static void C_ccall f_6507(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6504)
static void C_ccall f_6504(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6497)
static void C_ccall f_6497(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6491)
static void C_ccall f_6491(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6485)
static void C_ccall f_6485(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6479)
static void C_ccall f_6479(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6473)
static void C_ccall f_6473(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6467)
static void C_ccall f_6467(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6461)
static void C_ccall f_6461(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6455)
static void C_ccall f_6455(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6449)
static void C_ccall f_6449(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6443)
static void C_ccall f_6443(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6437)
static void C_ccall f_6437(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6431)
static void C_ccall f_6431(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6425)
static void C_ccall f_6425(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6419)
static void C_ccall f_6419(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6413)
static void C_ccall f_6413(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6407)
static void C_ccall f_6407(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6401)
static void C_ccall f_6401(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6395)
static void C_ccall f_6395(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6389)
static void C_ccall f_6389(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6383)
static void C_ccall f_6383(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6377)
static void C_ccall f_6377(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6371)
static void C_ccall f_6371(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6365)
static void C_ccall f_6365(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6359)
static void C_ccall f_6359(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6353)
static void C_ccall f_6353(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6347)
static void C_ccall f_6347(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6341)
static void C_ccall f_6341(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6335)
static void C_ccall f_6335(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6329)
static void C_ccall f_6329(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6323)
static void C_ccall f_6323(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6317)
static void C_ccall f_6317(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6311)
static void C_ccall f_6311(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6305)
static void C_ccall f_6305(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6299)
static void C_ccall f_6299(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6293)
static void C_ccall f_6293(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6287)
static void C_ccall f_6287(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6281)
static void C_ccall f_6281(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6275)
static void C_ccall f_6275(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6269)
static void C_ccall f_6269(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6263)
static void C_ccall f_6263(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6257)
static void C_ccall f_6257(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6251)
static void C_ccall f_6251(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6245)
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6025)
static void C_ccall f_6025(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6025)
static void C_ccall f_6025r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6176)
static void C_fcall f_6176(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6182)
static void C_ccall f_6182(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6171)
static void C_fcall f_6171(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6166)
static void C_fcall f_6166(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6027)
static void C_fcall f_6027(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6153)
static void C_ccall f_6153(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6161)
static void C_ccall f_6161(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6034)
static void C_fcall f_6034(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6141)
static void C_ccall f_6141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6044)
static void C_ccall f_6044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6046)
static void C_fcall f_6046(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6065)
static void C_ccall f_6065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6127)
static void C_ccall f_6127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6134)
static void C_ccall f_6134(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6121)
static void C_ccall f_6121(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6080)
static void C_ccall f_6080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6111)
static void C_ccall f_6111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6097)
static void C_ccall f_6097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6109)
static void C_ccall f_6109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6105)
static void C_ccall f_6105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6092)
static void C_ccall f_6092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6090)
static void C_ccall f_6090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6145)
static void C_ccall f_6145(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6010)
static void C_ccall f_6010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6020)
static void C_ccall f_6020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5979)
static void C_ccall f_5979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6005)
static void C_ccall f_6005(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5990)
static void C_ccall f_5990(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5994)
static void C_ccall f_5994(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5998)
static void C_ccall f_5998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6002)
static void C_ccall f_6002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5967)
static void C_ccall f_5967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5964)
static void C_ccall f_5964(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5904)
static void C_ccall f_5904(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5904)
static void C_ccall f_5904r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5931)
static void C_ccall f_5931(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5941)
static void C_ccall f_5941(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5925)
static void C_ccall f_5925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5892)
static void C_ccall f_5892(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5812)
static void C_ccall f_5812(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5812)
static void C_ccall f_5812r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5829)
static void C_fcall f_5829(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5824)
static void C_fcall f_5824(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5819)
static void C_fcall f_5819(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5814)
static void C_fcall f_5814(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5732)
static void C_ccall f_5732(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5732)
static void C_ccall f_5732r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5749)
static void C_fcall f_5749(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5744)
static void C_fcall f_5744(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5739)
static void C_fcall f_5739(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5734)
static void C_fcall f_5734(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5670)
static void C_fcall f_5670(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5726)
static void C_ccall f_5726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5730)
static void C_ccall f_5730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5691)
static void C_ccall f_5691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5694)
static void C_ccall f_5694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5705)
static void C_ccall f_5705(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5699)
static void C_ccall f_5699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5672)
static void C_fcall f_5672(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5681)
static void C_ccall f_5681(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5551)
static void C_ccall f_5551(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_5551)
static void C_ccall f_5551r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5646)
static void C_ccall f_5646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5558)
static void C_ccall f_5558(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5614)
static void C_ccall f_5614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5618)
static void C_ccall f_5618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5622)
static void C_ccall f_5622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5626)
static void C_ccall f_5626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5630)
static void C_ccall f_5630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5493)
static void C_ccall f_5493(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5497)
static void C_ccall f_5497(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5607)
static void C_ccall f_5607(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5587)
static void C_ccall f_5587(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5591)
static void C_ccall f_5591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5595)
static void C_ccall f_5595(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5459)
static void C_ccall f_5459(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5459)
static void C_ccall f_5459r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5476)
static void C_ccall f_5476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5480)
static void C_ccall f_5480(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5453)
static void C_ccall f_5453(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5432)
static void C_ccall f_5432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5436)
static void C_ccall f_5436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5448)
static void C_ccall f_5448(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5429)
static void C_ccall f_5429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5342)
static void C_ccall f_5342(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5342)
static void C_ccall f_5342r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5366)
static void C_fcall f_5366(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5361)
static void C_fcall f_5361(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5356)
static void C_fcall f_5356(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5344)
static void C_fcall f_5344(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5348)
static void C_ccall f_5348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5255)
static void C_ccall f_5255(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5255)
static void C_ccall f_5255r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5279)
static void C_fcall f_5279(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5274)
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5269)
static void C_fcall f_5269(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5257)
static void C_fcall f_5257(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5261)
static void C_ccall f_5261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5240)
static void C_fcall f_5240(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5244)
static void C_ccall f_5244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5207)
static void C_fcall f_5207(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5214)
static void C_ccall f_5214(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5217)
static void C_ccall f_5217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5234)
static void C_ccall f_5234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5220)
static void C_ccall f_5220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5223)
static void C_ccall f_5223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5230)
static void C_ccall f_5230(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5157)
static void C_fcall f_5157(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5169)
static void C_fcall f_5169(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5188)
static void C_ccall f_5188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5140)
static void C_ccall f_5140(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5123)
static void C_ccall f_5123(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5044)
static void C_fcall f_5044(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5087)
static void C_fcall f_5087(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5118)
static void C_ccall f_5118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5115)
static void C_ccall f_5115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5049)
static void C_fcall f_5049(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5058)
static void C_fcall f_5058(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5071)
static void C_ccall f_5071(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4932)
static void C_ccall f_4932(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4932)
static void C_ccall f_4932r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4938)
static void C_fcall f_4938(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4959)
static void C_ccall f_4959(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5033)
static void C_ccall f_5033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4963)
static void C_ccall f_4963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4966)
static void C_ccall f_4966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4973)
static void C_ccall f_4973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4975)
static void C_fcall f_4975(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4992)
static void C_ccall f_4992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5002)
static void C_ccall f_5002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5006)
static void C_ccall f_5006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4953)
static void C_ccall f_4953(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4877)
static void C_ccall f_4877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4883)
static void C_ccall f_4883(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4867)
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4871)
static void C_ccall f_4871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4851)
static void C_ccall f_4851(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4851)
static void C_ccall f_4851r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4839)
static void C_ccall f_4839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4824)
static void C_ccall f_4824(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4828)
static void C_ccall f_4828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4757)
static void C_ccall f_4757(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4757)
static void C_ccall f_4757r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4761)
static void C_ccall f_4761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4764)
static void C_ccall f_4764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4786)
static void C_ccall f_4786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4783)
static void C_ccall f_4783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4773)
static void C_ccall f_4773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4724)
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4728)
static void C_ccall f_4728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4705)
static void C_ccall f_4705(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4696)
static void C_ccall f_4696(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4677)
static void C_fcall f_4677(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4611)
static void C_ccall f_4611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4617)
static void C_fcall f_4617(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4621)
static void C_ccall f_4621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4629)
static void C_fcall f_4629(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4655)
static void C_ccall f_4655(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4647)
static void C_ccall f_4647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4591)
static void C_ccall f_4591(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4599)
static void C_ccall f_4599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4574)
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4585)
static void C_ccall f_4585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4589)
static void C_ccall f_4589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4544)
static void C_ccall f_4544(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4544)
static void C_ccall f_4544r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4551)
static void C_fcall f_4551(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4560)
static void C_ccall f_4560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4554)
static void C_ccall f_4554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4509)
static void C_ccall f_4509(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4513)
static void C_ccall f_4513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4542)
static void C_ccall f_4542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4528)
static void C_ccall f_4528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4522)
static void C_ccall f_4522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4495)
static void C_ccall f_4495(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4495)
static void C_ccall f_4495r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4507)
static void C_ccall f_4507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4481)
static void C_ccall f_4481(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4481)
static void C_ccall f_4481r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4493)
static void C_ccall f_4493(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4463)
static void C_fcall f_4463(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4467)
static void C_ccall f_4467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4479)
static void C_ccall f_4479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4426)
static void C_fcall f_4426(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4434)
static void C_ccall f_4434(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4417)
static void C_ccall f_4417(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4411)
static void C_ccall f_4411(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4405)
static void C_ccall f_4405(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4381)
static void C_fcall f_4381(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4403)
static void C_ccall f_4403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4399)
static void C_ccall f_4399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4351)
static void C_ccall f_4351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4379)
static void C_ccall f_4379(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4375)
static void C_ccall f_4375(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4367)
static void C_ccall f_4367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4295)
static void C_ccall f_4295(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4305)
static void C_ccall f_4305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4273)
static void C_ccall f_4273(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4201)
static void C_ccall f_4201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4213)
static void C_ccall f_4213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4204)
static void C_ccall f_4204(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4177)
static void C_ccall f_4177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4177)
static void C_ccall f_4177r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4181)
static void C_ccall f_4181(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4187)
static void C_ccall f_4187(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4187)
static void C_ccall f_4187r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4191)
static void C_ccall f_4191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4157)
static void C_ccall f_4157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4157)
static void C_ccall f_4157r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4161)
static void C_ccall f_4161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4167)
static void C_ccall f_4167(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4167)
static void C_ccall f_4167r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4171)
static void C_ccall f_4171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4137)
static void C_ccall f_4137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4152)
static void C_ccall f_4152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4142)
static void C_ccall f_4142(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4109)
static void C_ccall f_4109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4109)
static void C_ccall f_4109r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4113)
static void C_ccall f_4113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4124)
static void C_ccall f_4124(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4124)
static void C_ccall f_4124r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4128)
static void C_ccall f_4128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4090)
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4094)
static void C_ccall f_4094(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4097)
static void C_ccall f_4097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4054)
static void C_ccall f_4054(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4054)
static void C_ccall f_4054r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4085)
static void C_ccall f_4085(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4075)
static void C_ccall f_4075(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4068)
static void C_ccall f_4068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4039)
static void C_ccall f_4039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4032)
static void C_ccall f_4032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4000)
static void C_fcall f_4000(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4004)
static void C_ccall f_4004(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4016)
static void C_ccall f_4016(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3994)
static void C_fcall f_3994(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3982)
static C_word C_fcall f_3982(C_word t0);
C_noret_decl(f_3625)
static void C_ccall f_3625(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3771)
static void C_fcall f_3771(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3958)
static void C_ccall f_3958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3947)
static void C_ccall f_3947(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3954)
static void C_ccall f_3954(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3801)
static void C_fcall f_3801(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3940)
static void C_ccall f_3940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3919)
static void C_ccall f_3919(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3936)
static void C_ccall f_3936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3925)
static void C_ccall f_3925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3932)
static void C_ccall f_3932(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3843)
static void C_fcall f_3843(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3916)
static void C_ccall f_3916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3895)
static void C_ccall f_3895(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3912)
static void C_ccall f_3912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3901)
static void C_ccall f_3901(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3908)
static void C_ccall f_3908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3849)
static void C_ccall f_3849(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3892)
static void C_ccall f_3892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3888)
static void C_ccall f_3888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3881)
static void C_ccall f_3881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3877)
static void C_ccall f_3877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3856)
static void C_ccall f_3856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3860)
static void C_ccall f_3860(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3837)
static void C_ccall f_3837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3824)
static void C_ccall f_3824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3808)
static void C_ccall f_3808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3812)
static void C_ccall f_3812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3816)
static void C_ccall f_3816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3795)
static void C_ccall f_3795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3782)
static void C_ccall f_3782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3778)
static void C_ccall f_3778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3765)
static void C_ccall f_3765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3632)
static void C_ccall f_3632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3751)
static void C_ccall f_3751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3639)
static void C_ccall f_3639(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3641)
static void C_fcall f_3641(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3648)
static void C_ccall f_3648(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3723)
static void C_ccall f_3723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3732)
static void C_ccall f_3732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3720)
static void C_fcall f_3720(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3654)
static void C_ccall f_3654(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3701)
static void C_ccall f_3701(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3697)
static void C_ccall f_3697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3670)
static void C_ccall f_3670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3678)
static void C_ccall f_3678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3674)
static void C_ccall f_3674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3569)
static void C_fcall f_3569(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3578)
static void C_ccall f_3578(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3602)
static void C_ccall f_3602(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3614)
static void C_ccall f_3614(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3614)
static void C_ccall f_3614r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3620)
static void C_ccall f_3620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3608)
static void C_ccall f_3608(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3584)
static void C_ccall f_3584(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3590)
static void C_ccall f_3590(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3576)
static void C_ccall f_3576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3558)
static C_word C_fcall f_3558(C_word t0);
C_noret_decl(f_3553)
static void C_fcall f_3553(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3502)
static void C_ccall f_3502(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3502)
static void C_ccall f_3502r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3506)
static void C_ccall f_3506(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3515)
static void C_ccall f_3515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3518)
static void C_ccall f_3518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3475)
static void C_ccall f_3475(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3500)
static void C_ccall f_3500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3496)
static void C_ccall f_3496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3482)
static void C_ccall f_3482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3423)
static void C_fcall f_3423(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3431)
static void C_ccall f_3431(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3418)
static void C_fcall f_3418(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3317)
static void C_fcall f_3317(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3324)
static void C_ccall f_3324(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3330)
static void C_ccall f_3330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3417)
static void C_ccall f_3417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3334)
static void C_ccall f_3334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3351)
static void C_fcall f_3351(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3361)
static void C_ccall f_3361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3373)
static void C_fcall f_3373(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3383)
static void C_ccall f_3383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3343)
static void C_ccall f_3343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3288)
static void C_ccall f_3288(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3313)
static void C_ccall f_3313(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3309)
static void C_ccall f_3309(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3301)
static void C_ccall f_3301(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3261)
static void C_ccall f_3261(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3286)
static void C_ccall f_3286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3274)
static void C_ccall f_3274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3148)
static void C_ccall f_3148(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3148)
static void C_ccall f_3148r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3152)
static void C_ccall f_3152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3240)
static void C_ccall f_3240(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3232)
static void C_ccall f_3232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3161)
static void C_ccall f_3161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3164)
static void C_ccall f_3164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3172)
static void C_ccall f_3172(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3177)
static void C_ccall f_3177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3203)
static void C_ccall f_3203(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3183)
static void C_fcall f_3183(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3200)
static void C_ccall f_3200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3192)
static void C_ccall f_3192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3083)
static void C_ccall f_3083(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3083)
static void C_ccall f_3083r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3096)
static void C_ccall f_3096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3111)
static void C_ccall f_3111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3102)
static void C_ccall f_3102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3105)
static void C_ccall f_3105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3034)
static void C_fcall f_3034(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3036)
static void C_ccall f_3036(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3029)
static void C_ccall f_3029(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3006)
static void C_ccall f_3006(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3027)
static void C_ccall f_3027(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3013)
static void C_ccall f_3013(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3004)
static void C_ccall f_3004(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2994)
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2998)
static void C_ccall f_2998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2988)
static void C_ccall f_2988(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2982)
static void C_ccall f_2982(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2986)
static void C_ccall f_2986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2976)
static void C_ccall f_2976(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2970)
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2974)
static void C_ccall f_2974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2939)
static void C_ccall f_2939(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2939)
static void C_ccall f_2939r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2946)
static void C_ccall f_2946(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2901)
static void C_fcall f_2901(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2934)
static void C_ccall f_2934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2930)
static void C_ccall f_2930(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2905)
static void C_ccall f_2905(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2914)
static void C_ccall f_2914(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2863)
static void C_ccall f_2863(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2873)
static void C_ccall f_2873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2893)
static void C_ccall f_2893(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2876)
static void C_ccall f_2876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2883)
static void C_ccall f_2883(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2821)
static void C_ccall f_2821(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2821)
static void C_ccall f_2821r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2828)
static void C_ccall f_2828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2837)
static void C_ccall f_2837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2776)
static void C_ccall f_2776(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2776)
static void C_ccall f_2776r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2786)
static void C_ccall f_2786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2789)
static void C_ccall f_2789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2801)
static void C_ccall f_2801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2792)
static void C_ccall f_2792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2758)
static void C_ccall f_2758(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2717)
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2717)
static void C_ccall f_2717r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2750)
static void C_ccall f_2750(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2734)
static void C_ccall f_2734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2743)
static void C_ccall f_2743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2737)
static void C_ccall f_2737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2671)
static void C_ccall f_2671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2671)
static void C_ccall f_2671r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_2675)
static void C_ccall f_2675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2682)
static void C_ccall f_2682(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_6176)
static void C_fcall trf_6176(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6176(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6176(t0,t1);}

C_noret_decl(trf_6171)
static void C_fcall trf_6171(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6171(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6171(t0,t1,t2);}

C_noret_decl(trf_6166)
static void C_fcall trf_6166(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6166(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6166(t0,t1,t2,t3);}

C_noret_decl(trf_6027)
static void C_fcall trf_6027(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6027(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6027(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6034)
static void C_fcall trf_6034(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6034(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6034(t0,t1);}

C_noret_decl(trf_6046)
static void C_fcall trf_6046(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6046(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6046(t0,t1,t2,t3);}

C_noret_decl(trf_5829)
static void C_fcall trf_5829(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5829(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5829(t0,t1);}

C_noret_decl(trf_5824)
static void C_fcall trf_5824(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5824(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5824(t0,t1,t2);}

C_noret_decl(trf_5819)
static void C_fcall trf_5819(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5819(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5819(t0,t1,t2,t3);}

C_noret_decl(trf_5814)
static void C_fcall trf_5814(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5814(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5814(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5749)
static void C_fcall trf_5749(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5749(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5749(t0,t1);}

C_noret_decl(trf_5744)
static void C_fcall trf_5744(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5744(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5744(t0,t1,t2);}

C_noret_decl(trf_5739)
static void C_fcall trf_5739(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5739(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5739(t0,t1,t2,t3);}

C_noret_decl(trf_5734)
static void C_fcall trf_5734(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5734(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5734(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5670)
static void C_fcall trf_5670(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5670(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5670(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5672)
static void C_fcall trf_5672(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5672(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5672(t0,t1,t2);}

C_noret_decl(trf_5366)
static void C_fcall trf_5366(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5366(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5366(t0,t1);}

C_noret_decl(trf_5361)
static void C_fcall trf_5361(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5361(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5361(t0,t1,t2);}

C_noret_decl(trf_5356)
static void C_fcall trf_5356(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5356(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5356(t0,t1,t2,t3);}

C_noret_decl(trf_5344)
static void C_fcall trf_5344(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5344(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5344(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5279)
static void C_fcall trf_5279(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5279(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5279(t0,t1);}

C_noret_decl(trf_5274)
static void C_fcall trf_5274(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5274(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5274(t0,t1,t2);}

C_noret_decl(trf_5269)
static void C_fcall trf_5269(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5269(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5269(t0,t1,t2,t3);}

C_noret_decl(trf_5257)
static void C_fcall trf_5257(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5257(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5257(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5240)
static void C_fcall trf_5240(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5240(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5240(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5207)
static void C_fcall trf_5207(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5207(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5207(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5157)
static void C_fcall trf_5157(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5157(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5157(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5169)
static void C_fcall trf_5169(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5169(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5169(t0,t1,t2,t3);}

C_noret_decl(trf_5044)
static void C_fcall trf_5044(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5044(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5044(t0,t1,t2,t3);}

C_noret_decl(trf_5087)
static void C_fcall trf_5087(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5087(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5087(t0,t1,t2,t3);}

C_noret_decl(trf_5049)
static void C_fcall trf_5049(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5049(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5049(t0,t1,t2);}

C_noret_decl(trf_5058)
static void C_fcall trf_5058(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5058(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5058(t0,t1,t2);}

C_noret_decl(trf_4938)
static void C_fcall trf_4938(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4938(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4938(t0,t1,t2);}

C_noret_decl(trf_4975)
static void C_fcall trf_4975(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4975(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4975(t0,t1,t2);}

C_noret_decl(trf_4677)
static void C_fcall trf_4677(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4677(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4677(t0,t1,t2);}

C_noret_decl(trf_4617)
static void C_fcall trf_4617(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4617(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4617(t0,t1,t2);}

C_noret_decl(trf_4629)
static void C_fcall trf_4629(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4629(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4629(t0,t1,t2);}

C_noret_decl(trf_4551)
static void C_fcall trf_4551(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4551(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4551(t0,t1);}

C_noret_decl(trf_4463)
static void C_fcall trf_4463(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4463(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4463(t0,t1,t2,t3);}

C_noret_decl(trf_4426)
static void C_fcall trf_4426(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4426(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4426(t0,t1,t2);}

C_noret_decl(trf_4381)
static void C_fcall trf_4381(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4381(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4381(t0,t1,t2,t3);}

C_noret_decl(trf_4000)
static void C_fcall trf_4000(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4000(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4000(t0,t1,t2,t3);}

C_noret_decl(trf_3994)
static void C_fcall trf_3994(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3994(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3994(t0,t1);}

C_noret_decl(trf_3771)
static void C_fcall trf_3771(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3771(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3771(t0,t1);}

C_noret_decl(trf_3801)
static void C_fcall trf_3801(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3801(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3801(t0,t1);}

C_noret_decl(trf_3843)
static void C_fcall trf_3843(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3843(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3843(t0,t1);}

C_noret_decl(trf_3641)
static void C_fcall trf_3641(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3641(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3641(t0,t1,t2,t3);}

C_noret_decl(trf_3720)
static void C_fcall trf_3720(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3720(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3720(t0,t1);}

C_noret_decl(trf_3569)
static void C_fcall trf_3569(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3569(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3569(t0,t1);}

C_noret_decl(trf_3553)
static void C_fcall trf_3553(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3553(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3553(t0,t1);}

C_noret_decl(trf_3423)
static void C_fcall trf_3423(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3423(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3423(t0,t1);}

C_noret_decl(trf_3418)
static void C_fcall trf_3418(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3418(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3418(t0,t1,t2);}

C_noret_decl(trf_3317)
static void C_fcall trf_3317(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3317(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3317(t0,t1,t2,t3);}

C_noret_decl(trf_3351)
static void C_fcall trf_3351(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3351(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3351(t0,t1);}

C_noret_decl(trf_3373)
static void C_fcall trf_3373(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3373(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3373(t0,t1);}

C_noret_decl(trf_3183)
static void C_fcall trf_3183(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3183(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3183(t0,t1);}

C_noret_decl(trf_3034)
static void C_fcall trf_3034(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3034(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3034(t0,t1);}

C_noret_decl(trf_2901)
static void C_fcall trf_2901(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2901(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2901(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3130)){
C_save(t1);
C_rereclaim2(3130*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,399);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],15,"\003sysposix-error");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"open/rdonly");
lf[13]=C_h_intern(&lf[13],11,"open/wronly");
lf[14]=C_h_intern(&lf[14],9,"open/rdwr");
lf[15]=C_h_intern(&lf[15],9,"open/read");
lf[16]=C_h_intern(&lf[16],10,"open/write");
lf[17]=C_h_intern(&lf[17],10,"open/creat");
lf[18]=C_h_intern(&lf[18],11,"open/append");
lf[19]=C_h_intern(&lf[19],9,"open/excl");
lf[20]=C_h_intern(&lf[20],10,"open/trunc");
lf[21]=C_h_intern(&lf[21],11,"open/binary");
lf[22]=C_h_intern(&lf[22],9,"open/text");
lf[23]=C_h_intern(&lf[23],14,"open/noinherit");
lf[24]=C_h_intern(&lf[24],10,"perm/irusr");
lf[25]=C_h_intern(&lf[25],10,"perm/iwusr");
lf[26]=C_h_intern(&lf[26],10,"perm/ixusr");
lf[27]=C_h_intern(&lf[27],10,"perm/irgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iwgrp");
lf[29]=C_h_intern(&lf[29],10,"perm/ixgrp");
lf[30]=C_h_intern(&lf[30],10,"perm/iroth");
lf[31]=C_h_intern(&lf[31],10,"perm/iwoth");
lf[32]=C_h_intern(&lf[32],10,"perm/ixoth");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxu");
lf[34]=C_h_intern(&lf[34],10,"perm/irwxg");
lf[35]=C_h_intern(&lf[35],10,"perm/irwxo");
lf[36]=C_h_intern(&lf[36],9,"file-open");
lf[37]=C_h_intern(&lf[37],11,"\000file-error");
lf[38]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[39]=C_h_intern(&lf[39],17,"\003sysmake-c-string");
lf[40]=C_h_intern(&lf[40],20,"\003sysexpand-home-path");
lf[41]=C_h_intern(&lf[41],10,"file-close");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[43]=C_h_intern(&lf[43],11,"make-string");
lf[44]=C_h_intern(&lf[44],9,"file-read");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[46]=C_h_intern(&lf[46],11,"\000type-error");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[48]=C_h_intern(&lf[48],10,"file-write");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[51]=C_h_intern(&lf[51],13,"string-length");
lf[52]=C_h_intern(&lf[52],12,"file-mkstemp");
lf[53]=C_h_intern(&lf[53],13,"\003syssubstring");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[55]=C_h_intern(&lf[55],8,"seek/set");
lf[56]=C_h_intern(&lf[56],8,"seek/end");
lf[57]=C_h_intern(&lf[57],8,"seek/cur");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[61]=C_h_intern(&lf[61],9,"file-stat");
lf[62]=C_h_intern(&lf[62],9,"\003syserror");
lf[63]=C_h_intern(&lf[63],9,"file-size");
lf[64]=C_h_intern(&lf[64],22,"file-modification-time");
lf[65]=C_h_intern(&lf[65],16,"file-access-time");
lf[66]=C_h_intern(&lf[66],16,"file-change-time");
lf[67]=C_h_intern(&lf[67],10,"file-owner");
lf[68]=C_h_intern(&lf[68],16,"file-permissions");
lf[69]=C_h_intern(&lf[69],13,"regular-file\077");
lf[70]=C_h_intern(&lf[70],13,"\003sysfile-info");
lf[71]=C_h_intern(&lf[71],14,"symbolic-link\077");
lf[72]=C_h_intern(&lf[72],13,"stat-regular\077");
lf[73]=C_h_intern(&lf[73],15,"stat-directory\077");
lf[74]=C_h_intern(&lf[74],12,"stat-device\077");
lf[75]=C_h_intern(&lf[75],17,"character-device\077");
lf[76]=C_h_intern(&lf[76],13,"block-device\077");
lf[77]=C_h_intern(&lf[77],18,"stat-block-device\077");
lf[78]=C_h_intern(&lf[78],10,"stat-fifo\077");
lf[79]=C_h_intern(&lf[79],5,"fifo\077");
lf[80]=C_h_intern(&lf[80],13,"stat-symlink\077");
lf[81]=C_h_intern(&lf[81],7,"socket\077");
lf[82]=C_h_intern(&lf[82],12,"stat-socket\077");
lf[83]=C_h_intern(&lf[83],18,"set-file-position!");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[85]=C_h_intern(&lf[85],6,"stream");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[87]=C_h_intern(&lf[87],5,"port\077");
lf[88]=C_h_intern(&lf[88],13,"\000bounds-error");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[90]=C_h_intern(&lf[90],13,"file-position");
lf[91]=C_h_intern(&lf[91],16,"create-directory");
lf[92]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[93]=C_h_intern(&lf[93],12,"file-exists\077");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[95]=C_h_intern(&lf[95],12,"\003sysfor-each");
lf[96]=C_h_intern(&lf[96],12,"string-split");
lf[97]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[98]=C_h_intern(&lf[98],14,"canonical-path");
lf[99]=C_h_intern(&lf[99],16,"change-directory");
lf[100]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[101]=C_h_intern(&lf[101],16,"delete-directory");
lf[102]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[103]=C_h_intern(&lf[103],6,"string");
lf[104]=C_h_intern(&lf[104],9,"directory");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[106]=C_h_intern(&lf[106],16,"\003sysmake-pointer");
lf[107]=C_h_intern(&lf[107],17,"current-directory");
lf[108]=C_h_intern(&lf[108],10,"directory\077");
lf[109]=C_h_intern(&lf[109],27,"\003sysplatform-fixup-pathname");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[111]=C_h_intern(&lf[111],5,"null\077");
lf[112]=C_h_intern(&lf[112],6,"char=\077");
lf[113]=C_h_intern(&lf[113],8,"string=\077");
lf[114]=C_h_intern(&lf[114],16,"char-alphabetic\077");
lf[115]=C_h_intern(&lf[115],10,"string-ref");
lf[116]=C_h_intern(&lf[116],18,"string-intersperse");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[118]=C_h_intern(&lf[118],17,"current-user-name");
lf[119]=C_h_intern(&lf[119],9,"condition");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\003c:\134");
lf[121]=C_h_intern(&lf[121],22,"with-exception-handler");
lf[122]=C_h_intern(&lf[122],30,"call-with-current-continuation");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[124]=C_h_intern(&lf[124],7,"reverse");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[127]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[130]=C_decode_literal(C_heaptop,"\376B\000\000\027Documents and Settings\134");
lf[131]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[134]=C_h_intern(&lf[134],5,"\000text");
lf[135]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[137]=C_h_intern(&lf[137],13,"\003sysmake-port");
lf[138]=C_h_intern(&lf[138],21,"\003sysstream-port-class");
lf[139]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[140]=C_h_intern(&lf[140],15,"open-input-pipe");
lf[141]=C_h_intern(&lf[141],7,"\000binary");
lf[142]=C_h_intern(&lf[142],16,"open-output-pipe");
lf[143]=C_h_intern(&lf[143],16,"close-input-pipe");
lf[144]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[145]=C_h_intern(&lf[145],14,"\003syscheck-port");
lf[146]=C_h_intern(&lf[146],17,"close-output-pipe");
lf[147]=C_h_intern(&lf[147],20,"call-with-input-pipe");
lf[148]=C_h_intern(&lf[148],21,"call-with-output-pipe");
lf[149]=C_h_intern(&lf[149],20,"with-input-from-pipe");
lf[150]=C_h_intern(&lf[150],18,"\003sysstandard-input");
lf[151]=C_h_intern(&lf[151],19,"with-output-to-pipe");
lf[152]=C_h_intern(&lf[152],19,"\003sysstandard-output");
lf[153]=C_h_intern(&lf[153],11,"create-pipe");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[155]=C_h_intern(&lf[155],11,"signal/term");
lf[156]=C_h_intern(&lf[156],10,"signal/int");
lf[157]=C_h_intern(&lf[157],10,"signal/fpe");
lf[158]=C_h_intern(&lf[158],10,"signal/ill");
lf[159]=C_h_intern(&lf[159],11,"signal/segv");
lf[160]=C_h_intern(&lf[160],11,"signal/abrt");
lf[161]=C_h_intern(&lf[161],12,"signal/break");
lf[162]=C_h_intern(&lf[162],11,"signal/alrm");
lf[163]=C_h_intern(&lf[163],11,"signal/chld");
lf[164]=C_h_intern(&lf[164],11,"signal/cont");
lf[165]=C_h_intern(&lf[165],10,"signal/hup");
lf[166]=C_h_intern(&lf[166],9,"signal/io");
lf[167]=C_h_intern(&lf[167],11,"signal/kill");
lf[168]=C_h_intern(&lf[168],11,"signal/pipe");
lf[169]=C_h_intern(&lf[169],11,"signal/prof");
lf[170]=C_h_intern(&lf[170],11,"signal/quit");
lf[171]=C_h_intern(&lf[171],11,"signal/stop");
lf[172]=C_h_intern(&lf[172],11,"signal/trap");
lf[173]=C_h_intern(&lf[173],11,"signal/tstp");
lf[174]=C_h_intern(&lf[174],10,"signal/urg");
lf[175]=C_h_intern(&lf[175],11,"signal/usr1");
lf[176]=C_h_intern(&lf[176],11,"signal/usr2");
lf[177]=C_h_intern(&lf[177],13,"signal/vtalrm");
lf[178]=C_h_intern(&lf[178],12,"signal/winch");
lf[179]=C_h_intern(&lf[179],11,"signal/xcpu");
lf[180]=C_h_intern(&lf[180],11,"signal/xfsz");
lf[181]=C_h_intern(&lf[181],12,"signals-list");
lf[182]=C_h_intern(&lf[182],18,"\003sysinterrupt-hook");
lf[183]=C_h_intern(&lf[183],14,"signal-handler");
lf[184]=C_h_intern(&lf[184],19,"set-signal-handler!");
lf[185]=C_h_intern(&lf[185],10,"errno/perm");
lf[186]=C_h_intern(&lf[186],11,"errno/noent");
lf[187]=C_h_intern(&lf[187],10,"errno/srch");
lf[188]=C_h_intern(&lf[188],10,"errno/intr");
lf[189]=C_h_intern(&lf[189],8,"errno/io");
lf[190]=C_h_intern(&lf[190],12,"errno/noexec");
lf[191]=C_h_intern(&lf[191],10,"errno/badf");
lf[192]=C_h_intern(&lf[192],11,"errno/child");
lf[193]=C_h_intern(&lf[193],11,"errno/nomem");
lf[194]=C_h_intern(&lf[194],11,"errno/acces");
lf[195]=C_h_intern(&lf[195],11,"errno/fault");
lf[196]=C_h_intern(&lf[196],10,"errno/busy");
lf[197]=C_h_intern(&lf[197],11,"errno/exist");
lf[198]=C_h_intern(&lf[198],12,"errno/notdir");
lf[199]=C_h_intern(&lf[199],11,"errno/isdir");
lf[200]=C_h_intern(&lf[200],11,"errno/inval");
lf[201]=C_h_intern(&lf[201],11,"errno/mfile");
lf[202]=C_h_intern(&lf[202],11,"errno/nospc");
lf[203]=C_h_intern(&lf[203],11,"errno/spipe");
lf[204]=C_h_intern(&lf[204],10,"errno/pipe");
lf[205]=C_h_intern(&lf[205],11,"errno/again");
lf[206]=C_h_intern(&lf[206],10,"errno/rofs");
lf[207]=C_h_intern(&lf[207],10,"errno/nxio");
lf[208]=C_h_intern(&lf[208],10,"errno/2big");
lf[209]=C_h_intern(&lf[209],10,"errno/xdev");
lf[210]=C_h_intern(&lf[210],11,"errno/nodev");
lf[211]=C_h_intern(&lf[211],11,"errno/nfile");
lf[212]=C_h_intern(&lf[212],11,"errno/notty");
lf[213]=C_h_intern(&lf[213],10,"errno/fbig");
lf[214]=C_h_intern(&lf[214],11,"errno/mlink");
lf[215]=C_h_intern(&lf[215],9,"errno/dom");
lf[216]=C_h_intern(&lf[216],11,"errno/range");
lf[217]=C_h_intern(&lf[217],12,"errno/deadlk");
lf[218]=C_h_intern(&lf[218],17,"errno/nametoolong");
lf[219]=C_h_intern(&lf[219],11,"errno/nolck");
lf[220]=C_h_intern(&lf[220],11,"errno/nosys");
lf[221]=C_h_intern(&lf[221],14,"errno/notempty");
lf[222]=C_h_intern(&lf[222],11,"errno/ilseq");
lf[223]=C_h_intern(&lf[223],16,"change-file-mode");
lf[224]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[225]=C_h_intern(&lf[225],17,"file-read-access\077");
lf[226]=C_h_intern(&lf[226],18,"file-write-access\077");
lf[227]=C_h_intern(&lf[227],20,"file-execute-access\077");
lf[228]=C_h_intern(&lf[228],12,"fileno/stdin");
lf[229]=C_h_intern(&lf[229],13,"fileno/stdout");
lf[230]=C_h_intern(&lf[230],13,"fileno/stderr");
lf[231]=C_h_intern(&lf[231],7,"\000append");
lf[232]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[237]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[239]=C_h_intern(&lf[239],16,"open-input-file*");
lf[240]=C_h_intern(&lf[240],17,"open-output-file*");
lf[241]=C_h_intern(&lf[241],12,"port->fileno");
lf[242]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[243]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[244]=C_h_intern(&lf[244],25,"\003syspeek-unsigned-integer");
lf[245]=C_h_intern(&lf[245],16,"duplicate-fileno");
lf[246]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[247]=C_h_intern(&lf[247],6,"setenv");
lf[248]=C_h_intern(&lf[248],8,"unsetenv");
lf[249]=C_h_intern(&lf[249],9,"substring");
lf[250]=C_h_intern(&lf[250],25,"get-environment-variables");
lf[251]=C_h_intern(&lf[251],19,"current-environment");
lf[253]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[254]=C_h_intern(&lf[254],19,"seconds->local-time");
lf[255]=C_h_intern(&lf[255],18,"\003sysdecode-seconds");
lf[256]=C_h_intern(&lf[256],17,"seconds->utc-time");
lf[257]=C_h_intern(&lf[257],15,"seconds->string");
lf[258]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[259]=C_h_intern(&lf[259],12,"time->string");
lf[260]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[261]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[262]=C_h_intern(&lf[262],19,"local-time->seconds");
lf[263]=C_h_intern(&lf[263],15,"\003syscons-flonum");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[265]=C_h_intern(&lf[265],27,"local-timezone-abbreviation");
lf[266]=C_h_intern(&lf[266],5,"_exit");
lf[267]=C_h_intern(&lf[267],14,"terminal-port\077");
lf[268]=C_h_intern(&lf[268],19,"set-buffering-mode!");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[270]=C_h_intern(&lf[270],5,"\000full");
lf[271]=C_h_intern(&lf[271],5,"\000line");
lf[272]=C_h_intern(&lf[272],5,"\000none");
lf[273]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[274]=C_h_intern(&lf[274],6,"regexp");
lf[275]=C_h_intern(&lf[275],12,"string-match");
lf[276]=C_h_intern(&lf[276],12,"glob->regexp");
lf[277]=C_h_intern(&lf[277],13,"make-pathname");
lf[278]=C_h_intern(&lf[278],18,"decompose-pathname");
lf[279]=C_h_intern(&lf[279],4,"glob");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[281]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[282]=C_h_intern(&lf[282],13,"spawn/overlay");
lf[283]=C_h_intern(&lf[283],10,"spawn/wait");
lf[284]=C_h_intern(&lf[284],12,"spawn/nowait");
lf[285]=C_h_intern(&lf[285],13,"spawn/nowaito");
lf[286]=C_h_intern(&lf[286],12,"spawn/detach");
lf[287]=C_h_intern(&lf[287],16,"char-whitespace\077");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[290]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[291]=C_h_intern(&lf[291],24,"pathname-strip-directory");
lf[294]=C_h_intern(&lf[294],15,"process-execute");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[296]=C_h_intern(&lf[296],13,"process-spawn");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[298]=C_h_intern(&lf[298],18,"current-process-id");
lf[299]=C_h_intern(&lf[299],17,"\003sysshell-command");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[301]=C_h_intern(&lf[301],24,"get-environment-variable");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[303]=C_h_intern(&lf[303],27,"\003sysshell-command-arguments");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[305]=C_h_intern(&lf[305],11,"process-run");
lf[306]=C_h_intern(&lf[306],11,"\003sysprocess");
lf[307]=C_h_intern(&lf[307],14,"\000process-error");
lf[308]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[309]=C_h_intern(&lf[309],17,"\003sysmake-locative");
lf[310]=C_h_intern(&lf[310],8,"location");
lf[311]=C_h_intern(&lf[311],7,"process");
lf[312]=C_h_intern(&lf[312],8,"process*");
lf[313]=C_h_intern(&lf[313],16,"\003sysprocess-wait");
lf[314]=C_h_intern(&lf[314],12,"process-wait");
lf[315]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[316]=C_h_intern(&lf[316],5,"sleep");
lf[317]=C_h_intern(&lf[317],13,"get-host-name");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[319]=C_h_intern(&lf[319],18,"system-information");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[323]=C_h_intern(&lf[323],10,"find-files");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[327]=C_h_intern(&lf[327],16,"\003sysdynamic-wind");
lf[328]=C_h_intern(&lf[328],13,"pathname-file");
lf[329]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[330]=C_h_intern(&lf[330],17,"change-file-owner");
lf[331]=C_h_intern(&lf[331],5,"error");
lf[332]=C_h_intern(&lf[332],11,"create-fifo");
lf[333]=C_h_intern(&lf[333],14,"create-session");
lf[334]=C_h_intern(&lf[334],20,"create-symbolic-link");
lf[335]=C_h_intern(&lf[335],26,"current-effective-group-id");
lf[336]=C_h_intern(&lf[336],25,"current-effective-user-id");
lf[337]=C_h_intern(&lf[337],27,"current-effective-user-name");
lf[338]=C_h_intern(&lf[338],16,"current-group-id");
lf[339]=C_h_intern(&lf[339],15,"current-user-id");
lf[340]=C_h_intern(&lf[340],18,"map-file-to-memory");
lf[341]=C_h_intern(&lf[341],9,"file-link");
lf[342]=C_h_intern(&lf[342],9,"file-lock");
lf[343]=C_h_intern(&lf[343],18,"file-lock/blocking");
lf[344]=C_h_intern(&lf[344],11,"file-select");
lf[345]=C_h_intern(&lf[345],14,"file-test-lock");
lf[346]=C_h_intern(&lf[346],13,"file-truncate");
lf[347]=C_h_intern(&lf[347],11,"file-unlock");
lf[348]=C_h_intern(&lf[348],10,"get-groups");
lf[349]=C_h_intern(&lf[349],17,"group-information");
lf[350]=C_h_intern(&lf[350],17,"initialize-groups");
lf[351]=C_h_intern(&lf[351],26,"memory-mapped-file-pointer");
lf[352]=C_h_intern(&lf[352],17,"parent-process-id");
lf[353]=C_h_intern(&lf[353],12,"process-fork");
lf[354]=C_h_intern(&lf[354],16,"process-group-id");
lf[355]=C_h_intern(&lf[355],14,"process-signal");
lf[356]=C_h_intern(&lf[356],18,"read-symbolic-link");
lf[357]=C_h_intern(&lf[357],10,"set-alarm!");
lf[358]=C_h_intern(&lf[358],13,"set-group-id!");
lf[359]=C_h_intern(&lf[359],11,"set-groups!");
lf[360]=C_h_intern(&lf[360],21,"set-process-group-id!");
lf[361]=C_h_intern(&lf[361],19,"set-root-directory!");
lf[362]=C_h_intern(&lf[362],16,"set-signal-mask!");
lf[363]=C_h_intern(&lf[363],12,"set-user-id!");
lf[364]=C_h_intern(&lf[364],11,"signal-mask");
lf[365]=C_h_intern(&lf[365],12,"signal-mask!");
lf[366]=C_h_intern(&lf[366],14,"signal-masked\077");
lf[367]=C_h_intern(&lf[367],14,"signal-unmask!");
lf[368]=C_h_intern(&lf[368],13,"terminal-name");
lf[369]=C_h_intern(&lf[369],13,"terminal-size");
lf[370]=C_h_intern(&lf[370],22,"unmap-file-from-memory");
lf[371]=C_h_intern(&lf[371],16,"user-information");
lf[372]=C_h_intern(&lf[372],17,"utc-time->seconds");
lf[373]=C_h_intern(&lf[373],12,"string->time");
lf[374]=C_h_intern(&lf[374],16,"errno/wouldblock");
lf[375]=C_h_intern(&lf[375],19,"memory-mapped-file\077");
lf[376]=C_h_intern(&lf[376],13,"map/anonymous");
lf[377]=C_h_intern(&lf[377],8,"map/file");
lf[378]=C_h_intern(&lf[378],9,"map/fixed");
lf[379]=C_h_intern(&lf[379],11,"map/private");
lf[380]=C_h_intern(&lf[380],10,"map/shared");
lf[381]=C_h_intern(&lf[381],10,"open/fsync");
lf[382]=C_h_intern(&lf[382],11,"open/noctty");
lf[383]=C_h_intern(&lf[383],13,"open/nonblock");
lf[384]=C_h_intern(&lf[384],9,"open/sync");
lf[385]=C_h_intern(&lf[385],10,"perm/isgid");
lf[386]=C_h_intern(&lf[386],10,"perm/isuid");
lf[387]=C_h_intern(&lf[387],10,"perm/isvtx");
lf[388]=C_h_intern(&lf[388],9,"prot/exec");
lf[389]=C_h_intern(&lf[389],9,"prot/none");
lf[390]=C_h_intern(&lf[390],9,"prot/read");
lf[391]=C_h_intern(&lf[391],10,"prot/write");
lf[392]=C_h_intern(&lf[392],11,"make-vector");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[395]=C_h_intern(&lf[395],18,"getter-with-setter");
lf[396]=C_h_intern(&lf[396],17,"stat-char-device\077");
lf[397]=C_h_intern(&lf[397],17,"register-feature!");
lf[398]=C_h_intern(&lf[398],5,"posix");
C_register_lf2(lf,399,create_ptable());
t2=C_mutate(&lf[0] /* (set! c2031 ...) */,lf[1]);
t3=C_mutate(&lf[2] /* (set! c222 ...) */,lf[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2641,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t4);}

/* k2639 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2644,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2642 in k2639 */
static void C_ccall f_2644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2644,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2647,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2645 in k2642 in k2639 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2647,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2650,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2650,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2653,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2653,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2656,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2659,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 930  register-feature! */
((C_proc3)C_retrieve_proc(*((C_word*)lf[397]+1)))(3,*((C_word*)lf[397]+1),t2,lf[398]);}

/* k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word ab[63],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2659,2,t0,t1);}
t2=*((C_word*)lf[4]+1);
t3=C_mutate(&lf[5] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2671,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[10]+1 /* (set! posix-error ...) */,lf[5]);
t5=C_mutate((C_word*)lf[11]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[12]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[13]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[14]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[15]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[17]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[18]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[19]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[20]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[21]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[22]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[23]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[24]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[25]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[26]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[27]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[28]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[29]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[30]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[31]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[32]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[33]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[34]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[35]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=(C_word)C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[36]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2717,a[2]=t31,a[3]=((C_word)li1),tmp=(C_word)a,a+=4,tmp));
t33=C_mutate((C_word*)lf[41]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2758,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t34=*((C_word*)lf[43]+1);
t35=C_mutate((C_word*)lf[44]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2776,a[2]=t34,a[3]=((C_word)li3),tmp=(C_word)a,a+=4,tmp));
t36=C_mutate((C_word*)lf[48]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2821,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t37=*((C_word*)lf[51]+1);
t38=C_mutate((C_word*)lf[52]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2863,a[2]=t37,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp));
t39=C_mutate((C_word*)lf[55]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t40=C_mutate((C_word*)lf[56]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t41=C_mutate((C_word*)lf[57]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t42=C_mutate(&lf[58] /* (set! stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2901,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[61]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2939,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[63]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2970,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[64]+1 /* (set! file-modification-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2976,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[65]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2982,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[66]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2988,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[67]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2994,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[68]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3000,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[69]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3006,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[71]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3029,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3034,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[72]+1 /* (set! stat-regular? ...) */,*((C_word*)lf[69]+1));
t54=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3045,a[2]=t52,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1115 stat-type */
f_3034(t54,lf[73]);}

/* k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3045,2,t0,t1);}
t2=C_mutate((C_word*)lf[73]+1 /* (set! stat-directory? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3049,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1116 stat-type */
f_3034(t3,lf[396]);}

/* k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3049,2,t0,t1);}
t2=C_mutate((C_word*)lf[74]+1 /* (set! stat-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3053,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1117 stat-type */
f_3034(t3,lf[75]);}

/* k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3053,2,t0,t1);}
t2=C_mutate((C_word*)lf[75]+1 /* (set! character-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3057,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1118 stat-type */
f_3034(t3,lf[76]);}

/* k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3057,2,t0,t1);}
t2=C_mutate((C_word*)lf[76]+1 /* (set! block-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3061,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1119 stat-type */
f_3034(t3,lf[77]);}

/* k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3061,2,t0,t1);}
t2=C_mutate((C_word*)lf[77]+1 /* (set! stat-block-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3065,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1120 stat-type */
f_3034(t3,lf[78]);}

/* k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3065,2,t0,t1);}
t2=C_mutate((C_word*)lf[78]+1 /* (set! stat-fifo? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3069,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1121 stat-type */
f_3034(t3,lf[79]);}

/* k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3069,2,t0,t1);}
t2=C_mutate((C_word*)lf[79]+1 /* (set! fifo? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3073,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1122 stat-type */
f_3034(t3,lf[80]);}

/* k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3073,2,t0,t1);}
t2=C_mutate((C_word*)lf[80]+1 /* (set! stat-symlink? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3077,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1123 stat-type */
f_3034(t3,lf[81]);}

/* k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3077,2,t0,t1);}
t2=C_mutate((C_word*)lf[81]+1 /* (set! socket? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3081,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1124 stat-type */
f_3034(t3,lf[82]);}

/* k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3081,2,t0,t1);}
t2=C_mutate((C_word*)lf[82]+1 /* (set! stat-socket? ...) */,t1);
t3=C_mutate((C_word*)lf[83]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3083,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3146,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6526,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1141 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[395]+1)))(4,*((C_word*)lf[395]+1),t4,t5,*((C_word*)lf[83]+1));}

/* a6525 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6526(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6526,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6530,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6545,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1143 port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[87]+1)))(3,*((C_word*)lf[87]+1),t4,t2);}

/* k6543 in a6525 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[85]);
t4=((C_word*)t0)[2];
f_6530(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_6530(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 1148 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[90],lf[394],((C_word*)t0)[3]);}}}

/* k6528 in a6525 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6530,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6533,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6539,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1150 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_6533(2,t3,C_SCHEME_UNDEFINED);}}

/* k6537 in k6528 in a6525 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1151 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[90],lf[393],((C_word*)t0)[2]);}

/* k6531 in k6528 in a6525 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word ab[115],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3146,2,t0,t1);}
t2=C_mutate((C_word*)lf[90]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[91]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3148,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[99]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3261,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[101]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3288,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t6=*((C_word*)lf[4]+1);
t7=*((C_word*)lf[43]+1);
t8=*((C_word*)lf[103]+1);
t9=C_mutate((C_word*)lf[104]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3315,a[2]=t7,a[3]=((C_word)li27),tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[108]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3475,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t11=*((C_word*)lf[43]+1);
t12=C_mutate((C_word*)lf[107]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3502,a[2]=t11,a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp));
t13=*((C_word*)lf[111]+1);
t14=*((C_word*)lf[112]+1);
t15=*((C_word*)lf[113]+1);
t16=*((C_word*)lf[114]+1);
t17=*((C_word*)lf[115]+1);
t18=*((C_word*)lf[4]+1);
t19=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3553,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp);
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3558,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp);
t21=*((C_word*)lf[118]+1);
t22=*((C_word*)lf[107]+1);
t23=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3569,a[2]=t22,a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp);
t24=C_mutate((C_word*)lf[98]+1 /* (set! canonical-path ...) */,(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3625,a[2]=t16,a[3]=t14,a[4]=t21,a[5]=t23,a[6]=t15,a[7]=t13,a[8]=t17,a[9]=t19,a[10]=t18,a[11]=t20,a[12]=((C_word)li41),tmp=(C_word)a,a+=13,tmp));
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3982,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3994,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4000,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
t28=C_mutate((C_word*)lf[140]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4018,a[2]=t26,a[3]=t27,a[4]=t25,a[5]=((C_word)li45),tmp=(C_word)a,a+=6,tmp));
t29=C_mutate((C_word*)lf[142]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4054,a[2]=t26,a[3]=t27,a[4]=t25,a[5]=((C_word)li46),tmp=(C_word)a,a+=6,tmp));
t30=C_mutate((C_word*)lf[143]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4090,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[146]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[143]+1));
t32=*((C_word*)lf[140]+1);
t33=*((C_word*)lf[142]+1);
t34=*((C_word*)lf[143]+1);
t35=*((C_word*)lf[146]+1);
t36=C_mutate((C_word*)lf[147]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4109,a[2]=t32,a[3]=t34,a[4]=((C_word)li50),tmp=(C_word)a,a+=5,tmp));
t37=C_mutate((C_word*)lf[148]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4133,a[2]=t33,a[3]=t35,a[4]=((C_word)li53),tmp=(C_word)a,a+=5,tmp));
t38=C_mutate((C_word*)lf[149]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4157,a[2]=t32,a[3]=t34,a[4]=((C_word)li55),tmp=(C_word)a,a+=5,tmp));
t39=C_mutate((C_word*)lf[151]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4177,a[2]=t33,a[3]=t35,a[4]=((C_word)li57),tmp=(C_word)a,a+=5,tmp));
t40=C_mutate((C_word*)lf[153]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4197,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[155]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t42=C_mutate((C_word*)lf[156]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t43=C_mutate((C_word*)lf[157]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t44=C_mutate((C_word*)lf[158]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t45=C_mutate((C_word*)lf[159]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t46=C_mutate((C_word*)lf[160]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t47=C_mutate((C_word*)lf[161]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t48=C_set_block_item(lf[162] /* signal/alrm */,0,C_fix(0));
t49=C_set_block_item(lf[163] /* signal/chld */,0,C_fix(0));
t50=C_set_block_item(lf[164] /* signal/cont */,0,C_fix(0));
t51=C_set_block_item(lf[165] /* signal/hup */,0,C_fix(0));
t52=C_set_block_item(lf[166] /* signal/io */,0,C_fix(0));
t53=C_set_block_item(lf[167] /* signal/kill */,0,C_fix(0));
t54=C_set_block_item(lf[168] /* signal/pipe */,0,C_fix(0));
t55=C_set_block_item(lf[169] /* signal/prof */,0,C_fix(0));
t56=C_set_block_item(lf[170] /* signal/quit */,0,C_fix(0));
t57=C_set_block_item(lf[171] /* signal/stop */,0,C_fix(0));
t58=C_set_block_item(lf[172] /* signal/trap */,0,C_fix(0));
t59=C_set_block_item(lf[173] /* signal/tstp */,0,C_fix(0));
t60=C_set_block_item(lf[174] /* signal/urg */,0,C_fix(0));
t61=C_set_block_item(lf[175] /* signal/usr1 */,0,C_fix(0));
t62=C_set_block_item(lf[176] /* signal/usr2 */,0,C_fix(0));
t63=C_set_block_item(lf[177] /* signal/vtalrm */,0,C_fix(0));
t64=C_set_block_item(lf[178] /* signal/winch */,0,C_fix(0));
t65=C_set_block_item(lf[179] /* signal/xcpu */,0,C_fix(0));
t66=C_set_block_item(lf[180] /* signal/xfsz */,0,C_fix(0));
t67=(C_word)C_a_i_list(&a,7,*((C_word*)lf[155]+1),*((C_word*)lf[156]+1),*((C_word*)lf[157]+1),*((C_word*)lf[158]+1),*((C_word*)lf[159]+1),*((C_word*)lf[160]+1),*((C_word*)lf[161]+1));
t68=C_mutate((C_word*)lf[181]+1 /* (set! signals-list ...) */,t67);
t69=*((C_word*)lf[182]+1);
t70=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4271,a[2]=((C_word*)t0)[2],a[3]=t69,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1474 make-vector */
t71=*((C_word*)lf[392]+1);
((C_proc4)(void*)(*((C_word*)t71+1)))(4,t71,t70,C_fix(256),C_SCHEME_FALSE);}

/* k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word ab[321],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4271,2,t0,t1);}
t2=C_mutate((C_word*)lf[183]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4273,a[2]=t1,a[3]=((C_word)li59),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[184]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4282,a[2]=t1,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[182]+1 /* (set! interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4295,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li61),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[185]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[186]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[187]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[188]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[189]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[190]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[191]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[192]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[193]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[194]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[195]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[196]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[197]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[198]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[199]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[200]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[201]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[202]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[203]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[204]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[205]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[206]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[207]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[208]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[209]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[210]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[211]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[212]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[213]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[214]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[215]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[216]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[217]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[218]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[219]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[220]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[221]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[222]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[223]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4351,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4381,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp);
t45=C_mutate((C_word*)lf[225]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4405,a[2]=t44,a[3]=((C_word)li64),tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[226]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4411,a[2]=t44,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[227]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4417,a[2]=t44,a[3]=((C_word)li66),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[228]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[229]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[230]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4426,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp);
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4463,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[239]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4481,a[2]=t51,a[3]=t52,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp));
t54=C_mutate((C_word*)lf[240]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4495,a[2]=t51,a[3]=t52,a[4]=((C_word)li70),tmp=(C_word)a,a+=5,tmp));
t55=C_mutate((C_word*)lf[241]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4509,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[245]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4544,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[247]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4574,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[248]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4591,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t59=*((C_word*)lf[249]+1);
t60=C_mutate((C_word*)lf[250]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4611,a[2]=t59,a[3]=((C_word)li77),tmp=(C_word)a,a+=4,tmp));
t61=C_mutate((C_word*)lf[251]+1 /* (set! current-environment ...) */,*((C_word*)lf[250]+1));
t62=C_mutate(&lf[252] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4677,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[254]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4696,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[256]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4705,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[257]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4724,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[259]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4757,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[262]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4824,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[265]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4839,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[266]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4851,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[267]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4867,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[268]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4873,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t72=*((C_word*)lf[274]+1);
t73=*((C_word*)lf[275]+1);
t74=*((C_word*)lf[276]+1);
t75=*((C_word*)lf[104]+1);
t76=*((C_word*)lf[277]+1);
t77=*((C_word*)lf[278]+1);
t78=C_mutate((C_word*)lf[279]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4932,a[2]=t74,a[3]=t72,a[4]=t75,a[5]=t73,a[6]=t76,a[7]=t77,a[8]=((C_word)li92),tmp=(C_word)a,a+=9,tmp));
t79=C_mutate((C_word*)lf[282]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t80=C_mutate((C_word*)lf[283]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t81=C_mutate((C_word*)lf[284]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t82=C_mutate((C_word*)lf[285]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t83=C_mutate((C_word*)lf[286]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t84=*((C_word*)lf[287]+1);
t85=*((C_word*)lf[51]+1);
t86=*((C_word*)lf[115]+1);
t87=*((C_word*)lf[4]+1);
t88=C_mutate(&lf[288] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5044,a[2]=t87,a[3]=t85,a[4]=t86,a[5]=t84,a[6]=((C_word)li96),tmp=(C_word)a,a+=7,tmp));
t89=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5123,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp);
t90=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5140,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp);
t91=*((C_word*)lf[291]+1);
t92=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5157,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp);
t93=C_mutate(&lf[292] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5207,a[2]=t91,a[3]=t89,a[4]=t90,a[5]=t92,a[6]=((C_word)li101),tmp=(C_word)a,a+=7,tmp));
t94=C_mutate(&lf[293] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5240,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[294]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5255,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[296]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5342,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[298]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5429,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[299]+1 /* (set! shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5432,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t99=C_mutate((C_word*)lf[303]+1 /* (set! shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5453,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t100=*((C_word*)lf[296]+1);
t101=*((C_word*)lf[301]+1);
t102=C_mutate((C_word*)lf[305]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5459,a[2]=t100,a[3]=((C_word)li116),tmp=(C_word)a,a+=4,tmp));
t103=C_mutate((C_word*)lf[306]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5551,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t104=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5670,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp);
t105=C_mutate((C_word*)lf[311]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5732,a[2]=t104,a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp));
t106=C_mutate((C_word*)lf[312]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5812,a[2]=t104,a[3]=((C_word)li132),tmp=(C_word)a,a+=4,tmp));
t107=C_mutate((C_word*)lf[313]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5892,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[314]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5904,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[316]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5964,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[317]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5967,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[319]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5979,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[118]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6010,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t113=*((C_word*)lf[279]+1);
t114=*((C_word*)lf[275]+1);
t115=*((C_word*)lf[277]+1);
t116=*((C_word*)lf[108]+1);
t117=C_mutate((C_word*)lf[323]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6025,a[2]=t116,a[3]=t115,a[4]=t113,a[5]=t114,a[6]=((C_word)li153),tmp=(C_word)a,a+=7,tmp));
t118=C_mutate((C_word*)lf[330]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6245,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[332]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6251,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[333]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6257,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[334]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6263,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[335]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6269,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[336]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6275,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[337]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6281,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[338]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6287,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[339]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6293,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[340]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6299,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[341]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6305,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[342]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6311,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[343]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6317,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[344]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6323,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[345]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6329,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[346]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6335,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[347]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6341,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[348]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6347,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[349]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6353,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[350]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6359,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[351]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6365,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[352]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6371,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[353]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6377,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[354]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6383,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[355]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6389,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[356]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6395,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[357]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6401,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[358]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6407,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[359]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6413,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[360]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6419,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[361]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6425,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[362]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6431,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[363]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6437,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[364]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6443,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[365]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6449,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[366]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6455,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[367]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6461,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[368]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6467,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[369]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6473,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[370]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6479,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[371]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6485,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[372]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6491,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[373]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6497,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t161=C_set_block_item(lf[374] /* errno/wouldblock */,0,C_fix(0));
t162=C_mutate((C_word*)lf[79]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6504,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[375]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6507,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t164=C_set_block_item(lf[376] /* map/anonymous */,0,C_fix(0));
t165=C_set_block_item(lf[377] /* map/file */,0,C_fix(0));
t166=C_set_block_item(lf[378] /* map/fixed */,0,C_fix(0));
t167=C_set_block_item(lf[379] /* map/private */,0,C_fix(0));
t168=C_set_block_item(lf[380] /* map/shared */,0,C_fix(0));
t169=C_set_block_item(lf[381] /* open/fsync */,0,C_fix(0));
t170=C_set_block_item(lf[382] /* open/noctty */,0,C_fix(0));
t171=C_set_block_item(lf[383] /* open/nonblock */,0,C_fix(0));
t172=C_set_block_item(lf[384] /* open/sync */,0,C_fix(0));
t173=C_set_block_item(lf[385] /* perm/isgid */,0,C_fix(0));
t174=C_set_block_item(lf[386] /* perm/isuid */,0,C_fix(0));
t175=C_set_block_item(lf[387] /* perm/isvtx */,0,C_fix(0));
t176=C_set_block_item(lf[388] /* prot/exec */,0,C_fix(0));
t177=C_set_block_item(lf[389] /* prot/none */,0,C_fix(0));
t178=C_set_block_item(lf[390] /* prot/read */,0,C_fix(0));
t179=C_set_block_item(lf[391] /* prot/write */,0,C_fix(0));
t180=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t180+1)))(2,t180,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6507(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6507,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6504(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6504,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6497(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6497,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[373],lf[0]);}

/* utc-time->seconds in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6491(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6491,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[372],lf[0]);}

/* user-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6485(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6485,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* unmap-file-from-memory in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6479(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6479,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* terminal-size in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6473(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6473,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* terminal-name in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6467(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6467,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* signal-unmask! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6461(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6461,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* signal-masked? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6455(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6455,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* signal-mask! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6449(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6449,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* signal-mask in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6443(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6443,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* set-user-id! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6437(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6437,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* set-signal-mask! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6431(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6431,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* set-root-directory! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6425(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6425,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-process-group-id! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6419(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6419,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* set-groups! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6413(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6413,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* set-group-id! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6407(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6407,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* set-alarm! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6401(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6401,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* read-symbolic-link in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6395(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6395,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* process-signal in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6389(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6389,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* process-group-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6383(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6383,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* process-fork in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6377(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6377,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* parent-process-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6371(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6371,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* memory-mapped-file-pointer in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6365(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6365,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* initialize-groups in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6359(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6359,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* group-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6353(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6353,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* get-groups in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6347(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6347,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* file-unlock in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6341(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6341,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* file-truncate in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6335(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6335,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-test-lock in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6329(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6329,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* file-select in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6323(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6323,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* file-lock/blocking in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6317(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6317,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* file-lock in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6311(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6311,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* file-link in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6305(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6305,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* map-file-to-memory in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6299(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6299,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* current-user-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6293(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6293,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* current-group-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6287(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6287,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* current-effective-user-name in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6281(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6281,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* current-effective-user-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6275(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6275,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* current-effective-group-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6269(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6269,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[335],lf[0]);}

/* create-symbolic-link in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6263(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6263,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* create-session in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6257(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6257,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[333],lf[0]);}

/* create-fifo in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6251(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6251,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[332],lf[0]);}

/* change-file-owner in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6245,2,t0,t1);}
/* error */
t2=*((C_word*)lf[331]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[330],lf[0]);}

/* find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6025(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_6025r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_6025r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6025r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6027,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=((C_word)li148),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6166,a[2]=t5,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6171,a[2]=t6,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6176,a[2]=t7,a[3]=((C_word)li152),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action18821967 */
t9=t8;
f_6176(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id18831963 */
t11=t7;
f_6171(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit18841958 */
t13=t6;
f_6166(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body18801890 */
t15=t5;
f_6027(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-action1882 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6176(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6176,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6182,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp);
/* def-id18831963 */
t3=((C_word*)t0)[2];
f_6171(t3,t1,t2);}

/* a6181 in def-action1882 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6182(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6182,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1883 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6171(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6171,NULL,3,t0,t1,t2);}
/* def-limit18841958 */
t3=((C_word*)t0)[2];
f_6166(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1884 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6166(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6166,NULL,4,t0,t1,t2,t3);}
/* body18801890 */
t4=((C_word*)t0)[2];
f_6027(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6027(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6027,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[323]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6034,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_6034(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6161,a[2]=t4,a[3]=t7,a[4]=((C_word)li146),tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_6034(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6153,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));}}

/* f_6153 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6153(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6153,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_6161 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6161(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6161,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6034(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6034,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6145,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=((C_word)li141),tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6044,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6141,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2056 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[329]);}

/* k6139 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2056 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6044,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6046,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=((C_word)li145),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_6046(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6046(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6046,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_6065,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 2062 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6065,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6121,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 2063 pathname-file */
((C_proc3)C_retrieve_proc(*((C_word*)lf[328]+1)))(3,*((C_word*)lf[328]+1),t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6127,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 2069 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k6125 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6127,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6134,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2069 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 2070 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_6046(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k6132 in k6125 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2069 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_6046(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6121,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[324]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[325]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 2063 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_6046(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6080,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 2064 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6080,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6090,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6092,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=((C_word)li142),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6097,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word)li143),tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6111,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=((C_word)li144),tmp=(C_word)a,a+=6,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[327]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 2068 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_6046(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a6110 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6111,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a6096 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6097,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6105,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6109,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2067 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[326]);}

/* k6107 in a6096 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2067 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k6103 in a6096 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2067 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_6046(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a6091 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6092,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k6088 in k6078 in k6119 in k6063 in loop in k6042 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2065 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_6046(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_6145 in k6032 in body1880 in find-files in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6145(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6145,3,t0,t1,t2);}
/* posixwin.scm: 2054 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* current-user-name in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6010,2,t0,t1);}
if(C_truep((C_word)C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6020,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2030 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k6018 in current-user-name in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2031 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[118],lf[322]);}

/* system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5979,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5990,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6005,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2021 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k6003 in system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2022 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[319],lf[321]);}

/* k5988 in system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5990,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5994,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k5992 in k5988 in system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5994(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5994,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5998,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k5996 in k5992 in k5988 in system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5998,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6002,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k6000 in k5996 in k5992 in k5988 in system-information in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6002,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[320],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5967,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 2011 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[317],lf[318]);}}

/* sleep in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5964(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5964,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5904(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3r,(void*)f_5904r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5904r(t0,t1,t2,t3);}}

static void C_ccall f_5904r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(9);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
if(C_truep((C_word)C_i_nullp(t7))){
t8=(C_word)C_i_check_exact_2(t2,lf[314]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5925,a[2]=t5,a[3]=t2,a[4]=((C_word)li134),tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5931,a[2]=t2,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}
else{
/* ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t1,lf[2],t7);}}

/* a5930 in process-wait in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5931(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5931,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5941,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1993 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
/* posixwin.scm: 1995 values */
C_values(5,0,t1,t2,t3,t4);}}

/* k5939 in a5930 in process-wait in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1994 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[307],lf[314],lf[315],((C_word*)t0)[2]);}

/* a5924 in process-wait in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5925,2,t0,t1);}
/* posixwin.scm: 1990 ##sys#process-wait */
((C_proc4)C_retrieve_proc(*((C_word*)lf[313]+1)))(4,*((C_word*)lf[313]+1),t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5892(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5892,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_process_wait(t2,t3))){
/* posixwin.scm: 1983 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm: 1984 values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5812(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_5812r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5812r(t0,t1,t2,t3);}}

static void C_ccall f_5812r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5814,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li128),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5819,a[2]=t4,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5824,a[2]=t5,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5829,a[2]=t6,a[3]=((C_word)li131),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args17751798 */
t8=t7;
f_5829(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env17761794 */
t10=t6;
f_5824(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf17771789 */
t12=t5;
f_5819(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body17731783 */
t14=t4;
f_5814(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1775 in process* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5829(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5829,NULL,2,t0,t1);}
/* def-env17761794 */
t2=((C_word*)t0)[2];
f_5824(t2,t1,C_SCHEME_FALSE);}

/* def-env1776 in process* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5824(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5824,NULL,3,t0,t1,t2);}
/* def-exactf17771789 */
t3=((C_word*)t0)[2];
f_5819(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1777 in process* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5819(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5819,NULL,4,t0,t1,t2,t3);}
/* body17731783 */
t4=((C_word*)t0)[2];
f_5814(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1773 in process* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5814(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5814,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1977 %process */
f_5670(t1,lf[312],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5732(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_5732r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5732r(t0,t1,t2,t3);}}

static void C_ccall f_5732r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5734,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li123),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5739,a[2]=t4,a[3]=((C_word)li124),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5744,a[2]=t5,a[3]=((C_word)li125),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5749,a[2]=t6,a[3]=((C_word)li126),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args17201743 */
t8=t7;
f_5749(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env17211739 */
t10=t6;
f_5744(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf17221734 */
t12=t5;
f_5739(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body17181728 */
t14=t4;
f_5734(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1720 in process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5749(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5749,NULL,2,t0,t1);}
/* def-env17211739 */
t2=((C_word*)t0)[2];
f_5744(t2,t1,C_SCHEME_FALSE);}

/* def-env1721 in process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5744(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5744,NULL,3,t0,t1,t2);}
/* def-exactf17221734 */
t3=((C_word*)t0)[2];
f_5739(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1722 in process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5739(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5739,NULL,4,t0,t1,t2,t3);}
/* body17181728 */
t4=((C_word*)t0)[2];
f_5734(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1718 in process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5734(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5734,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1974 %process */
f_5670(t1,lf[311],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5670(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5670,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5672,a[2]=t2,a[3]=((C_word)li119),tmp=(C_word)a,a+=4,tmp);
t12=(C_word)C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5691,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm: 1962 chkstrlst */
t14=t11;
f_5672(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5726,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1965 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[303]+1)))(3,*((C_word*)lf[303]+1),t15,((C_word*)t8)[1]);}}

/* k5724 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5726,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5730,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1966 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[299]+1)))(2,*((C_word*)lf[299]+1),t3);}

/* k5728 in k5724 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_5691(2,t3,t2);}

/* k5689 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5691,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5694,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm: 1967 chkstrlst */
t3=((C_word*)t0)[2];
f_5672(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_5694(2,t3,C_SCHEME_UNDEFINED);}}

/* k5692 in k5689 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5694,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5699,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li120),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5705,a[2]=((C_word*)t0)[4],a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5704 in k5692 in k5689 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5705(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5705,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm: 1970 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm: 1971 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a5698 in k5692 in k5689 in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5699,2,t0,t1);}
/* posixwin.scm: 1968 ##sys#process */
t2=*((C_word*)lf[306]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5672(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5672,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5681,a[2]=((C_word*)t0)[2],a[3]=((C_word)li118),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[95]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a5680 in chkstrlst in %process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5681(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5681,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5551(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr9r,(void*)f_5551r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_5551r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_5551r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5555,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=t7,a[6]=t8,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep((C_word)C_i_nullp(t9))){
t11=t10;
f_5555(2,t11,C_SCHEME_FALSE);}
else{
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
t12=t10;
f_5555(2,t12,(C_word)C_i_car(t9));}
else{
/* ##sys#error */
t12=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,lf[2],t9);}}}

/* k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5555,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5558,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5646,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[8],((C_word*)t0)[2]);
/* posixwin.scm: 1934 $quote-args-list */
t5=lf[288];
f_5044(t5,t3,t4,t1);}

/* k5644 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1934 string-intersperse */
((C_proc3)C_retrieve_proc(*((C_word*)lf[116]+1)))(3,*((C_word*)lf[116]+1),((C_word*)t0)[2],t1);}

/* k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5558,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t4=((*(int *)C_data_pointer(t2))=C_unfix(t3),C_SCHEME_UNDEFINED);
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t6=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t7=((*(int *)C_data_pointer(t5))=C_unfix(t6),C_SCHEME_UNDEFINED);
t8=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t9=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t10=((*(int *)C_data_pointer(t8))=C_unfix(t9),C_SCHEME_UNDEFINED);
t11=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t12=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t13=((*(int *)C_data_pointer(t11))=C_unfix(t12),C_SCHEME_UNDEFINED);
t14=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5614,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=((C_word*)t0)[3],a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=t11,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[309]+1)))(6,*((C_word*)lf[309]+1),t14,t2,C_fix(0),C_SCHEME_FALSE,lf[310]);}

/* k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5614,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5618,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[309]+1)))(6,*((C_word*)lf[309]+1),t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[310]);}

/* k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5618,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_5622,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[309]+1)))(6,*((C_word*)lf[309]+1),t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[310]);}

/* k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5622,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_5626,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[309]+1)))(6,*((C_word*)lf[309]+1),t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[310]);}

/* k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5626,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_5630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
t5=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(4));
/* posixwin.scm: 1941 + */
C_plus(5,0,t2,t3,t4,t5);}

/* k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5630,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_5493,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
t9=(C_word)C_i_foreign_string_argumentp(t2);
/* ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_5493(2,t9,C_SCHEME_FALSE);}}

/* k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5493(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5493,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_5497,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t1,a[13]=((C_word*)t0)[13],a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_5497(2,t3,C_SCHEME_FALSE);}}

/* k5495 in k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5497,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[13]);
if(C_truep((C_word)stub1542(C_SCHEME_UNDEFINED,((C_word*)t0)[12],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6))){
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5587,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm: 1944 open-input-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[239]+1)))(3,*((C_word*)lf[239]+1),t7,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t8=t7;
f_5587(2,t8,C_SCHEME_FALSE);}}
else{
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5607,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1949 ##sys#update-errno */
t8=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* k5605 in k5495 in k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1950 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[307],((C_word*)t0)[3],lf[308],((C_word*)t0)[2]);}

/* k5585 in k5495 in k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5587(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5587,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5591,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1945 open-output-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[240]+1)))(3,*((C_word*)lf[240]+1),t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_5591(2,t3,C_SCHEME_FALSE);}}

/* k5589 in k5585 in k5495 in k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5591,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5595,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1947 open-input-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[239]+1)))(3,*((C_word*)lf[239]+1),t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_5595(2,t3,C_SCHEME_FALSE);}}

/* k5593 in k5589 in k5585 in k5495 in k5491 in k5628 in k5624 in k5620 in k5616 in k5612 in k5556 in k5553 in ##sys#process in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1943 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* process-run in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5459(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5459r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5459r(t0,t1,t2,t3);}}

static void C_ccall f_5459r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1905 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,*((C_word*)lf[284]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5476,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[299]+1)))(2,*((C_word*)lf[299]+1),t6);}}

/* k5474 in process-run in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5476,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5480,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[303]+1)))(3,*((C_word*)lf[303]+1),t2,((C_word*)t0)[2]);}

/* k5478 in k5474 in process-run in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1906 process-spawn */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],*((C_word*)lf[284]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5453(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5453,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[304],t2));}

/* ##sys#shell-command in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5432,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5436,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1889 get-environment-variable */
((C_proc3)C_retrieve_proc(*((C_word*)lf[301]+1)))(3,*((C_word*)lf[301]+1),t2,lf[302]);}

/* k5434 in ##sys#shell-command in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5436,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
if(C_truep((C_word)C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5448,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1893 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}}

/* k5446 in k5434 in ##sys#shell-command in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5448(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1894 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[299],lf[300]);}

/* current-process-id in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5429,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1502(C_SCHEME_UNDEFINED));}

/* process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5342(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_5342r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5342r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5342r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5344,a[2]=t3,a[3]=t2,a[4]=((C_word)li108),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5356,a[2]=t5,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5361,a[2]=t6,a[3]=((C_word)li110),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5366,a[2]=t7,a[3]=((C_word)li111),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-arglst14631488 */
t9=t8;
f_5366(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-envlst14641484 */
t11=t7;
f_5361(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-exactf14651479 */
t13=t6;
f_5356(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body14611471 */
t15=t5;
f_5344(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-arglst1463 in process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5366(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5366,NULL,2,t0,t1);}
/* def-envlst14641484 */
t2=((C_word*)t0)[2];
f_5361(t2,t1,C_SCHEME_FALSE);}

/* def-envlst1464 in process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5361(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5361,NULL,3,t0,t1,t2);}
/* def-exactf14651479 */
t3=((C_word*)t0)[2];
f_5356(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1465 in process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5356(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5356,NULL,4,t0,t1,t2,t3);}
/* body14611471 */
t4=((C_word*)t0)[2];
f_5344(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1461 in process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5344(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5344,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5348,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1880 $exec-setup */
t6=lf[292];
f_5207(t6,t5,lf[296],((C_word*)t0)[2],t2,t3,t4);}

/* k5346 in body1461 in process-spawn in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?(C_word)C_spawnvpe(((C_word*)t0)[4],t1):(C_word)C_spawnvp(((C_word*)t0)[4],t1));
/* posixwin.scm: 1881 $exec-teardown */
f_5240(((C_word*)t0)[3],lf[296],lf[297],((C_word*)t0)[2],t2);}

/* process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5255(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr3r,(void*)f_5255r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5255r(t0,t1,t2,t3);}}

static void C_ccall f_5255r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5257,a[2]=t2,a[3]=((C_word)li103),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5269,a[2]=t4,a[3]=((C_word)li104),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5274,a[2]=t5,a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5279,a[2]=t6,a[3]=((C_word)li106),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglst14031428 */
t8=t7;
f_5279(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-envlst14041424 */
t10=t6;
f_5274(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf14051419 */
t12=t5;
f_5269(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body14011411 */
t14=t4;
f_5257(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-arglst1403 in process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5279(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5279,NULL,2,t0,t1);}
/* def-envlst14041424 */
t2=((C_word*)t0)[2];
f_5274(t2,t1,C_SCHEME_FALSE);}

/* def-envlst1404 in process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5274,NULL,3,t0,t1,t2);}
/* def-exactf14051419 */
t3=((C_word*)t0)[2];
f_5269(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1405 in process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5269(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5269,NULL,4,t0,t1,t2,t3);}
/* body14011411 */
t4=((C_word*)t0)[2];
f_5257(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1401 in process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5257(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5257,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5261,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1875 $exec-setup */
t6=lf[292];
f_5207(t6,t5,lf[294],((C_word*)t0)[2],t2,t3,t4);}

/* k5259 in body1401 in process-execute in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
/* posixwin.scm: 1876 $exec-teardown */
f_5240(((C_word*)t0)[3],lf[294],lf[295],((C_word*)t0)[2],t2);}

/* $exec-teardown in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5240(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5240,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5244,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1867 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k5242 in $exec-teardown in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_free_exec_args();
t3=(C_word)C_free_exec_env();
t4=(C_word)C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm: 1871 ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[6]);}}

/* $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5207(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5207,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(C_word)C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5214,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t5,a[7]=t2,a[8]=((C_word*)t0)[5],a[9]=t3,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1859 pathname-strip-directory */
t9=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t9))(3,t9,t8,t3);}

/* k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5214(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5214,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5217,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=(C_word)C_block_size(t1);
/* posixwin.scm: 1860 setarg */
t4=((C_word*)t0)[4];
f_5123(5,t4,t2,C_fix(0),t1,t3);}

/* k5215 in k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5217,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5220,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5234,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1861 $quote-args-list */
t4=lf[288];
f_5044(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k5232 in k5215 in k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1861 build-exec-argvec */
f_5157(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k5218 in k5215 in k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5220,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5223,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1862 build-exec-argvec */
f_5157(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k5221 in k5218 in k5215 in k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5223,2,t0,t1);}
t2=(C_word)C_flushall();
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5230,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1864 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t3,((C_word*)t0)[2]);}

/* k5228 in k5221 in k5218 in k5215 in k5212 in $exec-setup in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1864 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* build-exec-argvec in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5157(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5157,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=(C_word)C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5169,a[2]=t8,a[3]=t2,a[4]=t4,a[5]=((C_word)li99),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_5169(t10,t1,t3,t5);}
else{
/* posixwin.scm: 1856 argvec-setter */
t6=t4;
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* doloop1341 in build-exec-argvec in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5169(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5169,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1852 argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5188,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=(C_word)C_block_size(t4);
/* posixwin.scm: 1855 argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* k5186 in doloop1341 in build-exec-argvec in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_5169(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5140(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5140,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?(C_word)C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=(C_word)C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(C_word)stub1327(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* setarg in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5123(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5123,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?(C_word)C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=(C_word)C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(C_word)stub1315(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5044(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5044,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5049,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li94),tmp=(C_word)a,a+=6,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5087,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li95),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_5087(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5087(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5087,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1833 reverse */
t4=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5115,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5118,a[2]=t4,a[3]=t6,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1838 needs-quoting? */
t8=((C_word*)t0)[2];
f_5049(t8,t7,t4);}}

/* k5116 in loop in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1838 string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],lf[289],((C_word*)t0)[2],lf[290]);}
else{
t2=((C_word*)t0)[3];
f_5115(2,t2,((C_word*)t0)[2]);}}

/* k5113 in loop in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5115,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm: 1835 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5087(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5049(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5049,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5053,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1825 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t2);}

/* k5051 in needs-quoting? in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5053,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5058,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,a[7]=((C_word)li93),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_5058(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k5051 in needs-quoting? in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5058(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5058,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5071,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5082,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1829 string-ref */
t6=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k5080 in loop in k5051 in needs-quoting? in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1829 char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5069 in loop in k5051 in needs-quoting? in $quote-args-list in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5071(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1830 loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_5058(t3,((C_word*)t0)[4],t2);}}

/* glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4932(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_4932r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4932r(t0,t1,t2);}}

static void C_ccall f_4932r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4938,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,a[8]=((C_word*)t0)[7],a[9]=((C_word)li91),tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_4938(t6,t1,t2);}

/* conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4938(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4938,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4953,a[2]=t3,a[3]=((C_word*)t0)[8],a[4]=((C_word)li88),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4959,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,a[9]=((C_word)li90),tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4959(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4959,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4963,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5033,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[281]);
/* posixwin.scm: 1787 make-pathname */
t8=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k5031 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1787 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4963,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4966,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1788 regexp */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4966,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4973,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[280]);
/* posixwin.scm: 1789 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k4971 in k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4973,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4975,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li89),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4975(t5,((C_word*)t0)[2],t1);}

/* loop in k4971 in k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4975(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4975,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[8]);
/* posixwin.scm: 1790 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_4938(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4992,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixwin.scm: 1791 string-match */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k4990 in loop in k4971 in k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4992,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5002,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixwin.scm: 1792 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixwin.scm: 1793 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4975(t3,((C_word*)t0)[6],t2);}}

/* k5000 in k4990 in loop in k4971 in k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5002,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5006,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixwin.scm: 1792 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4975(t4,t2,t3);}

/* k5004 in k5000 in k4990 in loop in k4971 in k4964 in k4961 in a4958 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5006,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4952 in conc-loop in glob in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4953(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4953,2,t0,t1);}
/* posixwin.scm: 1786 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_4873r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_4873r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4873r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4877,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1758 ##sys#check-port */
t6=*((C_word*)lf[145]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[268]);}

/* k4875 in set-buffering-mode! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4877,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4883,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[270]);
if(C_truep(t6)){
t7=t5;
f_4883(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[271]);
if(C_truep(t7)){
t8=t5;
f_4883(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[272]);
if(C_truep(t8)){
t9=t5;
f_4883(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1764 ##sys#error */
t9=*((C_word*)lf[62]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[268],lf[273],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k4881 in k4875 in set-buffering-mode! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[268]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[85],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm: 1770 ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[268],lf[269],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* terminal-port? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4867,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4871,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1748 ##sys#check-port */
t4=*((C_word*)lf[145]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[267]);}

/* k4869 in terminal-port? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* _exit in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4851(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4851r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4851r(t0,t1,t2);}}

static void C_ccall f_4851r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(t2,C_fix(0)):C_fix(0));
t5=(C_word)C_i_foreign_fixnum_argumentp(t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub1153(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4839,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub1145(t2),C_fix(0));}

/* local-time->seconds in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4824(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4824,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4828,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1730 check-time-vector */
f_4677(t3,lf[262],t2);}

/* k4826 in local-time->seconds in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1732 ##sys#cons-flonum */
((C_proc2)C_retrieve_proc(*((C_word*)lf[263]+1)))(2,*((C_word*)lf[263]+1),((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1733 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[262],lf[264],((C_word*)t0)[3]);}}

/* time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4757(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4757r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4757r(t0,t1,t2,t3);}}

static void C_ccall f_4757r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4761,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_4761(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_4761(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k4759 in time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4761,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4764,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1718 check-time-vector */
f_4677(t2,lf[259],((C_word*)t0)[2]);}

/* k4762 in k4759 in time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4764,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[259]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4773,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4783,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1722 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4786,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub1094(t4,t3),C_fix(0));}}

/* k4784 in k4762 in k4759 in time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1726 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1727 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[259],lf[261],((C_word*)t0)[2]);}}

/* k4781 in k4762 in k4759 in time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4783,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub1102(t3,t2,t1),C_fix(0));}

/* k4771 in k4762 in k4759 in time->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm: 1723 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[259],lf[260],((C_word*)t0)[2]);}}

/* seconds->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4724,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4728,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub1079(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4726 in seconds->string in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1711 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1712 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[258],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4705(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4705,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[256]);
/* posixwin.scm: 1704 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[255]+1)))(4,*((C_word*)lf[255]+1),t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4696(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4696,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[254]);
/* posixwin.scm: 1700 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[255]+1)))(4,*((C_word*)lf[255]+1),t1,t2,C_SCHEME_FALSE);}

/* check-time-vector in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4677(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4677,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_check_vector_2(t3,t2);
t5=(C_word)C_block_size(t3);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1696 ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[253],t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4611,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4617,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li76),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_4617(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4617(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4617,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4621,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub1035(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4619 in loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4621,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4629,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word)li75),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_4629(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k4619 in loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4629(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4629,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4655,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1685 substring */
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1686 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k4653 in scan in k4619 in loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4655,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4659,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1685 substring */
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k4657 in k4653 in scan in k4619 in loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4659,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4647,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1685 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_4617(t5,t3,t4);}

/* k4645 in k4657 in k4653 in scan in k4619 in loop in get-environment-variables in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4647,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4591(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4591,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[248]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4599,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1673 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k4597 in unsetenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4574,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[247]);
t5=(C_word)C_i_check_string_2(t3,lf[247]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4585,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1668 ##sys#make-c-string */
t7=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k4583 in setenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4585,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4589,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1668 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4587 in k4583 in setenv in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4544(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4544r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4544r(t0,t1,t2,t3);}}

static void C_ccall f_4544r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[245]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4551,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_4551(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[245]);
t8=t5;
f_4551(t8,(C_word)C_dup2(t2,t6));}}

/* k4549 in duplicate-fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4551(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4551,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4554,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4560,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1657 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_4554(2,t3,C_SCHEME_UNDEFINED);}}

/* k4558 in k4549 in duplicate-fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1658 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[245],lf[246],((C_word*)t0)[2]);}

/* k4552 in k4549 in duplicate-fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4509(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4509,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4513,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1639 ##sys#check-port */
t4=*((C_word*)lf[145]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[241]);}

/* k4511 in port->fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4513,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4542,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1640 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[244]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4540 in k4511 in port->fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4542,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1646 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[46],lf[241],lf[242],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4522,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4528,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1643 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_4522(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4526 in k4540 in k4511 in port->fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1644 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[241],lf[243],((C_word*)t0)[2]);}

/* k4520 in k4540 in k4511 in port->fileno in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4495(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4495r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4495r(t0,t1,t2,t3);}}

static void C_ccall f_4495r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[240]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4507,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1635 mode */
f_4426(t5,C_SCHEME_FALSE,t3);}

/* k4505 in open-output-file* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4507,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1635 check */
f_4463(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4481(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4481r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4481r(t0,t1,t2,t3);}}

static void C_ccall f_4481r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[239]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4493,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1631 mode */
f_4426(t5,C_SCHEME_TRUE,t3);}

/* k4491 in open-input-file* in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4493(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4493,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1631 check */
f_4463(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4463(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4463,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4467,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1622 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k4465 in check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4467,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1624 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[237],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4479,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1625 ##sys#make-port */
t3=*((C_word*)lf[137]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[138]+1),lf[238],lf[85]);}}

/* k4477 in k4465 in check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4426(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4426,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4434,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[231]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1617 ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[232],t5);}
else{
t8=t4;
f_4434(2,t8,lf[233]);}}
else{
/* posixwin.scm: 1618 ##sys#error */
t7=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[234],t5);}}
else{
t5=t4;
f_4434(2,t5,(C_truep(t2)?lf[235]:lf[236]));}}

/* k4432 in mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1613 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4417(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4417,3,t0,t1,t2);}
/* posixwin.scm: 1597 check */
f_4381(t1,t2,C_fix((C_word)2),lf[227]);}

/* file-write-access? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4411(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4411,3,t0,t1,t2);}
/* posixwin.scm: 1596 check */
f_4381(t1,t2,C_fix((C_word)4),lf[226]);}

/* file-read-access? in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4405(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4405,3,t0,t1,t2);}
/* posixwin.scm: 1595 check */
f_4381(t1,t2,C_fix((C_word)2),lf[225]);}

/* check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4381(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4381,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4399,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4403,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1592 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t7,t2);}

/* k4401 in check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1592 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4397 in check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4399,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4391,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_4391(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1593 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4389 in k4397 in check in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4351,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[223]);
t5=(C_word)C_i_check_exact_2(t3,lf[223]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4375,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4379,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1581 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t7,t2);}

/* k4377 in change-file-mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1581 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4373 in change-file-mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4375,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4367,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1582 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k4365 in k4373 in change-file-mode in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1583 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[223],lf[224],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4295(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4295,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4305,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1489 h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1491 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k4303 in ##sys#interrupt-hook in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1490 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4282,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[184]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k4269 in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4273(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4273,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[183]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4197r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4197r(t0,t1,t2);}}

static void C_ccall f_4197r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4201,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_4201(2,t4,(C_word)C_fixnum_or(*((C_word*)lf[21]+1),*((C_word*)lf[23]+1)));}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_4201(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k4199 in create-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4201,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4204,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE,t1),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4213,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1426 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_4204(2,t3,C_SCHEME_UNDEFINED);}}

/* k4211 in k4199 in create-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1427 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[37],lf[153],lf[154]);}

/* k4202 in k4199 in create-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1428 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4177r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4177r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4177r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[152]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4181,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k4179 in with-output-to-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4181(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4181,2,t0,t1);}
t2=C_mutate((C_word*)lf[152]+1 /* (set! standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4187,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li56),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1411 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4186 in k4179 in with-output-to-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4187(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4187r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4187r(t0,t1,t2);}}

static void C_ccall f_4187r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4191,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1413 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k4189 in a4186 in k4179 in with-output-to-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[152]+1 /* (set! standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4157r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4157r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4157r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[150]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4161,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k4159 in with-input-from-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4161,2,t0,t1);}
t2=C_mutate((C_word*)lf[150]+1 /* (set! standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4167,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li54),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1401 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4166 in k4159 in with-input-from-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4167(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4167r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4167r(t0,t1,t2);}}

static void C_ccall f_4167r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4171,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1403 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k4169 in a4166 in k4159 in with-input-from-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[150]+1 /* (set! standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4133r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4133r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4133r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4137,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k4135 in call-with-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4137,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4142,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li51),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4148,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li52),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1391 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4147 in k4135 in call-with-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4148r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4148r(t0,t1,t2);}}

static void C_ccall f_4148r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4152,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1394 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k4150 in a4147 in k4135 in call-with-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a4141 in k4135 in call-with-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4142(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4142,2,t0,t1);}
/* posixwin.scm: 1392 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4109r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4109r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4109r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4113,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k4111 in call-with-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4113,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4118,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li48),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4124,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li49),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1383 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4123 in k4111 in call-with-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4124(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4124r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4124r(t0,t1,t2);}}

static void C_ccall f_4124r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4128,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1386 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k4126 in a4123 in k4111 in call-with-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a4117 in k4111 in call-with-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4118,2,t0,t1);}
/* posixwin.scm: 1384 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4090(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4090,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4094,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1370 ##sys#check-port */
t4=*((C_word*)lf[145]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[143]);}

/* k4092 in close-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4094,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4097,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1372 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4095 in k4092 in close-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 1373 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[37],lf[143],lf[144],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4054(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_4054r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4054r(t0,t1,t2,t3);}}

static void C_ccall f_4054r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[142]);
t5=f_3982(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4068,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4075,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1365 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[141]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4085,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1366 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1367 badmode */
f_3994(t6,t5);}}}

/* k4083 in open-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4085,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4068(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k4073 in open-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4075(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4075,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4068(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k4066 in open-output-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1362 check */
f_4000(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4018(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_4018r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4018r(t0,t1,t2,t3);}}

static void C_ccall f_4018r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[140]);
t5=f_3982(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4032,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4039,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1355 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[141]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4049,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1356 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1357 badmode */
f_3994(t6,t5);}}}

/* k4047 in open-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4049,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4032(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k4037 in open-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4039,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4032(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k4030 in open-input-pipe in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1352 check */
f_4000(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4000(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4000,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4004,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1342 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k4002 in check in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4004,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1344 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[136],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4016,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1345 ##sys#make-port */
t3=*((C_word*)lf[137]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[138]+1),lf[139],lf[85]);}}

/* k4014 in k4002 in check in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3994(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3994,NULL,2,t1,t2);}
/* posixwin.scm: 1340 ##sys#error */
t3=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[135],t2);}

/* mode in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall f_3982(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[134]));}

/* canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3625(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[24],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3625,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[98]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3632,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3765,a[2]=t4,a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1279 cwd */
t8=((C_word*)t0)[5];
f_3569(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3771,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,a[9]=t4,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3972,a[2]=((C_word*)t0)[11],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1281 sref */
t10=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t10))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_3771(t9,C_SCHEME_FALSE);}}}

/* k3970 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3972(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1281 sep? */
t2=((C_word*)t0)[3];
f_3771(t2,f_3558(t1));}

/* k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3771(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3771,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3778,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3782,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1283 cwd */
t4=((C_word*)t0)[7];
f_3569(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3795,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1286 cwd */
t5=((C_word*)t0)[7];
f_3569(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3801,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3947,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3958,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1287 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k3956 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1287 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3945 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3947(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3947,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3954,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1288 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3801(t2,C_SCHEME_FALSE);}}

/* k3952 in k3945 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1288 sep? */
t2=((C_word*)t0)[3];
f_3801(t2,f_3558(t1));}

/* k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3801(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3801,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3808,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3824,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1290 cwd */
t4=((C_word*)t0)[6];
f_3569(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3837,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1296 cwd */
t5=((C_word*)t0)[6];
f_3569(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3843,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3919,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3940,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1297 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k3938 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1297 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3917 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3919(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3919,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3925,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3936,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1298 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_3843(t2,C_SCHEME_FALSE);}}

/* k3934 in k3917 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1298 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3923 in k3917 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3925,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3932,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1299 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_3843(t2,C_SCHEME_FALSE);}}

/* k3930 in k3923 in k3917 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3932(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1299 sep? */
t2=((C_word*)t0)[3];
f_3843(t2,f_3558(t1));}

/* k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3843(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3843,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[9];
f_3632(2,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3849,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3895,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3916,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1301 sref */
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[8],C_fix(0));}}

/* k3914 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1301 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3893 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3895,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3901,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3912,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1302 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3849(2,t2,C_SCHEME_FALSE);}}

/* k3910 in k3893 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1302 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3899 in k3893 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3901(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3901,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3908,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1303 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3849(2,t2,C_SCHEME_FALSE);}}

/* k3906 in k3899 in k3893 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1303 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3849(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3849,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3856,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1305 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[5],C_fix(1),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3892,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1309 sref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[5],C_fix(0));}}

/* k3890 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3892,2,t0,t1);}
t2=f_3558(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3877,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3881,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1311 cwd */
t5=((C_word*)t0)[2];
f_3569(t5,t4);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3888,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1314 cwd */
t4=((C_word*)t0)[2];
f_3569(t4,t3);}}

/* k3886 in k3890 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1314 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[133],((C_word*)t0)[2]);}

/* k3879 in k3890 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1311 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3875 in k3890 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1310 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3854 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3856,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3860,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1307 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(3),t3);}

/* k3858 in k3854 in k3847 in k3841 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3860(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1304 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[132],t1);}

/* k3835 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1296 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[131],((C_word*)t0)[2]);}

/* k3822 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1290 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(3));}

/* k3806 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3808,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3812,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1292 user */
t3=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k3810 in k3806 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3812,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3816,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1293 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k3814 in k3810 in k3806 in k3799 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1289 sappend */
t2=((C_word*)t0)[5];
((C_proc6)C_retrieve_proc(t2))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],lf[130],((C_word*)t0)[2],t1);}

/* k3793 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1286 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[129],((C_word*)t0)[2]);}

/* k3780 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1283 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3776 in k3769 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1282 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3763 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1279 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[128]);}

/* k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3632,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3639,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3751,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_block_size(t1);
/* posixwin.scm: 1315 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t3,t1,C_fix(3),t4);}

/* k3749 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[96]+1)))(4,*((C_word*)lf[96]+1),((C_word*)t0)[2],t1,lf[127]);}

/* k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3639(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3639,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3641,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word)li40),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_3641(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3641(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3641,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3648,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1317 null? */
t5=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3648,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3654,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1318 null? */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3720,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3723,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_i_car(((C_word*)t0)[4]);
/* posixwin.scm: 1329 string=? */
t6=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,lf[126],t5);}}

/* k3721 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3723,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_3720(t2,(C_word)C_i_cdr(((C_word*)t0)[4]));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3732,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(((C_word*)t0)[3]);
/* posixwin.scm: 1331 string=? */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,lf[125],t3);}}

/* k3730 in k3721 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3732,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_3720(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_3720(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k3718 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3720(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1327 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_3641(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3654(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3654,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1319 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[8],((C_word*)t0)[7],C_fix(0),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3701,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[7]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixwin.scm: 1320 sref */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,((C_word*)t0)[7],t4);}}

/* k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3701,2,t0,t1);}
t2=f_3558(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3670,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1322 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3689,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1325 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}}

/* k3687 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3689,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3693,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3697,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1326 reverse */
t4=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3695 in k3687 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1326 isperse */
f_3553(((C_word*)t0)[2],t1);}

/* k3691 in k3687 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1324 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3668 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3670,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3674,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3678,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_a_i_cons(&a,2,lf[123],((C_word*)t0)[2]);
/* posixwin.scm: 1323 reverse */
t5=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k3676 in k3668 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1323 isperse */
f_3553(((C_word*)t0)[2],t1);}

/* k3672 in k3668 in k3699 in k3652 in k3646 in loop in k3637 in k3630 in canonical-path in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1321 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3569(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3569,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3576,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3578,a[2]=((C_word*)t0)[2],a[3]=((C_word)li38),tmp=(C_word)a,a+=4,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3578(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3578,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3584,a[2]=t2,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3602,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
/* with-exception-handler */
((C_proc4)C_retrieve_proc(*((C_word*)lf[121]+1)))(4,*((C_word*)lf[121]+1),t1,t3,t4);}

/* a3601 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3602,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3608,a[2]=((C_word*)t0)[3],a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3614,a[2]=((C_word*)t0)[2],a[3]=((C_word)li36),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t2,t3);}

/* a3613 in a3601 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3614(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3614r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3614r(t0,t1,t2);}}

static void C_ccall f_3614r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3620,a[2]=t2,a[3]=((C_word)li35),tmp=(C_word)a,a+=4,tmp);
/* k581587 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a3619 in a3613 in a3601 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3620,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a3607 in a3601 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3608,2,t0,t1);}
/* posixwin.scm: 1274 cw */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a3583 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3584(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3584,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3590,a[2]=t2,a[3]=((C_word)li32),tmp=(C_word)a,a+=4,tmp);
/* k581587 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a3589 in a3583 in a3577 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3590(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3590,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[119]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[120]);}

/* k3574 in cwd in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* sep? in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall f_3558(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3553(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3553,NULL,2,t1,t2);}
/* string-intersperse */
((C_proc4)C_retrieve_proc(*((C_word*)lf[116]+1)))(4,*((C_word*)lf[116]+1),t1,t2,lf[117]);}

/* current-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3502(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3502r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3502r(t0,t1,t2);}}

static void C_ccall f_3502r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3506,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_3506(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_3506(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3504 in current-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3506(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3506,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1252 change-directory */
((C_proc3)C_retrieve_proc(*((C_word*)lf[99]+1)))(3,*((C_word*)lf[99]+1),((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3515,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1253 make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k3513 in k3504 in current-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3515,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3518,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1255 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3516 in k3513 in k3504 in current-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 1257 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 1258 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[107],lf[110]);}}

/* directory? in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3475(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3475,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[108]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3482,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3496,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3500,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1245 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t6,t2);}

/* k3498 in directory? in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1245 ##sys#platform-fixup-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[109]+1)))(3,*((C_word*)lf[109]+1),((C_word*)t0)[2],t1);}

/* k3494 in directory? in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1244 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3480 in directory? in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_3315r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3315r(t0,t1,t2);}}

static void C_ccall f_3315r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3317,a[2]=((C_word*)t0)[2],a[3]=((C_word)li24),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3418,a[2]=t3,a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3423,a[2]=t4,a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec428486 */
t6=t5;
f_3423(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?429482 */
t8=t4;
f_3418(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body426435 */
t10=t3;
f_3317(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[2],t9);}}}}

/* def-spec428 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3423(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3423,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3431,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1215 current-directory */
((C_proc2)C_retrieve_proc(*((C_word*)lf[107]+1)))(2,*((C_word*)lf[107]+1),t2);}

/* k3429 in def-spec428 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3431(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?429482 */
t2=((C_word*)t0)[3];
f_3418(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?429 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3418(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3418,NULL,3,t0,t1,t2);}
/* body426435 */
t3=((C_word*)t0)[2];
f_3317(t3,t1,t2,C_SCHEME_FALSE);}

/* body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3317(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3317,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[104]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3324,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1217 make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3324(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3324,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3327,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1218 ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[106]+1)))(2,*((C_word*)lf[106]+1),t2);}

/* k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3327,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3330,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1219 ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[106]+1)))(2,*((C_word*)lf[106]+1),t2);}

/* k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3330,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3334,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3417,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1220 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t3,((C_word*)t0)[4]);}

/* k3415 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1220 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3334,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3343,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1223 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3351,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word)li23),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3351(t6,((C_word*)t0)[6]);}}

/* loop in k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3351(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3351,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3361,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1232 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k3359 in loop in k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3361,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3373,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_3373(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_3373(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_3373(t7,C_SCHEME_FALSE);}}

/* k3371 in k3359 in loop in k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3373(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3373,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1239 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_3351(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3383,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1240 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3351(t3,t2);}}

/* k3381 in k3371 in k3359 in loop in k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3383,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k3341 in k3332 in k3328 in k3325 in k3322 in body426 in directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1224 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[104],lf[105],((C_word*)t0)[2]);}

/* delete-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3288(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3288,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[101]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3309,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3313,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1207 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k3311 in delete-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3313(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1207 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3307 in delete-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3309,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3301,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1208 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3299 in k3307 in delete-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3301(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1209 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[101],lf[102],((C_word*)t0)[2]);}

/* change-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3261(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3261,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[99]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3282,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3286,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1200 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k3284 in change-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1200 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3280 in change-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3282,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3274,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1201 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3272 in k3280 in change-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1202 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[99],lf[100],((C_word*)t0)[2]);}

/* create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3148(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3148r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3148r(t0,t1,t2,t3);}}

static void C_ccall f_3148r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3152,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_3152(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_3152(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3152,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[91]);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3161,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1188 canonical-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[98]+1)))(3,*((C_word*)lf[98]+1),t3,((C_word*)t0)[3]);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3223,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1189 canonical-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[98]+1)))(3,*((C_word*)lf[98]+1),t3,((C_word*)t0)[3]);}}

/* k3221 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3223,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3240,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1159 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k3238 in k3221 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3240(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3240,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3232,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3230 in k3238 in k3221 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[91],lf[92],((C_word*)t0)[2]);}

/* k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3161,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3164,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1176 string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[96]+1)))(4,*((C_word*)lf[96]+1),t2,t1,lf[97]);}

/* k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3164,2,t0,t1);}
t2=(C_word)C_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3172,a[2]=t4,a[3]=((C_word)li19),tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_i_cdr(t1);
/* for-each */
t7=*((C_word*)lf[95]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,((C_word*)t0)[2],t5,t6);}

/* a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3172(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3172,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3177,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1180 string-append */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[94],t2);}

/* k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3177,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3183,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3203,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1165 file-exists? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[93]+1)))(3,*((C_word*)lf[93]+1),t5,t3);}

/* k3201 in k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3203,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3206,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1166 ##sys#file-info */
t3=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_3183(t2,C_SCHEME_FALSE);}}

/* k3204 in k3201 in k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_3183(t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_3183(t2,C_SCHEME_FALSE);}}

/* k3181 in k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3183(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3183,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3200,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1159 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k3198 in k3181 in k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3200,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3192,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3190 in k3198 in k3181 in k3175 in a3171 in k3162 in k3159 in k3150 in create-directory in k3144 in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[91],lf[92],((C_word*)t0)[2]);}

/* set-file-position! in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3083(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3083r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3083r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3083r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[83]);
t8=(C_word)C_i_check_exact_2(t6,lf[83]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3096,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 1131 ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[88],lf[83],lf[89],t3,t2);}
else{
t10=t9;
f_3096(2,t10,C_SCHEME_UNDEFINED);}}

/* k3094 in set-file-position! in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3096,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3102,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3111,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1132 port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[87]+1)))(3,*((C_word*)lf[87]+1),t3,((C_word*)t0)[4]);}

/* k3109 in k3094 in set-file-position! in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[85]);
t4=((C_word*)t0)[4];
f_3102(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_3102(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 1136 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[46],lf[83],lf[86],((C_word*)t0)[5]);}}}

/* k3100 in k3094 in set-file-position! in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3102,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3105,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1137 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k3103 in k3100 in k3094 in set-file-position! in k3079 in k3075 in k3071 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1138 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[83],lf[84],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* stat-type in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3034(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3034,NULL,2,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3036,a[2]=t2,a[3]=((C_word)li16),tmp=(C_word)a,a+=4,tmp));}

/* f_3036 in stat-type in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3036(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3036,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3029(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3029,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[71]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3006(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3006,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[69]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3013,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3027,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1102 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k3025 in regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1102 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3011 in regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3000(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3000,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3004,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1098 ##sys#stat */
f_2901(t3,t2);}

/* k3002 in file-permissions in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2994,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2998,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1097 ##sys#stat */
f_2901(t3,t2);}

/* k2996 in file-owner in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2988(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2988,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2992,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1096 ##sys#stat */
f_2901(t3,t2);}

/* k2990 in file-change-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2992,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2982(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2982,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2986,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1095 ##sys#stat */
f_2901(t3,t2);}

/* k2984 in file-access-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2986,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2976(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2976,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2980,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1094 ##sys#stat */
f_2901(t3,t2);}

/* k2978 in file-modification-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2980,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2970,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2974,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1093 ##sys#stat */
f_2901(t3,t2);}

/* k2972 in file-size in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2939(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2939r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2939r(t0,t1,t2,t3);}}

static void C_ccall f_2939r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2943,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_2943(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_2943(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k2941 in file-stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2943,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2946,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1087 ##sys#stat */
f_2901(t2,((C_word*)t0)[2]);}

/* k2944 in k2941 in file-stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2946(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2946,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(0),C_fix(0),C_fix(0),C_fix(0)));}

/* ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_2901(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2901,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2905,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2905(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2930,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2934,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1080 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}
else{
/* posixwin.scm: 1081 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[46],lf[60],t2);}}}

/* k2932 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1080 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2928 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2930(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2905(2,t2,(C_word)C_stat(t1));}

/* k2903 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2905(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2905,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2914,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1083 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2912 in k2903 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1084 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[59],((C_word*)t0)[2]);}

/* file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2863(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2863,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[52]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2870,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1049 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2868 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2870,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2873,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1051 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k2871 in k2868 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2873,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2876,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2893,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1053 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_2876(2,t4,C_SCHEME_UNDEFINED);}}

/* k2891 in k2871 in k2868 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1054 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[52],lf[54],((C_word*)t0)[2]);}

/* k2874 in k2871 in k2868 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2876,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2883,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1055 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k2881 in k2874 in k2871 in k2868 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1055 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2821(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2821r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2821r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2821r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[48]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2828,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_2828(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1036 ##sys#signal-hook */
t8=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[46],lf[48],lf[50],t3);}}

/* k2826 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2828,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[48]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2837,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2843,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1041 ##sys#update-errno */
t9=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_2837(2,t8,C_SCHEME_UNDEFINED);}}

/* k2841 in k2826 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1042 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[48],lf[49],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2835 in k2826 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2776(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2776r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2776r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2776r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[44]);
t6=(C_word)C_i_check_exact_2(t3,lf[44]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2786,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_2786(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixwin.scm: 1023 make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k2784 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2786,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2789,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_2789(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1025 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[46],lf[44],lf[47],t1);}}

/* k2787 in k2784 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2789,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2792,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2801,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1028 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_2792(2,t5,C_SCHEME_UNDEFINED);}}

/* k2799 in k2787 in k2784 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1029 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[44],lf[45],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2790 in k2787 in k2784 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2792,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2758(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2758,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[41]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2771,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1015 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2769 in file-close in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1016 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[41],lf[42],((C_word*)t0)[2]);}

/* file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2717r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2717r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2717r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[36]);
t8=(C_word)C_i_check_exact_2(t3,lf[36]);
t9=(C_word)C_i_check_exact_2(t6,lf[36]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2734,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2750,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1005 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t11,t2);}

/* k2748 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1005 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2732 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2734,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2737,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2743,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1007 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_2737(2,t5,C_SCHEME_UNDEFINED);}}

/* k2741 in k2732 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1008 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[37],lf[36],lf[38],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2735 in k2732 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_2671r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2671r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2671r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2675,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 936  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k2673 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2675,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2682,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2686,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub23(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k2684 in k2673 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 937  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k2680 in k2673 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[465] = {
{"toplevel:posixwin_scm",(void*)C_posix_toplevel},
{"f_2641:posixwin_scm",(void*)f_2641},
{"f_2644:posixwin_scm",(void*)f_2644},
{"f_2647:posixwin_scm",(void*)f_2647},
{"f_2650:posixwin_scm",(void*)f_2650},
{"f_2653:posixwin_scm",(void*)f_2653},
{"f_2656:posixwin_scm",(void*)f_2656},
{"f_2659:posixwin_scm",(void*)f_2659},
{"f_3045:posixwin_scm",(void*)f_3045},
{"f_3049:posixwin_scm",(void*)f_3049},
{"f_3053:posixwin_scm",(void*)f_3053},
{"f_3057:posixwin_scm",(void*)f_3057},
{"f_3061:posixwin_scm",(void*)f_3061},
{"f_3065:posixwin_scm",(void*)f_3065},
{"f_3069:posixwin_scm",(void*)f_3069},
{"f_3073:posixwin_scm",(void*)f_3073},
{"f_3077:posixwin_scm",(void*)f_3077},
{"f_3081:posixwin_scm",(void*)f_3081},
{"f_6526:posixwin_scm",(void*)f_6526},
{"f_6545:posixwin_scm",(void*)f_6545},
{"f_6530:posixwin_scm",(void*)f_6530},
{"f_6539:posixwin_scm",(void*)f_6539},
{"f_6533:posixwin_scm",(void*)f_6533},
{"f_3146:posixwin_scm",(void*)f_3146},
{"f_4271:posixwin_scm",(void*)f_4271},
{"f_6507:posixwin_scm",(void*)f_6507},
{"f_6504:posixwin_scm",(void*)f_6504},
{"f_6497:posixwin_scm",(void*)f_6497},
{"f_6491:posixwin_scm",(void*)f_6491},
{"f_6485:posixwin_scm",(void*)f_6485},
{"f_6479:posixwin_scm",(void*)f_6479},
{"f_6473:posixwin_scm",(void*)f_6473},
{"f_6467:posixwin_scm",(void*)f_6467},
{"f_6461:posixwin_scm",(void*)f_6461},
{"f_6455:posixwin_scm",(void*)f_6455},
{"f_6449:posixwin_scm",(void*)f_6449},
{"f_6443:posixwin_scm",(void*)f_6443},
{"f_6437:posixwin_scm",(void*)f_6437},
{"f_6431:posixwin_scm",(void*)f_6431},
{"f_6425:posixwin_scm",(void*)f_6425},
{"f_6419:posixwin_scm",(void*)f_6419},
{"f_6413:posixwin_scm",(void*)f_6413},
{"f_6407:posixwin_scm",(void*)f_6407},
{"f_6401:posixwin_scm",(void*)f_6401},
{"f_6395:posixwin_scm",(void*)f_6395},
{"f_6389:posixwin_scm",(void*)f_6389},
{"f_6383:posixwin_scm",(void*)f_6383},
{"f_6377:posixwin_scm",(void*)f_6377},
{"f_6371:posixwin_scm",(void*)f_6371},
{"f_6365:posixwin_scm",(void*)f_6365},
{"f_6359:posixwin_scm",(void*)f_6359},
{"f_6353:posixwin_scm",(void*)f_6353},
{"f_6347:posixwin_scm",(void*)f_6347},
{"f_6341:posixwin_scm",(void*)f_6341},
{"f_6335:posixwin_scm",(void*)f_6335},
{"f_6329:posixwin_scm",(void*)f_6329},
{"f_6323:posixwin_scm",(void*)f_6323},
{"f_6317:posixwin_scm",(void*)f_6317},
{"f_6311:posixwin_scm",(void*)f_6311},
{"f_6305:posixwin_scm",(void*)f_6305},
{"f_6299:posixwin_scm",(void*)f_6299},
{"f_6293:posixwin_scm",(void*)f_6293},
{"f_6287:posixwin_scm",(void*)f_6287},
{"f_6281:posixwin_scm",(void*)f_6281},
{"f_6275:posixwin_scm",(void*)f_6275},
{"f_6269:posixwin_scm",(void*)f_6269},
{"f_6263:posixwin_scm",(void*)f_6263},
{"f_6257:posixwin_scm",(void*)f_6257},
{"f_6251:posixwin_scm",(void*)f_6251},
{"f_6245:posixwin_scm",(void*)f_6245},
{"f_6025:posixwin_scm",(void*)f_6025},
{"f_6176:posixwin_scm",(void*)f_6176},
{"f_6182:posixwin_scm",(void*)f_6182},
{"f_6171:posixwin_scm",(void*)f_6171},
{"f_6166:posixwin_scm",(void*)f_6166},
{"f_6027:posixwin_scm",(void*)f_6027},
{"f_6153:posixwin_scm",(void*)f_6153},
{"f_6161:posixwin_scm",(void*)f_6161},
{"f_6034:posixwin_scm",(void*)f_6034},
{"f_6141:posixwin_scm",(void*)f_6141},
{"f_6044:posixwin_scm",(void*)f_6044},
{"f_6046:posixwin_scm",(void*)f_6046},
{"f_6065:posixwin_scm",(void*)f_6065},
{"f_6127:posixwin_scm",(void*)f_6127},
{"f_6134:posixwin_scm",(void*)f_6134},
{"f_6121:posixwin_scm",(void*)f_6121},
{"f_6080:posixwin_scm",(void*)f_6080},
{"f_6111:posixwin_scm",(void*)f_6111},
{"f_6097:posixwin_scm",(void*)f_6097},
{"f_6109:posixwin_scm",(void*)f_6109},
{"f_6105:posixwin_scm",(void*)f_6105},
{"f_6092:posixwin_scm",(void*)f_6092},
{"f_6090:posixwin_scm",(void*)f_6090},
{"f_6145:posixwin_scm",(void*)f_6145},
{"f_6010:posixwin_scm",(void*)f_6010},
{"f_6020:posixwin_scm",(void*)f_6020},
{"f_5979:posixwin_scm",(void*)f_5979},
{"f_6005:posixwin_scm",(void*)f_6005},
{"f_5990:posixwin_scm",(void*)f_5990},
{"f_5994:posixwin_scm",(void*)f_5994},
{"f_5998:posixwin_scm",(void*)f_5998},
{"f_6002:posixwin_scm",(void*)f_6002},
{"f_5967:posixwin_scm",(void*)f_5967},
{"f_5964:posixwin_scm",(void*)f_5964},
{"f_5904:posixwin_scm",(void*)f_5904},
{"f_5931:posixwin_scm",(void*)f_5931},
{"f_5941:posixwin_scm",(void*)f_5941},
{"f_5925:posixwin_scm",(void*)f_5925},
{"f_5892:posixwin_scm",(void*)f_5892},
{"f_5812:posixwin_scm",(void*)f_5812},
{"f_5829:posixwin_scm",(void*)f_5829},
{"f_5824:posixwin_scm",(void*)f_5824},
{"f_5819:posixwin_scm",(void*)f_5819},
{"f_5814:posixwin_scm",(void*)f_5814},
{"f_5732:posixwin_scm",(void*)f_5732},
{"f_5749:posixwin_scm",(void*)f_5749},
{"f_5744:posixwin_scm",(void*)f_5744},
{"f_5739:posixwin_scm",(void*)f_5739},
{"f_5734:posixwin_scm",(void*)f_5734},
{"f_5670:posixwin_scm",(void*)f_5670},
{"f_5726:posixwin_scm",(void*)f_5726},
{"f_5730:posixwin_scm",(void*)f_5730},
{"f_5691:posixwin_scm",(void*)f_5691},
{"f_5694:posixwin_scm",(void*)f_5694},
{"f_5705:posixwin_scm",(void*)f_5705},
{"f_5699:posixwin_scm",(void*)f_5699},
{"f_5672:posixwin_scm",(void*)f_5672},
{"f_5681:posixwin_scm",(void*)f_5681},
{"f_5551:posixwin_scm",(void*)f_5551},
{"f_5555:posixwin_scm",(void*)f_5555},
{"f_5646:posixwin_scm",(void*)f_5646},
{"f_5558:posixwin_scm",(void*)f_5558},
{"f_5614:posixwin_scm",(void*)f_5614},
{"f_5618:posixwin_scm",(void*)f_5618},
{"f_5622:posixwin_scm",(void*)f_5622},
{"f_5626:posixwin_scm",(void*)f_5626},
{"f_5630:posixwin_scm",(void*)f_5630},
{"f_5493:posixwin_scm",(void*)f_5493},
{"f_5497:posixwin_scm",(void*)f_5497},
{"f_5607:posixwin_scm",(void*)f_5607},
{"f_5587:posixwin_scm",(void*)f_5587},
{"f_5591:posixwin_scm",(void*)f_5591},
{"f_5595:posixwin_scm",(void*)f_5595},
{"f_5459:posixwin_scm",(void*)f_5459},
{"f_5476:posixwin_scm",(void*)f_5476},
{"f_5480:posixwin_scm",(void*)f_5480},
{"f_5453:posixwin_scm",(void*)f_5453},
{"f_5432:posixwin_scm",(void*)f_5432},
{"f_5436:posixwin_scm",(void*)f_5436},
{"f_5448:posixwin_scm",(void*)f_5448},
{"f_5429:posixwin_scm",(void*)f_5429},
{"f_5342:posixwin_scm",(void*)f_5342},
{"f_5366:posixwin_scm",(void*)f_5366},
{"f_5361:posixwin_scm",(void*)f_5361},
{"f_5356:posixwin_scm",(void*)f_5356},
{"f_5344:posixwin_scm",(void*)f_5344},
{"f_5348:posixwin_scm",(void*)f_5348},
{"f_5255:posixwin_scm",(void*)f_5255},
{"f_5279:posixwin_scm",(void*)f_5279},
{"f_5274:posixwin_scm",(void*)f_5274},
{"f_5269:posixwin_scm",(void*)f_5269},
{"f_5257:posixwin_scm",(void*)f_5257},
{"f_5261:posixwin_scm",(void*)f_5261},
{"f_5240:posixwin_scm",(void*)f_5240},
{"f_5244:posixwin_scm",(void*)f_5244},
{"f_5207:posixwin_scm",(void*)f_5207},
{"f_5214:posixwin_scm",(void*)f_5214},
{"f_5217:posixwin_scm",(void*)f_5217},
{"f_5234:posixwin_scm",(void*)f_5234},
{"f_5220:posixwin_scm",(void*)f_5220},
{"f_5223:posixwin_scm",(void*)f_5223},
{"f_5230:posixwin_scm",(void*)f_5230},
{"f_5157:posixwin_scm",(void*)f_5157},
{"f_5169:posixwin_scm",(void*)f_5169},
{"f_5188:posixwin_scm",(void*)f_5188},
{"f_5140:posixwin_scm",(void*)f_5140},
{"f_5123:posixwin_scm",(void*)f_5123},
{"f_5044:posixwin_scm",(void*)f_5044},
{"f_5087:posixwin_scm",(void*)f_5087},
{"f_5118:posixwin_scm",(void*)f_5118},
{"f_5115:posixwin_scm",(void*)f_5115},
{"f_5049:posixwin_scm",(void*)f_5049},
{"f_5053:posixwin_scm",(void*)f_5053},
{"f_5058:posixwin_scm",(void*)f_5058},
{"f_5082:posixwin_scm",(void*)f_5082},
{"f_5071:posixwin_scm",(void*)f_5071},
{"f_4932:posixwin_scm",(void*)f_4932},
{"f_4938:posixwin_scm",(void*)f_4938},
{"f_4959:posixwin_scm",(void*)f_4959},
{"f_5033:posixwin_scm",(void*)f_5033},
{"f_4963:posixwin_scm",(void*)f_4963},
{"f_4966:posixwin_scm",(void*)f_4966},
{"f_4973:posixwin_scm",(void*)f_4973},
{"f_4975:posixwin_scm",(void*)f_4975},
{"f_4992:posixwin_scm",(void*)f_4992},
{"f_5002:posixwin_scm",(void*)f_5002},
{"f_5006:posixwin_scm",(void*)f_5006},
{"f_4953:posixwin_scm",(void*)f_4953},
{"f_4873:posixwin_scm",(void*)f_4873},
{"f_4877:posixwin_scm",(void*)f_4877},
{"f_4883:posixwin_scm",(void*)f_4883},
{"f_4867:posixwin_scm",(void*)f_4867},
{"f_4871:posixwin_scm",(void*)f_4871},
{"f_4851:posixwin_scm",(void*)f_4851},
{"f_4839:posixwin_scm",(void*)f_4839},
{"f_4824:posixwin_scm",(void*)f_4824},
{"f_4828:posixwin_scm",(void*)f_4828},
{"f_4757:posixwin_scm",(void*)f_4757},
{"f_4761:posixwin_scm",(void*)f_4761},
{"f_4764:posixwin_scm",(void*)f_4764},
{"f_4786:posixwin_scm",(void*)f_4786},
{"f_4783:posixwin_scm",(void*)f_4783},
{"f_4773:posixwin_scm",(void*)f_4773},
{"f_4724:posixwin_scm",(void*)f_4724},
{"f_4728:posixwin_scm",(void*)f_4728},
{"f_4705:posixwin_scm",(void*)f_4705},
{"f_4696:posixwin_scm",(void*)f_4696},
{"f_4677:posixwin_scm",(void*)f_4677},
{"f_4611:posixwin_scm",(void*)f_4611},
{"f_4617:posixwin_scm",(void*)f_4617},
{"f_4621:posixwin_scm",(void*)f_4621},
{"f_4629:posixwin_scm",(void*)f_4629},
{"f_4655:posixwin_scm",(void*)f_4655},
{"f_4659:posixwin_scm",(void*)f_4659},
{"f_4647:posixwin_scm",(void*)f_4647},
{"f_4591:posixwin_scm",(void*)f_4591},
{"f_4599:posixwin_scm",(void*)f_4599},
{"f_4574:posixwin_scm",(void*)f_4574},
{"f_4585:posixwin_scm",(void*)f_4585},
{"f_4589:posixwin_scm",(void*)f_4589},
{"f_4544:posixwin_scm",(void*)f_4544},
{"f_4551:posixwin_scm",(void*)f_4551},
{"f_4560:posixwin_scm",(void*)f_4560},
{"f_4554:posixwin_scm",(void*)f_4554},
{"f_4509:posixwin_scm",(void*)f_4509},
{"f_4513:posixwin_scm",(void*)f_4513},
{"f_4542:posixwin_scm",(void*)f_4542},
{"f_4528:posixwin_scm",(void*)f_4528},
{"f_4522:posixwin_scm",(void*)f_4522},
{"f_4495:posixwin_scm",(void*)f_4495},
{"f_4507:posixwin_scm",(void*)f_4507},
{"f_4481:posixwin_scm",(void*)f_4481},
{"f_4493:posixwin_scm",(void*)f_4493},
{"f_4463:posixwin_scm",(void*)f_4463},
{"f_4467:posixwin_scm",(void*)f_4467},
{"f_4479:posixwin_scm",(void*)f_4479},
{"f_4426:posixwin_scm",(void*)f_4426},
{"f_4434:posixwin_scm",(void*)f_4434},
{"f_4417:posixwin_scm",(void*)f_4417},
{"f_4411:posixwin_scm",(void*)f_4411},
{"f_4405:posixwin_scm",(void*)f_4405},
{"f_4381:posixwin_scm",(void*)f_4381},
{"f_4403:posixwin_scm",(void*)f_4403},
{"f_4399:posixwin_scm",(void*)f_4399},
{"f_4391:posixwin_scm",(void*)f_4391},
{"f_4351:posixwin_scm",(void*)f_4351},
{"f_4379:posixwin_scm",(void*)f_4379},
{"f_4375:posixwin_scm",(void*)f_4375},
{"f_4367:posixwin_scm",(void*)f_4367},
{"f_4295:posixwin_scm",(void*)f_4295},
{"f_4305:posixwin_scm",(void*)f_4305},
{"f_4282:posixwin_scm",(void*)f_4282},
{"f_4273:posixwin_scm",(void*)f_4273},
{"f_4197:posixwin_scm",(void*)f_4197},
{"f_4201:posixwin_scm",(void*)f_4201},
{"f_4213:posixwin_scm",(void*)f_4213},
{"f_4204:posixwin_scm",(void*)f_4204},
{"f_4177:posixwin_scm",(void*)f_4177},
{"f_4181:posixwin_scm",(void*)f_4181},
{"f_4187:posixwin_scm",(void*)f_4187},
{"f_4191:posixwin_scm",(void*)f_4191},
{"f_4157:posixwin_scm",(void*)f_4157},
{"f_4161:posixwin_scm",(void*)f_4161},
{"f_4167:posixwin_scm",(void*)f_4167},
{"f_4171:posixwin_scm",(void*)f_4171},
{"f_4133:posixwin_scm",(void*)f_4133},
{"f_4137:posixwin_scm",(void*)f_4137},
{"f_4148:posixwin_scm",(void*)f_4148},
{"f_4152:posixwin_scm",(void*)f_4152},
{"f_4142:posixwin_scm",(void*)f_4142},
{"f_4109:posixwin_scm",(void*)f_4109},
{"f_4113:posixwin_scm",(void*)f_4113},
{"f_4124:posixwin_scm",(void*)f_4124},
{"f_4128:posixwin_scm",(void*)f_4128},
{"f_4118:posixwin_scm",(void*)f_4118},
{"f_4090:posixwin_scm",(void*)f_4090},
{"f_4094:posixwin_scm",(void*)f_4094},
{"f_4097:posixwin_scm",(void*)f_4097},
{"f_4054:posixwin_scm",(void*)f_4054},
{"f_4085:posixwin_scm",(void*)f_4085},
{"f_4075:posixwin_scm",(void*)f_4075},
{"f_4068:posixwin_scm",(void*)f_4068},
{"f_4018:posixwin_scm",(void*)f_4018},
{"f_4049:posixwin_scm",(void*)f_4049},
{"f_4039:posixwin_scm",(void*)f_4039},
{"f_4032:posixwin_scm",(void*)f_4032},
{"f_4000:posixwin_scm",(void*)f_4000},
{"f_4004:posixwin_scm",(void*)f_4004},
{"f_4016:posixwin_scm",(void*)f_4016},
{"f_3994:posixwin_scm",(void*)f_3994},
{"f_3982:posixwin_scm",(void*)f_3982},
{"f_3625:posixwin_scm",(void*)f_3625},
{"f_3972:posixwin_scm",(void*)f_3972},
{"f_3771:posixwin_scm",(void*)f_3771},
{"f_3958:posixwin_scm",(void*)f_3958},
{"f_3947:posixwin_scm",(void*)f_3947},
{"f_3954:posixwin_scm",(void*)f_3954},
{"f_3801:posixwin_scm",(void*)f_3801},
{"f_3940:posixwin_scm",(void*)f_3940},
{"f_3919:posixwin_scm",(void*)f_3919},
{"f_3936:posixwin_scm",(void*)f_3936},
{"f_3925:posixwin_scm",(void*)f_3925},
{"f_3932:posixwin_scm",(void*)f_3932},
{"f_3843:posixwin_scm",(void*)f_3843},
{"f_3916:posixwin_scm",(void*)f_3916},
{"f_3895:posixwin_scm",(void*)f_3895},
{"f_3912:posixwin_scm",(void*)f_3912},
{"f_3901:posixwin_scm",(void*)f_3901},
{"f_3908:posixwin_scm",(void*)f_3908},
{"f_3849:posixwin_scm",(void*)f_3849},
{"f_3892:posixwin_scm",(void*)f_3892},
{"f_3888:posixwin_scm",(void*)f_3888},
{"f_3881:posixwin_scm",(void*)f_3881},
{"f_3877:posixwin_scm",(void*)f_3877},
{"f_3856:posixwin_scm",(void*)f_3856},
{"f_3860:posixwin_scm",(void*)f_3860},
{"f_3837:posixwin_scm",(void*)f_3837},
{"f_3824:posixwin_scm",(void*)f_3824},
{"f_3808:posixwin_scm",(void*)f_3808},
{"f_3812:posixwin_scm",(void*)f_3812},
{"f_3816:posixwin_scm",(void*)f_3816},
{"f_3795:posixwin_scm",(void*)f_3795},
{"f_3782:posixwin_scm",(void*)f_3782},
{"f_3778:posixwin_scm",(void*)f_3778},
{"f_3765:posixwin_scm",(void*)f_3765},
{"f_3632:posixwin_scm",(void*)f_3632},
{"f_3751:posixwin_scm",(void*)f_3751},
{"f_3639:posixwin_scm",(void*)f_3639},
{"f_3641:posixwin_scm",(void*)f_3641},
{"f_3648:posixwin_scm",(void*)f_3648},
{"f_3723:posixwin_scm",(void*)f_3723},
{"f_3732:posixwin_scm",(void*)f_3732},
{"f_3720:posixwin_scm",(void*)f_3720},
{"f_3654:posixwin_scm",(void*)f_3654},
{"f_3701:posixwin_scm",(void*)f_3701},
{"f_3689:posixwin_scm",(void*)f_3689},
{"f_3697:posixwin_scm",(void*)f_3697},
{"f_3693:posixwin_scm",(void*)f_3693},
{"f_3670:posixwin_scm",(void*)f_3670},
{"f_3678:posixwin_scm",(void*)f_3678},
{"f_3674:posixwin_scm",(void*)f_3674},
{"f_3569:posixwin_scm",(void*)f_3569},
{"f_3578:posixwin_scm",(void*)f_3578},
{"f_3602:posixwin_scm",(void*)f_3602},
{"f_3614:posixwin_scm",(void*)f_3614},
{"f_3620:posixwin_scm",(void*)f_3620},
{"f_3608:posixwin_scm",(void*)f_3608},
{"f_3584:posixwin_scm",(void*)f_3584},
{"f_3590:posixwin_scm",(void*)f_3590},
{"f_3576:posixwin_scm",(void*)f_3576},
{"f_3558:posixwin_scm",(void*)f_3558},
{"f_3553:posixwin_scm",(void*)f_3553},
{"f_3502:posixwin_scm",(void*)f_3502},
{"f_3506:posixwin_scm",(void*)f_3506},
{"f_3515:posixwin_scm",(void*)f_3515},
{"f_3518:posixwin_scm",(void*)f_3518},
{"f_3475:posixwin_scm",(void*)f_3475},
{"f_3500:posixwin_scm",(void*)f_3500},
{"f_3496:posixwin_scm",(void*)f_3496},
{"f_3482:posixwin_scm",(void*)f_3482},
{"f_3315:posixwin_scm",(void*)f_3315},
{"f_3423:posixwin_scm",(void*)f_3423},
{"f_3431:posixwin_scm",(void*)f_3431},
{"f_3418:posixwin_scm",(void*)f_3418},
{"f_3317:posixwin_scm",(void*)f_3317},
{"f_3324:posixwin_scm",(void*)f_3324},
{"f_3327:posixwin_scm",(void*)f_3327},
{"f_3330:posixwin_scm",(void*)f_3330},
{"f_3417:posixwin_scm",(void*)f_3417},
{"f_3334:posixwin_scm",(void*)f_3334},
{"f_3351:posixwin_scm",(void*)f_3351},
{"f_3361:posixwin_scm",(void*)f_3361},
{"f_3373:posixwin_scm",(void*)f_3373},
{"f_3383:posixwin_scm",(void*)f_3383},
{"f_3343:posixwin_scm",(void*)f_3343},
{"f_3288:posixwin_scm",(void*)f_3288},
{"f_3313:posixwin_scm",(void*)f_3313},
{"f_3309:posixwin_scm",(void*)f_3309},
{"f_3301:posixwin_scm",(void*)f_3301},
{"f_3261:posixwin_scm",(void*)f_3261},
{"f_3286:posixwin_scm",(void*)f_3286},
{"f_3282:posixwin_scm",(void*)f_3282},
{"f_3274:posixwin_scm",(void*)f_3274},
{"f_3148:posixwin_scm",(void*)f_3148},
{"f_3152:posixwin_scm",(void*)f_3152},
{"f_3223:posixwin_scm",(void*)f_3223},
{"f_3240:posixwin_scm",(void*)f_3240},
{"f_3232:posixwin_scm",(void*)f_3232},
{"f_3161:posixwin_scm",(void*)f_3161},
{"f_3164:posixwin_scm",(void*)f_3164},
{"f_3172:posixwin_scm",(void*)f_3172},
{"f_3177:posixwin_scm",(void*)f_3177},
{"f_3203:posixwin_scm",(void*)f_3203},
{"f_3206:posixwin_scm",(void*)f_3206},
{"f_3183:posixwin_scm",(void*)f_3183},
{"f_3200:posixwin_scm",(void*)f_3200},
{"f_3192:posixwin_scm",(void*)f_3192},
{"f_3083:posixwin_scm",(void*)f_3083},
{"f_3096:posixwin_scm",(void*)f_3096},
{"f_3111:posixwin_scm",(void*)f_3111},
{"f_3102:posixwin_scm",(void*)f_3102},
{"f_3105:posixwin_scm",(void*)f_3105},
{"f_3034:posixwin_scm",(void*)f_3034},
{"f_3036:posixwin_scm",(void*)f_3036},
{"f_3029:posixwin_scm",(void*)f_3029},
{"f_3006:posixwin_scm",(void*)f_3006},
{"f_3027:posixwin_scm",(void*)f_3027},
{"f_3013:posixwin_scm",(void*)f_3013},
{"f_3000:posixwin_scm",(void*)f_3000},
{"f_3004:posixwin_scm",(void*)f_3004},
{"f_2994:posixwin_scm",(void*)f_2994},
{"f_2998:posixwin_scm",(void*)f_2998},
{"f_2988:posixwin_scm",(void*)f_2988},
{"f_2992:posixwin_scm",(void*)f_2992},
{"f_2982:posixwin_scm",(void*)f_2982},
{"f_2986:posixwin_scm",(void*)f_2986},
{"f_2976:posixwin_scm",(void*)f_2976},
{"f_2980:posixwin_scm",(void*)f_2980},
{"f_2970:posixwin_scm",(void*)f_2970},
{"f_2974:posixwin_scm",(void*)f_2974},
{"f_2939:posixwin_scm",(void*)f_2939},
{"f_2943:posixwin_scm",(void*)f_2943},
{"f_2946:posixwin_scm",(void*)f_2946},
{"f_2901:posixwin_scm",(void*)f_2901},
{"f_2934:posixwin_scm",(void*)f_2934},
{"f_2930:posixwin_scm",(void*)f_2930},
{"f_2905:posixwin_scm",(void*)f_2905},
{"f_2914:posixwin_scm",(void*)f_2914},
{"f_2863:posixwin_scm",(void*)f_2863},
{"f_2870:posixwin_scm",(void*)f_2870},
{"f_2873:posixwin_scm",(void*)f_2873},
{"f_2893:posixwin_scm",(void*)f_2893},
{"f_2876:posixwin_scm",(void*)f_2876},
{"f_2883:posixwin_scm",(void*)f_2883},
{"f_2821:posixwin_scm",(void*)f_2821},
{"f_2828:posixwin_scm",(void*)f_2828},
{"f_2843:posixwin_scm",(void*)f_2843},
{"f_2837:posixwin_scm",(void*)f_2837},
{"f_2776:posixwin_scm",(void*)f_2776},
{"f_2786:posixwin_scm",(void*)f_2786},
{"f_2789:posixwin_scm",(void*)f_2789},
{"f_2801:posixwin_scm",(void*)f_2801},
{"f_2792:posixwin_scm",(void*)f_2792},
{"f_2758:posixwin_scm",(void*)f_2758},
{"f_2771:posixwin_scm",(void*)f_2771},
{"f_2717:posixwin_scm",(void*)f_2717},
{"f_2750:posixwin_scm",(void*)f_2750},
{"f_2734:posixwin_scm",(void*)f_2734},
{"f_2743:posixwin_scm",(void*)f_2743},
{"f_2737:posixwin_scm",(void*)f_2737},
{"f_2671:posixwin_scm",(void*)f_2671},
{"f_2675:posixwin_scm",(void*)f_2675},
{"f_2686:posixwin_scm",(void*)f_2686},
{"f_2682:posixwin_scm",(void*)f_2682},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
