/* Generated from scheduler.scm by the CHICKEN compiler
   http://www.call-cc.org
   2016-05-28 13:49
   Version 4.11.0 (rev ce980c4)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2016-05-28 on yves.more-magic.net (Linux)
   command line: scheduler.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file scheduler.c
   unit: scheduler
*/

#include "chicken.h"

#ifdef HAVE_ERRNO_H
# include <errno.h>
# define C_signal_interrupted_p     C_mk_bool(errno == EINTR)
#else
# define C_signal_interrupted_p     C_SCHEME_FALSE
#endif

#ifdef _WIN32
/* TODO: Winsock select() only works for sockets */
# include <winsock2.h>
/* Beware: winsock2.h must come BEFORE windows.h */
# define C_msleep(n)     (Sleep(C_unfix(n)), C_SCHEME_TRUE)
#else
# include <sys/time.h>
static C_word C_msleep(C_word ms);
C_word C_msleep(C_word ms) {
#ifdef __CYGWIN__
  if(usleep(C_unfix(ms) * 1000) == -1) return C_SCHEME_FALSE;
#else
  struct timespec ts;
  unsigned long mss = C_unfix(ms);
  ts.tv_sec = mss / 1000;
  ts.tv_nsec = (mss % 1000) * 1000000;
  
  if(nanosleep(&ts, NULL) == -1) return C_SCHEME_FALSE;
#endif
  return C_SCHEME_TRUE;
}
#endif

#ifdef NO_POSIX_POLL

/* Shouldn't we include <sys/select.h> here? */
static fd_set C_fdset_input, C_fdset_output;

#define C_fd_input_ready(fd,pos)  C_mk_bool(FD_ISSET(C_unfix(fd), &C_fdset_input))
#define C_fd_output_ready(fd,pos)  C_mk_bool(FD_ISSET(C_unfix(fd), &C_fdset_output))

C_inline int C_ready_fds_timeout(int to, double tm) {
  struct timeval timeout;
  timeout.tv_sec = tm / 1000;
  timeout.tv_usec = fmod(tm, 1000) * 1000;
  /* we use FD_SETSIZE, but really should use max fd */
  return select(FD_SETSIZE, &C_fdset_input, &C_fdset_output, NULL, to ? &timeout : NULL);
}

C_inline void C_prepare_fdset(int length) {
  FD_ZERO(&C_fdset_input);
  FD_ZERO(&C_fdset_output);
}

C_inline void C_fdset_add(int fd, int input, int output) {
  if (input) FD_SET(fd, &C_fdset_input);
  if (output) FD_SET(fd, &C_fdset_output);
}

#else
#  include <poll.h>
#  include <assert.h>

static int C_fdset_nfds;
static struct pollfd *C_fdset_set = NULL;

C_inline int C_fd_ready(int fd, int pos, int what) {
  assert(fd == C_fdset_set[pos].fd); /* Must match position in ##sys#fd-list! */
  return(C_fdset_set[pos].revents & what);
}

#define C_fd_input_ready(fd,pos)  C_mk_bool(C_fd_ready(C_unfix(fd), C_unfix(pos),POLLIN|POLLERR|POLLHUP|POLLNVAL))
#define C_fd_output_ready(fd,pos)  C_mk_bool(C_fd_ready(C_unfix(fd), C_unfix(pos),POLLOUT|POLLERR|POLLHUP|POLLNVAL))

C_inline int C_ready_fds_timeout(int to, double tm) {
  return poll(C_fdset_set, C_fdset_nfds, to ? (int)tm : -1);
}

C_inline void C_prepare_fdset(int length) {
  /* TODO: Only realloc when needed? */
  C_fdset_set = realloc(C_fdset_set, sizeof(struct pollfd) * length);
  if (C_fdset_set == NULL)
    C_halt(C_SCHEME_FALSE); /* Ugly: no message */
  C_fdset_nfds = 0;
}

/* This *must* be called in order, so position will match ##sys#fd-list */
C_inline void C_fdset_add(int fd, int input, int output) {
  C_fdset_set[C_fdset_nfds].events = ((input ? POLLIN : 0) | (output ? POLLOUT : 0));
  C_fdset_set[C_fdset_nfds++].fd = fd;
}
#endif

static C_PTABLE_ENTRY *create_ptable(void);

static C_TLS C_word lf[65];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,7),40,108,111,111,112,50,41,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,26),40,108,111,111,112,50,32,116,104,114,101,97,100,115,53,48,56,32,107,101,101,112,53,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,25),40,108,111,111,112,32,110,52,57,52,32,112,111,115,52,57,53,32,108,115,116,52,57,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,11),40,103,51,54,53,32,116,51,55,52,41,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,54,52,32,103,51,55,49,52,48,54,41,0,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,51,53,56,41,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,49,51,56,41,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,7),40,108,111,111,112,49,41,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,112,114,105,109,111,114,100,105,97,108,41};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,114,101,97,100,121,45,113,117,101,117,101,41,0,0,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,97,100,100,45,116,111,45,114,101,97,100,121,45,113,117,101,117,101,32,116,104,114,101,97,100,49,55,50,41,0,0,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,7),40,97,49,50,55,56,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,50,48,51,32,115,116,97,116,101,50,48,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,112,114,101,118,50,49,51,41,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,114,101,109,111,118,101,45,102,114,111,109,45,116,105,109,101,111,117,116,45,108,105,115,116,32,116,50,49,48,41,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,116,108,50,51,51,32,112,114,101,118,50,51,52,41,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,116,105,109,101,111,117,116,33,32,116,50,49,56,32,116,109,50,49,57,41,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,116,101,114,109,105,110,97,116,105,111,110,33,32,116,50,52,52,32,116,50,50,52,53,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,12),40,103,51,48,55,32,116,50,51,49,54,41,0,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,48,54,32,103,51,49,51,51,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,55,50,32,103,50,55,57,50,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,53,56,32,103,50,54,53,50,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,116,104,114,101,97,100,45,107,105,108,108,33,32,116,50,57,54,32,115,50,57,55,41,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,97,115,105,99,45,117,110,98,108,111,99,107,33,32,116,51,51,49,41,0,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,7),40,97,49,54,57,55,41,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,51,51,53,41};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,52,54,52,41,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,105,47,111,33,32,116,52,54,48,32,102,100,52,54,49,32,105,47,111,52,54,50,41,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,53,52,50,41,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,99,108,101,97,114,45,105,47,111,45,115,116,97,116,101,45,102,111,114,45,116,104,114,101,97,100,33,32,116,53,51,57,41};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,39),40,102,95,50,52,55,53,32,113,117,101,117,101,53,54,55,32,97,114,103,53,54,56,32,118,97,108,53,54,57,32,105,110,105,116,53,55,48,41,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,53,56,49,41,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,56,52,32,105,53,56,53,41};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,55,55,32,105,53,55,56,41};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,55,52,32,105,53,55,53,41};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,97,108,108,45,116,104,114,101,97,100,115,32,46,32,116,109,112,53,53,55,53,53,56,41,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,101,116,99,104,45,97,110,100,45,99,108,101,97,114,45,116,104,114,101,97,100,115,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,115,116,111,114,101,45,116,104,114,101,97,100,115,32,118,101,99,53,57,54,41,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,116,104,114,101,97,100,45,117,110,98,108,111,99,107,33,32,116,54,48,49,41,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,9),40,115,117,115,112,101,110,100,41,0,0,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,6),40,103,54,49,55,41,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,18),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,6),40,103,54,51,52,41,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,18),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,51,51,41,0,0,0,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,54,48,56,41,0,0,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from g478 */
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
double t1=(double )C_c_double(C_a1);
C_r=C_fix((C_word)C_ready_fds_timeout(t0,t1));
return C_r;}

/* from g409 */
C_regparm static C_word C_fcall stub414(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_truep(C_a1);
int t2=(int )C_truep(C_a2);
C_fdset_add(t0,t1,t2);
return C_r;}

/* from g351 */
C_regparm static C_word C_fcall stub354(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_prepare_fdset(t0);
return C_r;}

C_noret_decl(f_1733)
static void C_fcall f_1733(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2145)
static void C_ccall f_2145(C_word c,C_word *av) C_noret;
C_noret_decl(f_2142)
static void C_ccall f_2142(C_word c,C_word *av) C_noret;
C_noret_decl(f_2271)
static void C_fcall f_2271(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1265)
static void C_ccall f_1265(C_word c,C_word *av) C_noret;
C_noret_decl(f_1261)
static void C_ccall f_1261(C_word c,C_word *av) C_noret;
C_noret_decl(f_1794)
static void C_ccall f_1794(C_word c,C_word *av) C_noret;
C_noret_decl(f_1797)
static void C_ccall f_1797(C_word c,C_word *av) C_noret;
C_noret_decl(f_2201)
static void C_ccall f_2201(C_word c,C_word *av) C_noret;
C_noret_decl(f_1279)
static void C_ccall f_1279(C_word c,C_word *av) C_noret;
C_noret_decl(f_1656)
static void C_ccall f_1656(C_word c,C_word *av) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198(C_word c,C_word *av) C_noret;
C_noret_decl(f_2446)
static void C_ccall f_2446(C_word c,C_word *av) C_noret;
C_noret_decl(f_2195)
static void C_ccall f_2195(C_word c,C_word *av) C_noret;
C_noret_decl(f_1662)
static void C_ccall f_1662(C_word c,C_word *av) C_noret;
C_noret_decl(f_2242)
static void C_ccall f_2242(C_word c,C_word *av) C_noret;
C_noret_decl(f_1776)
static void C_ccall f_1776(C_word c,C_word *av) C_noret;
C_noret_decl(C_scheduler_toplevel)
C_externexport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_2187)
static void C_ccall f_2187(C_word c,C_word *av) C_noret;
C_noret_decl(f_2475)
static void C_ccall f_2475(C_word c,C_word *av) C_noret;
C_noret_decl(f_2181)
static void C_ccall f_2181(C_word c,C_word *av) C_noret;
C_noret_decl(f_2184)
static void C_ccall f_2184(C_word c,C_word *av) C_noret;
C_noret_decl(f_1674)
static void C_ccall f_1674(C_word c,C_word *av) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678(C_word c,C_word *av) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785(C_word c,C_word *av) C_noret;
C_noret_decl(f_1782)
static void C_ccall f_1782(C_word c,C_word *av) C_noret;
C_noret_decl(f_1788)
static void C_ccall f_1788(C_word c,C_word *av) C_noret;
C_noret_decl(f_2178)
static void C_ccall f_2178(C_word c,C_word *av) C_noret;
C_noret_decl(f_2172)
static void C_ccall f_2172(C_word c,C_word *av) C_noret;
C_noret_decl(f_2175)
static void C_ccall f_2175(C_word c,C_word *av) C_noret;
C_noret_decl(f_988)
static void C_fcall f_988(C_word t0,C_word t1) C_noret;
C_noret_decl(f_984)
static void C_fcall f_984(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1148)
static void C_ccall f_1148(C_word c,C_word *av) C_noret;
C_noret_decl(f_1045)
static void C_fcall f_1045(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_937)
static void C_ccall f_937(C_word c,C_word *av) C_noret;
C_noret_decl(f_2036)
static void C_fcall f_2036(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2034)
static void C_ccall f_2034(C_word c,C_word *av) C_noret;
C_noret_decl(f_2328)
static void C_ccall f_2328(C_word c,C_word *av) C_noret;
C_noret_decl(f_2430)
static void C_fcall f_2430(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1639)
static void C_ccall f_1639(C_word c,C_word *av) C_noret;
C_noret_decl(f_1953)
static void C_fcall f_1953(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1499)
static void C_fcall f_1499(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2309)
static void C_ccall f_2309(C_word c,C_word *av) C_noret;
C_noret_decl(f_2358)
static void C_fcall f_2358(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1938)
static void C_ccall f_1938(C_word c,C_word *av) C_noret;
C_noret_decl(f_1934)
static void C_ccall f_1934(C_word c,C_word *av) C_noret;
C_noret_decl(f_2340)
static void C_ccall f_2340(C_word c,C_word *av) C_noret;
C_noret_decl(f_1818)
static void C_ccall f_1818(C_word c,C_word *av) C_noret;
C_noret_decl(f_1483)
static void C_ccall f_1483(C_word c,C_word *av) C_noret;
C_noret_decl(f_972)
static void C_fcall f_972(C_word t0,C_word t1) C_noret;
C_noret_decl(f_976)
static void C_ccall f_976(C_word c,C_word *av) C_noret;
C_noret_decl(f_979)
static void C_ccall f_979(C_word c,C_word *av) C_noret;
C_noret_decl(f_2010)
static void C_fcall f_2010(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1331)
static void C_fcall f_1331(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2001)
static void C_ccall f_2001(C_word c,C_word *av) C_noret;
C_noret_decl(f_1327)
static void C_ccall f_1327(C_word c,C_word *av) C_noret;
C_noret_decl(f_2381)
static void C_fcall f_2381(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1509)
static void C_ccall f_1509(C_word c,C_word *av) C_noret;
C_noret_decl(f_2374)
static void C_ccall f_2374(C_word c,C_word *av) C_noret;
C_noret_decl(f_1361)
static void C_fcall f_1361(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2606)
static C_word C_fcall f_2606(C_word t0,C_word t1);
C_noret_decl(f_2601)
static void C_ccall f_2601(C_word c,C_word *av) C_noret;
C_noret_decl(f_1535)
static void C_ccall f_1535(C_word c,C_word *av) C_noret;
C_noret_decl(f_2629)
static C_word C_fcall f_2629(C_word t0,C_word t1);
C_noret_decl(f_2548)
static C_word C_fcall f_2548(C_word t0,C_word t1);
C_noret_decl(f_2545)
static void C_ccall f_2545(C_word c,C_word *av) C_noret;
C_noret_decl(f_1548)
static void C_ccall f_1548(C_word c,C_word *av) C_noret;
C_noret_decl(f_967)
static void C_ccall f_967(C_word c,C_word *av) C_noret;
C_noret_decl(f_1340)
static void C_ccall f_1340(C_word c,C_word *av) C_noret;
C_noret_decl(f_2065)
static void C_fcall f_2065(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1351)
static void C_fcall f_1351(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2587)
static C_word C_fcall f_2587(C_word t0,C_word t1);
C_noret_decl(f_2526)
static void C_ccall f_2526(C_word c,C_word *av) C_noret;
C_noret_decl(f_2523)
static void C_fcall f_2523(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1525)
static void C_fcall f_1525(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2529)
static void C_ccall f_2529(C_word c,C_word *av) C_noret;
C_noret_decl(f_2574)
static C_word C_fcall f_2574(C_word t0,C_word t1);
C_noret_decl(f_1830)
static void C_fcall f_1830(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word *av) C_noret;
C_noret_decl(f_1840)
static void C_ccall f_1840(C_word c,C_word *av) C_noret;
C_noret_decl(f_1855)
static void C_ccall f_1855(C_word c,C_word *av) C_noret;
C_noret_decl(f_1094)
static void C_fcall f_1094(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1889)
static void C_ccall f_1889(C_word c,C_word *av) C_noret;
C_noret_decl(f_1608)
static void C_fcall f_1608(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1895)
static void C_ccall f_1895(C_word c,C_word *av) C_noret;
C_noret_decl(f_1898)
static void C_ccall f_1898(C_word c,C_word *av) C_noret;
C_noret_decl(f_1618)
static void C_ccall f_1618(C_word c,C_word *av) C_noret;
C_noret_decl(f_1791)
static void C_ccall f_1791(C_word c,C_word *av) C_noret;
C_noret_decl(f_2400)
static void C_ccall f_2400(C_word c,C_word *av) C_noret;
C_noret_decl(f_2405)
static void C_fcall f_2405(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1722)
static void C_fcall f_1722(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1418)
static void C_ccall f_1418(C_word c,C_word *av) C_noret;
C_noret_decl(f_1413)
static void C_ccall f_1413(C_word c,C_word *av) C_noret;
C_noret_decl(f_1416)
static void C_ccall f_1416(C_word c,C_word *av) C_noret;
C_noret_decl(f_1410)
static void C_ccall f_1410(C_word c,C_word *av) C_noret;
C_noret_decl(f_2423)
static void C_ccall f_2423(C_word c,C_word *av) C_noret;
C_noret_decl(f_1079)
static void C_ccall f_1079(C_word c,C_word *av) C_noret;
C_noret_decl(f_1702)
static void C_ccall f_1702(C_word c,C_word *av) C_noret;
C_noret_decl(f_2287)
static void C_fcall f_2287(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2285)
static void C_ccall f_2285(C_word c,C_word *av) C_noret;
C_noret_decl(f_1589)
static void C_fcall f_1589(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1582)
static void C_ccall f_1582(C_word c,C_word *av) C_noret;
C_noret_decl(f_1082)
static void C_ccall f_1082(C_word c,C_word *av) C_noret;
C_noret_decl(f_1404)
static void C_ccall f_1404(C_word c,C_word *av) C_noret;
C_noret_decl(f_1286)
static void C_ccall f_1286(C_word c,C_word *av) C_noret;
C_noret_decl(f_1159)
static void C_ccall f_1159(C_word c,C_word *av) C_noret;
C_noret_decl(f_1916)
static void C_ccall f_1916(C_word c,C_word *av) C_noret;
C_noret_decl(f_1552)
static void C_ccall f_1552(C_word c,C_word *av) C_noret;
C_noret_decl(f_1558)
static void C_fcall f_1558(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1913)
static void C_ccall f_1913(C_word c,C_word *av) C_noret;
C_noret_decl(f_1910)
static void C_ccall f_1910(C_word c,C_word *av) C_noret;
C_noret_decl(f_1292)
static C_word C_fcall f_1292(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_1564)
static void C_ccall f_1564(C_word c,C_word *av) C_noret;
C_noret_decl(f_1561)
static void C_ccall f_1561(C_word c,C_word *av) C_noret;
C_noret_decl(f_1162)
static void C_ccall f_1162(C_word c,C_word *av) C_noret;
C_noret_decl(f_1684)
static void C_ccall f_1684(C_word c,C_word *av) C_noret;
C_noret_decl(f_2166)
static void C_ccall f_2166(C_word c,C_word *av) C_noret;
C_noret_decl(f_2494)
static void C_ccall f_2494(C_word c,C_word *av) C_noret;
C_noret_decl(f_1904)
static void C_ccall f_1904(C_word c,C_word *av) C_noret;
C_noret_decl(f_1907)
static void C_ccall f_1907(C_word c,C_word *av) C_noret;
C_noret_decl(f_2104)
static void C_ccall f_2104(C_word c,C_word *av) C_noret;
C_noret_decl(f_1698)
static void C_ccall f_1698(C_word c,C_word *av) C_noret;
C_noret_decl(f_1901)
static void C_ccall f_1901(C_word c,C_word *av) C_noret;
C_noret_decl(f_2484)
static void C_ccall f_2484(C_word c,C_word *av) C_noret;

C_noret_decl(trf_1733)
static void C_ccall trf_1733(C_word c,C_word *av) C_noret;
static void C_ccall trf_1733(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1733(t0,t1,t2);}

C_noret_decl(trf_2271)
static void C_ccall trf_2271(C_word c,C_word *av) C_noret;
static void C_ccall trf_2271(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2271(t0,t1);}

C_noret_decl(trf_988)
static void C_ccall trf_988(C_word c,C_word *av) C_noret;
static void C_ccall trf_988(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_988(t0,t1);}

C_noret_decl(trf_984)
static void C_ccall trf_984(C_word c,C_word *av) C_noret;
static void C_ccall trf_984(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_984(t0,t1);}

C_noret_decl(trf_1045)
static void C_ccall trf_1045(C_word c,C_word *av) C_noret;
static void C_ccall trf_1045(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1045(t0,t1,t2);}

C_noret_decl(trf_2036)
static void C_ccall trf_2036(C_word c,C_word *av) C_noret;
static void C_ccall trf_2036(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2036(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2430)
static void C_ccall trf_2430(C_word c,C_word *av) C_noret;
static void C_ccall trf_2430(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2430(t0,t1,t2,t3);}

C_noret_decl(trf_1953)
static void C_ccall trf_1953(C_word c,C_word *av) C_noret;
static void C_ccall trf_1953(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1953(t0,t1,t2);}

C_noret_decl(trf_1499)
static void C_ccall trf_1499(C_word c,C_word *av) C_noret;
static void C_ccall trf_1499(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1499(t0,t1,t2);}

C_noret_decl(trf_2358)
static void C_ccall trf_2358(C_word c,C_word *av) C_noret;
static void C_ccall trf_2358(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2358(t0,t1,t2,t3);}

C_noret_decl(trf_972)
static void C_ccall trf_972(C_word c,C_word *av) C_noret;
static void C_ccall trf_972(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_972(t0,t1);}

C_noret_decl(trf_2010)
static void C_ccall trf_2010(C_word c,C_word *av) C_noret;
static void C_ccall trf_2010(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2010(t0,t1);}

C_noret_decl(trf_1331)
static void C_ccall trf_1331(C_word c,C_word *av) C_noret;
static void C_ccall trf_1331(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1331(t0,t1);}

C_noret_decl(trf_2381)
static void C_ccall trf_2381(C_word c,C_word *av) C_noret;
static void C_ccall trf_2381(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2381(t0,t1,t2,t3);}

C_noret_decl(trf_1361)
static void C_ccall trf_1361(C_word c,C_word *av) C_noret;
static void C_ccall trf_1361(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1361(t0,t1);}

C_noret_decl(trf_2065)
static void C_ccall trf_2065(C_word c,C_word *av) C_noret;
static void C_ccall trf_2065(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2065(t0,t1,t2,t3);}

C_noret_decl(trf_1351)
static void C_ccall trf_1351(C_word c,C_word *av) C_noret;
static void C_ccall trf_1351(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1351(t0,t1,t2,t3);}

C_noret_decl(trf_2523)
static void C_ccall trf_2523(C_word c,C_word *av) C_noret;
static void C_ccall trf_2523(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2523(t0,t1);}

C_noret_decl(trf_1525)
static void C_ccall trf_1525(C_word c,C_word *av) C_noret;
static void C_ccall trf_1525(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1525(t0,t1,t2);}

C_noret_decl(trf_1830)
static void C_ccall trf_1830(C_word c,C_word *av) C_noret;
static void C_ccall trf_1830(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1830(t0,t1,t2);}

C_noret_decl(trf_1094)
static void C_ccall trf_1094(C_word c,C_word *av) C_noret;
static void C_ccall trf_1094(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1094(t0,t1);}

C_noret_decl(trf_1608)
static void C_ccall trf_1608(C_word c,C_word *av) C_noret;
static void C_ccall trf_1608(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1608(t0,t1,t2);}

C_noret_decl(trf_2405)
static void C_ccall trf_2405(C_word c,C_word *av) C_noret;
static void C_ccall trf_2405(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2405(t0,t1,t2);}

C_noret_decl(trf_1722)
static void C_ccall trf_1722(C_word c,C_word *av) C_noret;
static void C_ccall trf_1722(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1722(t0,t1,t2);}

C_noret_decl(trf_2287)
static void C_ccall trf_2287(C_word c,C_word *av) C_noret;
static void C_ccall trf_2287(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2287(t0,t1,t2);}

C_noret_decl(trf_1589)
static void C_ccall trf_1589(C_word c,C_word *av) C_noret;
static void C_ccall trf_1589(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1589(t0,t1,t2);}

C_noret_decl(trf_1558)
static void C_ccall trf_1558(C_word c,C_word *av) C_noret;
static void C_ccall trf_1558(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1558(t0,t1);}

/* g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_fcall f_1733(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1733,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_slot(t2,C_fix(11));
if(C_truep(C_i_pairp(t3))){
t4=C_u_i_cdr(t3);
t5=C_eqp(t4,C_SCHEME_TRUE);
t6=(C_truep(t5)?t5:C_eqp(t4,lf[18]));
if(C_truep(t6)){
t7=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_eqp(t4,C_SCHEME_FALSE);
t8=(C_truep(t7)?t7:C_eqp(t4,lf[19]));
if(C_truep(t8)){
t9=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_TRUE);
t10=t1;{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t9=C_eqp(t4,lf[20]);
if(C_truep(t9)){
t10=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t11=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_TRUE);
t12=t1;{
C_word av2[2];
av2[0]=t12;
av2[1]=t11;
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}
else{
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1776,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:412: open-output-string */
t11=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k2143 in k2140 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2145,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:491: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2065(t4,((C_word*)t0)[4],t3,((C_word*)t0)[5]);}

/* k2140 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_2142,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2145,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:490: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#clear-i/o-state-for-thread! */
static void C_fcall f_2271(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,3))){
C_save_and_reclaim_args((void *)trf_2271,2,t1,t2);}
a=C_alloc(11);
t3=C_slot(t2,C_fix(11));
if(C_truep(C_i_pairp(t3))){
t4=C_slot(t2,C_fix(11));
t5=C_u_i_car(t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2285,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2287,a[2]=t6,a[3]=t2,a[4]=t9,a[5]=((C_word)li29),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_2287(t11,t7,*((C_word*)lf[11]+1));}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k1263 in interrupt-hook */
static void C_ccall f_1265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1265,2,av);}
/* scheduler.scm:273: oldhook */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* ##sys#interrupt-hook */
static void C_ccall f_1261(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_1261,4,av);}
a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1265,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(t2,C_fix(255));
if(C_truep(t5)){
t6=*((C_word*)lf[1]+1);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1279,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word)li12),tmp=(C_word)a,a+=6,tmp);
t8=C_i_setslot(*((C_word*)lf[1]+1),C_fix(1),t7);
/* scheduler.scm:272: ##sys#schedule */
t9=*((C_word*)lf[0]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
/* scheduler.scm:273: oldhook */
t6=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* k1792 in k1789 in k1786 in k1783 in k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_1794,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1797,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:412: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1795 in k1792 in k1789 in k1786 in k1783 in k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1797(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1797,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_halt(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2199 in k2196 in k2193 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2201(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2201,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:498: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2065(t4,((C_word*)t0)[4],t3,((C_word*)t0)[5]);}

/* a1278 in interrupt-hook */
static void C_ccall f_1279(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1279,2,av);}
/* scheduler.scm:271: oldhook */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1654 in k1550 in thread-kill! */
static void C_ccall f_1656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1656,2,av);}
t2=((C_word*)t0)[2];
f_1558(t2,C_i_setslot(((C_word*)t0)[3],C_fix(12),t1));}

/* k2196 in k2193 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2198(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_2198,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2201,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:497: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k2444 in loop in loop in loop in all-threads */
static void C_ccall f_2446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2446,2,av);}
/* scheduler.scm:543: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2430(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k2193 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_2195,2,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2198,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(((C_word*)t0)[6],C_fix(4)))){
/* scheduler.scm:496: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2198(2,av2);}}}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_a_i_cons(&a,2,((C_word*)t0)[6],((C_word*)t0)[5]);
/* scheduler.scm:499: loop2 */
t5=((C_word*)((C_word*)t0)[3])[1];
f_2065(t5,((C_word*)t0)[4],t3,t4);}}

/* ##sys#thread-basic-unblock! */
static void C_ccall f_1662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1662,3,av);}
t3=C_i_set_i_slot(t2,C_fix(11),C_SCHEME_FALSE);
t4=C_i_set_i_slot(t2,C_fix(4),C_SCHEME_FALSE);
/* scheduler.scm:362: ##sys#add-to-ready-queue */
t5=*((C_word*)lf[36]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k2240 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_2242,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1776(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_1776,2,av);}
a=C_alloc(7);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1782,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:412: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[33];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_scheduler_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("scheduler_toplevel"));
C_check_nursery_minimum(C_calculate_demand(56,c,5));
if(!C_demand(C_calculate_demand(56,c,5))){
C_save_and_reclaim((void*)C_scheduler_toplevel,c,av);}
toplevel_initialized=1;
if(!C_demand_2(354)){
C_save(t1);
C_rereclaim2(354*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(56);
C_initialize_lf(lf,65);
lf[0]=C_h_intern(&lf[0],12,"\003sysschedule");
lf[1]=C_h_intern(&lf[1],18,"\003syscurrent-thread");
lf[2]=C_h_intern(&lf[2],17,"\003sysdynamic-winds");
lf[3]=C_h_intern(&lf[3],18,"\003sysstandard-input");
lf[4]=C_h_intern(&lf[4],19,"\003sysstandard-output");
lf[5]=C_h_intern(&lf[5],18,"\003sysstandard-error");
lf[6]=C_h_intern(&lf[6],29,"\003syscurrent-exception-handler");
lf[7]=C_h_intern(&lf[7],28,"\003syscurrent-parameter-vector");
lf[8]=C_h_intern(&lf[8],5,"ready");
lf[9]=C_h_intern(&lf[9],7,"running");
lf[11]=C_h_intern(&lf[11],11,"\003sysfd-list");
lf[12]=C_decode_literal(C_heaptop,"\376B\000\000\010deadlock");
lf[15]=C_h_intern(&lf[15],20,"\003sysforce-primordial");
lf[16]=C_h_intern(&lf[16],25,"\003systhread-basic-unblock!");
lf[17]=C_h_intern(&lf[17],28,"\003sysremove-from-timeout-list");
lf[18]=C_h_intern(&lf[18],6,"\000input");
lf[19]=C_h_intern(&lf[19],7,"\000output");
lf[20]=C_h_intern(&lf[20],4,"\000all");
lf[21]=C_h_intern(&lf[21],7,"sprintf");
lf[22]=C_h_intern(&lf[22],17,"get-output-string");
lf[23]=C_h_intern(&lf[23],16,"\003syswrite-char-0");
lf[24]=C_h_intern(&lf[24],9,"\003sysprint");
lf[25]=C_decode_literal(C_heaptop,"\376B\000\000\006, o = ");
lf[26]=C_decode_literal(C_heaptop,"\376B\000\000\006 (i = ");
lf[27]=C_decode_literal(C_heaptop,"\376B\000\000#fdset-test: invalid i/o direction: ");
lf[28]=C_h_intern(&lf[28],18,"open-output-string");
lf[29]=C_decode_literal(C_heaptop,"\376B\000\000\013 (expected ");
lf[30]=C_decode_literal(C_heaptop,"\376B\000\0009thread is registered for I/O on unknown file-descriptor: ");
lf[31]=C_decode_literal(C_heaptop,"\376U0.0\000");
lf[32]=C_decode_literal(C_heaptop,"\376B\000\000\007 (fd = ");
lf[33]=C_decode_literal(C_heaptop,"\376B\000\000%create-fdset: invalid i/o direction: ");
lf[34]=C_h_intern(&lf[34],10,"\003syslength");
lf[36]=C_h_intern(&lf[36],22,"\003sysadd-to-ready-queue");
lf[37]=C_h_intern(&lf[37],21,"\003sysprimordial-thread");
lf[38]=C_h_intern(&lf[38],19,"\003systhread-unblock!");
lf[39]=C_h_intern(&lf[39],15,"\003sysready-queue");
lf[40]=C_h_intern(&lf[40],18,"\003sysinterrupt-hook");
lf[41]=C_h_intern(&lf[41],29,"\003systhread-block-for-timeout!");
lf[42]=C_h_intern(&lf[42],7,"blocked");
lf[43]=C_decode_literal(C_heaptop,"\376B\000\0002##sys#thread-block-for-timeout!: invalid timeout: ");
lf[44]=C_h_intern(&lf[44],33,"\003systhread-block-for-termination!");
lf[45]=C_h_intern(&lf[45],4,"dead");
lf[46]=C_h_intern(&lf[46],10,"terminated");
lf[47]=C_h_intern(&lf[47],16,"\003systhread-kill!");
lf[48]=C_h_intern(&lf[48],18,"condition-variable");
lf[49]=C_h_intern(&lf[49],8,"\003sysdelq");
lf[50]=C_h_intern(&lf[50],6,"thread");
lf[51]=C_h_intern(&lf[51],29,"\003sysdefault-exception-handler");
lf[52]=C_h_intern(&lf[52],10,"\003syssignal");
lf[53]=C_h_intern(&lf[53],26,"\003sysshow-exception-warning");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\011in thread");
lf[55]=C_h_intern(&lf[55],25,"\003systhread-block-for-i/o!");
lf[56]=C_h_intern(&lf[56],15,"\003sysall-threads");
lf[57]=C_h_intern(&lf[57],3,"i/o");
lf[58]=C_h_intern(&lf[58],7,"timeout");
lf[59]=C_h_intern(&lf[59],27,"\003sysfetch-and-clear-threads");
lf[60]=C_h_intern(&lf[60],19,"\003sysrestore-threads");
lf[61]=C_h_intern(&lf[61],8,"sleeping");
lf[62]=C_h_intern(&lf[62],4,"exit");
lf[63]=C_h_intern(&lf[63],22,"\003syskill-other-threads");
lf[64]=C_h_intern(&lf[64],9,"suspended");
C_register_lf2(lf,65,create_ptable());{}
t2=C_mutate2((C_word*)lf[0]+1 /* (set! ##sys#schedule ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_937,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[15]+1 /* (set! ##sys#force-primordial ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1148,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t4=lf[13] /* ready-queue-head */ =C_SCHEME_END_OF_LIST;;
t5=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t6=C_mutate2((C_word*)lf[39]+1 /* (set! ##sys#ready-queue ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1159,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[36]+1 /* (set! ##sys#add-to-ready-queue ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1162,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t8=*((C_word*)lf[40]+1);
t9=C_mutate2((C_word*)lf[40]+1 /* (set! ##sys#interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1261,a[2]=t8,a[3]=((C_word)li13),tmp=(C_word)a,a+=4,tmp));
t10=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t11=C_mutate2((C_word*)lf[17]+1 /* (set! ##sys#remove-from-timeout-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1286,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[41]+1 /* (set! ##sys#thread-block-for-timeout! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1327,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[44]+1 /* (set! ##sys#thread-block-for-termination! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1418,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[47]+1 /* (set! ##sys#thread-kill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1548,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[16]+1 /* (set! ##sys#thread-basic-unblock! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1662,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[51]+1 /* (set! ##sys#default-exception-handler ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1674,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(lf[11] /* ##sys#fd-list */,0,C_SCHEME_END_OF_LIST);
t18=C_mutate2((C_word*)lf[55]+1 /* (set! ##sys#thread-block-for-i/o! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1934,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2(&lf[35] /* (set! ##sys#clear-i/o-state-for-thread! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2271,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[56]+1 /* (set! ##sys#all-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2340,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[59]+1 /* (set! ##sys#fetch-and-clear-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2484,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate2((C_word*)lf[60]+1 /* (set! ##sys#restore-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2494,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate2((C_word*)lf[38]+1 /* (set! ##sys#thread-unblock! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2513,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t24=*((C_word*)lf[62]+1);
t25=C_mutate2((C_word*)lf[63]+1 /* (set! ##sys#kill-other-threads ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2545,a[2]=t24,a[3]=((C_word)li45),tmp=(C_word)a,a+=4,tmp));
t26=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t26;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t26+1)))(2,av2);}}

/* k2185 in k2182 in k2179 in k2176 in k2173 in k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2187,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_halt(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_2475 in all-threads */
static void C_ccall f_2475(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_2475,6,av);}
a=C_alloc(3);
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* k2179 in k2176 in k2173 in k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_2181,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:493: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k2182 in k2179 in k2176 in k2173 in k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2184(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2184,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2187,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:493: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#default-exception-handler */
static void C_ccall f_1674(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,4))){C_save_and_reclaim((void *)f_1674,3,av);}
a=C_alloc(10);
t3=*((C_word*)lf[1]+1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1678,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_mk_bool(C_abort_on_thread_exceptions))){
t5=*((C_word*)lf[37]+1);
t6=C_slot(*((C_word*)lf[37]+1),C_fix(1));
t7=t6;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1698,a[2]=t7,a[3]=t2,a[4]=((C_word)li25),tmp=(C_word)a,a+=5,tmp);
t9=C_i_setslot(*((C_word*)lf[37]+1),C_fix(1),t8);
/* scheduler.scm:376: ##sys#thread-unblock! */
t10=*((C_word*)lf[38]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t10;
av2[1]=t4;
av2[2]=*((C_word*)lf[37]+1);
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}
else{
/* scheduler.scm:378: ##sys#show-exception-warning */
t5=*((C_word*)lf[53]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[54];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}}

/* k1676 in default-exception-handler */
static void C_ccall f_1678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_1678,2,av);}
a=C_alloc(3);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(7),((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1684,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:380: ##sys#thread-kill! */
t4=*((C_word*)lf[47]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[46];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k1783 in k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1785,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1788,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[32];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1782,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1785,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1786 in k1783 in k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_1788,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1791,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2176 in k2173 in k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2178(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_2178,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2181,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:493: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_2172,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2175,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_u_i_car(((C_word*)t0)[6]);
/* scheduler.scm:493: ##sys#print */
t4=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2173 in k2170 in k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_2175,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2178,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:493: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[29];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k986 in loop2 in k977 in k974 in loop1 in k965 in schedule */
static void C_fcall f_988(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,1))){
C_save_and_reclaim_args((void *)trf_988,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(t1,C_fix(3));
t3=C_eqp(t2,lf[8]);
if(C_truep(t3)){
t4=((C_word*)t0)[2];
t5=t1;
t6=C_mutate2((C_word*)lf[1]+1 /* (set! ##sys#current-thread ...) */,t5);
t7=C_i_setslot(t5,C_fix(3),lf[9]);
t8=C_slot(t5,C_fix(5));
t9=C_slot(t8,C_fix(0));
t10=C_mutate2((C_word*)lf[2]+1 /* (set! ##sys#dynamic-winds ...) */,t9);
t11=C_slot(t8,C_fix(1));
t12=C_mutate2((C_word*)lf[3]+1 /* (set! ##sys#standard-input ...) */,t11);
t13=C_slot(t8,C_fix(2));
t14=C_mutate2((C_word*)lf[4]+1 /* (set! ##sys#standard-output ...) */,t13);
t15=C_slot(t8,C_fix(3));
t16=C_mutate2((C_word*)lf[5]+1 /* (set! ##sys#standard-error ...) */,t15);
t17=C_slot(t8,C_fix(4));
t18=C_mutate2((C_word*)lf[6]+1 /* (set! ##sys#current-exception-handler ...) */,t17);
t19=C_slot(t8,C_fix(5));
t20=C_mutate2((C_word*)lf[7]+1 /* (set! ##sys#current-parameter-vector ...) */,t19);
t21=C_slot(t5,C_fix(9));
t22=C_set_initial_timer_interrupt_period(t21);
t23=C_slot(t5,C_fix(1));
/* scheduler.scm:153: g122 */
t24=t23;{
C_word av2[2];
av2[0]=t24;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t24+1)))(2,av2);}}
else{
/* scheduler.scm:220: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_984(t4,((C_word*)t0)[2]);}}
else{
if(C_truep(C_i_nullp(lf[10]))){
if(C_truep(C_i_nullp(*((C_word*)lf[11]+1)))){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_halt(lf[12]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* scheduler.scm:218: loop1 */
t2=((C_word*)((C_word*)t0)[4])[1];
f_972(t2,((C_word*)t0)[2]);}}
else{
/* scheduler.scm:218: loop1 */
t2=((C_word*)((C_word*)t0)[4])[1];
f_972(t2,((C_word*)t0)[2]);}}}

/* loop2 in k977 in k974 in loop1 in k965 in schedule */
static void C_fcall f_984(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_984,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_988,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=lf[13];
if(C_truep(C_i_nullp(lf[13]))){
t4=t2;
f_988(t4,C_SCHEME_FALSE);}
else{
t4=C_slot(t3,C_fix(1));
t5=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t4);
t6=C_eqp(C_SCHEME_END_OF_LIST,t4);
if(C_truep(t6)){
t7=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t8=C_u_i_car(t3);
t9=t2;
f_988(t9,t8);}
else{
t7=C_u_i_car(t3);
t8=t2;
f_988(t8,t7);}}}

/* ##sys#force-primordial */
static void C_ccall f_1148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1148,2,av);}
t2=C_i_set_i_slot(*((C_word*)lf[37]+1),C_fix(13),C_SCHEME_FALSE);
/* scheduler.scm:225: ##sys#thread-unblock! */
t3=*((C_word*)lf[38]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=*((C_word*)lf[37]+1);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* loop in loop1 in k965 in schedule */
static void C_fcall f_1045(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_1045,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_caar(t2);
t4=t2;
t5=C_u_i_car(t4);
t6=C_u_i_cdr(t5);
t7=C_slot(t6,C_fix(4));
if(C_truep(C_i_equalp(t3,t7))){
if(C_truep(C_flonum_greater_or_equal_p(((C_word*)t0)[2],t3))){
t8=C_i_set_i_slot(t6,C_fix(13),C_SCHEME_TRUE);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1079,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:186: ##sys#clear-i/o-state-for-thread! */
f_2271(t9,t6);}
else{
t8=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t2);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1094,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_nullp(lf[13]))){
t10=C_i_nullp(*((C_word*)lf[11]+1));
t11=t9;
f_1094(t11,(C_truep(t10)?C_i_pairp(lf[10]):C_SCHEME_FALSE));}
else{
t10=t9;
f_1094(t10,C_SCHEME_FALSE);}}}
else{
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:206: loop */
t12=t1;
t13=t9;
t1=t12;
t2=t13;
goto loop;}}}

/* ##sys#schedule */
static void C_ccall f_937(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_937,2,av);}
a=C_alloc(6);
t2=*((C_word*)lf[1]+1);
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_slot(*((C_word*)lf[1]+1),C_fix(3));
t6=C_slot(*((C_word*)lf[1]+1),C_fix(5));
t7=C_i_setslot(t6,C_fix(0),*((C_word*)lf[2]+1));
t8=C_i_setslot(t6,C_fix(1),*((C_word*)lf[3]+1));
t9=C_i_setslot(t6,C_fix(2),*((C_word*)lf[4]+1));
t10=C_i_setslot(t6,C_fix(3),*((C_word*)lf[5]+1));
t11=C_i_setslot(t6,C_fix(4),*((C_word*)lf[6]+1));
t12=C_i_setslot(t6,C_fix(5),*((C_word*)lf[7]+1));
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_967,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t14=C_eqp(t5,lf[9]);
t15=(C_truep(t14)?t14:C_eqp(t5,lf[8]));
if(C_truep(t15)){
t16=C_i_set_i_slot(*((C_word*)lf[1]+1),C_fix(13),C_SCHEME_FALSE);
/* scheduler.scm:170: ##sys#add-to-ready-queue */
t17=*((C_word*)lf[36]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t17;
av2[1]=t13;
av2[2]=*((C_word*)lf[1]+1);
((C_proc)(void*)(*((C_word*)t17+1)))(3,av2);}}
else{
t16=t13;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t16;
av2[1]=C_SCHEME_UNDEFINED;
f_967(2,av2);}}}

/* loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_fcall f_2036(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(13,0,4))){
C_save_and_reclaim_args((void *)trf_2036,5,t0,t1,t2,t3,t4);}
a=C_alloc(13);
t5=C_i_zerop(t2);
t6=(C_truep(t5)?t5:C_i_nullp(t4));
if(C_truep(t6)){
t7=t4;
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_u_i_car(t4);
t8=t7;
t9=C_u_i_car(t8);
t10=t9;
t11=C_fd_input_ready(t10,t3);
t12=C_fd_output_ready(t10,t3);
t13=(C_truep(t11)?t11:t12);
if(C_truep(t13)){
t14=C_u_i_cdr(t8);
t15=C_SCHEME_UNDEFINED;
t16=(*a=C_VECTOR_TYPE|1,a[1]=t15,tmp=(C_word)a,a+=2,tmp);
t17=C_set_block_item(t16,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2065,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=((C_word*)t0)[2],a[6]=t10,a[7]=t16,a[8]=t11,a[9]=t12,a[10]=((C_word)li1),tmp=(C_word)a,a+=11,tmp));
t18=((C_word*)t16)[1];
f_2065(t18,t1,t14,C_SCHEME_END_OF_LIST);}
else{
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2242,a[2]=t1,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
t15=C_a_i_plus(&a,2,t3,C_fix(1));
t16=t4;
t17=C_u_i_cdr(t16);
/* scheduler.scm:500: loop */
t19=t14;
t20=t2;
t21=t15;
t22=t17;
t1=t19;
t2=t20;
t3=t21;
t4=t22;
goto loop;}}}

/* k2032 in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2034(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2034,2,av);}
t2=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k2326 in loop in clear-i/o-state-for-thread! */
static void C_ccall f_2328(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_2328,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in loop in loop in all-threads */
static void C_fcall f_2430(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,5))){
C_save_and_reclaim_args((void *)trf_2430,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2446,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t7=C_u_i_caar(t2);
t8=t2;
t9=C_u_i_car(t8);
t10=C_u_i_cdr(t9);
/* scheduler.scm:543: cns */
t11=((C_word*)t0)[3];{
C_word av2[6];
av2[0]=t11;
av2[1]=t6;
av2[2]=lf[58];
av2[3]=t7;
av2[4]=t10;
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}
else{
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k1637 in k1550 in thread-kill! */
static void C_ccall f_1639(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1639,2,av);}
t2=((C_word*)t0)[2];
f_1558(t2,C_i_setslot(((C_word*)t0)[3],C_fix(2),t1));}

/* loop in thread-block-for-i/o! */
static void C_fcall f_1953(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_1953,3,t0,t1,t2);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_list2(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,*((C_word*)lf[11]+1));
t5=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=C_u_i_car(t3);
t5=C_eqp(((C_word*)t0)[2],t4);
if(C_truep(t5)){
t6=C_u_i_cdr(t3);
t7=C_a_i_cons(&a,2,((C_word*)t0)[3],t6);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_i_setslot(t3,C_fix(1),t7);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t6=t2;
t7=C_u_i_cdr(t6);
/* scheduler.scm:438: loop */
t9=t1;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}}

/* for-each-loop272 in for-each-loop258 in thread-kill! */
static void C_fcall f_1499(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1499,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1509,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:328: ##sys#thread-unblock! */
t5=*((C_word*)lf[38]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2307 in loop in clear-i/o-state-for-thread! */
static void C_ccall f_2309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2309,2,av);}
if(C_truep(C_i_nullp(t1))){
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_i_setslot(((C_word*)t0)[4],C_fix(1),t1);
t3=((C_word*)t0)[2];
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* loop in all-threads */
static void C_fcall f_2358(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,5))){
C_save_and_reclaim_args((void *)trf_2358,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2374,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t7=t2;
t8=C_u_i_car(t7);
/* scheduler.scm:533: cns */
t9=((C_word*)t0)[3];{
C_word av2[6];
av2[0]=t9;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=C_SCHEME_FALSE;
av2[4]=t8;
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t9+1)))(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2381,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=((C_word)li34),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2381(t7,t1,*((C_word*)lf[11]+1),t3);}}

/* k1936 in thread-block-for-i/o! */
static void C_ccall f_1938(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_1938,2,av);}
a=C_alloc(3);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),lf[42]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(13),C_SCHEME_FALSE);
t4=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(11),t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#thread-block-for-i/o! */
static void C_ccall f_1934(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,3))){C_save_and_reclaim((void *)f_1934,5,av);}
a=C_alloc(14);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1938,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1953,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=((C_word)li27),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_1953(t9,t5,*((C_word*)lf[11]+1));}

/* ##sys#all-threads */
static void C_ccall f_2340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +10,c,6))){
C_save_and_reclaim((void*)f_2340,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+10);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2475,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp):C_u_i_car(t2));
t5=t4;
t6=C_i_nullp(t2);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_slot(t2,C_fix(1)));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_u_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_slot(t7,C_fix(1)));
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2358,a[2]=t13,a[3]=t5,a[4]=((C_word)li35),tmp=(C_word)a,a+=5,tmp));
t15=((C_word*)t13)[1];
f_2358(t15,t1,lf[13],t9);}

/* k1816 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1818,2,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
t3=((C_word*)((C_word*)t0)[3])[1];
t4=stub414(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t2,t3);
t5=((C_word*)t0)[5];
t6=C_u_i_cdr(t5);
/* scheduler.scm:417: loop */
t7=((C_word*)((C_word*)t0)[6])[1];
f_1722(t7,((C_word*)t0)[7],t6);}

/* k1481 in for-each-loop258 in thread-kill! */
static void C_ccall f_1483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1483,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_i_set_i_slot(((C_word*)t0)[3],C_fix(3),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop1 in k965 in schedule */
static void C_fcall f_972(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(17,0,3))){
C_save_and_reclaim_args((void *)trf_972,2,t0,t1);}
a=C_alloc(17);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_976,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_nullp(lf[10]))){
t3=t2;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_976(2,av2);}}
else{
t3=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1045,a[2]=t3,a[3]=t5,a[4]=((C_word*)t0)[3],a[5]=((C_word)li6),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_1045(t7,t2,lf[10]);}}

/* k974 in loop1 in k965 in schedule */
static void C_ccall f_976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,2))){C_save_and_reclaim((void *)f_976,2,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_979,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
/* scheduler.scm:209: ##sys#force-primordial */
t3=*((C_word*)lf[15]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nullp(*((C_word*)lf[11]+1)))){
t3=C_SCHEME_UNDEFINED;
t4=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
f_979(2,av2);}}
else{
t3=t2;
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2001,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1855,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:389: ##sys#length */
t7=*((C_word*)lf[34]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=*((C_word*)lf[11]+1);
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k977 in k974 in loop1 in k965 in schedule */
static void C_ccall f_979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_979,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_984,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li0),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_984(t5,((C_word*)t0)[3]);}

/* k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_fcall f_2010(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_2010,2,t0,t1);}
a=C_alloc(9);
t2=(C_truep(((C_word*)t0)[2])?stub482(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1):stub482(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1));
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
/* scheduler.scm:459: ##sys#force-primordial */
t4=*((C_word*)lf[15]+1);{
C_word av2[2];
av2[0]=t4;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_greaterp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2034,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2036,a[2]=t6,a[3]=((C_word)li2),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_2036(t8,t4,t2,C_fix(0),*((C_word*)lf[11]+1));}
else{
t4=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k1329 in thread-block-for-timeout! */
static void C_fcall f_1331(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(13,0,4))){
C_save_and_reclaim_args((void *)trf_1331,2,t0,t1);}
a=C_alloc(13);
if(C_truep(C_flonum_greaterp(((C_word*)t0)[2],lf[31]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1340,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1351,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word)li16),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_1351(t6,t2,lf[10],C_SCHEME_FALSE);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,2))){C_save_and_reclaim((void *)f_2001,2,av);}
a=C_alloc(13);
t2=C_i_pairp(lf[10]);
t3=t2;
t4=C_i_pairp(lf[13]);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2010,a[2]=t5,a[3]=t3,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t7=(C_truep(t3)?C_i_not(t5):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=C_u_i_caar(lf[10]);
t9=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
t10=C_a_i_flonum_difference(&a,2,t8,t9);
t11=t6;
f_2010(t11,C_i_flonum_max(lf[31],t10));}
else{
t8=t6;
f_2010(t8,lf[31]);}}

/* ##sys#thread-block-for-timeout! */
static void C_ccall f_1327(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_1327,4,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1331,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t3))){
t5=t4;
f_1331(t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1404,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:293: open-output-string */
t6=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* loop in loop in all-threads */
static void C_fcall f_2381(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(!C_demand(C_calculate_demand(14,0,4))){
C_save_and_reclaim_args((void *)trf_2381,4,t0,t1,t2,t3);}
a=C_alloc(14);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=C_u_i_caar(t2);
t7=t6;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2400,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t9=t2;
t10=C_u_i_car(t9);
t11=C_u_i_cdr(t10);
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2405,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=t13,a[6]=((C_word)li32),tmp=(C_word)a,a+=7,tmp));
t15=((C_word*)t13)[1];
f_2405(t15,t8,t11);}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2430,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=((C_word)li33),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2430(t7,t1,lf[10],t3);}}

/* k1507 in for-each-loop272 in for-each-loop258 in thread-kill! */
static void C_ccall f_1509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1509,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1499(t3,((C_word*)t0)[4],t2);}

/* k2372 in loop in all-threads */
static void C_ccall f_2374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2374,2,av);}
/* scheduler.scm:533: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2358(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k1359 in loop in k1329 in thread-block-for-timeout! */
static void C_fcall f_1361(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_1361,2,t0,t1);}
a=C_alloc(6);
if(C_truep(t1)){
if(C_truep(((C_word*)t0)[2])){
t2=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_a_i_cons(&a,2,t2,((C_word*)t0)[5]);
t4=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(1),t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_a_i_cons(&a,2,t2,((C_word*)t0)[5]);
t4=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t3);
t5=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t2=C_slot(((C_word*)t0)[5],C_fix(1));
/* scheduler.scm:301: loop */
t3=((C_word*)((C_word*)t0)[7])[1];
f_1351(t3,((C_word*)t0)[6],t2,((C_word*)t0)[5]);}}

/* for-each-loop633 in kill-other-threads */
static C_word C_fcall f_2606(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_2587(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k2599 in kill-other-threads */
static void C_ccall f_2601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2601,2,av);}
/* scheduler.scm:601: exit */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1533 in for-each-loop258 in thread-kill! */
static void C_ccall f_1535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1535,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1525(t3,((C_word*)t0)[4],t2);}

/* for-each-loop616 in kill-other-threads */
static C_word C_fcall f_2629(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_2574(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* suspend in kill-other-threads */
static C_word C_fcall f_2548(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;{}
t2=C_eqp(t1,((C_word*)t0)[2]);
t3=(C_truep(t2)?C_SCHEME_UNDEFINED:C_i_setslot(t1,C_fix(3),lf[64]));
t4=C_i_set_i_slot(t1,C_fix(11),C_SCHEME_FALSE);
return(C_i_set_i_slot(t1,C_fix(12),C_SCHEME_END_OF_LIST));}

/* ##sys#kill-other-threads */
static void C_ccall f_2545(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(!C_demand(C_calculate_demand(27,c,2))){C_save_and_reclaim((void *)f_2545,3,av);}
a=C_alloc(27);
t3=*((C_word*)lf[1]+1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2548,a[2]=t3,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t5=C_mutate2((C_word*)lf[37]+1 /* (set! ##sys#primordial-thread ...) */,*((C_word*)lf[1]+1));
t6=C_a_i_list1(&a,1,*((C_word*)lf[1]+1));
t7=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t6);
t8=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,lf[13]);
t9=f_2548(t4,*((C_word*)lf[1]+1));
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2574,a[2]=t4,a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
t11=lf[10];
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2629,a[2]=t10,a[3]=((C_word)li42),tmp=(C_word)a,a+=4,tmp);
t13=f_2629(t12,lf[10]);
t14=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t15=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2587,a[2]=t4,a[3]=((C_word)li43),tmp=(C_word)a,a+=4,tmp);
t16=*((C_word*)lf[11]+1);
t17=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2606,a[2]=t15,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp);
t18=f_2606(t17,*((C_word*)lf[11]+1));
t19=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2601,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:600: thunk */
t20=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t20;
av2[1]=t19;
((C_proc)(void*)(*((C_word*)t20+1)))(2,av2);}}

/* ##sys#thread-kill! */
static void C_ccall f_1548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,3))){C_save_and_reclaim((void *)f_1548,4,av);}
a=C_alloc(11);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1552,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=t2;
t6=C_slot(t5,C_fix(8));
if(C_truep(C_i_nullp(t6))){
t7=C_SCHEME_UNDEFINED;
t8=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
f_1552(2,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1525,a[2]=t8,a[3]=((C_word)li22),tmp=(C_word)a,a+=4,tmp));
t10=((C_word*)t8)[1];
f_1525(t10,t4,t6);}}

/* k965 in schedule */
static void C_ccall f_967(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_967,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_972,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li7),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_972(t5,((C_word*)t0)[3]);}

/* k1338 in k1329 in thread-block-for-timeout! */
static void C_ccall f_1340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1340,2,av);}
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),lf[42]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(13),C_SCHEME_FALSE);
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(4),((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_fcall f_2065(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(15,0,4))){
C_save_and_reclaim_args((void *)trf_2065,4,t0,t1,t2,t3);}
a=C_alloc(15);
if(C_truep(C_i_nullp(t2))){
if(C_truep(C_i_nullp(t3))){
t4=C_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t5=C_a_i_plus(&a,2,((C_word*)t0)[3],C_fix(1));
t6=C_slot(((C_word*)t0)[4],C_fix(1));
/* scheduler.scm:476: loop */
t7=((C_word*)((C_word*)t0)[5])[1];
f_2036(t7,t1,t4,t5,t6);}
else{
t4=C_a_i_cons(&a,2,((C_word*)t0)[6],t3);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2104,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t8=C_a_i_plus(&a,2,((C_word*)t0)[3],C_fix(1));
t9=C_slot(((C_word*)t0)[4],C_fix(1));
/* scheduler.scm:478: loop */
t10=((C_word*)((C_word*)t0)[5])[1];
f_2036(t10,t6,t7,t8,t9);}}
else{
t4=C_u_i_car(t2);
t5=t4;
t6=C_slot(t5,C_fix(11));
t7=t6;
if(C_truep(C_slot(t5,C_fix(13)))){
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:484: loop2 */
t23=t1;
t24=t9;
t25=t3;
t1=t23;
t2=t24;
t3=t25;
goto loop;}
else{
if(C_truep(C_i_pairp(t7))){
t8=C_u_i_car(t7);
t9=C_eqp(((C_word*)t0)[6],t8);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2195,a[2]=t2,a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t11=C_u_i_cdr(t7);
t12=t10;
t13=((C_word*)t0)[8];
t14=((C_word*)t0)[9];
t15=t11;
t16=C_eqp(t15,C_SCHEME_TRUE);
t17=(C_truep(t16)?t16:C_eqp(t15,lf[18]));
if(C_truep(t17)){
t18=t12;{
C_word av2[2];
av2[0]=t18;
av2[1]=t13;
((C_proc)(void*)(*((C_word*)t18+1)))(2,av2);}}
else{
t18=C_eqp(t15,C_SCHEME_FALSE);
t19=(C_truep(t18)?t18:C_eqp(t15,lf[19]));
if(C_truep(t19)){
t20=t12;{
C_word av2[2];
av2[0]=t20;
av2[1]=t14;
((C_proc)(void*)(*((C_word*)t20+1)))(2,av2);}}
else{
t20=C_eqp(t15,lf[20]);
if(C_truep(t20)){
t21=t12;{
C_word av2[2];
av2[0]=t21;
av2[1]=(C_truep(t13)?t13:t14);
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}
else{
t21=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1889,a[2]=t12,a[3]=t14,a[4]=t13,a[5]=t15,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: open-output-string */
t22=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t22;
av2[1]=t21;
((C_proc)(void*)(*((C_word*)t22+1)))(2,av2);}}}}}
else{
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2166,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:493: open-output-string */
t11=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}
else{
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2142,a[2]=t2,a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(t5,C_fix(4)))){
/* scheduler.scm:489: ##sys#remove-from-timeout-list */
t9=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}
else{
t9=t8;{
C_word av2[2];
av2[0]=t9;
av2[1]=C_SCHEME_UNDEFINED;
f_2142(2,av2);}}}}}}

/* loop in k1329 in thread-block-for-timeout! */
static void C_fcall f_1351(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_1351,4,t0,t1,t2,t3);}
a=C_alloc(8);
t4=C_i_nullp(t2);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1361,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=t1,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t6=t5;
f_1361(t6,t4);}
else{
t6=C_u_i_caar(t2);
t7=t5;
f_1361(t7,C_flonum_lessp(((C_word*)t0)[2],t6));}}

/* g634 in kill-other-threads */
static C_word C_fcall f_2587(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;{}
t2=C_slot(t1,C_fix(1));
return(f_2548(((C_word*)t0)[2],t2));}

/* k2524 in k2521 in thread-unblock! */
static void C_ccall f_2526(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2526,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2529,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:573: ##sys#clear-i/o-state-for-thread! */
f_2271(t2,((C_word*)t0)[3]);}

/* k2521 in thread-unblock! */
static void C_fcall f_2523(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_2523,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2526,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:572: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* for-each-loop258 in thread-kill! */
static void C_fcall f_1525(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(!C_demand(C_calculate_demand(15,0,3))){
C_save_and_reclaim_args((void *)trf_1525,3,t0,t1,t2);}
a=C_alloc(15);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1535,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
t5=t3;
t6=t4;
t7=C_i_set_i_slot(t6,C_fix(2),C_SCHEME_FALSE);
t8=C_i_set_i_slot(t6,C_fix(4),C_SCHEME_TRUE);
t9=C_i_set_i_slot(t6,C_fix(5),C_SCHEME_FALSE);
t10=C_slot(t6,C_fix(3));
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1483,a[2]=t5,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t10))){
t12=t5;{
C_word av2[2];
av2[0]=t12;
av2[1]=C_i_set_i_slot(t6,C_fix(3),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}
else{
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1499,a[2]=t13,a[3]=((C_word)li21),tmp=(C_word)a,a+=4,tmp));
t15=((C_word*)t13)[1];
f_1499(t15,t11,t10);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2527 in k2524 in k2521 in thread-unblock! */
static void C_ccall f_2529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2529,2,av);}
/* scheduler.scm:574: ##sys#thread-basic-unblock! */
t2=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* g617 in kill-other-threads */
static C_word C_fcall f_2574(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;{}
t2=C_slot(t1,C_fix(1));
return(f_2548(((C_word*)t0)[2],t2));}

/* for-each-loop364 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_fcall f_1830(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1830,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1840,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:392: g365 */
t5=((C_word*)t0)[3];
f_1733(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#thread-unblock! */
static void C_ccall f_2513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2513,3,av);}
a=C_alloc(4);
t3=C_slot(t2,C_fix(3));
t4=C_eqp(lf[42],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2523,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=t5;
f_2523(t6,t4);}
else{
t6=C_slot(t2,C_fix(3));
t7=t5;
f_2523(t7,C_eqp(lf[61],t6));}}

/* k1838 in for-each-loop364 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1840(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1840,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1830(t3,((C_word*)t0)[4],t2);}

/* k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_1855,2,av);}
a=C_alloc(6);
t2=stub354(C_SCHEME_UNDEFINED,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1722,a[2]=t4,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_1722(t6,((C_word*)t0)[2],*((C_word*)lf[11]+1));}

/* k1092 in loop in loop1 in k965 in schedule */
static void C_fcall f_1094(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,1))){
C_save_and_reclaim_args((void *)trf_1094,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_caar(lf[10]);
t3=C_a_i_flonum_difference(&a,2,t2,((C_word*)t0)[2]);
t4=C_quickflonumtruncate(t3);
t5=C_i_fixnum_max(C_fix(0),t4);
if(C_truep(C_msleep(t5))){
t6=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_FALSE);
t7=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_mk_bool(C_signal_interrupted_p);
t7=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t6);
t8=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1889(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,4))){C_save_and_reclaim((void *)f_1889,2,av);}
a=C_alloc(8);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1895,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* scheduler.scm:425: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[27];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* for-each-loop306 in k1562 in k1559 in k1556 in k1550 in thread-kill! */
static void C_fcall f_1608(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1608,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1618,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:350: g307 */
t5=((C_word*)t0)[3];
f_1589(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1895(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_1895,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1898,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1898(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_1898,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1901,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[26];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1616 in for-each-loop306 in k1562 in k1559 in k1556 in k1550 in thread-kill! */
static void C_ccall f_1618(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1618,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1608(t3,((C_word*)t0)[4],t2);}

/* k1789 in k1786 in k1783 in k1780 in k1774 in g365 in loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1791(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_1791,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1794,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:412: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k2398 in loop in loop in all-threads */
static void C_ccall f_2400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2400,2,av);}
/* scheduler.scm:536: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2381(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* loop in loop in loop in all-threads */
static void C_fcall f_2405(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_2405,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=((C_word*)t0)[2];
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2423,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=t2;
t7=C_u_i_cdr(t6);
/* scheduler.scm:540: loop */
t9=t5;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}

/* loop in k1853 in k974 in loop1 in k965 in schedule */
static void C_fcall f_1722(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(!C_demand(C_calculate_demand(25,0,3))){
C_save_and_reclaim_args((void *)trf_1722,3,t0,t1,t2);}
a=C_alloc(25);
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_caar(t2);
t4=t3;
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_FALSE;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1733,a[2]=t6,a[3]=t8,a[4]=t4,a[5]=((C_word)li3),tmp=(C_word)a,a+=6,tmp);
t10=t2;
t11=C_u_i_car(t10);
t12=C_u_i_cdr(t11);
t13=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1818,a[2]=t6,a[3]=t8,a[4]=t4,a[5]=t2,a[6]=((C_word*)t0)[2],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t14=C_SCHEME_UNDEFINED;
t15=(*a=C_VECTOR_TYPE|1,a[1]=t14,tmp=(C_word)a,a+=2,tmp);
t16=C_set_block_item(t15,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1830,a[2]=t15,a[3]=t9,a[4]=((C_word)li4),tmp=(C_word)a,a+=5,tmp));
t17=((C_word*)t15)[1];
f_1830(t17,t13,t12);}}

/* ##sys#thread-block-for-termination! */
static void C_ccall f_1418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_1418,4,av);}
a=C_alloc(3);
t4=C_slot(t3,C_fix(3));
t5=C_eqp(t4,lf[45]);
t6=(C_truep(t5)?t5:C_eqp(t4,lf[46]));
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_slot(t3,C_fix(12));
t8=C_a_i_cons(&a,2,t2,t7);
t9=C_i_setslot(t3,C_fix(12),t8);
t10=C_i_setslot(t2,C_fix(3),lf[42]);
t11=C_i_set_i_slot(t2,C_fix(13),C_SCHEME_FALSE);
t12=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t12;
av2[1]=C_i_setslot(t2,C_fix(11),t3);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* k1411 in k1408 in k1402 in thread-block-for-timeout! */
static void C_ccall f_1413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_1413,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1416,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:293: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1414 in k1411 in k1408 in k1402 in thread-block-for-timeout! */
static void C_ccall f_1416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1416,2,av);}
t2=((C_word*)t0)[2];
f_1331(t2,C_halt(t1));}

/* k1408 in k1402 in thread-block-for-timeout! */
static void C_ccall f_1410(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,4))){C_save_and_reclaim((void *)f_1410,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1413,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:293: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2421 in loop in loop in loop in all-threads */
static void C_ccall f_2423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2423,2,av);}
/* scheduler.scm:540: cns */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[57];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1077 in loop in loop1 in k965 in schedule */
static void C_ccall f_1079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_1079,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1082,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:187: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1700 in a1697 in default-exception-handler */
static void C_ccall f_1702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1702,2,av);}
/* scheduler.scm:375: ptx */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in clear-i/o-state-for-thread! */
static void C_fcall f_2287(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(5,0,3))){
C_save_and_reclaim_args((void *)trf_2287,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=t3;
t5=C_u_i_car(t4);
t6=C_eqp(((C_word*)t0)[2],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2309,a[2]=t2,a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t8=C_u_i_cdr(t4);
/* scheduler.scm:515: ##sys#delq */
t9=*((C_word*)lf[49]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t7;
av2[2]=((C_word*)t0)[3];
av2[3]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2328,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:520: loop */
t11=t7;
t12=t9;
t1=t11;
t2=t12;
goto loop;}}}

/* k2283 in clear-i/o-state-for-thread! */
static void C_ccall f_2285(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2285,2,av);}
t2=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* g307 in k1562 in k1559 in k1556 in k1550 in thread-kill! */
static void C_fcall f_1589(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,2))){
C_save_and_reclaim_args((void *)trf_1589,3,t0,t1,t2);}
t3=C_slot(t2,C_fix(11));
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
/* scheduler.scm:354: ##sys#thread-basic-unblock! */
t5=*((C_word*)lf[16]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k1580 in k1562 in k1559 in k1556 in k1550 in thread-kill! */
static void C_ccall f_1582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1582,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_i_set_i_slot(((C_word*)t0)[3],C_fix(12),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1080 in k1077 in loop in loop1 in k965 in schedule */
static void C_ccall f_1082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_1082,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:188: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_1045(t4,((C_word*)t0)[4],t3);}

/* k1402 in thread-block-for-timeout! */
static void C_ccall f_1404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1404,2,av);}
a=C_alloc(6);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1410,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:293: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[43];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* ##sys#remove-from-timeout-list */
static void C_ccall f_1286(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_1286,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1292,a[2]=t2,a[3]=((C_word)li14),tmp=(C_word)a,a+=4,tmp);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=f_1292(t3,lf[10],C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#ready-queue */
static void C_ccall f_1159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1159,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=lf[13];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1914 in k1911 in k1908 in k1905 in k1902 in k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1916(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1916,2,av);}
t2=C_halt(t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1550 in thread-kill! */
static void C_ccall f_1552(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1552,2,av);}
a=C_alloc(9);
t2=C_slot(((C_word*)t0)[2],C_fix(11));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1558,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_structurep(t3,lf[48]))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1639,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_slot(t3,C_fix(2));
/* scheduler.scm:339: ##sys#delq */
t7=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
if(C_truep(C_i_structurep(t3,lf[50]))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1656,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_slot(t3,C_fix(12));
/* scheduler.scm:341: ##sys#delq */
t7=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t4;
f_1558(t6,t5);}}}

/* k1556 in k1550 in thread-kill! */
static void C_fcall f_1558(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1558,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1561,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:342: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1911 in k1908 in k1905 in k1902 in k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_1913,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1916,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:425: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1908 in k1905 in k1902 in k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_1910,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1913,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:425: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* loop in remove-from-timeout-list */
static C_word C_fcall f_1292(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
loop:{}
if(C_truep(C_i_nullp(t1))){
t3=t1;
return(t3);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_slot(t1,C_fix(1));
t5=C_slot(t3,C_fix(1));
t6=C_eqp(t5,((C_word*)t0)[2]);
if(C_truep(t6)){
if(C_truep(t2)){
return(C_i_setslot(t2,C_fix(1),t4));}
else{
t7=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t4);
return(t7);}}
else{
t9=t4;
t10=t1;
t1=t9;
t2=t10;
goto loop;}}}

/* k1562 in k1559 in k1556 in k1550 in thread-kill! */
static void C_ccall f_1564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,3))){C_save_and_reclaim((void *)f_1564,2,av);}
a=C_alloc(15);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),((C_word*)t0)[3]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),C_SCHEME_FALSE);
t4=C_i_set_i_slot(((C_word*)t0)[2],C_fix(11),C_SCHEME_FALSE);
t5=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_END_OF_LIST);
t6=C_slot(((C_word*)t0)[2],C_fix(12));
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1582,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t6))){
t8=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(12),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1589,a[2]=((C_word*)t0)[2],a[3]=((C_word)li19),tmp=(C_word)a,a+=4,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1608,a[2]=t10,a[3]=t8,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t12=((C_word*)t10)[1];
f_1608(t12,t7,t6);}}

/* k1559 in k1556 in k1550 in thread-kill! */
static void C_ccall f_1561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_1561,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:343: ##sys#clear-i/o-state-for-thread! */
f_2271(t2,((C_word*)t0)[2]);}

/* ##sys#add-to-ready-queue */
static void C_ccall f_1162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_1162,3,av);}
a=C_alloc(3);
t3=C_i_setslot(t2,C_fix(3),lf[8]);
t4=C_a_i_cons(&a,2,t2,C_SCHEME_END_OF_LIST);
t5=C_eqp(C_SCHEME_END_OF_LIST,lf[13]);
if(C_truep(t5)){
t6=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t4);
t7=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t4);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t6=C_i_setslot(lf[14],C_fix(1),t4);
t7=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t4);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k1682 in k1676 in default-exception-handler */
static void C_ccall f_1684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1684,2,av);}
/* scheduler.scm:381: ##sys#schedule */
t2=*((C_word*)lf[0]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2164 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_2166,2,av);}
a=C_alloc(7);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2172,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:493: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[30];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* ##sys#restore-threads */
static void C_ccall f_2494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2494,3,av);}
t3=C_slot(t2,C_fix(0));
t4=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t3);
t5=C_slot(t2,C_fix(1));
t6=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t5);
t7=C_slot(t2,C_fix(2));
t8=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t7);
t9=C_slot(t2,C_fix(3));
t10=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t9);
t11=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}

/* k1902 in k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1904(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1904,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1907,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[25];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1905 in k1902 in k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_1907,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1910,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2102 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_2104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_2104,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a1697 in default-exception-handler */
static void C_ccall f_1698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_1698,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1702,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:374: ##sys#signal */
t3=*((C_word*)lf[52]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1899 in k1896 in k1893 in k1887 in loop2 in loop in k2008 in k1999 in k974 in loop1 in k965 in schedule */
static void C_ccall f_1901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1901,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1904,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* ##sys#fetch-and-clear-threads */
static void C_ccall f_2484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,1))){C_save_and_reclaim((void *)f_2484,2,av);}
a=C_alloc(5);
t2=C_a_i_vector4(&a,4,lf[13],lf[14],*((C_word*)lf[11]+1),lf[10]);
t3=lf[13] /* ready-queue-head */ =C_SCHEME_END_OF_LIST;;
t4=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t5=C_set_block_item(lf[11] /* ##sys#fd-list */,0,C_SCHEME_END_OF_LIST);
t6=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[125] = {
{"f_1733:scheduler_2escm",(void*)f_1733},
{"f_2145:scheduler_2escm",(void*)f_2145},
{"f_2142:scheduler_2escm",(void*)f_2142},
{"f_2271:scheduler_2escm",(void*)f_2271},
{"f_1265:scheduler_2escm",(void*)f_1265},
{"f_1261:scheduler_2escm",(void*)f_1261},
{"f_1794:scheduler_2escm",(void*)f_1794},
{"f_1797:scheduler_2escm",(void*)f_1797},
{"f_2201:scheduler_2escm",(void*)f_2201},
{"f_1279:scheduler_2escm",(void*)f_1279},
{"f_1656:scheduler_2escm",(void*)f_1656},
{"f_2198:scheduler_2escm",(void*)f_2198},
{"f_2446:scheduler_2escm",(void*)f_2446},
{"f_2195:scheduler_2escm",(void*)f_2195},
{"f_1662:scheduler_2escm",(void*)f_1662},
{"f_2242:scheduler_2escm",(void*)f_2242},
{"f_1776:scheduler_2escm",(void*)f_1776},
{"toplevel:scheduler_2escm",(void*)C_scheduler_toplevel},
{"f_2187:scheduler_2escm",(void*)f_2187},
{"f_2475:scheduler_2escm",(void*)f_2475},
{"f_2181:scheduler_2escm",(void*)f_2181},
{"f_2184:scheduler_2escm",(void*)f_2184},
{"f_1674:scheduler_2escm",(void*)f_1674},
{"f_1678:scheduler_2escm",(void*)f_1678},
{"f_1785:scheduler_2escm",(void*)f_1785},
{"f_1782:scheduler_2escm",(void*)f_1782},
{"f_1788:scheduler_2escm",(void*)f_1788},
{"f_2178:scheduler_2escm",(void*)f_2178},
{"f_2172:scheduler_2escm",(void*)f_2172},
{"f_2175:scheduler_2escm",(void*)f_2175},
{"f_988:scheduler_2escm",(void*)f_988},
{"f_984:scheduler_2escm",(void*)f_984},
{"f_1148:scheduler_2escm",(void*)f_1148},
{"f_1045:scheduler_2escm",(void*)f_1045},
{"f_937:scheduler_2escm",(void*)f_937},
{"f_2036:scheduler_2escm",(void*)f_2036},
{"f_2034:scheduler_2escm",(void*)f_2034},
{"f_2328:scheduler_2escm",(void*)f_2328},
{"f_2430:scheduler_2escm",(void*)f_2430},
{"f_1639:scheduler_2escm",(void*)f_1639},
{"f_1953:scheduler_2escm",(void*)f_1953},
{"f_1499:scheduler_2escm",(void*)f_1499},
{"f_2309:scheduler_2escm",(void*)f_2309},
{"f_2358:scheduler_2escm",(void*)f_2358},
{"f_1938:scheduler_2escm",(void*)f_1938},
{"f_1934:scheduler_2escm",(void*)f_1934},
{"f_2340:scheduler_2escm",(void*)f_2340},
{"f_1818:scheduler_2escm",(void*)f_1818},
{"f_1483:scheduler_2escm",(void*)f_1483},
{"f_972:scheduler_2escm",(void*)f_972},
{"f_976:scheduler_2escm",(void*)f_976},
{"f_979:scheduler_2escm",(void*)f_979},
{"f_2010:scheduler_2escm",(void*)f_2010},
{"f_1331:scheduler_2escm",(void*)f_1331},
{"f_2001:scheduler_2escm",(void*)f_2001},
{"f_1327:scheduler_2escm",(void*)f_1327},
{"f_2381:scheduler_2escm",(void*)f_2381},
{"f_1509:scheduler_2escm",(void*)f_1509},
{"f_2374:scheduler_2escm",(void*)f_2374},
{"f_1361:scheduler_2escm",(void*)f_1361},
{"f_2606:scheduler_2escm",(void*)f_2606},
{"f_2601:scheduler_2escm",(void*)f_2601},
{"f_1535:scheduler_2escm",(void*)f_1535},
{"f_2629:scheduler_2escm",(void*)f_2629},
{"f_2548:scheduler_2escm",(void*)f_2548},
{"f_2545:scheduler_2escm",(void*)f_2545},
{"f_1548:scheduler_2escm",(void*)f_1548},
{"f_967:scheduler_2escm",(void*)f_967},
{"f_1340:scheduler_2escm",(void*)f_1340},
{"f_2065:scheduler_2escm",(void*)f_2065},
{"f_1351:scheduler_2escm",(void*)f_1351},
{"f_2587:scheduler_2escm",(void*)f_2587},
{"f_2526:scheduler_2escm",(void*)f_2526},
{"f_2523:scheduler_2escm",(void*)f_2523},
{"f_1525:scheduler_2escm",(void*)f_1525},
{"f_2529:scheduler_2escm",(void*)f_2529},
{"f_2574:scheduler_2escm",(void*)f_2574},
{"f_1830:scheduler_2escm",(void*)f_1830},
{"f_2513:scheduler_2escm",(void*)f_2513},
{"f_1840:scheduler_2escm",(void*)f_1840},
{"f_1855:scheduler_2escm",(void*)f_1855},
{"f_1094:scheduler_2escm",(void*)f_1094},
{"f_1889:scheduler_2escm",(void*)f_1889},
{"f_1608:scheduler_2escm",(void*)f_1608},
{"f_1895:scheduler_2escm",(void*)f_1895},
{"f_1898:scheduler_2escm",(void*)f_1898},
{"f_1618:scheduler_2escm",(void*)f_1618},
{"f_1791:scheduler_2escm",(void*)f_1791},
{"f_2400:scheduler_2escm",(void*)f_2400},
{"f_2405:scheduler_2escm",(void*)f_2405},
{"f_1722:scheduler_2escm",(void*)f_1722},
{"f_1418:scheduler_2escm",(void*)f_1418},
{"f_1413:scheduler_2escm",(void*)f_1413},
{"f_1416:scheduler_2escm",(void*)f_1416},
{"f_1410:scheduler_2escm",(void*)f_1410},
{"f_2423:scheduler_2escm",(void*)f_2423},
{"f_1079:scheduler_2escm",(void*)f_1079},
{"f_1702:scheduler_2escm",(void*)f_1702},
{"f_2287:scheduler_2escm",(void*)f_2287},
{"f_2285:scheduler_2escm",(void*)f_2285},
{"f_1589:scheduler_2escm",(void*)f_1589},
{"f_1582:scheduler_2escm",(void*)f_1582},
{"f_1082:scheduler_2escm",(void*)f_1082},
{"f_1404:scheduler_2escm",(void*)f_1404},
{"f_1286:scheduler_2escm",(void*)f_1286},
{"f_1159:scheduler_2escm",(void*)f_1159},
{"f_1916:scheduler_2escm",(void*)f_1916},
{"f_1552:scheduler_2escm",(void*)f_1552},
{"f_1558:scheduler_2escm",(void*)f_1558},
{"f_1913:scheduler_2escm",(void*)f_1913},
{"f_1910:scheduler_2escm",(void*)f_1910},
{"f_1292:scheduler_2escm",(void*)f_1292},
{"f_1564:scheduler_2escm",(void*)f_1564},
{"f_1561:scheduler_2escm",(void*)f_1561},
{"f_1162:scheduler_2escm",(void*)f_1162},
{"f_1684:scheduler_2escm",(void*)f_1684},
{"f_2166:scheduler_2escm",(void*)f_2166},
{"f_2494:scheduler_2escm",(void*)f_2494},
{"f_1904:scheduler_2escm",(void*)f_1904},
{"f_1907:scheduler_2escm",(void*)f_1907},
{"f_2104:scheduler_2escm",(void*)f_2104},
{"f_1698:scheduler_2escm",(void*)f_1698},
{"f_1901:scheduler_2escm",(void*)f_1901},
{"f_2484:scheduler_2escm",(void*)f_2484},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		5
S|  ##sys#for-each		1
S|  sprintf		4
o|eliminated procedure checks: 124 
o|specializations:
o|  1 (fpmax float float)
o|  10 (eqv? * (not float))
o|  4 (##sys#check-output-port * * *)
o|  3 (car pair)
o|  20 (cdr pair)
o|  4 (cdar (pair pair *))
(o e)|safe calls: 185 
o|Removed `not' forms: 5 
o|contracted procedure: k992 
o|inlining procedure: k989 
o|contracted procedure: "(scheduler.scm:219) switch120" 
o|contracted procedure: "(scheduler.scm:158) restore-thread-state-buffer" 
o|inlining procedure: k989 
o|contracted procedure: "(scheduler.scm:214) remove-from-ready-queue" 
o|contracted procedure: k1187 
o|inlining procedure: k1184 
o|inlining procedure: k1184 
o|propagated global variable: first-pair181 ready-queue-head 
o|inlining procedure: k1029 
o|inlining procedure: k1029 
o|contracted procedure: "(scheduler.scm:211) unblock-threads-for-i/o" 
o|inlining procedure: k2016 
o|inlining procedure: k2016 
o|inlining procedure: k2038 
o|inlining procedure: k2038 
o|inlining procedure: k2067 
o|inlining procedure: k2067 
o|contracted procedure: k2137 
o|inlining procedure: k2134 
o|contracted procedure: k2160 
o|inlining procedure: k2190 
o|inlining procedure: k2190 
o|contracted procedure: "(scheduler.scm:494) fdset-test" 
o|inlining procedure: k1859 
o|inlining procedure: k1859 
o|inlining procedure: k1877 
o|substituted constant variable: a1891 
o|substituted constant variable: a1892 
o|inlining procedure: k1877 
o|substituted constant variable: a1918 
o|substituted constant variable: a1923 
o|substituted constant variable: a1925 
o|substituted constant variable: a1930 
o|substituted constant variable: a1932 
o|substituted constant variable: a2168 
o|substituted constant variable: a2169 
o|inlining procedure: k2134 
o|contracted procedure: "(scheduler.scm:454) g478479" 
o|substituted constant variable: a2262 
o|contracted procedure: "(scheduler.scm:445) create-fdset" 
o|inlining procedure: k1724 
o|inlining procedure: k1738 
o|inlining procedure: k1755 
o|inlining procedure: k1755 
o|substituted constant variable: a1778 
o|substituted constant variable: a1779 
o|substituted constant variable: a1799 
o|substituted constant variable: a1804 
o|substituted constant variable: a1806 
o|substituted constant variable: a1811 
o|substituted constant variable: a1813 
o|inlining procedure: k1738 
o|inlining procedure: k1724 
o|contracted procedure: "(scheduler.scm:392) g409410" 
o|inlining procedure: k1832 
o|inlining procedure: k1832 
o|contracted procedure: "(scheduler.scm:388) g351352" 
o|inlining procedure: k1047 
o|inlining procedure: k1047 
o|inlining procedure: k1068 
o|inlining procedure: k1068 
o|contracted procedure: k1102 
o|inlining procedure: k1099 
o|inlining procedure: k1099 
o|inlining procedure: k1118 
o|inlining procedure: k1118 
o|contracted procedure: "(scheduler.scm:166) update-thread-state-buffer" 
o|propagated global variable: ct128 ##sys#current-thread 
o|inlining procedure: k1170 
o|inlining procedure: k1170 
o|inlining procedure: k1263 
o|propagated global variable: ct205 ##sys#current-thread 
o|inlining procedure: k1263 
o|inlining procedure: k1294 
o|inlining procedure: k1294 
o|inlining procedure: k1312 
o|inlining procedure: k1312 
o|inlining procedure: k1332 
o|inlining procedure: k1353 
o|inlining procedure: k1353 
o|inlining procedure: k1332 
o|substituted constant variable: a1406 
o|substituted constant variable: a1407 
o|inlining procedure: k1423 
o|inlining procedure: k1423 
o|inlining procedure: k1580 
o|inlining procedure: k1591 
o|inlining procedure: k1591 
o|inlining procedure: k1580 
o|inlining procedure: k1610 
o|inlining procedure: k1610 
o|inlining procedure: k1644 
o|inlining procedure: k1644 
o|contracted procedure: "(scheduler.scm:335) abandon-mutexes" 
o|inlining procedure: k1461 
o|inlining procedure: k1461 
o|inlining procedure: k1527 
o|contracted procedure: "(scheduler.scm:318) g259266" 
o|inlining procedure: k1481 
o|inlining procedure: k1481 
o|inlining procedure: k1501 
o|contracted procedure: "(scheduler.scm:325) g273280" 
o|inlining procedure: k1501 
o|inlining procedure: k1527 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|inlining procedure: k1955 
o|inlining procedure: k1955 
o|inlining procedure: k2273 
o|inlining procedure: k2289 
o|inlining procedure: k2289 
o|inlining procedure: k2310 
o|inlining procedure: k2310 
o|inlining procedure: k2273 
o|inlining procedure: k2360 
o|inlining procedure: k2360 
o|inlining procedure: k2383 
o|inlining procedure: k2407 
o|inlining procedure: k2407 
o|inlining procedure: k2383 
o|inlining procedure: k2432 
o|inlining procedure: k2432 
o|inlining procedure: k2515 
o|inlining procedure: k2515 
o|propagated global variable: primordial609 ##sys#current-thread 
o|inlining procedure: k2608 
o|inlining procedure: k2608 
o|propagated global variable: g640642 ##sys#fd-list 
o|inlining procedure: k2631 
o|inlining procedure: k2631 
o|propagated global variable: g623625 ##sys#timeout-list 
o|propagated global variable: primordial609 ##sys#current-thread 
o|replaced variables: 258 
o|removed binding forms: 176 
o|substituted constant variable: r11852653 
o|inlining procedure: k1194 
o|inlining procedure: k1194 
o|inlining procedure: k2253 
o|inlining procedure: k2253 
o|substituted constant variable: r11002683 
o|substituted constant variable: r11192688 
o|substituted constant variable: r22902750 
o|converted assignments to bindings: (suspend610) 
o|simplifications: ((let . 1)) 
o|replaced variables: 20 
o|removed binding forms: 284 
o|inlining procedure: k998 
o|inlining procedure: k1821 
o|replaced variables: 14 
o|removed binding forms: 33 
o|substituted constant variable: r9992854 
o|contracted procedure: k1715 
o|simplifications: ((let . 1)) 
o|replaced variables: 2 
o|removed binding forms: 16 
o|removed conditional forms: 1 
o|removed binding forms: 2 
o|simplifications: ((if . 17) (##core#call . 231)) 
o|  call simplifications:
o|    vector
o|    list	2
o|    ##sys#structure?	2
o|    flonum?
o|    fp>
o|    fp<
o|    fx=	2
o|    set-cdr!	3
o|    equal?
o|    fp>=
o|    fxmax
o|    ##sys#setislot	18
o|    not
o|    caar	7
o|    fp-	2
o|    fx>
o|    zero?
o|    pair?	15
o|    car	12
o|    cons	15
o|    sub1	2
o|    add1	3
o|    cdr	8
o|    null?	25
o|    eq?	25
o|    ##sys#setslot	29
o|    ##sys#slot	51
o|contracted procedure: k959 
o|contracted procedure: k1023 
o|contracted procedure: k1013 
o|contracted procedure: k943 
o|contracted procedure: k950 
o|contracted procedure: k953 
o|contracted procedure: k1233 
o|contracted procedure: k1237 
o|contracted procedure: k1241 
o|contracted procedure: k1245 
o|contracted procedure: k1249 
o|contracted procedure: k1253 
o|contracted procedure: k1257 
o|contracted procedure: k1004 
o|contracted procedure: k998 
o|contracted procedure: k1203 
o|contracted procedure: k1190 
o|contracted procedure: k1198 
o|contracted procedure: k1032 
o|contracted procedure: k2002 
o|contracted procedure: k2005 
o|contracted procedure: k2013 
o|contracted procedure: k2019 
o|contracted procedure: k2028 
o|contracted procedure: k2041 
o|contracted procedure: k2044 
o|contracted procedure: k2047 
o|contracted procedure: k2050 
o|contracted procedure: k2056 
o|contracted procedure: k2070 
o|contracted procedure: k2076 
o|contracted procedure: k2083 
o|contracted procedure: k2087 
o|contracted procedure: k2091 
o|contracted procedure: k2098 
o|contracted procedure: k2106 
o|contracted procedure: k2110 
o|contracted procedure: k2114 
o|contracted procedure: k2117 
o|contracted procedure: k2120 
o|contracted procedure: k2126 
o|contracted procedure: k2233 
o|contracted procedure: k2229 
o|contracted procedure: k2225 
o|contracted procedure: k2207 
o|contracted procedure: k2219 
o|contracted procedure: k1862 
o|contracted procedure: k1865 
o|contracted procedure: k1871 
o|contracted procedure: k1874 
o|contracted procedure: k1880 
o|contracted procedure: k2151 
o|contracted procedure: k2244 
o|contracted procedure: k2256 
o|contracted procedure: k2259 
o|contracted procedure: k2264 
o|contracted procedure: k1727 
o|contracted procedure: k1730 
o|contracted procedure: k1735 
o|contracted procedure: k1741 
o|contracted procedure: k1748 
o|contracted procedure: k1751 
o|contracted procedure: k1758 
o|contracted procedure: k1761 
o|contracted procedure: k1768 
o|contracted procedure: k1835 
o|contracted procedure: k1845 
o|contracted procedure: k1849 
o|contracted procedure: k1038 
o|contracted procedure: k1050 
o|contracted procedure: k1054 
o|contracted procedure: k1059 
o|contracted procedure: k1065 
o|contracted procedure: k1071 
o|contracted procedure: k1074 
o|contracted procedure: k1095 
o|contracted procedure: k1112 
o|contracted procedure: k1107 
o|contracted procedure: k1115 
o|contracted procedure: k1121 
o|contracted procedure: k1132 
o|contracted procedure: k1135 
o|contracted procedure: k1138 
o|contracted procedure: k1209 
o|propagated global variable: ct128 ##sys#current-thread 
o|contracted procedure: k1212 
o|contracted procedure: k1215 
o|contracted procedure: k1218 
o|contracted procedure: k1221 
o|contracted procedure: k1224 
o|contracted procedure: k1150 
o|contracted procedure: k1164 
o|contracted procedure: k1167 
o|contracted procedure: k1174 
o|contracted procedure: k1170 
o|contracted procedure: k1269 
o|contracted procedure: k1272 
o|contracted procedure: k1297 
o|contracted procedure: k1300 
o|contracted procedure: k1303 
o|contracted procedure: k1323 
o|contracted procedure: k1309 
o|contracted procedure: k1335 
o|contracted procedure: k1341 
o|contracted procedure: k1344 
o|contracted procedure: k1356 
o|contracted procedure: k1373 
o|contracted procedure: k1369 
o|contracted procedure: k1381 
o|contracted procedure: k1377 
o|contracted procedure: k1388 
o|contracted procedure: k1395 
o|contracted procedure: k1398 
o|contracted procedure: k1420 
o|contracted procedure: k1426 
o|contracted procedure: k1429 
o|contracted procedure: k1449 
o|contracted procedure: k1445 
o|contracted procedure: k1432 
o|contracted procedure: k1435 
o|contracted procedure: k1438 
o|contracted procedure: k1553 
o|contracted procedure: k1565 
o|contracted procedure: k1568 
o|contracted procedure: k1571 
o|contracted procedure: k1574 
o|contracted procedure: k1577 
o|contracted procedure: k1586 
o|contracted procedure: k1601 
o|contracted procedure: k1594 
o|contracted procedure: k1613 
o|contracted procedure: k1623 
o|contracted procedure: k1627 
o|contracted procedure: k1630 
o|contracted procedure: k1641 
o|contracted procedure: k1647 
o|contracted procedure: k1658 
o|contracted procedure: k1458 
o|contracted procedure: k1464 
o|contracted procedure: k1530 
o|contracted procedure: k1540 
o|contracted procedure: k1544 
o|contracted procedure: k1469 
o|contracted procedure: k1472 
o|contracted procedure: k1475 
o|contracted procedure: k1478 
o|contracted procedure: k1487 
o|contracted procedure: k1504 
o|contracted procedure: k1514 
o|contracted procedure: k1518 
o|contracted procedure: k1664 
o|contracted procedure: k1667 
o|contracted procedure: k1679 
o|contracted procedure: k1688 
o|contracted procedure: k1691 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|contracted procedure: k1939 
o|contracted procedure: k1942 
o|contracted procedure: k1949 
o|contracted procedure: k1958 
o|contracted procedure: k1966 
o|contracted procedure: k1962 
o|contracted procedure: k1969 
o|contracted procedure: k1993 
o|contracted procedure: k1975 
o|contracted procedure: k1982 
o|contracted procedure: k2336 
o|contracted procedure: k2276 
o|contracted procedure: k2332 
o|contracted procedure: k2279 
o|contracted procedure: k2292 
o|contracted procedure: k2295 
o|contracted procedure: k2298 
o|contracted procedure: k2304 
o|contracted procedure: k2313 
o|contracted procedure: k2317 
o|contracted procedure: k2472 
o|contracted procedure: k2342 
o|contracted procedure: k2466 
o|contracted procedure: k2345 
o|contracted procedure: k2460 
o|contracted procedure: k2348 
o|contracted procedure: k2454 
o|contracted procedure: k2351 
o|contracted procedure: k2363 
o|contracted procedure: k2386 
o|contracted procedure: k2395 
o|contracted procedure: k2410 
o|contracted procedure: k2417 
o|contracted procedure: k2435 
o|contracted procedure: k2448 
o|contracted procedure: k2486 
o|contracted procedure: k2497 
o|contracted procedure: k2501 
o|contracted procedure: k2505 
o|contracted procedure: k2509 
o|contracted procedure: k2541 
o|contracted procedure: k2518 
o|contracted procedure: k2537 
o|contracted procedure: k2559 
o|contracted procedure: k2550 
o|contracted procedure: k2553 
o|contracted procedure: k2567 
o|contracted procedure: k2580 
o|contracted procedure: k2593 
o|contracted procedure: k2611 
o|contracted procedure: k2621 
o|contracted procedure: k2625 
o|contracted procedure: k2634 
o|contracted procedure: k2644 
o|contracted procedure: k2648 
o|propagated global variable: primordial609 ##sys#current-thread 
o|simplifications: ((let . 40)) 
o|removed binding forms: 209 
o|replaced variables: 73 
o|inlining procedure: k946 
o|removed binding forms: 28 
o|contracted procedure: k962 
o|propagated global variable: ct128 ##sys#current-thread 
o|propagated global variable: ct128 ##sys#current-thread 
o|removed binding forms: 3 
o|replaced variables: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: loop211 0 
o|direct leaf routine/allocation: suspend610 0 
o|direct leaf routine/allocation: g617624 0 
o|direct leaf routine/allocation: g634641 0 
o|converted assignments to bindings: (loop211) 
o|contracted procedure: "(scheduler.scm:592) k2571" 
o|contracted procedure: "(scheduler.scm:597) k2614" 
o|contracted procedure: "(scheduler.scm:593) k2637" 
o|simplifications: ((let . 1)) 
o|removed binding forms: 3 
o|direct leaf routine/allocation: for-each-loop633644 0 
o|direct leaf routine/allocation: for-each-loop616627 0 
o|contracted procedure: k2583 
o|contracted procedure: k2596 
o|converted assignments to bindings: (for-each-loop633644) 
o|converted assignments to bindings: (for-each-loop616627) 
o|simplifications: ((let . 2)) 
o|removed binding forms: 2 
o|customizable procedures: (k2521 loop583 loop580 loop576 loop573 loop541 loop463 for-each-loop272283 for-each-loop258291 k1556 g307314 for-each-loop306317 k1329 k1359 loop232 k1092 ##sys#clear-i/o-state-for-thread! loop137 g365372 for-each-loop364405 loop357 k2008 loop2507 loop493 k986 loop1135 loop2152) 
o|calls to known targets: 68 
o|identified direct recursive calls: f_2065 1 
o|identified direct recursive calls: f_2036 1 
o|identified direct recursive calls: f_1045 1 
o|identified direct recursive calls: f_1292 1 
o|identified direct recursive calls: f_1953 1 
o|identified direct recursive calls: f_2287 1 
o|identified direct recursive calls: f_2405 1 
o|identified direct recursive calls: f_2629 1 
o|identified direct recursive calls: f_2606 1 
o|fast box initializations: 17 
o|fast global references: 27 
o|fast global assignments: 22 
o|dropping unused closure argument: f_2271 
*/
/* end of file */
