/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_envelope.cpp  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include "interface_widget_envelope.h"
#include <gdkmm/colormap.h>
#include <stdio.h>
#include <math.h>

#define RPGC(m_gc) m_gc
#define RPFONT(m_font) Glib::RefPtr<Pango::Font>(&m_font)

int Envelope_Editor::color_values[] = {
    10, 20, 30,
    250, 100, 100,
    250, 250, 250,
    210, 210, 250,
    180, 180, 180,
    100, 100, 150,
    100, 150, 100,
    170, 250, 170,
    150, 50, 50

};
                                  

void Envelope_Editor::allocate_colormap () {

	Gdk::Color tmpcolor;
	int i;
//	Gdk::Colormap some_colormap(Gdk::Colormap::get_system());
//	Glib::RefPtr<Gdk::Colormap>Colormap colormap=*get_colormap();
	for (i=0;i<Max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].set_red( color_values[i] * 0xFFFF / 0xFF );
		colors[i/3].set_green(  color_values[i+1] * 0xFFFF / 0xFF );
		colors[i/3].set_blue ( color_values[i+2] * 0xFFFF / 0xFF );
	        get_colormap()->alloc_color(colors[i/3]);
	}

}

void Envelope_Editor::init_colors() {
/*
	Gdk_WindowAttr attributes;
        int attributes_mask;
	int i;

        set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;
*/

	allocate_colormap();


	for (int i=0;i<(Max_Colors);i++) {

		GC[i]=Gdk::GC::create(get_window());
		GC[i]->set_foreground(colors[i]);

	}

//	GC[Col_BackGround].set_exposures(1);
//	window.set_user_data(gtkobj());
//	window.set_background(colors[Col_BackGround]);

	add_events(Gdk::ALL_EVENTS_MASK);

}

bool Envelope_Editor::do_expose_event(GdkEventExpose* p0) {

        redraw_all=true;
	draw_envelope();
	return 0;

}

Sint16 Envelope_Editor::get_height_at_pos(int e_position,int p_height_max) {

        int heightpos,max;

	heightpos=(int)envelope->get_height_at_pos(e_position*100/zoom_amount);

	if (heightpos==Envelope::NO_POINT) {

		return Envelope::NO_POINT;
	}

	max=envelope->get_max_value();
/*	
	if (envelope->is_signed()) {
         	
		heightpos+=max;
		max*=2;
	}
  */

	heightpos=max-heightpos;	


       	return heightpos*p_height_max/max;

}

void Envelope_Editor::recalculate() {


	int new_width=get_width();

	if (frames_played!=NULL) free(frames_played);
	(void*)frames_played=malloc(new_width);
        memset(frames_played,0,get_width());

	need_recalculation=false;

}


void Envelope_Editor::draw_position(int pos) {

	int min,max,prev;
	int divide_y,real_x,old_real_x;	
	int real_node=-1;
	int i;


	max=get_height_at_pos(pos,get_height()-bottom_height);
	min=max;

        real_x=pos*100/zoom_amount;
	old_real_x=(pos-1)*100/zoom_amount;

	for (i=0;i<envelope->get_node_count();i++) if (envelope->get_node_offset(i)==real_x) real_node=i;
	
	i=pos;

	if ( (real_x!=old_real_x) && (envelope->is_loop_enabled()) && ((real_node==envelope->get_loop_begin()) || (real_node==envelope->get_loop_end())) ) {

		get_window()->draw_rectangle(RPGC(GC[Col_Loop_BackGround]),true,i,0,1,get_height()-bottom_height);

	} else if ( (real_x!=old_real_x) && (envelope->is_sustain_loop_enabled()) && ((real_node==envelope->get_sustain_loop_begin()) || (real_node==envelope->get_sustain_loop_end())) ) {


		get_window()->draw_rectangle(RPGC(GC[Col_SusLoop_BackGround]),TRUE,i,0,1,get_height()-bottom_height);

	} else if (frames_played[i]) {

		get_window()->draw_rectangle(RPGC(GC[Col_ForeGround]),TRUE,i,0,1,get_height()-bottom_height);
	} else {

		get_window()->draw_rectangle(RPGC(GC[Col_BackGround]),TRUE,i,0,1,get_height()-bottom_height);
	}

/*	if (envelope->is_signed()) {
		
		divide_y=(height()-bottom_height)/2;
	} else {*/

		divide_y=(get_height()-bottom_height)-3;

	if  (real_x!=old_real_x) {

        	if (real_x % 100==0) {

			get_window()->draw_rectangle(RPGC(GC[Col_MetricHi]),TRUE,pos,divide_y-7,1,13);

		} else if (real_x % 10==0) {

			get_window()->draw_rectangle(RPGC(GC[Col_Metric]),TRUE,pos,divide_y-3,1,5);

		} else if (zoom_amount>=200) {

			get_window()->draw_rectangle(RPGC(GC[Col_Metric]),TRUE,pos,divide_y-1,1,3);
		} else {

			get_window()->draw_rectangle(RPGC(GC[Col_Metric]),TRUE,pos,divide_y,1,1);
		}

	} else {

		get_window()->draw_rectangle(RPGC(GC[Col_Metric]),TRUE,pos,divide_y,1,1);
	}


//	} else {

//				window.draw_rectangle(GC[Col_Loop_BackGround],FALSE,(i*zoom_amount/100),divide_y-1,0,2);
//	}


	if (max==Envelope::NO_POINT) {

		return;
	}

	// Make sure we draw a continuous line
	if (i>0) {
		prev=get_height_at_pos(i-1,get_height()-bottom_height);
		if (max<(prev-1)) max=prev-1;
		if (min>(prev+1)) min=prev+1;
	}

	max++;	
	get_window()->draw_rectangle(RPGC(GC[Col_ForeGround]),TRUE,i,min,1,(max-min));
	get_window()->draw_rectangle(RPGC(GC[Col_Soft]),TRUE,i,min-1,1,1);
	get_window()->draw_rectangle(RPGC(GC[Col_Soft]),TRUE,i,max,1,1);
	
}

void Envelope_Editor::draw_envelope() {

	int i;
	int tmp_index;

//        window.draw_rectangle(GC[Col_BackGround],TRUE,0,0,width()-1,height()-1);

	if (envelope==NULL) return;

	if ( (old_width!=get_width()) || (old_height!=get_height()) ) need_recalculation=true;


	// normalize positions previously drawn played
	if (!need_recalculation && !redraw_all) {

		for(i=0;i<get_width();i++) {

			if (frames_played[i]) {

				frames_played[i]=0;
				draw_position(i);	
			}
		}
	}

	if (need_recalculation) recalculate();

	//calculate if any of the positions is being played

	/*
	for (i=0;i<player->get_voice_amount_limit();i++) {

         	if ( (tmp_index=player->get_voice_envelope_pos(i,envelope))!=-1 ) {

			int dest;
			dest=tmp_index*zoom_amount/100;

			if ((dest>=0) &&(dest<width())) {

				frames_played[dest]=1;
			}
		}
	}

	*/
	// redraw
	for(i=0;i<get_width();i++) {

		if ((redraw_all) || (frames_played[i])) {

			draw_position(i);	
		}
	}

	draw_points();

	if (redraw_all) {

		char envelope_info_text[100];
		get_window()->draw_rectangle(RPGC(GC[Col_BackGround]),TRUE,0,get_height()-bottom_height,get_width(),bottom_height);
		sprintf(envelope_info_text,"Node %i/%i - Tick %i, Value %i. Zoom: %i%%",grab_point_number+1,envelope->get_node_count(),envelope->get_node_offset(grab_point_number),envelope->get_node_height(grab_point_number),zoom_amount);
//		get_window()->draw_glyphs(RPGC(GC[Col_Loop_BackGround]),RPFONT(font),0,get_height()-3,Pango::GlyphString(envelope_info_text));

	}

	old_width=get_width();
	old_height=get_height();
	redraw_all=false;
}

// widget -> envelope conversion

int Envelope_Editor::get_envelope_pos_x(int p_posx) {

	return p_posx*100/zoom_amount;	
}

int Envelope_Editor::get_envelope_pos_y(int p_posy) {

	int new_y,max;

	max=envelope->get_max_value();

	new_y=p_posy*max/(get_height()-bottom_height);

	new_y=envelope->get_max_value()-new_y;

	return new_y;
}


int Envelope_Editor::get_point_x(int p_node) {

	 return envelope->get_node_offset(p_node)*zoom_amount/100;
}

int Envelope_Editor::get_point_y(int p_node) {

        int heightpos,max;

	heightpos=envelope->get_node_height(p_node);

	max=envelope->get_max_value();

	heightpos=max-heightpos;	

	return heightpos*(get_height()-bottom_height)/max;
}

void Envelope_Editor::draw_points() {

	int i;

	for (i=0;i<envelope->get_node_count();i++) {

		int node_x,node_y;

		node_x=get_point_x(i);
		node_y=get_point_y(i);
		if (i==grab_point_number) {

			get_window()->draw_rectangle(RPGC(GC[Col_Loop_BackGround]),FALSE,node_x-2,node_y-2,5,5);
		}else {

			get_window()->draw_rectangle(RPGC(GC[Col_Loop_ForeGround]),FALSE,node_x-1,node_y-2,3,3);
		}
	}


}
void Envelope_Editor::attempt_node_grab(int p_node_x,int p_node_y) {


        int i;

	grabbing_point=false;

	// check if we can grab an existing node
	for (i=0;i<envelope->get_node_count();i++) {

		int node_x,node_y,dist;
		node_x=get_point_x(i);
		node_y=get_point_y(i);

		dist=(int)sqrt((p_node_x-node_x)*(p_node_x-node_x)+(p_node_y-node_y)*(p_node_y-node_y));

                if (dist<6) {

			grabbing_point=true;
			grab_point_number=i;
			grab_x=node_x;
			grab_y=node_y;
               }

	}
	
	// if not.. let's see if we can create it
	if (!grabbing_point) {

		if ( (i=envelope->add_node_at_offset(get_envelope_pos_x(p_node_x),get_envelope_pos_y(p_node_y)))>=0 ) {

			grabbing_point=true;
			grab_point_number=i;
		}
	}

	redraw_all=true;
	queue_draw();
	changed.emit();


}

gint Envelope_Editor::button_release_event_impl(GdkEventButton* event) {

        zooming=false;
        grabbing_point=false;
	return 0;

}

gint Envelope_Editor::enter_notify_event_impl(GdkEventCrossing* event) {

        zooming=false;
	grabbing_point=false;
	return 0;

}

gint Envelope_Editor::leave_notify_event_impl(GdkEventCrossing* event) {

        zooming=false;
	grabbing_point=false;
	return 0;

}
gint Envelope_Editor::motion_notify_event_impl(GdkEventMotion* event) {

	if (grabbing_point) {


		envelope->set_node_offset(grab_point_number,get_envelope_pos_x(event->x),get_envelope_pos_y(event->y));
		redraw_all=true;
		queue_draw();
		
	}

	if (zooming) {

		int newzoom;

		newzoom=(int)zoom_original+(grab_x-event->x)*10;

		if (newzoom<10) newzoom=10;
		if (newzoom>2000) newzoom=2000;
                zoom_amount=newzoom;
                redraw_all=true;
		need_recalculation=true;
		queue_draw();

	}

	return 1;

}

void Envelope_Editor::start_zoom(int x, int y) {

	zooming=true;
	grab_x=x;
	grab_y=y;
	zoom_original=zoom_amount;
	need_recalculation=true;

}
void Envelope_Editor::delete_selected_node() {

	if (grab_point_number>=0) envelope->delete_node(grab_point_number);
	queue_draw();
	changed.emit();
}


Envelope_Editor::Envelope_Editor(){

	redraw_all=true;
	envelope=NULL;
	frames_played=NULL;
	need_recalculation=true;
	zoom_amount=500;
	grabbing_point=false;
	font_height=0;

     //   font.load("-adobe-courier-bold-r-normal--*-140-*-*-*-*-*-*");
      //  font_height=font.ascent()+font.descent();
	bottom_height=font_height+8;
	signal_expose_event().connect(slot(*this,&Envelope_Editor::do_expose_event));
	signal_realize().connect(slot(*this,&Envelope_Editor::init_colors));
	
}
Envelope_Editor::~Envelope_Editor(){
}
