// Copyright 2015 Canonical Ltd.
// Licensed under the AGPLv3, see LICENCE file for details.

package helptopics

const Logging = `
Juju produces logs for both server and client components. 

The logs generated by client commands such as the 'juju' command can
be viewed by passing --show-log. More detailed logs are emitted if
--debug is passed.

Examples:

  $ juju status --show-log
  2015-11-09 10:37:34 INFO juju.cmd supercommand.go:58 running juju [1.26-al...
  2015-11-09 10:37:34 INFO juju.api api.go:267 connecting to API addresses: ...
  2015-11-09 10:37:34 INFO juju.api apiclient.go:473 dialing "wss://localhos...
  2015-11-09 10:37:34 INFO juju.api apiclient.go:266 connection established ...
  model: local
  machines:
    "0":
      agent-state: started
      agent-version: 1.26-alpha2.1
      dns-name: localhost
      instance-id: localhost
      series: vivid
      controller-member-status: has-vote
    "1":
      agent-state: started
      agent-version: 1.26-alpha2.1
      dns-name: 10.0.3.130
      instance-id: menno-local-machine-1
      series: trusty
      hardware: arch=amd64
  services: {}
  2015-11-09 10:37:34 INFO cmd supercommand.go:450 command finished

  $ juju status --debug
  2015-11-09 10:38:05 INFO juju.cmd supercommand.go:58 running juju [1.26-alp...
  2015-11-09 10:38:05 DEBUG juju.api api.go:155 trying cached API connection ...
  2015-11-09 10:38:05 INFO juju.api api.go:267 connecting to API addresses: [...
  2015-11-09 10:38:05 INFO juju.api apiclient.go:473 dialing "wss://localhost...
  2015-11-09 10:38:05 INFO juju.api apiclient.go:266 connection established t...
  2015-11-09 10:38:05 DEBUG juju.api api.go:484 API hostnames unchanged - not...
  2015-11-09 10:38:05 DEBUG juju.api api.go:514 cacheChangedAPIInfo: serverUU...
  model: local
  machines:
    "0":
      agent-state: started
      agent-version: 1.26-alpha2.1
      dns-name: localhost
      instance-id: localhost
      series: vivid
      controller-member-status: has-vote
    "1":
      agent-state: started
      agent-version: 1.26-alpha2.1
      dns-name: 10.0.3.130
      instance-id: menno-local-machine-1
      series: trusty
      hardware: arch=amd64
  services: {}
  2015-11-09 10:38:05 INFO cmd supercommand.go:450 command finished

The consolidated log for all Juju's server components can be viewed
via the 'juju debug-log' command. Alternatively, individual log files
are generated for each machine or unit agent and stored on the machine
on which they run.

Machine specific logs can be found at /var/log/juju/machine-N.log
where 'N' is the integer machine identifier. For example, the log file
of the bootstrap machine will be found at /var/log/juju/machine-0.log
on machine-0.

Each unit also has it's own log file at /var/log/juju/unit-<unit
name>.log on the machine it runs on. For example, the log file for
a unit called wordpress/1 would be /var/log/juju/unit-wordpress-1.log.

Juju uses a system of hierarchically named logging modules. As a user
you can use this hierarchy to control the logging detail for different
parts of Juju's infrastructure.

Logs from Juju's internal components all use a module name starting
with "juju".  Different areas of Juju use unique, nested names. For
example, providers are under juju.provider, workers are under
juju.worker and database parts are under juju.state

Output from the charm hook execution are emitted using a module name
starting with "unit".  By default, Juju makes sure that this
information is logged out at the DEBUG level but it is possible to
override this for specific units.

All the agents are initially started with logging set to DEBUG. This
means you see all internal Juju logging output until the agent has
finished initialising and the logging system is told to use the
logging setup configured for the model.

You can configure Juju's logging system using a number of different
mechanisms:

environment variable
  - export JUJU_LOGGING_CONFIG='...'
setting the logging-config option at bootstrap time
  - juju bootstrap --logging-config='...'
or setting the logging-config option later
  - juju set-model-config logging-config='...'

The configuration format taken by all these mechanisms is the same:
one or more "module.prefix=LEVEL" items separated by semicolons.

Example:

  juju set-model-config logging-config "juju=WARNING; unit=INFO"

Valid logging levels:
  CRITICAL
  ERROR
  WARNING
  INFO
  DEBUG
  TRACE
`
