#
#    Copyright (C) 2007 Marco Ferragina <marco.ferragina@gmail.com>
#    Copyright (C) 2009 Francesco Marella <francesco.marella@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


class StatusListener:
	"""
	Base class for status changes listner objects
	"""
	def __init__(self, crunner):
		crunner.connect("checker-status-changed", self.on_status_changed)
		crunner.connect("checker-checker-running", self.on_checker_running)
		pass

	def on_status_changed(self, crunner, checker):
		raise NotImplementedError()

	def on_checker_running(self, obj):
		pass #raise NotImplementedError()
