#
#    Copyright (C) 2007 Marco Ferragina <marco.ferragina@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import threading
import os
import subprocess
import gconf
import sys
from email.header import decode_header # mime_decode()
import gtk
import wnck
import xdg.BaseDirectory as bd

CONFIG_HOME = bd.xdg_config_home

(
	GSTPLAY,
	GNOMEPLAY,
	NOENGINE
) = range(3)

try:
	import gnome
	gnome.sound_init("localhost")
	ENGINE = GNOMEPLAY
except ImportError:
	try:
		import gst
		import gobject
		ENGINE = GSTPLAY
	except ImportError:
		ENGINE = NOENGINE

class __GstPlayThread(threading.Thread):
	def __init__(self, ply):
		self.ply = ply
		threading.Thread.__init__(self)
	def run(self):
		self.ply.set_state(gst.STATE_PLAYING)
		def bus_event(bus, message):
			t = message.type
			if t == gst.MESSAGE_EOS:
				self.ply.set_state(gst.STATE_NULL)
			return True
		self.ply.get_bus().add_watch(bus_event)
			

def __gstplay(filename):
	try:
		cwd = os.getcwd()
		location = os.path.join(cwd, filename)
		ply = gst.element_factory_make("playbin", "player")
		ply.set_property("uri", "file://" + location)
		pt = __GstPlayThread(ply)
		pt.start()
	except:
		pass

if ENGINE == GNOMEPLAY:
	def playsnd(filename):
		gnome.sound_play(filename)
elif ENGINE == GSTPLAY:
	playsnd = __gstplay
else:
	def playsnd(filename):
		pass

def get_config_path():	
	config_path = os.path.join(CONFIG_HOME, "cgmail")
	if not os.path.exists(config_path):
		os.makedirs(config_path)
	return config_path
	
def prepend_config_path(filename):
	return os.path.join(get_config_path(), filename)
	
def debug(message):
	print "[DEBUG]: ", message

def log(logdata):
	logfile = prepend_config_path("cgmailservice.log")
	logdata += "\n"
	if not os.path.isfile(logfile):
		logfile = open(logfile, 'w+')
	else:
		logfile = open(logfile, 'a+')
	logfile.write(logdata)
	logfile.close()

def invoke_subprocess(cmdline):
	setsid = getattr(os, 'setsid', None)
	subprocess.Popen(cmdline, close_fds = True, preexec_fn = setsid)

def get_default_mail_reader():
	client = gconf.client_get_default()
	cmd  = client.get_string("/desktop/gnome/url-handlers/mailto/command")
	return cmd.split()[0]

def open_mail_reader():
	cmdline = get_default_mail_reader()
	invoke_subprocess(cmdline)

def open_browser(url):
	"""Open an HTTP URL"""
	try:
		import gnomevfs
		gnomevfs.url_show(url)
		return
	except:
		import webbrowser
		webbrowser.open(url)

def mime_decode(str):
	strn, encoding = decode_header(str)[0]
	if encoding is None:
		return strn
	else:
		return strn.decode(encoding, "replace")
		
def window_is_running(name):
	# screen needs preload
	screen = wnck.screen_get_default()
	screen.get_windows_stacked()
	screen = wnck.screen_get_default()
	for win in screen.get_windows_stacked():
		_name, app = (win.get_name(), win.get_application().get_name())
		if _name == name:
			workspace = win.get_workspace()
			time = gtk.get_current_event_time()
			workspace.activate(time)
			if not win.is_active():
				win.activate(time)
			if win.is_minimized():
				win.unminimize(time)
			break
			
if __name__ == "__main__":
	import gtk
	open_browser("http://google.it")
