import xml.dom
from xml.dom import minidom
import types
import os

from baseaccountmanager import BaseAccountManager, CannotSaveError

class NotTextNodeError: pass

class XMLAccounts(BaseAccountManager):
	def __init__(self):
		
		self.file = os.path.expanduser("~/.config/cgmail/accounts.xml")
		if not os.path.exists(self.file):
			print "No xml config file found! Creating a default one..."
			try:
				os.makedirs(os.path.expanduser("~/.config/cgmail"))
			except OSError:
				pass
			self.xmldoc = self.__create_default()
			self.__save()
			os.chmod(self.file, 0600)
			print "...done"

		try:
			self.xmldoc = minidom.parse(self.file)
		except IOError:
			self.xmldoc = self.__create_default()
			self.__save()

		self.__dic = self.__node_to_dic(self.xmldoc)
	
	def reset(self):
		print "removing", self.file
		try:
			os.unlink(self.file)
		except:
			print "Warnig: can't remove", self.file
	
	def get_accounts_dicts(self):
		if self.__dic["accounts"] == '':
			return None
		else:
			ret = self.__dic["accounts"]["account"]
			# we want to return always a list of dicts
			try:
				if type(ret) == types.DictType:
					list = []
					list.append(ret)
					return list
				else:
					return ret
			except:
				print "Error in XMLAccounts.py at get_accounts_dict"
	
	def remove_account(self, id):
		"""
		remove the account identified by id
		"""
		#print "removing account", id

		nodes = self.xmldoc.firstChild
		for account in nodes.childNodes:
			if account.nodeType != account.ELEMENT_NODE:
				continue
			for param in account.childNodes:
				if param.nodeName == "id":
					value = self.__get_text_from_node(param)
					if value == id:
						parent = param.parentNode # account
						acc = parent.parentNode # accounts
						acc.removeChild(parent)
						param.unlink()
						
						self.__save()

						# reload dic
						self.__dic = self.__node_to_dic(self.xmldoc)

						return
	
	def add_account(self, dic, force_id = None):
		"""
		Add an account to configuration. dic is a dict in form
		of key, values for accounts parameters. This method
		will add automagically an unique identifier to the new
		account
		"""
		
		if force_id != None:
			dic["id"] = force_id
		else:
			dic["id"] = self.__get_next_id()

		#print "adding account", dic

		ac = self.xmldoc.createElement("account")
		
		for key, value in dic.iteritems():
			node = self.xmldoc.createElement(key)
			nodevalue = self.xmldoc.createTextNode(value)
			node.appendChild(nodevalue)
			ac.appendChild(node)

		self.xmldoc.firstChild.appendChild(ac)
		self.__save()

		# reload dic
		self.__dic = self.__node_to_dic(self.xmldoc)

		return dic["id"]
	
	def __get_next_id(self):
		"""
		get an unique id for accounts
		"""

		if self.__dic["accounts"] == '':
			# there are no accounts
			return "1"

		accounts = self.__dic["accounts"].values()[0]
		if type(accounts) == types.DictType:
			# there is only one account
			return str(int(accounts["id"]) + 1)

		# more than one account
		max = 0
		for account in accounts:
			if int(account["id"]) > max:
				max = int(account["id"])
		return str(max + 1)
	
	def __save(self):
		"""
		store the xml file
		"""
		try:
			xfile = open(self.file, "w")
			#self.xmldoc.writexml(xfile, '', '\t', '\n')
			self.xmldoc.writexml(xfile, '', '', '')
			xfile.close()
		except Exception:
			raise CannotSaveError()
	
	def __create_default(self):
		"""
		Create the dafault config file if there isn't one
		"""
		domImp = xml.dom.getDOMImplementation()
		doc = domImp.createDocument("", "accounts", None)
		return doc
		
	def __get_text_from_node(self, node):
		"""
		scans through all children of node and gathers the
		text. if node has non-text child-nodes, then
		NotTextNodeError is raised.
		"""
		t = ""
		for n in node.childNodes:
			if n.nodeType == n.TEXT_NODE:
				t += n.nodeValue
			else:
				raise NotTextNodeError
		return t.strip("\n\t")


	def __node_to_dic(self, node):
		"""
		nodeToDic() scans through the children of node and makes a
		dictionary from the content.
		"""
		dic = {}
		multlist = {} # holds temporary lists where there are multiple children
		multiple = False
		for n in node.childNodes:
			if n.nodeType != n.ELEMENT_NODE:
				continue

			# find out if there are multiple records
			if len(node.getElementsByTagName(n.nodeName)) > 1:
				multiple = True
				# and set up the list to hold the values
				if not multlist.has_key(n.nodeName):
					multlist[n.nodeName] = []

			try:
				#text node
				text = self.__get_text_from_node(n)
			except NotTextNodeError:
				if multiple:
				# append to our list
					multlist[n.nodeName].append(self.__node_to_dic(n))
					dic.update({n.nodeName:multlist[n.nodeName]})
					continue
				else:
		                # 'normal' node
					dic.update({n.nodeName:self.__node_to_dic(n)})
					continue

			# text node
			if multiple:
				multlist[n.nodeName].append(text)
				dic.update({n.nodeName:multlist[n.nodeName]})
			else:
				dic.update({n.nodeName:text})
		return dic
		
		
if __name__ == "__main__":
	x = XMLConfig()
	x.add_account({"username": "redgun", "password": "test", "server": "pop.libero.it"})
