package librpki

import (
	"crypto/rsa"
	"crypto/x509"
	"math/big"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestDecode(t *testing.T) {
	data := `rsync://rpki.apnic.net/repository/apnic-rpki-root-iana-origin.cer

MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAx9RWSL61YAAYumEiU8z8
qH2ETVIL01ilxZlzIL9JYSORMN5Cmtf8V2JblIealSqgOTGjvSjEsiV73s67zYQI
7C/iSOb96uf3/s86NqbxDiFQGN8qG7RNcdgVuUlAidl8WxvLNI8VhqbAB5uSg/Mr
LeSOvXRja041VptAxIhcGzDMvlAJRwkrYK/Mo8P4E2rSQgwqCgae0ebY1CsJ3Cjf
i67C1nw7oXqJJovvXJ4apGmEv8az23OLC6Ki54Ul/E6xk227BFttqFV3YMtKx42H
cCcDVZZy01n7JjzvO8ccaXmHIgR7utnqhBRNNq5Xc5ZhbkrUsNtiJmrZzVlgU6Ou
0wIDAQAB
`

	key := []byte{
		0xC7, 0xD4, 0x56, 0x48, 0xBE, 0xB5,
		0x60, 0x00, 0x18, 0xBA, 0x61, 0x22, 0x53, 0xCC, 0xFC, 0xA8, 0x7D,
		0x84, 0x4D, 0x52, 0x0B, 0xD3, 0x58, 0xA5, 0xC5, 0x99, 0x73, 0x20,
		0xBF, 0x49, 0x61, 0x23, 0x91, 0x30, 0xDE, 0x42, 0x9A, 0xD7, 0xFC,
		0x57, 0x62, 0x5B, 0x94, 0x87, 0x9A, 0x95, 0x2A, 0xA0, 0x39, 0x31,
		0xA3, 0xBD, 0x28, 0xC4, 0xB2, 0x25, 0x7B, 0xDE, 0xCE, 0xBB, 0xCD,
		0x84, 0x08, 0xEC, 0x2F, 0xE2, 0x48, 0xE6, 0xFD, 0xEA, 0xE7, 0xF7,
		0xFE, 0xCF, 0x3A, 0x36, 0xA6, 0xF1, 0x0E, 0x21, 0x50, 0x18, 0xDF,
		0x2A, 0x1B, 0xB4, 0x4D, 0x71, 0xD8, 0x15, 0xB9, 0x49, 0x40, 0x89,
		0xD9, 0x7C, 0x5B, 0x1B, 0xCB, 0x34, 0x8F, 0x15, 0x86, 0xA6, 0xC0,
		0x07, 0x9B, 0x92, 0x83, 0xF3, 0x2B, 0x2D, 0xE4, 0x8E, 0xBD, 0x74,
		0x63, 0x6B, 0x4E, 0x35, 0x56, 0x9B, 0x40, 0xC4, 0x88, 0x5C, 0x1B,
		0x30, 0xCC, 0xBE, 0x50, 0x09, 0x47, 0x09, 0x2B, 0x60, 0xAF, 0xCC,
		0xA3, 0xC3, 0xF8, 0x13, 0x6A, 0xD2, 0x42, 0x0C, 0x2A, 0x0A, 0x06,
		0x9E, 0xD1, 0xE6, 0xD8, 0xD4, 0x2B, 0x09, 0xDC, 0x28, 0xDF, 0x8B,
		0xAE, 0xC2, 0xD6, 0x7C, 0x3B, 0xA1, 0x7A, 0x89, 0x26, 0x8B, 0xEF,
		0x5C, 0x9E, 0x1A, 0xA4, 0x69, 0x84, 0xBF, 0xC6, 0xB3, 0xDB, 0x73,
		0x8B, 0x0B, 0xA2, 0xA2, 0xE7, 0x85, 0x25, 0xFC, 0x4E, 0xB1, 0x93,
		0x6D, 0xBB, 0x04, 0x5B, 0x6D, 0xA8, 0x55, 0x77, 0x60, 0xCB, 0x4A,
		0xC7, 0x8D, 0x87, 0x70, 0x27, 0x03, 0x55, 0x96, 0x72, 0xD3, 0x59,
		0xFB, 0x26, 0x3C, 0xEF, 0x3B, 0xC7, 0x1C, 0x69, 0x79, 0x87, 0x22,
		0x04, 0x7B, 0xBA, 0xD9, 0xEA, 0x84, 0x14, 0x4D, 0x36, 0xAE, 0x57,
		0x73, 0x96, 0x61, 0x6E, 0x4A, 0xD4, 0xB0, 0xDB, 0x62, 0x26, 0x6A,
		0xD9, 0xCD, 0x59, 0x60, 0x53, 0xA3, 0xAE, 0xD3,
	}
	bigint := big.NewInt(0)
	bigint.SetBytes(key)

	tal, err := DecodeTAL([]byte(data))
	assert.Nil(t, err)
	assert.Equal(t, tal.PublicKey.(*rsa.PublicKey).E, 65537)

	cert := &x509.Certificate{
		PublicKeyAlgorithm: x509.RSA,
		PublicKey: &rsa.PublicKey{
			E: 65537,
			N: bigint,
		},
	}
	assert.Equal(t, tal.CheckCertificate(cert), true)
}
