#-clisp
(require "asdf")
#+clisp
(load #p"/usr/share/common-lisp/source/cl-asdf/asdf.lisp")

(let ((tmpdir (uiop:getenv "AUTOPKGTEST_TMP")))
  ;; Store FASL in some temporary dir
  (asdf:clear-output-translations)
  (setq asdf:*user-cache* tmpdir)
  (asdf:initialize-output-translations)

  ;; Compile test libs in temporary directory, see cffi-tests.patch
  (setq *default-pathname-defaults* (parse-namestring (concatenate 'string tmpdir "/"))))

#-ecl
(require "cffi-tests")
#+ecl
(asdf:load-system "cffi-tests")

(asdf:test-system "cffi-tests")
