//
// os/x11/keycodes.h: X11 keycode definitions.
//
// CEN64: Cycle-Accurate Nintendo 64 Emulator.
// Copyright (C) 2015, Tyler J. Stachecki.
//
// This file is subject to the terms and conditions defined in
// 'LICENSE', which is part of this source code package.
//

#ifndef CEN64_OS_X11_KEYCODES
#define CEN64_OS_X11_KEYCODES
#include <X11/keysym.h>

// Letter keys.
#define CEN64_KEY_A XK_a
#define CEN64_KEY_B XK_b
#define CEN64_KEY_C XK_c
#define CEN64_KEY_D XK_d
#define CEN64_KEY_E XK_e
#define CEN64_KEY_F XK_f
#define CEN64_KEY_G XK_g
#define CEN64_KEY_H XK_h
#define CEN64_KEY_I XK_i
#define CEN64_KEY_J XK_j
#define CEN64_KEY_K XK_k
#define CEN64_KEY_L XK_l
#define CEN64_KEY_M XK_m
#define CEN64_KEY_N XK_n
#define CEN64_KEY_O XK_o
#define CEN64_KEY_P XK_p
#define CEN64_KEY_Q XK_q
#define CEN64_KEY_R XK_r
#define CEN64_KEY_S XK_s
#define CEN64_KEY_T XK_t
#define CEN64_KEY_U XK_u
#define CEN64_KEY_V XK_v
#define CEN64_KEY_W XK_w
#define CEN64_KEY_X XK_x
#define CEN64_KEY_Y XK_y
#define CEN64_KEY_Z XK_z

// Number keys.
#define CEN64_KEY_0 XK_0
#define CEN64_KEY_1 XK_1
#define CEN64_KEY_2 XK_2
#define CEN64_KEY_3 XK_3
#define CEN64_KEY_4 XK_4
#define CEN64_KEY_5 XK_5
#define CEN64_KEY_6 XK_6
#define CEN64_KEY_7 XK_7
#define CEN64_KEY_8 XK_8
#define CEN64_KEY_9 XK_9

// Directional keys.
#define CEN64_KEY_LEFT XK_Left
#define CEN64_KEY_UP XK_Up
#define CEN64_KEY_RIGHT XK_Right
#define CEN64_KEY_DOWN XK_Down

// Other keys.
#define CEN64_KEY_BSLASH XK_backslash
#define CEN64_KEY_COMMA XK_comma
#define CEN64_KEY_EQUALS XK_equal
#define CEN64_KEY_FSLASH XK_fslash
#define CEN64_KEY_MINUS XK_minus
#define CEN64_KEY_LALT XK_Alt_L
#define CEN64_KEY_LBRACKET XK_bracketleft
#define CEN64_KEY_LCTRL XK_Control_L
#define CEN64_KEY_LSHIFT XK_Shift_L
#define CEN64_KEY_LSUPER XK_Super_L
#define CEN64_KEY_PERIOD XK_period
#define CEN64_KEY_RALT XK_Alt_R
#define CEN64_KEY_RBRACKET XK_bracketright
#define CEN64_KEY_RCTRL XK_Control_R
#define CEN64_KEY_RETURN XK_Return
#define CEN64_KEY_RSHIFT XK_Shift_R
#define CEN64_KEY_RSUPER XK_Super_R
#define CEN64_KEY_SEMICOLON XK_semicolon
#define CEN64_KEY_SLASH XK_slash
#define CEN64_KEY_SPACE XK_space

#endif

