#
# 	UNIX-SPECIFIC BINDINGS
# 	(c) 1997 Alexandre Burton
# 	v1.80a (10/08/97)
#


proc bindtools2 {t} {
    bind $t.f3.drunks <Button-3> makedrunksBox
    bind $t.f3.square <Button-3> makesawBox
    bind $t.f3.rand   <Button-3> makerandBox
    bind $t.f3.sines  <Button-3> makesinesBox
    bind $t.f3.scatt  <Button-3> makescattBox
    bind $t.f1.normal <Button-3> makenormBox
    bind $t.f1.comp	  <Button-3> makecompBox
}

proc bindtools {t} {
    bind $t.f3.drunks <Button-3> makedrunksBox
    bind $t.f3.square <Button-3> makesawBox
    bind $t.f3.rand   <Button-3> makerandBox
    bind $t.f3.sines  <Button-3> makesinesBox
    bind $t.f3.scatt  <Button-3> makescattBox
    bind $t.f5.normal <Button-3> makenormBox
    bind $t.f5.comp	  <Button-3> makecompBox

    bind .pre <Control-c> gcopie
    bind .pre <Control-x> gcut
    bind .pre <Control-v> gpaste
    bind .pre <Control-z> gclear

}

#-sb- bindings modified for Linux, as Alt-cmd didn't work
# version 2.0.4

proc bindedit {} {
    global killbutt fillbutt tags path prefs
    bind .edit <semicolon> "checkcomment"
    bind .edit  <Control-z> "catch { chooseText }       ; break"
    bind .edit  <Control-c> "catch { Tcopie}  ; break"
    bind .edit  <Control-v> "catch { Tpaste }           ; break"
    bind .edit  <Control-x> "catch { Tcut }             ; break"
    bind .edit  <Control-o> "catch { openModule }       ; break"
    bind .edit  <Control-s> "catch { saveModule }       ; break"
    bind .edit  <Control-a> "catch { doSelectAll }      ; break"
    bind .edit  <Control-g> "catch { goTo }		; break"
    bind .edit  <Control-f> "catch { selSearch f }      ; break"
    bind .edit  <Control-b> "catch { selSearch b }      ; break"
    bind .edit  <Control-r> "catch { getReplaceName }   ; break"
    bind .edit  <Control-u> "catch { helpOpcode }       ; break"
    bind .edit  <Help> "catch { helpOpcode }       ; break"
    bind .edit  <Control-semicolon> "catch { doComments }      ; break"
#    bind .edit  <Alt-y> "doInsert                   ; break"
    bind .edit  <Control-equal> "catch {power u}        ; break"
    bind .edit  <Control-minus> "catch {power d}        ; break"
    bind .edit  <Control-l> "catch {colorit}            ; break"
    bind .edit  <Control-e> ".menubar.wind invoke 0     ; break"
    bind .edit  <Control-w> "catch {hideCurrent}        ; break"
    bind .edit  <Control-d> "cyclePanel                 ; break"
    bind .edit  <Control-m> "gimmePlace                 ; break"
    bind .edit  <Control-p> "hideAll                    ; break"
    bind .edit  <Control-t> "prettyprint                ; break"
    bind .edit  <Control-End> {$path(edit).menu.section invoke 1}
    bind .edit  <Control-Down> {$path(edit).menu.section invoke 2}
    bind .edit  <Control-Next> {$path(edit).menu.section invoke 3}
    bind .edit  <Control-Left> {$path(edit).menu.section invoke 4}
    bind .edit  <Control-Begin> {$path(edit).menu.section invoke 5}
    bind .edit  <Control-Right> {$path(edit).menu.section invoke 6}
    bind .edit  <Control-Home> {$path(edit).menu.section invoke 7}
    bind .edit  <Control-Up> {$path(edit).menu.section invoke 8}
    bind .edit  <Control-Prior> {$path(edit).menu.section invoke 9}

    bind .pre <Down> "focusGraph 1"
    bind .pre <Up> "focusGraph -1"

    bind .edit  <ButtonRelease-1> "catch {mcopie}"
    bind .edit  <Double-Button-2> "catch {mpaste} ; break"

    foreach pane {tk_interface mono stereo quad score} {
#	bind .edit.panel.$pane.t  <ButtonRelease-3> "doInsert"
    }
    

    bind .edit <$prefs(skey)> "$path(trans).bStop invoke"
    bind .edit <$prefs(pkey)> "$path(trans).bPlay invoke"
    bind .edit <$prefs(ikey)> "$path(trans).bPause invoke"

    bind .edit <Control-q> "wm withdraw .edit; break"
    bind .edit <Control-n> {checkIt 1 ; break}
    bind .edit <Control-i> "catch {reInit} ; break"

}

proc bindsoundwin {utik} {
    global path prefs
    bind . <Control-g> "$utik invoke 3"
    bind . <Control-n> {checkIt 1}
    bind . <Control-t> "$utik invoke 4"
    bind . <Control-s> "saveGraph"
    bind . <Control-q> "quitte"
    bind . <Control-o> "openModule"
    bind . <Control-r> "$utik invoke 1"
    bind . <Control-i> {parseModule $module(path)}
    bind . <Control-e> "$utik invoke 0"

    bind . <Control-y> updateNewMenu
    bind . <Shift-Control-m> ".menubar.option invoke 4"    
    bind . <Shift-Control-g> ".menubar.option invoke 5"    
    bind . <Shift-Control-a> ".menubar.option invoke 6"    
    bind . <Shift-Control-t> ".menubar.option invoke 8"    
    bind . <Shift-Control-p> ".menubar.option invoke 17"    
    bind . <Shift-Control-r> ".menubar.option invoke 18"  
    
    bind . <$prefs(skey)> "$path(trans).bStop invoke"
    bind . <$prefs(pkey)> "$path(trans).bPlay invoke"
    bind . <$prefs(ikey)> "$path(trans).bPause invoke"
    
}

proc bindsound {} {
global prefs path
    bind . <$prefs(skey)> "$path(trans).bStop invoke"
    bind . <$prefs(pkey)> "$path(trans).bPlay invoke"
    bind . <$prefs(ikey)> "$path(trans).bPause invoke"
    
}

proc bindgraph {} {
	global path prefs

	$path(area)  bind point <Command-Button-1> "selectKill ; break"
    	$path(area)  bind point <Command-ButtonRelease-1> "killPoint %x %y ; break"
    	$path(area)  bind point <Button-2> "selectKill  ; break"
    	$path(area)  bind point <ButtonRelease-2> "killPoint %x %y ; break"

        bind .pre <$prefs(skey)> "$path(trans).bStop invoke"
        bind .pre <$prefs(pkey)> "$path(trans).bPlay invoke"
        bind .pre <$prefs(ikey)> "$path(trans).bPause invoke"

  	bind .pre <Control-s> saveGraph
    	bind .pre <Control-o> openModule
    	bind .pre <Control-q> quitte
    	bind .pre <Control-e> ".menubar.wind invoke 0"
    	bind .pre <Control-n> {checkIt 1}
    	bind .pre <Control-i> "catch {reInit}"
	bind .pre <Control-Up> "nodge actif -1"
	bind .pre <Control-Down> "nodge actif 1"
	bind .pre <Shift-Control-Up> "nodge actif -10"
	bind .pre <Shift-Control-Down> "nodge actif 10"
	bind .pre <Down> "focusGraph 1"
    bind .pre <Up> "focusGraph -1"

}


proc bindvslide {} {
	global path prefs
    bind .vslide <$prefs(skey)> "$path(trans).bStop invoke"
    bind .vslide <$prefs(pkey)> "$path(trans).bPlay invoke"
    bind .vslide <$prefs(ikey)> "$path(trans).bPause invoke"
}

proc bindtoo {} {
	global path prefs

    bind .win <Down> "focusGraph 1"
    bind .win <Up> "focusGraph -1"
    bind .win <$prefs(skey)> "$path(trans).bStop invoke"
    bind .win <$prefs(pkey)> "$path(trans).bPlay invoke"
    bind .win <$prefs(ikey)> "$path(trans).bPause invoke"

}
