#
# 	Construction et gestion des panels d'edition
# 	(c) 1996-7 Jean Piche
# 	v. 1.80a (10/08/97)
#

proc maketwinFrame {where} {
    global path ffont color tags id outtags prefs tcl_platform
    pack [frame $where -background black] -expand 1 -fill both
    foreach pane [concat $tags $outtags] {    	
	
	modebug "building editwindow:" "pane ($pane)"

	frame $where.$pane -height 1000 -relief groove -bd 1
	frame $where.hand$pane -borderwidth 1 -relief raised \
		-cursor sb_v_double_arrow
	
	if {$pane == "tk_interface"} {set myname interface} {set myname $pane}
	pack [label $where.hand$pane.l -width 8 -bg \#4169e1  -text $myname]
	
	pack [text $where.$pane.t -tabs $prefs(tabs) -yscrollcommand "$where.$pane.scrollysco set" \
		-width 50 -height 10 -highlightthickness 0 -bg gray95 -state normal\
		-selectforeground gray50] \
		-fill both -expand 1
	  
	scrollbar $where.$pane.scrollysco -command "$where.$pane.t yview" -highlightthickness 0 
	pack $where.$pane.scrollysco -before $where.$pane.t -side right -fill y 
	
	$path(edit).menu.section add check -variable toggleState($pane) \
		-label $pane -command "toggleWin2 $path(panel).$pane" 
	
	pack [checkbutton .edit.top.$pane -text $pane\
		-indicatoron 0 -justify center -anchor center\
		-variable toggleState($pane)\
		-command "toggleWin2 $path(panel).$pane" -width 8 -anchor w] \
		-side left -fill x -expand 1 -anchor n
	

	bindHelp .edit.top.$pane 	bEditSelect
	bindHelp $where.$pane.t 	bEditView
	bindHelp $where.hand$pane.l  	bEditHandle
    }

    foreach pane {mono stereo quad} {
	bind $where.$pane.t <Button-1> "+selectThisPane $pane"
	bind $where.$pane.t <Tab> "checkLastWord"
	bind $where.$pane.t <space> "checkLastWord"
	bind $where.$pane.t <Return> "checkLastWord"
	#		bindtags $where.$pane.t "$where.$pane.t $where.$pane Text all"
    }	
    foreach pane $tags {
	set id($pane) [new textUndoer $path(panel).$pane.t]
	bindHelp $where.$pane.t bEditEdit
    }  
    
    foreach pane $outtags {
	$where.$pane.t config -bg gray80 -state disabled
    }
    
    doFont
	makeInsertPopups $where
}

proc makeInsertPopups {where} {
    global pp opsDatabase path tcl_platform
    array set inserterTk {
	{Filein}		{
	    {standard filein} {cfilein name -label <string>}
	    {MIDI filein}     {cfilein name -label <string> -type MIDI}
	}
	{Sliders} {
	    {slider options} 	{cslider name -label <string> -rate <i|k> -unit <string> -orient <h|v> -res <float> -rel <lin|log> -min <float> -max <float> -init <float> -color <\#RGB|Xcolor> -width <pixels>}
	    {slider1}	 	{cslider data1 -res .01 -min 0 -max 1 -init .5}
	    {slider10}	 	{cslider data10 -res .1 -min 0 -max 10 -init 5}
	    {slider100} 		{cslider data100 -res .1 -min 0 -max 100 -init 50}
	    {slider1000}        	{cslider data1000 -res .1 -min 0 -max 1000 -init 500}
	    {sliderFreq}        	{cslider frequency -rel log -res .01 -min 10 -max 10000 -init 500}
	    {sliderdB}          	{cslider ampdb -rel log  -res .1 -min 30 -max 80 -init 60}
	    {slider total_time} 	{cslider total_time  -unit s -ori h -min 1 -res .01 -max 300 -init 30}
	    {midi_slider}   	{cmidi name event channel  min max <init>}
	}
	{Graphs}	   {
	    {graph options}    {cgraph name -label <string> -unit <string> -rel <lin|log> -min <float> -max <float> -gen <int> -size <^2> -init <float> -func <list>}
	    {graph freq}       {cgraph freq -unit Hz -rel lo -min 20 -max  15000 -init 500}
	    {graph ampdb}      {cgraph amp -unit db -rel lo -min 30  -max 90  -init 65 }
	    {graph envelope}   {cgraph env -unit x -rel lin  -min 0 -max 1 -func \"0 0 .1 1 .2 .7 .8 .7 1 0 \" }
	}
	{Toggle}	{
	    {standard toggle} {ctoggle name -label <string> -init <0|1>}
	}
	{Popup}	    	{
	    {standard popup} {cpopup name -label <string> -value <string> \"<string2> <string3> ...\"}
	}
	{Separator}	{
	    {standard separator} {csepar -label <string>}
	}
    }
    
    destroy	$path(panel).tk_interface.t.menutk 
    destroy	$path(panel).mono.t.menumono 
    destroy	$path(panel).stereo.t.menustereo
    destroy	$path(panel).quad.t.menuquad 
    destroy	$path(panel).score.t.menuscore 
    
    set pp(tk)     [createContextMenu $where.tk_interface.t tk]
    set pp(mono)   [createContextMenu $where.mono.t mono]
    set pp(stereo) [createContextMenu $where.stereo.t stereo]
    set pp(quad)   [createContextMenu $where.quad.t quad]
    set pp(score)  [createContextMenu $where.score.t score]
    
    set i 0
    set licat ""
    
    foreach item [lsort -integer [array names opsDatabase]] {
	set cat [lindex [split [lindex $opsDatabase($item) 3] "/"] 0]
	if {[lsearch $licat $cat] == "-1"} {lappend licat $cat}
    }
    
    foreach cate $licat {
	if {$cate != "Function"} {
	    if {$tcl_platform(platform) == "macintosh"} {
		$pp(mono) add cascade -label $cate  -menu [set me [menu $pp(mono).[string tolower $cate] -tearoff 0]]		
		foreach pane {stereo quad} {$pp($pane) add cascade -label $cate -menu $me}
	    } {
		foreach pane {mono stereo quad} {
		    $pp($pane) add cascade -label $cate  -menu [menu $pp($pane).[string tolower $cate] -tearoff 0]		
		}
	    }
	}
    }
    
    foreach men [lsort -integer [array names opsDatabase]] {
	set cat [lindex [split [lindex $opsDatabase($men) 3] "/"] 0]
	set scat [string tolower $cat]
	set adress [lindex [split [lindex $opsDatabase($men) 3] "/"] 1]
	set name [lindex $opsDatabase($men) 0]
	set res \{[lindex $opsDatabase($men) 1]\}
	set syn \{[lindex $opsDatabase($men) 2]\}
	set sub [lindex $opsDatabase($men) 4]
	if {$cat == "Function"} {set line "sco $res $name $syn"} { set line "orc $res $name $syn"}
	if {$sub == "-"} {
	    if {$cat == "Function"} {
		$pp(score) add command -label "$res $name" -command "doPutItem  $line"
	    } { 
		$pp(mono).$scat add command -label "$res $name" -command "doPutItem  $line"
		if  {$tcl_platform(platform) != "macintosh"} {
		    foreach pane {stereo quad} {
			$pp($pane).$scat add command -label "$res $name" -command "doPutItem  $line"		    
		    }
		}
	    }
	} else {
	    if  {$tcl_platform(platform) == "macintosh"} {
		if ![winfo exists $pp(mono).$scat.$sub] {
		    set m [menu $pp(mono).$scat.$sub  -tearoff 0]
		    $pp(mono).$scat add cascade -label $sub -menu $m
		}
		$pp(mono).$scat.$sub add command -label "$res $name" -command "doPutItem  $line"
		
		
	    } else {
		foreach pane {mono stereo quad} {
		    if ![winfo exists $pp($pane).$scat.$sub] {
			set m($pane) [menu $pp($pane).$scat.$sub  -tearoff 0]
			$pp($pane).$scat add cascade -label $sub -menu $m($pane)		    
		    }
		}
		foreach pane {mono stereo quad} {
		    $pp($pane).$scat.$sub add command -label "$res $name" -command "doPutItem  $line"		    
		}
	    }
	}
    }
    
    foreach int [array names inserterTk] {
	$pp(tk) add cascade -label $int -menu [set me [menu $pp(tk).[string tolower $int] -tearoff 0]]
	catch {unset temp}
	array set temp $inserterTk($int)
	foreach out [array names temp] {
	    set line "interf $temp($out)"
	    $me add command -label $out -command "doPutItem  $line"
	}
    }
}

proc selectThisPane {pane} {
    global path
    bug selecting this pane: $pane
    foreach p {mono stereo quad} {$path(panel).$p.t config -bd 2}
    $path(panel).$pane.t config -bd 3
    $path(winOut).rates.nchnls.$pane invoke
}

proc gimmePlace {which} {
    global panelist path color soloList
    set which [string range [lindex [split $which .] 3] 4 end]
    if {[$path(panel).hand$which.l cget -bg] == "forestgreen"} {
	$path(panel).hand$which.l config  -bg \#4169e1
	foreach item [array names soloList] {
	    set prelist  [lreplace $soloList($item) 8 9]
	    set prelist  [lreplace $prelist 10 11]
	    for {set i 1} {$i < [llength $prelist]} {set i [expr $i + 2]} {
		set a$i [lindex $prelist $i]
	    }  
	    place configure $path(panel).$item -x $a1 -relx $a3 -y $a5 -rely $a7 -relwidth $a9 -relheight $a11 -anchor $a13
	}
	for {set i 0} {$i < 9} {incr i} {
	    $path(edit).menu.section entryconfigure $i -state normal
	}	
    } else {
	$path(panel).hand$which.l config -bg forestgreen
	catch {unset soloList}
	foreach item $panelist {
	    set soloList($item) [place info $path(panel).$item]
	    set soloList(hand$item) [place info $path(panel).hand$item]
	    place forget $path(panel).$item
	    place forget $path(panel).hand$item
	}
	place $path(panel).$which -x 0 -relx 0 -y 0 -rely 0 -width {} -relwidth 1 -height {} -relheight 1 -anchor nw 
	place $path(panel).hand$which  -y 1     -relx .97 -anchor e
	for {set i 0} {$i < 9} {incr i} {
	    $path(edit).menu.section entryconfigure $i -state disabled
	}
    }
}


proc Place {fract which} {
    global H1 Y1 path panelist
    set next [string range [lindex [split $which .] 3] 4 end]
    set prev [lindex $panelist [expr [lsearch $panelist $next] - 1 ]]
    set tot [expr  ([winfo y $path(panel).$next] + [winfo height $path(panel).$next])/$H1.0]
    set tot [expr round($tot*100.0)/100.0]
    set top [expr $fract - ([winfo y $path(panel).$prev]/$H1.0)] 
    place $path(panel).$prev -relheight $top 
    set off [expr 1.0 * ([winfo height .edit.panel.handmono] / 2) / [winfo height .edit.panel] ]
    place $path(panel).hand${next} -rely [expr 1.0 * $fract+$off]
    place $path(panel).$next -relheight [expr $tot-$fract]  -rely $fract -anchor nw 
}

proc Placer {} {
    
    global path panelist
    foreach item $panelist {
	place forget $path(panel).$item
	place forget $path(panel).hand$item
    }
    orderPanelist
    
    set a 0
    
    # 1/nombre de panels
    set heit [expr 1.0 / [llength $panelist].0]
    
    set off [expr 1.0 * ([winfo height .edit.panel.handmono] / 2) / [winfo height .edit.panel] ]
    
    
    foreach pan $panelist {
		place $path(panel).$pan -relheight $heit  -rely [expr $heit*$a.0]   -anchor nw -relwidth 1
#		update
		place $path(panel).hand$pan  -rely [expr ($heit*$a.0)+$off]     -relx .97 -anchor e
#		place $path(panel).hand$pan  -y [winfo y .edit.panel.$pan]     -relx .97 -anchor e
		bind $path(panel).hand$pan.l <ButtonRelease-1> {
			place forget $path(panel).mire;Place [expr [winfo y $path(panel).mire]/$H1.0] %W }
		bind $path(panel).hand$pan.l <B1-Motion> {Draw [expr (%Y-$Y1)] %W}
		bind $path(panel).hand$pan.l <Button-1> {paneDown %Y  %W }
		bind $path(panel).hand$pan.l <ButtonRelease-2> {deletePane %W }
		bind $path(panel).hand$pan.l <ButtonRelease-3> {gimmePlace %W}
		incr a
    }
    place $path(panel).hand[lindex $panelist 0]  -y 1     -relx .97 -anchor e
    bind $path(panel).hand[lindex $panelist 0].l <ButtonRelease-1> {}
    bind $path(panel).hand[lindex $panelist 0].l <B1-Motion> {}
    bind $path(panel).hand[lindex $panelist 0].l <Button-1> {}
}

proc reconf {} {
    global H1 Y1 path
    set H1 [winfo height $path(panel)]
    set Y1 [winfo rooty $path(panel)]
}

proc Draw {val which} {
    global panelist prev H1 path tags outtags
    set which [string range [lindex [split $which .] 3] 4 end]
    set prev [lindex $panelist [expr [lsearch $panelist $which]-1]]
    set next [lindex $panelist [expr [lsearch $panelist $which]+1]]
    if {[lsearch $panelist $which] == 1} { 
		     set posup [expr [winfo y $path(panel).$prev] +42]
	} else { set posup [expr [winfo y $path(panel).$prev] +22 ] }
	
    if {[lsearch $panelist $which] == [expr [llength $panelist] - 1]} { 
		     set posdown [expr [winfo y $path(panel).$which]+[winfo height $path(panel).$which] -27]
	} else { set posdown [expr [winfo y $path(panel).$next] -22 ] }
	
    if {$val >= $posup && $val <= $posdown } {
		place $path(panel).mire -rely [expr $val/$H1.0] -relwidth 1
		set prev [expr $val/$H1.0]
    } 
}

proc paneDown {where which} {
    global H1 Y1 path panelist
    set H1 [winfo height $path(panel)]
    set Y1 [winfo rooty $path(panel)]
    place $path(panel).mire -rely [expr ($where-$Y1)/$H1.0] -relwidth 1
    set prev [expr (($where-$Y1)/$H1.0) ]
    Draw [expr ($where-$Y1)] $which
}


proc deletePane {which} {
    global panelist path toggleState
	if {[llength $panelist] == 1} {
	bell
	set toggleState($which) 1
	return
	}
    set which [string range [lindex [split $which .] 3] 4 end]
    place forget $path(panel).$which
    place forget $path(panel).hand$which
    set panelist [lreplace $panelist [lsearch $panelist $which] [lsearch $panelist $which] ]
    set toggleState($which) 0
    Placer 
}

proc orderPanelist {} {
    global panelist tags outtags
    set i 0
    foreach pane {info tk_interface mono stereo quad score orcOut scoreOut csoundOut} {
	set order($pane) $i
     incr i
    }
   foreach item $panelist {
	lappend sorted $order($item) 
    }
    foreach tag [lsort $sorted] {
	lappend panesorted [lindex [concat $tags $outtags] $tag]
    }
    set panelist $panesorted
}

