//
// TypeReferenceCollection.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Thu Jan 26 11:25:58 CET 2006
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil {

	using System;
	using System.Collections;
	using System.Collections.Specialized;

	using Mono.Cecil.Cil;

	using Hcp = Mono.Cecil.HashCodeProvider;
	using Cmp = System.Collections.Comparer;

	public sealed class TypeReferenceCollection : NameObjectCollectionBase, ITypeReferenceCollection {

		ModuleDefinition m_container;

		public event TypeReferenceEventHandler OnTypeReferenceAdded;
		public event TypeReferenceEventHandler OnTypeReferenceRemoved;
	
		public TypeReference this [int index] {
			get { return this.BaseGet (index) as TypeReference; }
			set { this.BaseSet (index, value); }
		}

		public TypeReference this [string fullName] {
			get { return this.BaseGet (fullName) as TypeReference; }
			set { this.BaseSet (fullName, value); }
		}

		public ModuleDefinition Container {
			get { return m_container; }
		}

		public bool IsSynchronized {
			get { return (this as ICollection).IsSynchronized; }
		}

		public object SyncRoot {
			get { return (this as ICollection).SyncRoot; }
		}

		public TypeReferenceCollection (ModuleDefinition container) :
			base (Hcp.Instance, Cmp.Default)
		{
			m_container = container;
		}

		public void Add (TypeReference value)
		{
			if (value == null)
				throw new ArgumentNullException ("value");

			if (OnTypeReferenceAdded != null)
				OnTypeReferenceAdded (this, new TypeReferenceEventArgs (value));

			this.BaseSet (value.FullName, value);
		}

		public void Clear ()
		{
			if (OnTypeReferenceRemoved != null)
				foreach (TypeReference item in this)
					OnTypeReferenceRemoved (this, new TypeReferenceEventArgs (item));
			this.BaseClear ();
		}

		public bool Contains (TypeReference value)
		{
			return Contains (value.FullName);
		}

		public bool Contains (string fullName)
		{
			return this.BaseGet (fullName) != null;
		}

		public int IndexOf (TypeReference value)
		{
			string [] keys = this.BaseGetAllKeys ();
			return Array.IndexOf (keys, value.FullName, 0, keys.Length);
		}

		public void Remove (TypeReference value)
		{
			if (OnTypeReferenceRemoved != null && this.Contains (value))
				OnTypeReferenceRemoved (this, new TypeReferenceEventArgs (value));
			this.BaseRemove (value.FullName);
		}

		public void RemoveAt (int index)
		{
			if (OnTypeReferenceRemoved != null)
				OnTypeReferenceRemoved (this, new TypeReferenceEventArgs (this [index]));
			this.BaseRemoveAt (index);
		}

		public void CopyTo (Array ary, int index)
		{
			(this as ICollection).CopyTo (ary, index);
		}

		public new IEnumerator GetEnumerator ()
		{
			return this.BaseGetAllValues ().GetEnumerator ();
		}

		public void Accept (IReflectionVisitor visitor)
		{
			visitor.VisitTypeReferenceCollection (this);
		}

#if CF_1_0
		internal object [] BaseGetAllValues ()
		{ 
			object [] values = new object [this.Count];
			for (int i=0; i < values.Length; ++i) {
				values [i] = this.BaseGet (i); 
			}
			return values;
		}
#endif
	}
}
