//
// FieldDefinitionCollection.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Thu Sep 29 23:20:03 CEST 2005
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil {

	using System;
	using System.Collections;

	using Mono.Cecil.Cil;

	public sealed class FieldDefinitionCollection : IFieldDefinitionCollection {

		IList m_items;
		TypeDefinition m_container;

		public event FieldDefinitionEventHandler OnFieldDefinitionAdded;
		public event FieldDefinitionEventHandler OnFieldDefinitionRemoved;

		public FieldDefinition this [int index] {
			get { return m_items [index] as FieldDefinition; }
			set { m_items [index] = value; }
		}

		public TypeDefinition Container {
			get { return m_container; }
		}

		public int Count {
			get { return m_items.Count; }
		}

		public bool IsSynchronized {
			get { return false; }
		}

		public object SyncRoot {
			get { return this; }
		}

		public FieldDefinitionCollection (TypeDefinition container)
		{
			m_container = container;
			m_items = new ArrayList ();
		}

		public void Add (FieldDefinition value)
		{
			if (OnFieldDefinitionAdded != null && !this.Contains (value))
				OnFieldDefinitionAdded (this, new FieldDefinitionEventArgs (value));
			m_items.Add (value);
		}

		public void Clear ()
		{
			if (OnFieldDefinitionRemoved != null)
				foreach (FieldDefinition item in this)
					OnFieldDefinitionRemoved (this, new FieldDefinitionEventArgs (item));
			m_items.Clear ();
		}

		public bool Contains (FieldDefinition value)
		{
			return m_items.Contains (value);
		}

		public int IndexOf (FieldDefinition value)
		{
			return m_items.IndexOf (value);
		}

		public void Insert (int index, FieldDefinition value)
		{
			if (OnFieldDefinitionAdded != null && !this.Contains (value))
				OnFieldDefinitionAdded (this, new FieldDefinitionEventArgs (value));
			m_items.Insert (index, value);
		}

		public void Remove (FieldDefinition value)
		{
			if (OnFieldDefinitionRemoved != null && this.Contains (value))
				OnFieldDefinitionRemoved (this, new FieldDefinitionEventArgs (value));
			m_items.Remove (value);
		}

		public void RemoveAt (int index)
		{
			if (OnFieldDefinitionRemoved != null)
				OnFieldDefinitionRemoved (this, new FieldDefinitionEventArgs (this [index]));
			m_items.Remove (index);
		}

		public void CopyTo (Array ary, int index)
		{
			m_items.CopyTo (ary, index);
		}

		public IEnumerator GetEnumerator ()
		{
			return m_items.GetEnumerator ();
		}

		public FieldDefinition GetField (string name)
		{
			foreach (FieldDefinition field in this)
				if (field.Name == name)
					return field;

			return null;
		}

		public void Accept (IReflectionVisitor visitor)
		{
			visitor.VisitFieldDefinitionCollection (this);
		}
	}
}
