/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2011 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

#include "cdw_task.h"
#include "gettext.h"
#include "cdw_string.h"
#include "cdw_main_window.h"
#include "cdw_widgets.h"
#include "cdw_debug.h"
#include "cdw_cdrecord_options.h"
#include "cdw_ext_tools.h"


static cdw_task_t *local_task = (cdw_task_t *) NULL;

enum {
	f_cdrecord_pad_cb,
	f_cdrecord_pad_l,

	f_cdrecord_pad_size_l,
	f_cdrecord_pad_size_i,
	f_cdrecord_pad_size_xl,

	f_cdrecord_burnproof_cb,
	f_cdrecord_burnproof_l,
	f_cdrecord_other_l,
	f_cdrecord_other_i };


static FIELD *page_cdrecord_fields[CDW_CDRECORD_OPTIONS_N_FIELDS + 1]; /* +1 for last field == NULL */


cdw_rv_t cdw_cdrecord_options_form(cdw_form_t *cdw_form, void *cdw_task, int first_col, int second_col, int width_wide, __attribute__((unused)) int width_narrow)
{
	cdw_task_t *task = (cdw_task_t *) cdw_task;
	local_task = task;
	cdw_form->fields = page_cdrecord_fields;

	int padsize_width = CDW_CDRECORD_OPTIONS_PADSIZE_FIELD_LEN_MAX;
	char pad_size[CDW_CDRECORD_OPTIONS_PADSIZE_FIELD_LEN_MAX + 1];
	snprintf(pad_size, (size_t) padsize_width + 1, "%d", task->burn.cdrecord.pad_size);
	int Xs_col = second_col + padsize_width;

	/* the "150" value below is selected after small tests with DVD;
	   originally it was 63, which worked just fine for CDs,but for DVDs
	   it was insufficient;
	   TODO: the same value is used in code initializing config variable,
	   so it should be a constant defined in some header */

	cdw_form_descr_t descr[] = {
		/*     type        begin_y   begin_x       n_cols           n_lines  field enum              data1                                       data2 */

		{ CDW_WIDGET_CHECKBOX, 1,  first_col + 1,          1,     1,  f_cdrecord_pad_cb,        (void *) NULL,         task->burn.cdrecord.pad ? 1 : 0 },
		{ CDW_WIDGET_LABEL,    1,  first_col + 4, width_wide,     1,  f_cdrecord_pad_l,         _("Pad"),                                            0 },

		/* 2TRANS: this is checkbox label: keep no longer than original; "Pad" refers to adding empty data at the end of track */
		{ CDW_WIDGET_LABEL,    2,  first_col,     width_wide,     1,  f_cdrecord_pad_size_l,    _("Pad size (number >= 0, '150' is recommended)"),   0 },
		{ CDW_WIDGET_INPUT,    3,  second_col, padsize_width,     1,  f_cdrecord_pad_size_i,    pad_size,                                padsize_width },
		/* padsize, Xs */
		/* 2TRANS: do not translate */
		{ CDW_WIDGET_LABEL,    3,  Xs_col,  1,                    1,  f_cdrecord_pad_size_xl,   _("s"),                                              0 },

		{ CDW_WIDGET_CHECKBOX, 5,  first_col + 1,          1,     1,  f_cdrecord_burnproof_cb,  (void *) NULL,   task->burn.cdrecord.burnproof ? 1 : 0 },
		{ CDW_WIDGET_LABEL,    5,  first_col + 4, width_wide,     1,  f_cdrecord_burnproof_l,   _("Burnproof"),                                      0 },

		{ CDW_WIDGET_LABEL,    6,  first_col,     width_wide,     1,  f_cdrecord_other_l,       _("Other cdrecord options:"),                        0 },
		{ CDW_WIDGET_INPUT,    7,  first_col,     width_wide - 3, 1,  f_cdrecord_other_i,       task->burn.cdrecord.other_cdrecord_options,          0 },

		/* guard */
		{ -1,                  0,  0,           0,              0,  0,                          (void *) NULL,                                       0 }};

	cdw_rv_t crv = cdw_form_description_to_fields(descr, cdw_form);
	if (crv != CDW_OK) {
		cdw_vdm ("ERROR: failed to convert form description to form\n");
		return CDW_ERROR;
	} else {
		return CDW_OK;
	}
}





cdw_rv_t cdw_cdrecord_options_validate(cdw_form_t *cdw_form, int *fi)
{
	char *s = cdw_ncurses_get_field_string(*(cdw_form->fields + f_cdrecord_other_i));
	cdw_rv_t crv = cdw_string_security_parser(s, (char *) NULL);
	if (crv != CDW_OK) {
		*fi = f_cdrecord_other_i;
		return CDW_NO;
	}

	return CDW_OK;
}





cdw_rv_t cdw_cdrecord_options_save(cdw_form_t *cdw_form, cdw_task_t *task)
{
	task->burn.cdrecord.pad = cdw_form_get_checkbox_state(cdw_form, f_cdrecord_pad_cb);

	const char *buf = cdw_form_get_string(cdw_form, f_cdrecord_pad_size_i);
	task->burn.cdrecord.pad_size = atoi(buf);

	task->burn.cdrecord.burnproof = cdw_form_get_checkbox_state(cdw_form, f_cdrecord_burnproof_cb);

	cdw_string_set(&(task->burn.cdrecord.other_cdrecord_options), cdw_ncurses_get_field_string(*(cdw_form->fields + f_cdrecord_other_i)));

	return CDW_OK;
}

