#ifndef H_CDW_STRING
#define H_CDW_STRING

#include <stdbool.h>
#include <stddef.h> /* size_t */

#include "main.h"

#define CDW_STRING_UNSAFE_CHARS_STRING "&!*`'|^\\;\"$"


char *cdw_string_rtrim(char *str);
char *cdw_string_ltrim(char *str);
char *cdw_string_concat(const char *str, ...);
cdw_rv_t cdw_string_append(char **head, const char *tail);
cdw_rv_t cdw_string_set(char **target, const char *source);

cdw_rv_t cdw_string_security_parser(const char *string, char *invalid);

bool cdw_string_starts_with_ci(const char *field, const char *fieldname);


void cdw_string_free_table_of_strings(char *labels[], int n_max);
cdw_rv_t cdw_string_ints2labels_3(char **labels, int ints[], size_t n);
cdw_rv_t cdw_string_get_bool_value(const char *buffer, bool *value);


char *cdw_string_get_printable_if_needed(const char *string);

/* unit tests */

void cdw_string_run_tests(void);

#endif /* H_CDW_STRING */
