#ifndef H_CDW_PROCESSWIN
#define H_CDW_PROCESSWIN

#include <stdbool.h>

#include <ncursesw/ncurses.h> /* chtype */

#include "main.h"
#include "cdw_colors.h"

/* size of processwin */
#define PROCESSWIN_COLS 40
#define PROCESSWIN_ROWS 14
/* maximal length of text that can be displayed in
   one line of processwin (does not include ending '\0') */
#define PROCESSWIN_MAX_RTEXT_LEN (PROCESSWIN_COLS - 2 - 1)


cdw_rv_t cdw_processwin_create(const char *title, const char *label, bool show_progress);
void cdw_processwin_destroy(const char *status_string, bool wait);
void cdw_processwin_wrefresh(void);
void cdw_processwin_wgetch(void);
bool cdw_processwin_is_active(void);


void cdw_processwin_display_main_info(const char *string);
void cdw_processwin_display_sub_info(const char *string);

void cdw_processwin_display_fifo_and_speed(int fifo_level, int speed_decimal, int speed_fract);
void cdw_processwin_erase_fifo_and_speed(void);
void cdw_processwin_display_eta(const char *eta_line);
void cdw_processwin_erase_eta(void);
void cdw_processwin_display_progress_conditional(long current, long total, const char *description);
void cdw_processwin_display_progress(long current_amount, long total_amount, const char *description);
void cdw_processwin_add_progress_bar(void);
void cdw_processwin_delete_progress_bar(void);

void cdw_processwin_draw_progress_bar(int value, cdw_colors_t color1, cdw_colors_t color2, chtype c);
void cdw_processwin_reset_progress(void);

void cdw_processwin_force_refresh(void);

#endif /* H_CDW_PROCESSWIN */

