#ifndef H_CDW_MAIN_WINDOW
#define H_CDW_MAIN_WINDOW

#include <stdbool.h>

#include <ncursesw/ncurses.h>
#include <ncursesw/menu.h>

#include "main.h" /* cdw_rv_t */
#include "cdw_disc.h"




/*
________________________________________________________
|_______________ _____________________________________ |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||  main_menu  | |      files_list                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||_____________| |___________________________________| |
|_______________ _____________________________________ |
||             | |                                   | |
||  disc_info  | |      files_info_sub               | |
||             | |                                   | |
||_____________| |___________________________________| |
|______________________________________________________|

*/



/* be careful with order of fields in this enum - it has to be the same
 * as order of button labels in main menu built in cdw_ui.c */
typedef enum menu_items {
	CDW_MENU_ADD_FILES = 0,
	CDW_MENU_DELETE_FILES,
	CDW_MENU_BURN_FILES,
	CDW_MENU_CREATE_IMAGE,
	CDW_MENU_BURN_IMAGE,
	CDW_MENU_RIP_DISC,
	CDW_MENU_ERASE_DISC,
	CDW_MENU_CONFIG,
	CDW_MENU_EXIT_CDW
} cdw_menu_items_t;


cdw_rv_t cdw_main_ui_init(void);
void     cdw_main_ui_clean(void);


void cdw_main_ui_main_window_wrefresh_part(size_t n_lines, size_t n_cols, size_t begin_y, size_t begin_x);
void cdw_main_ui_main_window_wrefresh(void);

//cdw_rv_t cdw_main_ui_disc_info_view_update(void);
void cdw_main_ui_disc_info_view_display_data(const cdw_disc_t *disc);

cdw_rv_t cdw_main_ui_files_info_view_update(bool fetch_data);

cdw_rv_t cdw_main_ui_add_to_selected_files(void);
cdw_rv_t cdw_main_ui_delete_from_selected_files(void);

void cdw_main_ui_show_license(void);

WINDOW *cdw_main_ui_get_tooltips_subwindow(void);
WINDOW *cdw_main_ui_get_main_window(void);
MENU *cdw_main_ui_get_main_menu(void);

#endif /* H_CDW_MAIN_WINDOW */
